/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.loaders;

import android.content.Context;
import com.calldorado.base.listeners.AbstractListener;
import com.calldorado.base.listeners.OnAdLoaderFinishedListener;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.models.AdProvider;
import com.calldorado.base.models.debug.AdDebugLog;
import com.calldorado.base.views.CAdView;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010$\u001a\u00020%2\u0006\u0010\u0006\u001a\u00020\u0016H&J\b\u0010&\u001a\u00020%H&J\u0006\u0010'\u001a\u00020\nJ\b\u0010(\u001a\u0004\u0018\u00010)J\u0006\u0010*\u001a\u00020\nJ\b\u0010+\u001a\u00020,H&J\u0006\u0010-\u001a\u00020\u0012J\b\u0010.\u001a\u00020/H&J\n\u00100\u001a\u0004\u0018\u00010\nH&J\b\u00101\u001a\u000202H&J\b\u00103\u001a\u00020%H&J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u00020,H&J\b\u00106\u001a\u000202H&J\"\u00107\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n08j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`9R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006:"}, d2={"Lcom/calldorado/base/loaders/AdLoader;", "", "context", "Landroid/content/Context;", "adProfileModel", "Lcom/calldorado/base/models/AdProfileModel;", "listener", "Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "(Landroid/content/Context;Lcom/calldorado/base/models/AdProfileModel;Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getAdProfileModel", "()Lcom/calldorado/base/models/AdProfileModel;", "getContext", "()Landroid/content/Context;", "defaultHaltTime", "", "getDefaultHaltTime", "()J", "eventListener", "Lcom/calldorado/base/listeners/AbstractListener;", "getEventListener", "()Lcom/calldorado/base/listeners/AbstractListener;", "getListener", "()Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "setListener", "(Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;)V", "ticker", "Lkotlinx/coroutines/Job;", "timerJob", "getTimerJob", "()Lkotlinx/coroutines/Job;", "setTimerJob", "(Lkotlinx/coroutines/Job;)V", "attachAdEventListener", "", "destroy", "getAdKey", "getAdProvider", "Lcom/calldorado/base/models/AdProvider;", "getAdProviderName", "getCAdView", "Lcom/calldorado/base/views/CAdView;", "getImpressionDelay", "getNetworkResponse", "Lcom/calldorado/base/models/debug/AdDebugLog;", "getReward", "isDestroyed", "", "loadAd", "notifyPublisherSuccess", "adView", "showAd", "toMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "base_release"})
public abstract class AdLoader {
    @NotNull
    private final Context context;
    @NotNull
    private final AdProfileModel adProfileModel;
    @NotNull
    private OnAdLoaderFinishedListener listener;
    @NotNull
    private final String TAG;
    public Job timerJob;
    private final long defaultHaltTime;
    private Job ticker;

    public AdLoader(@NotNull Context context, @NotNull AdProfileModel adProfileModel, @NotNull OnAdLoaderFinishedListener listener) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)adProfileModel, (String)"adProfileModel");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.context = context;
        this.adProfileModel = adProfileModel;
        this.listener = listener;
        this.TAG = "7.0_AdLoader";
        this.defaultHaltTime = 10000L;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AdProfileModel getAdProfileModel() {
        return this.adProfileModel;
    }

    @NotNull
    public final OnAdLoaderFinishedListener getListener() {
        return this.listener;
    }

    public final void setListener(@NotNull OnAdLoaderFinishedListener onAdLoaderFinishedListener) {
        Intrinsics.checkNotNullParameter((Object)onAdLoaderFinishedListener, (String)"<set-?>");
        this.listener = onAdLoaderFinishedListener;
    }

    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    @Nullable
    public abstract AbstractListener getEventListener();

    @NotNull
    public final Job getTimerJob() {
        Job job = this.timerJob;
        if (job != null) {
            return job;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"timerJob");
        return null;
    }

    public final void setTimerJob(@NotNull Job job) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"<set-?>");
        this.timerJob = job;
    }

    public final long getDefaultHaltTime() {
        return this.defaultHaltTime;
    }

    @Nullable
    public final AdProvider getAdProvider() {
        Object object;
        try {
            object = this.adProfileModel.getProvider();
            object = Intrinsics.areEqual((Object)object, (Object)"dfp") ? AdProvider.dfp : (Intrinsics.areEqual((Object)object, (Object)"applovin") ? AdProvider.applovin : null);
        }
        catch (Exception e) {
            object = null;
        }
        return object;
    }

    public final long getImpressionDelay() {
        long l;
        try {
            l = this.adProfileModel.getImpressionDelay();
        }
        catch (Exception e) {
            e.printStackTrace();
            l = 0L;
        }
        return l;
    }

    @NotNull
    public final String getAdProviderName() {
        String returnStr = "";
        try {
            if (this.adProfileModel != null) {
                returnStr = String.valueOf(this.adProfileModel.getProvider());
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "getAdProviderName Exception " + e.getMessage());
        }
        return returnStr;
    }

    @NotNull
    public final String getAdKey() {
        String returnStr = "";
        try {
            if (this.adProfileModel != null) {
                returnStr = this.adProfileModel.getAdUnit();
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "getAdKey Exception " + e.getMessage());
        }
        return returnStr;
    }

    public abstract void attachAdEventListener(@NotNull AbstractListener var1);

    public abstract void notifyPublisherSuccess(@NotNull CAdView var1);

    @NotNull
    public abstract CAdView getCAdView();

    public abstract void destroy();

    public abstract void loadAd();

    public abstract boolean showAd();

    @Nullable
    public abstract String getReward();

    @NotNull
    public abstract AdDebugLog getNetworkResponse();

    @NotNull
    public final HashMap<String, String> toMap() {
        Object object;
        try {
            object = new Pair[4];
            object[0] = TuplesKt.to((Object)"ad_key", (Object)this.adProfileModel.getAdUnit());
            String string = this.adProfileModel.getProvider();
            if (string == null) {
                string = "";
            }
            object[1] = TuplesKt.to((Object)"provider", (Object)string);
            object[2] = TuplesKt.to((Object)"ad_time", (Object)String.valueOf(this.adProfileModel.getAdTime()));
            object[3] = TuplesKt.to((Object)"zone", (Object)this.adProfileModel.getZone());
            object = MapsKt.hashMapOf((Pair[])object);
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "toMap Exception " + e.getMessage());
            object = new HashMap();
        }
        return object;
    }

    public abstract boolean isDestroyed();
}

