/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.loaders;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.ViewGroup;
import com.calldorado.ads.adsapi.CBannerAdView;
import com.calldorado.ads.adsapi.ConvertersKt;
import com.calldorado.base.listeners.AbstractListener;
import com.calldorado.base.listeners.AdListener;
import com.calldorado.base.listeners.BannerListener;
import com.calldorado.base.listeners.OnAdLoaderFinishedListener;
import com.calldorado.base.loaders.AdLoader;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.views.CAdView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u001eH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/calldorado/base/loaders/BannerLoader;", "Lcom/calldorado/base/loaders/AdLoader;", "context", "Landroid/content/Context;", "listener", "Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "adProfileModel", "Lcom/calldorado/base/models/AdProfileModel;", "(Landroid/content/Context;Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;Lcom/calldorado/base/models/AdProfileModel;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "eventListener", "Lcom/calldorado/base/listeners/BannerListener;", "getEventListener", "()Lcom/calldorado/base/listeners/BannerListener;", "setEventListener", "(Lcom/calldorado/base/listeners/BannerListener;)V", "isPersonalisedAdsAllowed", "", "()Z", "sharedPreferences", "Landroid/content/SharedPreferences;", "attachAdEventListener", "", "Lcom/calldorado/base/listeners/AbstractListener;", "getAdView", "Landroid/view/ViewGroup;", "getCAdView", "Lcom/calldorado/base/views/CAdView;", "notifyPublisherSuccess", "adView", "base_release"})
public abstract class BannerLoader
extends AdLoader {
    @NotNull
    private final String TAG;
    @NotNull
    private final SharedPreferences sharedPreferences;
    private final boolean isPersonalisedAdsAllowed;
    @Nullable
    private BannerListener eventListener;

    public BannerLoader(@NotNull Context context, @NotNull OnAdLoaderFinishedListener listener, @NotNull AdProfileModel adProfileModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)adProfileModel, (String)"adProfileModel");
        super(context, adProfileModel, listener);
        this.TAG = "7.0_BannerLoader";
        SharedPreferences sharedPreferences = context.getSharedPreferences("cdo_preferences", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"getSharedPreferences(...)");
        this.sharedPreferences = sharedPreferences;
        this.isPersonalisedAdsAllowed = this.sharedPreferences.getBoolean("shouldShowPersonalisedAds", adProfileModel.getShouldShowPersonalisedAdsDefault());
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    public final boolean isPersonalisedAdsAllowed() {
        return this.isPersonalisedAdsAllowed;
    }

    @Override
    @Nullable
    public BannerListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(@Nullable BannerListener bannerListener) {
        this.eventListener = bannerListener;
    }

    @Override
    public void attachAdEventListener(@NotNull AbstractListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        try {
            AbstractListener abstractListener = listener;
            if (abstractListener instanceof BannerListener) {
                this.setEventListener((BannerListener)listener);
            } else if (abstractListener instanceof AdListener) {
                this.setEventListener(ConvertersKt.convertMixedListenerToBannerListener((AdListener)listener));
            } else {
                CLog.e(this.getTAG(), "Invalid Listener. Please refer to the integration guide.");
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "attachAdEventListener Exception " + e.getMessage());
        }
    }

    @Override
    public void notifyPublisherSuccess(@NotNull CAdView adView) {
        Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
        try {
            BannerListener bannerListener = this.getEventListener();
            if (bannerListener != null) {
                bannerListener.onBannerAdLoaded((CBannerAdView)adView);
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "notifyPublisherSuccess Exception " + e.getMessage());
        }
    }

    @Override
    @NotNull
    public CAdView getCAdView() {
        return new CBannerAdView(this.getContext(), this);
    }

    @Nullable
    public abstract ViewGroup getAdView();
}

