/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.loaders;

import android.content.Context;
import android.view.ViewGroup;
import com.calldorado.ads.adsapi.ConvertersKt;
import com.calldorado.base.listeners.AbstractListener;
import com.calldorado.base.listeners.AdListener;
import com.calldorado.base.listeners.NativeListener;
import com.calldorado.base.listeners.OnAdLoaderFinishedListener;
import com.calldorado.base.loaders.AdLoader;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.views.CAdView;
import com.calldorado.base.views.CNativeAdView;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H&J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0014H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/calldorado/base/loaders/NativeLoader;", "Lcom/calldorado/base/loaders/AdLoader;", "context", "Landroid/content/Context;", "nativeListener", "Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "profileModel", "Lcom/calldorado/base/models/AdProfileModel;", "(Landroid/content/Context;Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;Lcom/calldorado/base/models/AdProfileModel;)V", "eventListener", "Lcom/calldorado/base/listeners/NativeListener;", "getEventListener", "()Lcom/calldorado/base/listeners/NativeListener;", "setEventListener", "(Lcom/calldorado/base/listeners/NativeListener;)V", "attachAdEventListener", "", "listener", "Lcom/calldorado/base/listeners/AbstractListener;", "getCAdView", "Lcom/calldorado/base/views/CAdView;", "initView", "Landroid/view/ViewGroup;", "notifyPublisherSuccess", "adView", "base_release"})
public abstract class NativeLoader
extends AdLoader {
    @Nullable
    private NativeListener eventListener;

    public NativeLoader(@NotNull Context context, @NotNull OnAdLoaderFinishedListener nativeListener, @NotNull AdProfileModel profileModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)nativeListener, (String)"nativeListener");
        Intrinsics.checkNotNullParameter((Object)profileModel, (String)"profileModel");
        super(context, profileModel, nativeListener);
    }

    @Override
    @Nullable
    public NativeListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(@Nullable NativeListener nativeListener) {
        this.eventListener = nativeListener;
    }

    @Override
    public void attachAdEventListener(@NotNull AbstractListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        try {
            AbstractListener abstractListener = listener;
            if (abstractListener instanceof NativeListener) {
                this.setEventListener((NativeListener)listener);
            } else if (abstractListener instanceof AdListener) {
                this.setEventListener(ConvertersKt.convertMixedListenerToNativeListener((AdListener)listener));
            } else {
                CLog.e(this.getTAG(), "Invalid Listener.");
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "attachAdEventListener Exception " + e.getMessage());
        }
    }

    @Override
    public void notifyPublisherSuccess(@NotNull CAdView adView) {
        Intrinsics.checkNotNullParameter((Object)adView, (String)"adView");
        try {
            NativeListener nativeListener = this.getEventListener();
            if (nativeListener != null) {
                nativeListener.onNativeAdLoaded((CNativeAdView)adView);
            }
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "notifyPublisherSuccess Exception " + e.getMessage());
        }
    }

    @Override
    @NotNull
    public CAdView getCAdView() {
        return new CNativeAdView(this.getContext(), this);
    }

    @Nullable
    public abstract ViewGroup initView();
}

