/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.logging;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressLint(value={"AndroidLogDetector"})
public class CLog {
    private static final int PERFORMANCE = 99;
    private static boolean enableInfoDebugVerboseLogging;
    private static boolean enableWarningLogging;
    private static boolean enableErrorsLogging;
    private static boolean enablePerformanceLogging;
    private static boolean enableWtfLogging;
    private static boolean enableLogToFile;
    private static String logFileName;
    private Context context;
    private static int LOG_SIZE;
    private static boolean startPerformanceLogging;
    private static long performanceStartingMilis;
    private static CLog cLogInstance;

    private CLog(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CLog getInstance(Context context) {
        if (cLogInstance != null) return cLogInstance;
        Class<CLog> clazz = CLog.class;
        synchronized (CLog.class) {
            if (cLogInstance != null) return cLogInstance;
            cLogInstance = new CLog(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cLogInstance;
        }
    }

    public void enableAll(boolean enable) {
        enableErrorsLogging = enable;
        enableInfoDebugVerboseLogging = enable;
        enableWarningLogging = enable;
        enablePerformanceLogging = enable;
        enableWtfLogging = enable;
    }

    private synchronized void logToFile2(String tag, String msg) {
        if (this.context == null) {
            enableLogToFile = false;
            return;
        }
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS", Locale.getDefault());
        String time = formatter.format(date);
        SharedPreferences prefs = this.context.getSharedPreferences("clogpref", 0);
        int counter = prefs.getInt("clogCounter", 0);
        try {
            String lf = logFileName + counter;
            File logFile = new File(this.context.getFilesDir(), lf);
            BufferedWriter writer = new BufferedWriter(new FileWriter(logFile, false));
            writer.write(time + "; TAG: " + tag + "; Log message: " + msg);
            ((Writer)writer).close();
            counter = counter == LOG_SIZE ? 0 : ++counter;
            prefs.edit().putInt("clogCounter", counter).commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void v(String tag, String msg) {
        if (enableInfoDebugVerboseLogging) {
            try {
                CLog.showLongLogcatOutput(2, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void i(String tag, String msg) {
        if (enableInfoDebugVerboseLogging) {
            try {
                CLog.showLongLogcatOutput(4, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void i(String tag, String msg, String referenceToChunkedOutput) {
        if (enableInfoDebugVerboseLogging) {
            try {
                CLog.showLongLogcatOutput(4, tag, msg, referenceToChunkedOutput, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void d(String tag, String msg) {
        if (enableInfoDebugVerboseLogging) {
            try {
                CLog.showLongLogcatOutput(3, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void d(String tag, String msg, Throwable e) {
        if (enableInfoDebugVerboseLogging) {
            try {
                CLog.showLongLogcatOutput(3, tag, msg, null, e);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void w(String tag, String msg) {
        if (enableWarningLogging) {
            try {
                CLog.showLongLogcatOutput(5, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void w(String tag, String msg, Exception e) {
        if (enableWarningLogging) {
            try {
                CLog.showLongLogcatOutput(5, tag, msg, null, e);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void e(String tag, String msg) {
        if (enableErrorsLogging) {
            try {
                CLog.showLongLogcatOutput(6, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void e(String tag, String msg, Exception e) {
        if (enableErrorsLogging) {
            try {
                CLog.showLongLogcatOutput(6, tag, msg, null, e);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void a(String tag, String msg) {
        if (enableWtfLogging) {
            try {
                CLog.showLongLogcatOutput(7, tag, msg, null, null);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void a(String tag, String msg, Exception e) {
        if (enableWtfLogging) {
            try {
                CLog.showLongLogcatOutput(7, tag, msg, null, e);
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
        }
    }

    public static void p(String tag) {
        if (enablePerformanceLogging) {
            boolean bl = startPerformanceLogging = !startPerformanceLogging;
            if (startPerformanceLogging) {
                performanceStartingMilis = System.currentTimeMillis();
            } else {
                long performanceEndingMilis = System.currentTimeMillis();
                if (performanceEndingMilis > performanceStartingMilis) {
                    long result = performanceEndingMilis - performanceStartingMilis;
                    if (result > 0L) {
                        CLog.showLongLogcatOutput(99, tag, "Performance logging in milis: " + result + "ms.", null, null);
                    } else if (result == 0L) {
                        CLog.showLongLogcatOutput(5, tag, "Performance logging 1 operation is faster than 1 millisecond", null, null);
                    } else {
                        CLog.showLongLogcatOutput(6, tag, "Performance logging failed - negative value", null, null);
                    }
                } else if (performanceEndingMilis == performanceStartingMilis) {
                    CLog.showLongLogcatOutput(5, tag, "Performance logging 2 operation is faster than 1 millisecond", null, null);
                } else {
                    CLog.showLongLogcatOutput(6, tag, "Performance logging failed...negative performance value makes no sense (at least in this universe)", null, null);
                }
            }
        }
    }

    private static void showLongLogcatOutput(int logType, String tag, String msg, String referenceToChunkedOutput, Throwable error) {
        int charLimit = 3500;
        if (msg != null && msg.length() > charLimit) {
            int chunkCount = msg.length() / charLimit;
            for (int chunk = 0; chunk <= chunkCount; ++chunk) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("chunk ").append(chunk).append(" of ").append(chunkCount).append(referenceToChunkedOutput == null ? "" : referenceToChunkedOutput).append(": ");
                int max = charLimit * (chunk + 1);
                if (chunk != 0) {
                    stringBuilder.append("\n");
                }
                if (max >= msg.length()) {
                    stringBuilder.append(msg.substring(charLimit * chunk));
                } else {
                    stringBuilder.append(msg.substring(charLimit * chunk, max));
                }
                stringBuilder.append("\n");
                CLog.printLog(logType, tag, stringBuilder.toString(), error);
            }
        } else {
            CLog.printLog(logType, tag, msg, error);
        }
    }

    private static void printLog(int logType, String tag, String msg, Throwable error) {
        switch (logType) {
            case 2: {
                if (!enableInfoDebugVerboseLogging) break;
                Log.v((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 3: {
                if (!enableInfoDebugVerboseLogging) break;
                Log.d((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 4: {
                if (!enableInfoDebugVerboseLogging) break;
                Log.i((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 5: {
                if (!enableWarningLogging) break;
                Log.w((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 6: {
                if (!enableErrorsLogging) break;
                Log.e((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 7: {
                if (!enableWtfLogging) break;
                Log.wtf((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            case 99: {
                if (!enablePerformanceLogging) break;
                Log.i((String)tag, (String)(" " + msg), (Throwable)error);
                break;
            }
            default: {
                if (!enableInfoDebugVerboseLogging) break;
                Log.v((String)tag, (String)(" " + msg), (Throwable)error);
            }
        }
        if (enableLogToFile && cLogInstance != null) {
            cLogInstance.logToFile2(tag, msg);
        }
    }

    static {
        logFileName = "Clog";
        LOG_SIZE = 1000;
    }
}

