/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.network.NetworkConnectivityManager;
import com.calldorado.base.network.NetworkState;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000=\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0006\u0010\u0016\u001a\u00020\u0010J)\u0010\u0017\u001a\u00020\u00102!\u0010\u0018\u001a\u001d\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\u000bR\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u001f\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/calldorado/base/network/NetworkConnectivityManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "mConnectivityCallback", "com/calldorado/base/network/NetworkConnectivityManager$mConnectivityCallback$1", "Lcom/calldorado/base/network/NetworkConnectivityManager$mConnectivityCallback$1;", "mConnectivityManager", "Landroid/net/ConnectivityManager;", "mNetworkListenerFun", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "isAvailable", "", "mNetworkStateEnum", "Lcom/calldorado/base/network/NetworkState;", "getNetworkState", "listen", "networkAvailable", "stop", "waitForNetwork", "networkListenerFun", "base_release"})
public final class NetworkConnectivityManager {
    @NotNull
    private NetworkState mNetworkStateEnum;
    @Nullable
    private Function1<? super Boolean, Unit> mNetworkListenerFun;
    @Nullable
    private final ConnectivityManager mConnectivityManager;
    @NotNull
    private final mConnectivityCallback.1 mConnectivityCallback;

    public NetworkConnectivityManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.mNetworkStateEnum = NetworkState.PENDING;
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.mConnectivityCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ NetworkConnectivityManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkConnectivityManager.access$setMNetworkStateEnum$p(this.this$0, NetworkState.AVAILABLE);
                    Function1 function1 = NetworkConnectivityManager.access$getMNetworkListenerFun$p(this.this$0);
                    if (function1 == null) break block0;
                    function1.invoke((Object)true);
                }
            }

            public void onLost(@NotNull Network network) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                    NetworkConnectivityManager.access$setMNetworkStateEnum$p(this.this$0, NetworkState.LOST);
                    Function1 function1 = NetworkConnectivityManager.access$getMNetworkListenerFun$p(this.this$0);
                    if (function1 == null) break block0;
                    function1.invoke((Object)false);
                }
            }
        };
    }

    @NotNull
    public final NetworkState getNetworkState() {
        return this.mNetworkStateEnum;
    }

    private final void listen() {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                ConnectivityManager connectivityManager = this.mConnectivityManager;
                if (connectivityManager != null) {
                    connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.mConnectivityCallback);
                }
            } else {
                NetworkRequest networkRequest = new NetworkRequest.Builder().addCapability(12).build();
                ConnectivityManager connectivityManager = this.mConnectivityManager;
                if (connectivityManager != null) {
                    connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)this.mConnectivityCallback);
                }
            }
        }
        catch (Exception e) {
            this.mNetworkStateEnum = NetworkState.ERROR;
            CLog.d("AdsConnectivityManager", "listen Exception " + e.getMessage());
        }
    }

    public final void stop() {
        try {
            ConnectivityManager connectivityManager = this.mConnectivityManager;
            if (connectivityManager != null) {
                connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.mConnectivityCallback);
            }
        }
        catch (Exception e) {
            CLog.d("AdsConnectivityManager", "stop Exception " + e.getMessage());
        }
    }

    private final boolean networkAvailable() {
        try {
            if (this.mConnectivityManager == null) {
                return false;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                Network network = this.mConnectivityManager.getActiveNetwork();
                if (network == null) {
                    return false;
                }
                Network network2 = network;
                NetworkCapabilities networkCapabilities = this.mConnectivityManager.getNetworkCapabilities(network2);
                if (networkCapabilities == null) {
                    return false;
                }
                NetworkCapabilities activeNetwork = networkCapabilities;
                return activeNetwork.hasTransport(1) ? true : (activeNetwork.hasTransport(0) ? true : activeNetwork.hasTransport(3));
            }
            NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) {
                return false;
            }
            NetworkInfo nwInfo = networkInfo;
            return nwInfo.isConnected();
        }
        catch (Exception e) {
            CLog.d("AdsConnectivityManager", "networkAvailable Exception " + e.getMessage());
            return false;
        }
    }

    public final void waitForNetwork(@NotNull Function1<? super Boolean, Unit> networkListenerFun) {
        Intrinsics.checkNotNullParameter(networkListenerFun, (String)"networkListenerFun");
        this.mNetworkListenerFun = networkListenerFun;
        this.listen();
    }

    public static final /* synthetic */ void access$setMNetworkStateEnum$p(NetworkConnectivityManager $this, NetworkState networkState) {
        $this.mNetworkStateEnum = networkState;
    }

    public static final /* synthetic */ Function1 access$getMNetworkListenerFun$p(NetworkConnectivityManager $this) {
        return $this.mNetworkListenerFun;
    }
}

