/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.providers;

import android.content.Context;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.core.os.BundleKt;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxAdViewAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinSdkUtils;
import com.calldorado.base.listeners.BannerListener;
import com.calldorado.base.listeners.OnAdLoaderFinishedListener;
import com.calldorado.base.loaders.BannerLoader;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.models.CalldoradoAdsError;
import com.calldorado.base.models.debug.AdDebugLog;
import com.calldorado.base.providers.AppLovinSdkManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\u0006\u0010\u001e\u001a\u00020\u0014J\b\u0010\u001f\u001a\u00020\u0012H\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/calldorado/base/providers/AppLovinBannerBiddingLoader;", "Lcom/calldorado/base/loaders/BannerLoader;", "context", "Landroid/content/Context;", "loaderFinishedListener", "Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "adProfileModel", "Lcom/calldorado/base/models/AdProfileModel;", "(Landroid/content/Context;Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;Lcom/calldorado/base/models/AdProfileModel;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "adView", "Lcom/applovin/mediation/ads/MaxAdView;", "loadedAd", "Lcom/applovin/mediation/MaxAd;", "mIsDestroyed", "", "destroy", "", "getAdView", "Landroid/view/ViewGroup;", "getNetworkResponse", "Lcom/calldorado/base/models/debug/AdDebugLog;", "getReward", "getSize", "", "isDestroyed", "loadAd", "performTheLoadAd", "showAd", "base_release"})
public final class AppLovinBannerBiddingLoader
extends BannerLoader {
    @NotNull
    private final String TAG;
    @Nullable
    private MaxAdView adView;
    @Nullable
    private MaxAd loadedAd;
    private boolean mIsDestroyed;

    public AppLovinBannerBiddingLoader(@NotNull Context context, @NotNull OnAdLoaderFinishedListener loaderFinishedListener, @NotNull AdProfileModel adProfileModel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)loaderFinishedListener, (String)"loaderFinishedListener");
        Intrinsics.checkNotNullParameter((Object)adProfileModel, (String)"adProfileModel");
        super(context, loaderFinishedListener, adProfileModel);
        this.TAG = "7.0_AppLovinBannerBiddingLoader";
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    @Override
    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    @Override
    @Nullable
    public ViewGroup getAdView() {
        CLog.d(this.getTAG(), "getAdView()");
        return (ViewGroup)this.adView;
    }

    @Override
    public boolean showAd() {
        return false;
    }

    @Override
    @Nullable
    public String getReward() {
        return null;
    }

    @Override
    public void destroy() {
        try {
            this.mIsDestroyed = true;
            MaxAdView maxAdView = this.adView;
            if (maxAdView != null) {
                maxAdView.destroy();
            }
            this.loadedAd = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @NotNull
    public AdDebugLog getNetworkResponse() {
        return AppLovinSdkManager.INSTANCE.getNetworkResponse(this.loadedAd);
    }

    @Override
    public void loadAd() {
        this.mIsDestroyed = false;
        if (!AppLovinSdkManager.INSTANCE.isAppLovinInitialized()) {
            CLog.d(this.getTAG(), "applovin is not yet initialized");
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AppLovinBannerBiddingLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CLog.d(this.this$0.getTAG(), "trying to initialize applovin");
                            long startInitTimeLng = System.currentTimeMillis();
                            AppLovinSdkManager.INSTANCE.initialize(this.this$0.getContext(), this.this$0.getAdProfileModel().getAdRetry(), this.this$0.isPersonalisedAdsAllowed(), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, startInitTimeLng){
                                final /* synthetic */ AppLovinBannerBiddingLoader this$0;
                                final /* synthetic */ long $startInitTimeLng;
                                {
                                    this.this$0 = $receiver;
                                    this.$startInitTimeLng = $startInitTimeLng;
                                    super(0);
                                }

                                public final void invoke() {
                                    CLog.d(this.this$0.getTAG(), "applovin is now initialized");
                                    long endInitTimeLng = System.currentTimeMillis();
                                    if (this.this$0.getAdProfileModel().getWaitForInit()) {
                                        this.this$0.performTheLoadAd();
                                    }
                                    this.this$0.getListener().onAdLoaderInitialized(this.this$0, "applovin", endInitTimeLng - this.$startInitTimeLng);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            if (!this.getAdProfileModel().getWaitForInit()) {
                CLog.d(this.getTAG(), "returning onAdLoaderFailed");
                this.getListener().onAdLoaderFailed(this, new CalldoradoAdsError(1, "1###not initialized###isAppLovinInitialized returned false", "applovin", "applovin", this.getAdProfileModel().getAdUnit()));
            } else {
                CLog.d(this.getTAG(), "just wait for init");
            }
        } else {
            this.performTheLoadAd();
        }
    }

    public final void performTheLoadAd() {
        if (!this.mIsDestroyed) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AppLovinBannerBiddingLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                CLog.d(this.this$0.getTAG(), "performing the loadAd attempt");
                                AppLovinBannerBiddingLoader.access$setAdView$p(this.this$0, new MaxAdView(this.this$0.getAdProfileModel().getAdUnit(), MaxAdFormat.MREC, AppLovinSdkManager.INSTANCE.getAppLovinSdkInstance(), this.this$0.getContext()));
                                MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxAdView);
                                maxAdView.setRevenueListener(new MaxAdRevenueListener(this.this$0){
                                    final /* synthetic */ AppLovinBannerBiddingLoader this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void onAdRevenuePaid(@Nullable MaxAd ad) {
                                        CLog.d(this.this$0.getTAG(), "onAdRevenuePaid");
                                        if (AppLovinBannerBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                            return;
                                        }
                                        double adRevenueDbl = 0.0;
                                        Object placementIdStr = "";
                                        if (ad != null) {
                                            adRevenueDbl = ad.getRevenue();
                                            if (adRevenueDbl < 0.0) {
                                                adRevenueDbl = 0.0;
                                            }
                                            placementIdStr = ad.getNetworkName() + " " + ad.getNetworkPlacement();
                                            this.this$0.getListener().onAdRevenuePaid(this.this$0, adRevenueDbl, (String)placementIdStr);
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ad_platform", (Object)"appLovin"), TuplesKt.to((Object)"ad_source", (Object)ad.getNetworkName()), TuplesKt.to((Object)"ad_format", (Object)ad.getFormat().getLabel()), TuplesKt.to((Object)"ad_unit_name", (Object)ad.getAdUnitId()), TuplesKt.to((Object)"value", (Object)adRevenueDbl), TuplesKt.to((Object)"currency", (Object)"USD")};
                                            this.this$0.getListener().onAdRevenueParams(this.this$0, BundleKt.bundleOf((Pair[])pairArray));
                                        }
                                    }
                                });
                                MaxAdView maxAdView2 = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxAdView2);
                                maxAdView2.setListener(new MaxAdViewAdListener(this.this$0){
                                    final /* synthetic */ AppLovinBannerBiddingLoader this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void onAdLoaded(@NotNull MaxAd maxAd) {
                                        Intrinsics.checkNotNullParameter((Object)maxAd, (String)"maxAd");
                                        try {
                                            CLog.d(this.this$0.getTAG(), "onAdLoaded from network " + maxAd.getNetworkName());
                                            AppLovinBannerBiddingLoader.access$setLoadedAd$p(this.this$0, maxAd);
                                            if (AppLovinBannerBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                                return;
                                            }
                                            this.this$0.getListener().onAdLoaderSuccess(this.this$0, AppLovinSdkManager.INSTANCE.getDetailsAsString(maxAd));
                                            MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                            Intrinsics.checkNotNull((Object)maxAdView);
                                            maxAdView.stopAutoRefresh();
                                        }
                                        catch (Exception e) {
                                            CLog.d(this.this$0.getTAG(), "onAdLoaded Exception: " + e.getMessage());
                                        }
                                    }

                                    public void onAdDisplayed(@Nullable MaxAd ad) {
                                        CLog.d(this.this$0.getTAG(), "onAdDisplayed");
                                    }

                                    public void onAdHidden(@Nullable MaxAd ad) {
                                        CLog.d(this.this$0.getTAG(), "onAdHidden");
                                    }

                                    public void onAdLoadFailed(@Nullable String adUnitId, @Nullable MaxError error) {
                                        CLog.d(this.this$0.getTAG(), "onAdLoadFailed");
                                        if (AppLovinBannerBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                            return;
                                        }
                                        try {
                                            String strMessage = AppLovinSdkManager.INSTANCE.getErrorDetailsAsString(error);
                                            int lngCode = 0;
                                            if (error != null) {
                                                lngCode = error.getCode();
                                            }
                                            CLog.d(this.this$0.getTAG(), lngCode + " " + strMessage);
                                            this.this$0.getListener().onAdLoaderFailed(this.this$0, new CalldoradoAdsError(lngCode, strMessage, "applovin", "applovin", this.this$0.getAdProfileModel().getAdUnit()));
                                            MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                            Intrinsics.checkNotNull((Object)maxAdView);
                                            maxAdView.stopAutoRefresh();
                                        }
                                        catch (Exception e) {
                                            this.this$0.getListener().onAdLoaderFailed(this.this$0, new CalldoradoAdsError(1, "onAdLoaderFailed Exception " + e.getMessage(), "applovin", "applovin", this.this$0.getAdProfileModel().getAdUnit()));
                                            MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                            Intrinsics.checkNotNull((Object)maxAdView);
                                            maxAdView.stopAutoRefresh();
                                        }
                                    }

                                    public void onAdDisplayFailed(@Nullable MaxAd ad, @Nullable MaxError error) {
                                        CLog.d(this.this$0.getTAG(), "onAdDisplayFailed");
                                        if (AppLovinBannerBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                            return;
                                        }
                                        try {
                                            String strMessage = AppLovinSdkManager.INSTANCE.getErrorDetailsAsString(error);
                                            int lngCode = 0;
                                            if (error != null) {
                                                lngCode = error.getCode();
                                            }
                                            CLog.d(this.this$0.getTAG(), lngCode + " " + strMessage);
                                            this.this$0.getListener().onAdLoaderFailed(this.this$0, new CalldoradoAdsError(lngCode, strMessage, "applovin", "applovin", this.this$0.getAdProfileModel().getAdUnit()));
                                            MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                            Intrinsics.checkNotNull((Object)maxAdView);
                                            maxAdView.stopAutoRefresh();
                                        }
                                        catch (Exception e) {
                                            this.this$0.getListener().onAdLoaderFailed(this.this$0, new CalldoradoAdsError(1, "onAdDisplayFailed Exception " + e.getMessage(), "applovin", "applovin", this.this$0.getAdProfileModel().getAdUnit()));
                                            MaxAdView maxAdView = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                            Intrinsics.checkNotNull((Object)maxAdView);
                                            maxAdView.stopAutoRefresh();
                                        }
                                    }

                                    public void onAdClicked(@NotNull MaxAd maxAd) {
                                        block1: {
                                            Intrinsics.checkNotNullParameter((Object)maxAd, (String)"maxAd");
                                            CLog.d(this.this$0.getTAG(), "onAdClicked");
                                            if (AppLovinBannerBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                                return;
                                            }
                                            BannerListener bannerListener = this.this$0.getEventListener();
                                            if (bannerListener == null) break block1;
                                            bannerListener.onAdClicked(this.this$0);
                                        }
                                    }

                                    public void onAdExpanded(@NotNull MaxAd maxAd) {
                                        Intrinsics.checkNotNullParameter((Object)maxAd, (String)"maxAd");
                                        CLog.d(this.this$0.getTAG(), "onAdExpanded");
                                    }

                                    public void onAdCollapsed(@NotNull MaxAd maxAd) {
                                        Intrinsics.checkNotNullParameter((Object)maxAd, (String)"maxAd");
                                        CLog.d(this.this$0.getTAG(), "onAdCollapsed");
                                    }
                                });
                                int widthPx = AppLovinSdkUtils.dpToPx((Context)this.this$0.getContext(), (int)300);
                                int heightPx = AppLovinSdkUtils.dpToPx((Context)this.this$0.getContext(), (int)250);
                                MaxAdView maxAdView3 = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxAdView3);
                                maxAdView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(widthPx, heightPx));
                                MaxAdView maxAdView4 = AppLovinBannerBiddingLoader.access$getAdView$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxAdView4);
                                maxAdView4.loadAd();
                            }
                            catch (Exception e) {
                                CLog.d(this.this$0.getTAG(), "loadAd Exception " + e.getMessage());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final int getSize() {
        return 250;
    }

    public static final /* synthetic */ void access$setAdView$p(AppLovinBannerBiddingLoader $this, MaxAdView maxAdView) {
        $this.adView = maxAdView;
    }

    public static final /* synthetic */ MaxAdView access$getAdView$p(AppLovinBannerBiddingLoader $this) {
        return $this.adView;
    }

    public static final /* synthetic */ boolean access$getMIsDestroyed$p(AppLovinBannerBiddingLoader $this) {
        return $this.mIsDestroyed;
    }

    public static final /* synthetic */ void access$setLoadedAd$p(AppLovinBannerBiddingLoader $this, MaxAd maxAd) {
        $this.loadedAd = maxAd;
    }
}

