/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.providers;

import android.content.Context;
import android.os.Bundle;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdFormat;
import com.applovin.mediation.MaxAdWaterfallInfo;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxNetworkResponseInfo;
import com.applovin.sdk.AppLovinPrivacySettings;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkConfiguration;
import com.applovin.sdk.AppLovinSdkSettings;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.debug.AdDebugError;
import com.calldorado.base.models.debug.AdDebugLog;
import com.calldorado.base.models.debug.AdDebugResponse;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00042\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\"H\u0002J,\u0010#\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020\u00172\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010'\u001a\u00020\u0017J\u0006\u0010(\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0006\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u0013`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/calldorado/base/providers/AppLovinSdkManager;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "appLovinSdkInstance", "Lcom/applovin/sdk/AppLovinSdk;", "getAppLovinSdkInstance", "()Lcom/applovin/sdk/AppLovinSdk;", "setAppLovinSdkInstance", "(Lcom/applovin/sdk/AppLovinSdk;)V", "aspectRatio", "getAspectRatio", "setAspectRatio", "(Ljava/lang/String;)V", "initListenerList", "Ljava/util/ArrayList;", "Lkotlin/Function0;", "", "Lkotlin/collections/ArrayList;", "mInitializeInProgress", "", "getDetailsAsString", "ad", "Lcom/applovin/mediation/MaxAd;", "getErrorDetailsAsString", "error", "Lcom/applovin/mediation/MaxError;", "getNetworkResponse", "Lcom/calldorado/base/models/debug/AdDebugLog;", "getSdkKeyFromManifest", "context", "Landroid/content/Context;", "initialize", "shouldAdRetry", "shouldShowPersonalizedAds", "initCallback", "isAppLovinInitialized", "showMediationDebugger", "base_release"})
@SourceDebugExtension(value={"SMAP\nAppLovinSdkManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLovinSdkManager.kt\ncom/calldorado/base/providers/AppLovinSdkManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1855#2,2:191\n*S KotlinDebug\n*F\n+ 1 AppLovinSdkManager.kt\ncom/calldorado/base/providers/AppLovinSdkManager\n*L\n66#1:191,2\n*E\n"})
public final class AppLovinSdkManager {
    @NotNull
    public static final AppLovinSdkManager INSTANCE = new AppLovinSdkManager();
    @NotNull
    private static final String TAG = "7.0_initializeAppLovin";
    @NotNull
    private static String aspectRatio = "";
    @Nullable
    private static AppLovinSdk appLovinSdkInstance;
    private static boolean mInitializeInProgress;
    @NotNull
    private static ArrayList<Function0<Unit>> initListenerList;

    private AppLovinSdkManager() {
    }

    @NotNull
    public final String getTAG() {
        return TAG;
    }

    @NotNull
    public final String getAspectRatio() {
        return aspectRatio;
    }

    public final void setAspectRatio(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        aspectRatio = string;
    }

    @Nullable
    public final AppLovinSdk getAppLovinSdkInstance() {
        return appLovinSdkInstance;
    }

    public final void setAppLovinSdkInstance(@Nullable AppLovinSdk appLovinSdk) {
        appLovinSdkInstance = appLovinSdk;
    }

    public final void initialize(@NotNull Context context, boolean shouldAdRetry, boolean shouldShowPersonalizedAds, @NotNull Function0<Unit> initCallback) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(initCallback, (String)"initCallback");
            if (appLovinSdkInstance == null) {
                AppLovinPrivacySettings.setDoNotSell((boolean)true, (Context)context);
                CLog.d(TAG, "Setting applovin user consent to " + shouldShowPersonalizedAds);
                AppLovinPrivacySettings.setHasUserConsent((boolean)shouldShowPersonalizedAds, (Context)context);
                AppLovinPrivacySettings.setIsAgeRestrictedUser((boolean)false, (Context)context);
                AppLovinSdkSettings appLovinSdkSettings = null;
                if (!shouldAdRetry) {
                    appLovinSdkSettings = new AppLovinSdkSettings(context);
                    appLovinSdkSettings.setExtraParameter("disable_auto_retry_ad_formats", MaxAdFormat.MREC.getLabel());
                    appLovinSdkSettings.setExtraParameter("disable_auto_retry_ad_formats", MaxAdFormat.NATIVE.getLabel());
                }
                AppLovinSdk appLovinSdk = appLovinSdkInstance = AppLovinSdk.getInstance((String)this.getSdkKeyFromManifest(context), (AppLovinSdkSettings)appLovinSdkSettings, (Context)context);
                if (appLovinSdk != null) {
                    appLovinSdk.setMediationProvider("max");
                }
            }
            AppLovinSdk appLovinSdk = appLovinSdkInstance;
            if (appLovinSdk == null) break block5;
            AppLovinSdk appLovinSdkInstance = appLovinSdk;
            boolean bl = false;
            if (!appLovinSdkInstance.isInitialized()) {
                initListenerList.add(initCallback);
                appLovinSdkInstance.initializeSdk(AppLovinSdkManager::initialize$lambda$2$lambda$1);
            } else {
                CLog.d(TAG, "Applovin ALREADY Initialized");
                initCallback.invoke();
            }
        }
    }

    public final boolean isAppLovinInitialized() {
        try {
            AppLovinSdk instance = appLovinSdkInstance;
            boolean bl = false;
            if (instance == null) {
                return false;
            }
            return instance.isInitialized();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public final void showMediationDebugger() {
        try {
            AppLovinSdk appLovinSdk = appLovinSdkInstance;
            if (appLovinSdk != null) {
                appLovinSdk.showMediationDebugger();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final AdDebugLog getNetworkResponse(@Nullable MaxAd ad) {
        MaxAd maxAd;
        MaxAd maxAd2 = ad;
        List list = maxAd2 != null && (maxAd2 = maxAd2.getWaterfall()) != null ? maxAd2.getNetworkResponses() : null;
        List responses = list == null ? CollectionsKt.emptyList() : list;
        List networkResponse = new ArrayList();
        for (MaxNetworkResponseInfo data : responses) {
            AdDebugError adDebugError;
            String string = data.getAdLoadState().toString();
            String string2 = data.getMediatedNetwork().getName();
            Boolean bl = data.isBidding();
            Long l = data.getLatencyMillis();
            if (data.getError() == null) {
                adDebugError = null;
            } else {
                MaxError maxError = data.getError();
                MaxError maxError2 = data.getError();
                MaxError maxError3 = data.getError();
                MaxError maxError4 = data.getError();
                adDebugError = new AdDebugError(maxError != null ? Integer.valueOf(maxError.getCode()) : null, maxError2 != null ? maxError2.getMessage() : null, maxError3 != null ? Integer.valueOf(maxError3.getMediatedNetworkErrorCode()) : null, maxError4 != null ? maxError4.getMediatedNetworkErrorMessage() : null);
            }
            AdDebugResponse item = new AdDebugResponse(string, string2, bl, l, adDebugError);
            networkResponse.add(item);
        }
        MaxAd maxAd3 = ad;
        MaxAd maxAd4 = ad;
        return new AdDebugLog(maxAd3 != null ? maxAd3.getAdUnitId() : null, (maxAd = ad) != null && (maxAd = maxAd.getFormat()) != null ? maxAd.getLabel() : null, maxAd4 != null ? maxAd4.getNetworkPlacement() : null, networkResponse);
    }

    @NotNull
    public final String getDetailsAsString(@Nullable MaxAd ad) {
        if (ad != null) {
            try {
                String strReturn = ad.getWaterfall().getName() + "###";
                strReturn = strReturn + ad.getWaterfall().getTestName() + "###";
                strReturn = strReturn + ad.getWaterfall().getLatencyMillis() + "###";
                strReturn = strReturn + aspectRatio + "###";
                for (MaxNetworkResponseInfo networkResponse : ad.getWaterfall().getNetworkResponses()) {
                    strReturn = strReturn + networkResponse.getMediatedNetwork() + "..." + networkResponse.getAdLoadState() + "..." + networkResponse.getLatencyMillis();
                    strReturn = strReturn + (String)(networkResponse.getError() != null ? "..." + networkResponse.getError() : "...no errors");
                }
                return strReturn;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Could not generate string, error: " + e.getMessage();
            }
        }
        return "ad was null";
    }

    @NotNull
    public final String getErrorDetailsAsString(@Nullable MaxError error) {
        if (error != null) {
            try {
                MaxAdWaterfallInfo maxAdWaterfallInfo = error.getWaterfall();
                String string = maxAdWaterfallInfo != null ? maxAdWaterfallInfo.getName() : null;
                if (string == null) {
                    string = "no waterfall";
                }
                String strReturn = string + "###";
                MaxAdWaterfallInfo maxAdWaterfallInfo2 = error.getWaterfall();
                String string2 = maxAdWaterfallInfo2 != null ? maxAdWaterfallInfo2.getTestName() : null;
                if (string2 == null) {
                    string2 = "no waterfall";
                }
                strReturn = strReturn + string2 + "###";
                MaxAdWaterfallInfo maxAdWaterfallInfo3 = error.getWaterfall();
                strReturn = strReturn + (maxAdWaterfallInfo3 != null ? Long.valueOf(maxAdWaterfallInfo3.getLatencyMillis()) : null) + "###";
                MaxAdWaterfallInfo maxAdWaterfallInfo4 = error.getWaterfall();
                List list = maxAdWaterfallInfo4 != null ? maxAdWaterfallInfo4.getNetworkResponses() : null;
                Intrinsics.checkNotNull((Object)list);
                for (MaxNetworkResponseInfo networkResponse : list) {
                    strReturn = strReturn + networkResponse.getMediatedNetwork() + "..." + networkResponse.getAdLoadState() + "..." + networkResponse.getLatencyMillis();
                    strReturn = strReturn + (String)(networkResponse.getError() != null ? "..." + networkResponse.getError() : "...no errors");
                }
                return strReturn;
            }
            catch (Exception e) {
                e.printStackTrace();
                return "Could not generate string, error: " + e.getMessage();
            }
        }
        return "ad was null";
    }

    private final String getSdkKeyFromManifest(Context context) {
        String string;
        try {
            Bundle bundle = context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
            Intrinsics.checkNotNullExpressionValue((Object)bundle, (String)"metaData");
            Bundle metaData = bundle;
            string = String.valueOf(metaData.get("cdo.applovin.sdk.key"));
        }
        catch (Exception e) {
            string = null;
        }
        return string;
    }

    private static final void initialize$lambda$2$lambda$1(AppLovinSdkConfiguration configuration) {
        CLog.d(TAG, "Applovin initializeSdk returned");
        CLog.d(TAG, configuration.toString());
        Iterable $this$forEach$iv = initListenerList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
        initListenerList.clear();
    }

    static {
        initListenerList = new ArrayList();
    }
}

