/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.providers.applovin;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.os.BundleKt;
import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdRevenueListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.nativeAds.MaxNativeAd;
import com.applovin.mediation.nativeAds.MaxNativeAdListener;
import com.applovin.mediation.nativeAds.MaxNativeAdLoader;
import com.applovin.mediation.nativeAds.MaxNativeAdView;
import com.applovin.mediation.nativeAds.MaxNativeAdViewBinder;
import com.calldorado.ads_base.R;
import com.calldorado.base.AdsUtils;
import com.calldorado.base.listeners.BannerListener;
import com.calldorado.base.listeners.OnAdLoaderFinishedListener;
import com.calldorado.base.loaders.BannerLoader;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.models.CalldoradoAdsError;
import com.calldorado.base.models.CustomAppLovinNativeAdsView;
import com.calldorado.base.models.debug.AdDebugLog;
import com.calldorado.base.providers.AppLovinSdkManager;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u00015B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0012\u0010!\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010\"\u001a\u0004\u0018\u00010 2\u0006\u0010#\u001a\u00020\rH\u0002J\n\u0010$\u001a\u0004\u0018\u00010 H\u0002J\n\u0010%\u001a\u0004\u0018\u00010 H\u0002J\b\u0010&\u001a\u00020\u001eH\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0019H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\n\u0010-\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010.\u001a\u00020\u0017H\u0016J\b\u0010/\u001a\u00020\u001eH\u0016J\u001c\u00100\u001a\u00020\u001e2\b\u00101\u001a\u0004\u0018\u00010\u00152\b\u00102\u001a\u0004\u0018\u00010 H\u0002J\u0006\u00103\u001a\u00020\u001eJ\b\u00104\u001a\u00020\u0017H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/calldorado/base/providers/applovin/AppLovinNativeBiddingLoader;", "Lcom/calldorado/base/loaders/BannerLoader;", "context", "Landroid/content/Context;", "loaderListener", "Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;", "adProfileModel", "Lcom/calldorado/base/models/AdProfileModel;", "customViewList", "", "Lcom/calldorado/base/models/CustomAppLovinNativeAdsView;", "(Landroid/content/Context;Lcom/calldorado/base/listeners/OnAdLoaderFinishedListener;Lcom/calldorado/base/models/AdProfileModel;Ljava/util/List;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "aspectRatio", "getAspectRatio", "setAspectRatio", "(Ljava/lang/String;)V", "loadedNativeAd", "Lcom/applovin/mediation/MaxAd;", "mIsDestroyed", "", "nativeAdContainerView", "Landroid/view/ViewGroup;", "nativeAdLoader", "Lcom/applovin/mediation/nativeAds/MaxNativeAdLoader;", "waterfallMessage", "changeColorsIfNeeded", "", "maxNativeAdView", "Lcom/applovin/mediation/nativeAds/MaxNativeAdView;", "changeMediaViewMargins", "createCustomAdView", "zoneName", "createNativeAdView", "createNativeAdViewBanner", "destroy", "getAdView", "getDynamicAdViewFromRatio", "ratio", "", "getNetworkResponse", "Lcom/calldorado/base/models/debug/AdDebugLog;", "getReward", "isDestroyed", "loadAd", "modifyNativeAdContainerLayout", "ad", "nativeAdView", "performTheAdLoad", "showAd", "NativeAdListener", "base_release"})
@SourceDebugExtension(value={"SMAP\nAppLovinNativeBiddingLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLovinNativeBiddingLoader.kt\ncom/calldorado/base/providers/applovin/AppLovinNativeBiddingLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,530:1\n1#2:531\n321#3,4:532\n*S KotlinDebug\n*F\n+ 1 AppLovinNativeBiddingLoader.kt\ncom/calldorado/base/providers/applovin/AppLovinNativeBiddingLoader\n*L\n524#1:532,4\n*E\n"})
public final class AppLovinNativeBiddingLoader
extends BannerLoader {
    @NotNull
    private final List<CustomAppLovinNativeAdsView> customViewList;
    @NotNull
    private final String TAG;
    @NotNull
    private String aspectRatio;
    @NotNull
    private final ViewGroup nativeAdContainerView;
    @Nullable
    private MaxNativeAdLoader nativeAdLoader;
    @Nullable
    private MaxAd loadedNativeAd;
    private boolean mIsDestroyed;
    @NotNull
    private String waterfallMessage;

    public AppLovinNativeBiddingLoader(@NotNull Context context, @NotNull OnAdLoaderFinishedListener loaderListener, @NotNull AdProfileModel adProfileModel, @NotNull List<CustomAppLovinNativeAdsView> customViewList) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)loaderListener, (String)"loaderListener");
        Intrinsics.checkNotNullParameter((Object)adProfileModel, (String)"adProfileModel");
        Intrinsics.checkNotNullParameter(customViewList, (String)"customViewList");
        super(context, loaderListener, adProfileModel);
        this.customViewList = customViewList;
        this.TAG = "7.0_AppLovinNativeBiddingLoader";
        this.aspectRatio = "";
        this.nativeAdContainerView = (ViewGroup)new FrameLayout(context);
        this.waterfallMessage = "";
    }

    public /* synthetic */ AppLovinNativeBiddingLoader(Context context, OnAdLoaderFinishedListener onAdLoaderFinishedListener, AdProfileModel adProfileModel, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(context, onAdLoaderFinishedListener, adProfileModel, list);
    }

    @Override
    @NotNull
    public String getTAG() {
        return this.TAG;
    }

    @NotNull
    public final String getAspectRatio() {
        return this.aspectRatio;
    }

    public final void setAspectRatio(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aspectRatio = string;
    }

    @Override
    public boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    @Override
    @Nullable
    public ViewGroup getAdView() {
        return this.nativeAdContainerView;
    }

    @Override
    public boolean showAd() {
        return false;
    }

    @Override
    @Nullable
    public String getReward() {
        return null;
    }

    @Override
    @NotNull
    public AdDebugLog getNetworkResponse() {
        return AppLovinSdkManager.INSTANCE.getNetworkResponse(this.loadedNativeAd);
    }

    private final MaxNativeAdView createCustomAdView(String zoneName) {
        MaxNativeAdView maxNativeAdView;
        try {
            CustomAppLovinNativeAdsView customView;
            Object v0;
            block3: {
                Iterable iterable = this.customViewList;
                for (Object t : iterable) {
                    CustomAppLovinNativeAdsView it = (CustomAppLovinNativeAdsView)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getZoneName(), (Object)zoneName)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            CustomAppLovinNativeAdsView customAppLovinNativeAdsView = customView = (CustomAppLovinNativeAdsView)v0;
            Integer n = customAppLovinNativeAdsView != null ? customAppLovinNativeAdsView.getLayout() : null;
            Intrinsics.checkNotNull((Object)n);
            MaxNativeAdViewBinder.Builder builder = new MaxNativeAdViewBinder.Builder(n.intValue());
            Integer n2 = customView.getTitle();
            Intrinsics.checkNotNull((Object)n2);
            MaxNativeAdViewBinder.Builder builder2 = builder.setTitleTextViewId(n2.intValue());
            Integer n3 = customView.getBody();
            Intrinsics.checkNotNull((Object)n3);
            MaxNativeAdViewBinder.Builder builder3 = builder2.setBodyTextViewId(n3.intValue());
            Integer n4 = customView.getOptions();
            Intrinsics.checkNotNull((Object)n4);
            MaxNativeAdViewBinder.Builder builder4 = builder3.setOptionsContentViewGroupId(n4.intValue());
            Integer n5 = customView.getIcon();
            Intrinsics.checkNotNull((Object)n5);
            MaxNativeAdViewBinder.Builder builder5 = builder4.setIconImageViewId(n5.intValue());
            Integer n6 = customView.getMediaContent();
            Intrinsics.checkNotNull((Object)n6);
            MaxNativeAdViewBinder.Builder builder6 = builder5.setMediaContentViewGroupId(n6.intValue());
            Integer n7 = customView.getCallToAction();
            Intrinsics.checkNotNull((Object)n7);
            MaxNativeAdViewBinder maxNativeAdViewBinder = builder6.setCallToActionButtonId(n7.intValue()).build();
            Intrinsics.checkNotNullExpressionValue((Object)maxNativeAdViewBinder, (String)"build(...)");
            MaxNativeAdViewBinder binder = maxNativeAdViewBinder;
            maxNativeAdView = new MaxNativeAdView(binder, this.getContext());
        }
        catch (Exception e) {
            maxNativeAdView = this.createNativeAdView();
        }
        return maxNativeAdView;
    }

    private final MaxNativeAdView createNativeAdView() {
        MaxNativeAdView maxNativeAdView;
        try {
            MaxNativeAdViewBinder maxNativeAdViewBinder = new MaxNativeAdViewBinder.Builder(R.layout.cdo_applovin_native_custom_ad_view_1_91).setOptionsContentViewGroupId(R.id.ad_options_view).setTitleTextViewId(R.id.title_text_view).setBodyTextViewId(R.id.body_text_view).setAdvertiserTextViewId(R.id.advertiser_textView).setIconImageViewId(R.id.icon_image_view).setMediaContentViewGroupId(R.id.media_view_container).setCallToActionButtonId(R.id.cta_button).build();
            Intrinsics.checkNotNullExpressionValue((Object)maxNativeAdViewBinder, (String)"build(...)");
            MaxNativeAdViewBinder binder = maxNativeAdViewBinder;
            maxNativeAdView = new MaxNativeAdView(binder, this.getContext());
        }
        catch (Exception e) {
            maxNativeAdView = null;
        }
        return maxNativeAdView;
    }

    private final MaxNativeAdView createNativeAdViewBanner() {
        try {
            MaxNativeAdViewBinder applovinBinder = new MaxNativeAdViewBinder.Builder(R.layout.cdo_layout_applovin_ad).setOptionsContentViewGroupId(R.id.ad_options_view).setTitleTextViewId(R.id.title_text_view).setBodyTextViewId(R.id.native_ad_text).setAdvertiserTextViewId(R.id.advertiser_textView).setMediaContentViewGroupId(R.id.media_view_container).setCallToActionButtonId(R.id.cta_button).build();
            MaxNativeAdView maxNativeAdView = new MaxNativeAdView(applovinBinder, this.getContext());
            this.changeColorsIfNeeded(maxNativeAdView);
            return maxNativeAdView;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void changeColorsIfNeeded(MaxNativeAdView maxNativeAdView) {
        int it;
        ConstraintLayout rootView = (ConstraintLayout)maxNativeAdView.findViewById(R.id.root_view);
        Button ctaButton = (Button)maxNativeAdView.findViewById(R.id.cta_button);
        TextView sponsoredTv = (TextView)maxNativeAdView.findViewById(R.id.mediationAds_tv_sponsored);
        TextView advertiserTv = (TextView)maxNativeAdView.findViewById(R.id.advertiser_textView);
        TextView titleTv = (TextView)maxNativeAdView.findViewById(R.id.title_text_view);
        TextView bodyTv = (TextView)maxNativeAdView.findViewById(R.id.native_ad_text);
        Drawable drawable = ctaButton.getBackground();
        GradientDrawable ctaButtonDrawable = drawable instanceof GradientDrawable ? (GradientDrawable)drawable : null;
        Integer n = this.getAdProfileModel().getAdBackgroundColor();
        if (n != null) {
            it = ((Number)n).intValue();
            boolean bl = false;
            rootView.setBackgroundColor(it);
        }
        Integer n2 = this.getAdProfileModel().getCtaButtonColor();
        if (n2 != null) {
            it = ((Number)n2).intValue();
            boolean bl = false;
            GradientDrawable gradientDrawable = ctaButtonDrawable;
            if (gradientDrawable != null) {
                gradientDrawable.setColor(it);
            }
        }
        Integer n3 = this.getAdProfileModel().getCtaButtonOutlineColor();
        if (n3 != null) {
            it = ((Number)n3).intValue();
            boolean bl = false;
            GradientDrawable gradientDrawable = ctaButtonDrawable;
            if (gradientDrawable != null) {
                gradientDrawable.setStroke(this.getContext().getResources().getDimensionPixelSize(R.dimen.cdo_native_cta_button_stroke_width), it);
            }
        }
        Integer n4 = this.getAdProfileModel().getCtaButtonTextColor();
        if (n4 != null) {
            it = ((Number)n4).intValue();
            boolean bl = false;
            ctaButton.setTextColor(it);
        }
        Integer n5 = this.getAdProfileModel().getTextColor();
        if (n5 != null) {
            it = ((Number)n5).intValue();
            boolean bl = false;
            sponsoredTv.setTextColor(it);
            advertiserTv.setTextColor(it);
            titleTv.setTextColor(it);
            bodyTv.setTextColor(it);
        }
        ctaButton.setBackground((Drawable)ctaButtonDrawable);
    }

    @Override
    public void loadAd() {
        this.mIsDestroyed = false;
        CLog.d(this.getTAG(), "loadAd");
        if (!AppLovinSdkManager.INSTANCE.isAppLovinInitialized()) {
            CLog.d(this.getTAG(), "applovin is not yet initialized");
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AppLovinNativeBiddingLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            CLog.d(this.this$0.getTAG(), "trying to initialize applovin");
                            long startInitTimeLng = System.currentTimeMillis();
                            AppLovinSdkManager.INSTANCE.initialize(this.this$0.getContext(), this.this$0.getAdProfileModel().getAdRetry(), this.this$0.isPersonalisedAdsAllowed(), (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, startInitTimeLng){
                                final /* synthetic */ AppLovinNativeBiddingLoader this$0;
                                final /* synthetic */ long $startInitTimeLng;
                                {
                                    this.this$0 = $receiver;
                                    this.$startInitTimeLng = $startInitTimeLng;
                                    super(0);
                                }

                                public final void invoke() {
                                    CLog.d(this.this$0.getTAG(), "applovin is now initialized");
                                    long endInitTimeLng = System.currentTimeMillis();
                                    if (this.this$0.getAdProfileModel().getWaitForInit()) {
                                        this.this$0.performTheAdLoad();
                                    }
                                    this.this$0.getListener().onAdLoaderInitialized(this.this$0, "applovin", endInitTimeLng - this.$startInitTimeLng);
                                }
                            }));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            if (!this.getAdProfileModel().getWaitForInit()) {
                CLog.d(this.getTAG(), "returning onAdLoaderFailed");
                this.getListener().onAdLoaderFailed(this, new CalldoradoAdsError(1, "1###not initialized###isAppLovinInitialized returned false", "applovin", "applovin", this.getAdProfileModel().getAdUnit()));
            } else {
                CLog.d(this.getTAG(), "just wait for init");
            }
        } else {
            this.performTheAdLoad();
        }
    }

    public final void performTheAdLoad() {
        if (!this.mIsDestroyed) {
            BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ AppLovinNativeBiddingLoader this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            try {
                                CLog.d(this.this$0.getTAG(), "performing the loadAd attempt");
                                AppLovinNativeBiddingLoader.access$setNativeAdLoader$p(this.this$0, new MaxNativeAdLoader(this.this$0.getAdProfileModel().getAdUnit(), AppLovinSdkManager.INSTANCE.getAppLovinSdkInstance(), this.this$0.getContext()));
                                MaxNativeAdLoader maxNativeAdLoader = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxNativeAdLoader);
                                maxNativeAdLoader.setRevenueListener(new MaxAdRevenueListener(this.this$0){
                                    final /* synthetic */ AppLovinNativeBiddingLoader this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    public void onAdRevenuePaid(@Nullable MaxAd ad) {
                                        CLog.d(this.this$0.getTAG(), "onAdRevenuePaid");
                                        if (AppLovinNativeBiddingLoader.access$getMIsDestroyed$p(this.this$0)) {
                                            return;
                                        }
                                        double adRevenueDbl = 0.0;
                                        Object placementIdStr = "";
                                        if (ad != null) {
                                            adRevenueDbl = ad.getRevenue();
                                            if (adRevenueDbl < 0.0) {
                                                adRevenueDbl = 0.0;
                                            }
                                            placementIdStr = ad.getNetworkName() + " " + ad.getNetworkPlacement();
                                            this.this$0.getListener().onAdRevenuePaid(this.this$0, adRevenueDbl, (String)placementIdStr);
                                            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"ad_platform", (Object)"appLovin"), TuplesKt.to((Object)"ad_source", (Object)ad.getNetworkName()), TuplesKt.to((Object)"ad_format", (Object)ad.getFormat().getLabel()), TuplesKt.to((Object)"ad_unit_name", (Object)ad.getAdUnitId()), TuplesKt.to((Object)"value", (Object)adRevenueDbl), TuplesKt.to((Object)"currency", (Object)"USD")};
                                            this.this$0.getListener().onAdRevenueParams(this.this$0, BundleKt.bundleOf((Pair[])pairArray));
                                        }
                                    }
                                });
                                MaxNativeAdLoader maxNativeAdLoader2 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                Intrinsics.checkNotNull((Object)maxNativeAdLoader2);
                                maxNativeAdLoader2.setNativeAdListener((MaxNativeAdListener)this.this$0.new NativeAdListener());
                                if (AdsUtils.INSTANCE.isRightToLeftLanguage()) {
                                    MaxNativeAdLoader maxNativeAdLoader3 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                    if (maxNativeAdLoader3 != null) {
                                        maxNativeAdLoader3.setLocalExtraParameter("admob_ad_choices_placement", (Object)Boxing.boxInt((int)0));
                                    }
                                    MaxNativeAdLoader maxNativeAdLoader4 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                    if (maxNativeAdLoader4 != null) {
                                        maxNativeAdLoader4.setLocalExtraParameter("gam_ad_choices_placement", (Object)Boxing.boxInt((int)0));
                                    }
                                }
                                CLog.d(this.this$0.getTAG(), "performTheAdLoad: adprofilemodel template = " + this.this$0.getAdProfileModel().getTemplate());
                                switch (this.this$0.getAdProfileModel().getTemplate()) {
                                    case 1: {
                                        MaxNativeAdLoader maxNativeAdLoader5 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader5 != null) {
                                            maxNativeAdLoader5.loadAd(AppLovinNativeBiddingLoader.access$createNativeAdViewBanner(this.this$0));
                                        }
                                        break;
                                    }
                                    case 2: {
                                        MaxNativeAdLoader maxNativeAdLoader6 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader6 != null) {
                                            maxNativeAdLoader6.loadAd();
                                        }
                                        break;
                                    }
                                    case 3: {
                                        MaxNativeAdLoader maxNativeAdLoader7 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader7 != null) {
                                            maxNativeAdLoader7.loadAd(AppLovinNativeBiddingLoader.access$createNativeAdView(this.this$0));
                                        }
                                        break;
                                    }
                                    case 4: {
                                        MaxNativeAdLoader maxNativeAdLoader8 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader8 != null) {
                                            maxNativeAdLoader8.loadAd();
                                        }
                                        break;
                                    }
                                    case 5: {
                                        MaxNativeAdLoader maxNativeAdLoader9 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader9 != null) {
                                            maxNativeAdLoader9.loadAd(AppLovinNativeBiddingLoader.access$createCustomAdView(this.this$0, this.this$0.getAdProfileModel().getZone()));
                                        }
                                        break;
                                    }
                                    default: {
                                        MaxNativeAdLoader maxNativeAdLoader10 = AppLovinNativeBiddingLoader.access$getNativeAdLoader$p(this.this$0);
                                        if (maxNativeAdLoader10 != null) {
                                            maxNativeAdLoader10.loadAd(AppLovinNativeBiddingLoader.access$createNativeAdView(this.this$0));
                                        }
                                        break;
                                    }
                                }
                            }
                            catch (Exception e) {
                                CLog.d(this.this$0.getTAG(), "loadAd Exception " + e.getMessage());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @Override
    public void destroy() {
        try {
            this.mIsDestroyed = true;
            ViewGroup viewGroup = this.nativeAdContainerView;
            Intrinsics.checkNotNull((Object)viewGroup);
            viewGroup.removeAllViews();
        }
        catch (Exception e) {
            CLog.d(this.getTAG(), "destroy Exception: " + e.getMessage());
        }
    }

    private final MaxNativeAdView getDynamicAdViewFromRatio(float ratio) {
        double d;
        int layoutRes = 0;
        try {
            d = (double)MathKt.roundToInt((double)((double)ratio * 1000.0)) / 1000.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            d = 0.0;
        }
        double roundedRatio = d;
        CLog.d(this.getTAG(), "getDynamicAdViewFromRation: rounded ratio = " + roundedRatio);
        d = roundedRatio;
        boolean bl = 1.201 <= d ? d <= 1.4 : false;
        if (bl) {
            layoutRes = R.layout.cdo_applovin_native_template_1_3;
            CLog.d(this.getTAG(), "getDynamicAdViewFromRation: template 1.3");
        } else {
            boolean bl2 = 0.7 <= d ? d <= 1.2 : false;
            if (bl2) {
                layoutRes = R.layout.cdo_applovin_native_template_1;
                CLog.d(this.getTAG(), "getDynamicAdViewFromRation: template 1");
            } else {
                boolean bl3 = 0.001 <= d ? d <= 0.699 : false;
                if (bl3) {
                    layoutRes = R.layout.cdo_applovin_native_template_0_5;
                    CLog.d(this.getTAG(), "getDynamicAdViewFromRation: template 0.5");
                } else {
                    layoutRes = R.layout.cdo_applovin_native_custom_ad_view_1_91;
                    CLog.d(this.getTAG(), "getDynamicAdViewFromRation: template default, 1.91");
                }
            }
        }
        MaxNativeAdViewBinder maxNativeAdViewBinder = new MaxNativeAdViewBinder.Builder(layoutRes).setOptionsContentViewGroupId(R.id.ad_options_view).setTitleTextViewId(R.id.title_text_view).setBodyTextViewId(R.id.body_text_view).setAdvertiserTextViewId(R.id.advertiser_textView).setIconImageViewId(R.id.icon_image_view).setMediaContentViewGroupId(R.id.media_view_container).setCallToActionButtonId(R.id.cta_button).build();
        Intrinsics.checkNotNullExpressionValue((Object)maxNativeAdViewBinder, (String)"build(...)");
        MaxNativeAdViewBinder binder = maxNativeAdViewBinder;
        MaxNativeAdView maxNativeAdView = new MaxNativeAdView(binder, this.getContext());
        LinearLayout adMediaViewContainer = (LinearLayout)maxNativeAdView.findViewById(R.id.media_view_container);
        ViewGroup.LayoutParams layoutParams = adMediaViewContainer.getLayoutParams();
        ConstraintLayout.LayoutParams layoutParams2 = layoutParams instanceof ConstraintLayout.LayoutParams ? (ConstraintLayout.LayoutParams)layoutParams : null;
        if (layoutParams2 != null) {
            (layoutParams2 = layoutParams instanceof ConstraintLayout.LayoutParams ? (ConstraintLayout.LayoutParams)layoutParams : null).dimensionRatio = String.valueOf(roundedRatio);
        }
        adMediaViewContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.aspectRatio = String.valueOf(roundedRatio);
        AppLovinSdkManager.INSTANCE.setAspectRatio(this.aspectRatio);
        return maxNativeAdView;
    }

    private final void modifyNativeAdContainerLayout(MaxAd ad, MaxNativeAdView nativeAdView) {
        View mediaView;
        MaxAd maxAd = ad;
        View view = maxAd != null && (maxAd = maxAd.getNativeAd()) != null ? maxAd.getMediaView() : (mediaView = null);
        if (mediaView != null) {
            MaxNativeAdView maxNativeAdView;
            Float mediaAspectRatio;
            MaxNativeAd maxNativeAd = ad.getNativeAd();
            Float f = mediaAspectRatio = maxNativeAd != null ? Float.valueOf(maxNativeAd.getMediaContentAspectRatio()) : null;
            if (f != null) {
                float it = ((Number)f).floatValue();
                boolean bl = false;
                if (!Float.isNaN(it) && !(it == 0.0f)) {
                    LinearLayout adMediaViewContainer;
                    MaxNativeAdView maxNativeAdView2 = nativeAdView;
                    LinearLayout linearLayout = adMediaViewContainer = maxNativeAdView2 != null ? (LinearLayout)maxNativeAdView2.findViewById(R.id.media_view_container) : null;
                    Object object = linearLayout != null ? linearLayout.getLayoutParams() : null;
                    ConstraintLayout.LayoutParams layoutParams = object instanceof ConstraintLayout.LayoutParams ? (ConstraintLayout.LayoutParams)object : null;
                    if (layoutParams != null) {
                        (layoutParams = object instanceof ConstraintLayout.LayoutParams ? (ConstraintLayout.LayoutParams)object : null).dimensionRatio = String.valueOf(it);
                    }
                    LinearLayout linearLayout2 = adMediaViewContainer;
                    if (linearLayout2 != null) {
                        linearLayout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }
            }
            if ((maxNativeAdView = nativeAdView) != null && (maxNativeAdView = maxNativeAdView.getMediaContentViewGroup()) != null) {
                maxNativeAdView.addView(mediaView);
            }
        } else {
            this.changeMediaViewMargins(nativeAdView);
        }
    }

    private final void changeMediaViewMargins(MaxNativeAdView maxNativeAdView) {
        block1: {
            LinearLayout linearLayoutContainer;
            MaxNativeAdView maxNativeAdView2 = maxNativeAdView;
            LinearLayout linearLayout = linearLayoutContainer = maxNativeAdView2 != null ? (LinearLayout)maxNativeAdView2.findViewById(R.id.linear_container) : null;
            if (linearLayout == null) break block1;
            View $this$updateLayoutParams$iv = (View)linearLayout;
            boolean $i$f$updateLayoutParamsTyped = false;
            ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
            }
            ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
            ConstraintLayout.LayoutParams $this$changeMediaViewMargins_u24lambda_u247 = (ConstraintLayout.LayoutParams)params$iv;
            boolean bl = false;
            $this$changeMediaViewMargins_u24lambda_u247.setMarginStart(this.getContext().getResources().getDimensionPixelSize(R.dimen.cdo_native_banner_ad_margin_start));
            $this$changeMediaViewMargins_u24lambda_u247.startToStart = 0;
            $this$updateLayoutParams$iv.setLayoutParams(params$iv);
        }
    }

    public static final /* synthetic */ void access$setNativeAdLoader$p(AppLovinNativeBiddingLoader $this, MaxNativeAdLoader maxNativeAdLoader) {
        $this.nativeAdLoader = maxNativeAdLoader;
    }

    public static final /* synthetic */ MaxNativeAdView access$createNativeAdViewBanner(AppLovinNativeBiddingLoader $this) {
        return $this.createNativeAdViewBanner();
    }

    public static final /* synthetic */ MaxNativeAdView access$createNativeAdView(AppLovinNativeBiddingLoader $this) {
        return $this.createNativeAdView();
    }

    public static final /* synthetic */ MaxNativeAdView access$createCustomAdView(AppLovinNativeBiddingLoader $this, String zoneName) {
        return $this.createCustomAdView(zoneName);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/calldorado/base/providers/applovin/AppLovinNativeBiddingLoader$NativeAdListener;", "Lcom/applovin/mediation/nativeAds/MaxNativeAdListener;", "(Lcom/calldorado/base/providers/applovin/AppLovinNativeBiddingLoader;)V", "onNativeAdClicked", "", "nativeAd", "Lcom/applovin/mediation/MaxAd;", "onNativeAdLoadFailed", "adUnitId", "", "error", "Lcom/applovin/mediation/MaxError;", "onNativeAdLoaded", "nativeAdView", "Lcom/applovin/mediation/nativeAds/MaxNativeAdView;", "ad", "base_release"})
    private final class NativeAdListener
    extends MaxNativeAdListener {
        public void onNativeAdLoaded(@Nullable MaxNativeAdView nativeAdView, @Nullable MaxAd ad) {
            try {
                MaxNativeAdView maxNativeAdView;
                AppLovinNativeBiddingLoader appLovinNativeBiddingLoader;
                MaxNativeAdView adView;
                AppLovinNativeBiddingLoader.this.waterfallMessage = AppLovinSdkManager.INSTANCE.getDetailsAsString(ad);
                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoaded");
                if (AppLovinNativeBiddingLoader.this.mIsDestroyed) {
                    return;
                }
                if (AppLovinNativeBiddingLoader.this.loadedNativeAd != null) {
                    MaxNativeAdLoader maxNativeAdLoader = AppLovinNativeBiddingLoader.this.nativeAdLoader;
                    Intrinsics.checkNotNull((Object)maxNativeAdLoader);
                    maxNativeAdLoader.destroy(AppLovinNativeBiddingLoader.this.loadedNativeAd);
                }
                if ((adView = nativeAdView) == null) {
                    appLovinNativeBiddingLoader = AppLovinNativeBiddingLoader.this;
                    appLovinNativeBiddingLoader.waterfallMessage = appLovinNativeBiddingLoader.waterfallMessage + adView + " from onNativeAdLoaded is NULL";
                }
                MaxAd maxAd = ad;
                if (maxAd != null) {
                    appLovinNativeBiddingLoader = maxAd;
                    AppLovinNativeBiddingLoader appLovinNativeBiddingLoader2 = AppLovinNativeBiddingLoader.this;
                    AppLovinNativeBiddingLoader it = appLovinNativeBiddingLoader;
                    boolean bl = false;
                    CLog.d(appLovinNativeBiddingLoader2.getTAG(), "onNativeAdLoaded from network " + it.getNetworkName());
                }
                switch (AppLovinNativeBiddingLoader.this.getAdProfileModel().getTemplate()) {
                    case 1: {
                        AppLovinNativeBiddingLoader.this.modifyNativeAdContainerLayout(ad, nativeAdView);
                        break;
                    }
                    case 3: 
                    case 4: {
                        MaxNativeAd nativeAd;
                        MaxAd maxAd2 = ad;
                        Object object = nativeAd = maxAd2 != null ? maxAd2.getNativeAd() : null;
                        if (nativeAd == null) break;
                        float aspectRatio = nativeAd.getMediaContentAspectRatio();
                        CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoaded: media content aspect ratio = " + aspectRatio);
                        if (Float.isNaN(aspectRatio) || aspectRatio == 0.0f) {
                            try {
                                MaxNativeAd.MaxNativeAdImage maxNativeAdImage;
                                MaxNativeAd.MaxNativeAdImage maxNativeAdImage2;
                                MaxNativeAd.MaxNativeAdImage maxNativeAdImage3 = nativeAd.getMainImage();
                                float f = maxNativeAdImage3 != null && (maxNativeAdImage3 = maxNativeAdImage3.getDrawable()) != null ? (float)maxNativeAdImage3.getIntrinsicHeight() : 0.0f;
                                MaxNativeAd.MaxNativeAdImage maxNativeAdImage4 = nativeAd.getMainImage();
                                Float f2 = maxNativeAdImage4 != null && (maxNativeAdImage4 = maxNativeAdImage4.getDrawable()) != null ? Float.valueOf(maxNativeAdImage4.getIntrinsicWidth()) : null;
                                Intrinsics.checkNotNull(f2);
                                aspectRatio = f / f2.floatValue();
                                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoaded: aspect ratio is nan or 0f, intrinsic height = " + ((maxNativeAdImage2 = nativeAd.getMainImage()) != null && (maxNativeAdImage2 = maxNativeAdImage2.getDrawable()) != null ? Integer.valueOf(maxNativeAdImage2.getIntrinsicHeight()) : null));
                                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoaded: aspect ratio is nan or 0f, intrinsic width = " + ((maxNativeAdImage = nativeAd.getMainImage()) != null && (maxNativeAdImage = maxNativeAdImage.getDrawable()) != null ? Integer.valueOf(maxNativeAdImage.getIntrinsicWidth()) : null));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if ((adView = !Float.isNaN(aspectRatio) && !(aspectRatio == 0.0f) ? AppLovinNativeBiddingLoader.this.getDynamicAdViewFromRatio(aspectRatio) : AppLovinNativeBiddingLoader.this.getDynamicAdViewFromRatio(0.0f)) == null) {
                            AppLovinNativeBiddingLoader appLovinNativeBiddingLoader3 = AppLovinNativeBiddingLoader.this;
                            appLovinNativeBiddingLoader3.waterfallMessage = appLovinNativeBiddingLoader3.waterfallMessage + "adView is NULL after dynamic ratio layout change";
                            break;
                        }
                        MaxNativeAdLoader maxNativeAdLoader = AppLovinNativeBiddingLoader.this.nativeAdLoader;
                        if (maxNativeAdLoader == null) break;
                        maxNativeAdLoader.render(adView, ad);
                        break;
                    }
                }
                if ((maxNativeAdView = adView) != null && (maxNativeAdView = (TextView)maxNativeAdView.findViewById(R.id.native_ad_privacy_information_icon_image)) != null) {
                    maxNativeAdView.setOnClickListener(arg_0 -> NativeAdListener.onNativeAdLoaded$lambda$1(AppLovinNativeBiddingLoader.this, arg_0));
                }
                AppLovinNativeBiddingLoader.this.loadedNativeAd = ad;
                AppLovinNativeBiddingLoader.this.nativeAdContainerView.removeAllViews();
                AppLovinNativeBiddingLoader.this.nativeAdContainerView.addView((View)adView);
                AppLovinNativeBiddingLoader.this.getListener().onAdLoaderSuccess(AppLovinNativeBiddingLoader.this, AppLovinSdkManager.INSTANCE.getDetailsAsString(ad));
            }
            catch (Exception e) {
                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoaded Exception " + e.getMessage());
                AppLovinNativeBiddingLoader.this.getListener().onAdLoaderFailed(AppLovinNativeBiddingLoader.this, new CalldoradoAdsError(1, "onAdLoaderFailed Exception " + e.getMessage() + ", waterfallmessage = " + AppLovinNativeBiddingLoader.this.waterfallMessage, "applovin", "applovin", AppLovinNativeBiddingLoader.this.getAdProfileModel().getAdUnit()));
            }
        }

        public void onNativeAdLoadFailed(@NotNull String adUnitId, @NotNull MaxError error) {
            Intrinsics.checkNotNullParameter((Object)adUnitId, (String)"adUnitId");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            try {
                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdLoadFailed");
                if (AppLovinNativeBiddingLoader.this.mIsDestroyed) {
                    return;
                }
                String strMessage = AppLovinSdkManager.INSTANCE.getErrorDetailsAsString(error);
                AppLovinNativeBiddingLoader.this.getListener().onAdLoaderFailed(AppLovinNativeBiddingLoader.this, new CalldoradoAdsError(error.getCode(), strMessage, "applovin", "applovin", AppLovinNativeBiddingLoader.this.getAdProfileModel().getAdUnit()));
            }
            catch (Exception e) {
                AppLovinNativeBiddingLoader.this.getListener().onAdLoaderFailed(AppLovinNativeBiddingLoader.this, new CalldoradoAdsError(1, "onAdLoaderFailed Exception " + e.getMessage(), "applovin", "applovin", AppLovinNativeBiddingLoader.this.getAdProfileModel().getAdUnit()));
            }
        }

        public void onNativeAdClicked(@NotNull MaxAd nativeAd) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)nativeAd, (String)"nativeAd");
                CLog.d(AppLovinNativeBiddingLoader.this.getTAG(), "onNativeAdClicked");
                if (AppLovinNativeBiddingLoader.this.mIsDestroyed) {
                    return;
                }
                BannerListener bannerListener = AppLovinNativeBiddingLoader.this.getEventListener();
                if (bannerListener == null) break block1;
                bannerListener.onAdClicked(AppLovinNativeBiddingLoader.this);
            }
        }

        private static final void onNativeAdLoaded$lambda$1(AppLovinNativeBiddingLoader this$0, View it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            try {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"https://www.applovin.com"));
                intent.setFlags(0x10000000);
                this$0.getContext().startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

