/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.repository;

import com.calldorado.base.NativeAdCustomColor;
import com.calldorado.base.logging.CLog;
import com.calldorado.base.models.AdProfileModel;
import com.calldorado.base.models.AdsCardSize;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00052\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011H\u0002J\u0016\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005R:\u0010\u0003\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR6\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\nR.\u0010\u000f\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/calldorado/base/repository/AdProfilesRepository;", "", "()V", "adSizePerZone", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getAdSizePerZone", "()Ljava/util/HashMap;", "setAdSizePerZone", "(Ljava/util/HashMap;)V", "customColorList", "Lcom/calldorado/base/NativeAdCustomColor;", "getCustomColorList", "setCustomColorList", "waterfallConfig", "changeColorIfNeeded", "", "Lcom/calldorado/base/models/AdProfileModel;", "zoneName", "adProfileModelList", "getAdProfiles", "getAdSizeFromLoadedZoneName", "Lcom/calldorado/base/models/AdsCardSize;", "zone", "setZone", "", "element", "Companion", "base_release"})
@SourceDebugExtension(value={"SMAP\nAdProfilesRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdProfilesRepository.kt\ncom/calldorado/base/repository/AdProfilesRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,71:1\n1855#2,2:72\n1282#3,2:74\n*S KotlinDebug\n*F\n+ 1 AdProfilesRepository.kt\ncom/calldorado/base/repository/AdProfilesRepository\n*L\n50#1:72,2\n64#1:74,2\n*E\n"})
public final class AdProfilesRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, String> waterfallConfig = new HashMap();
    @NotNull
    private HashMap<String, NativeAdCustomColor> customColorList = new HashMap();
    @NotNull
    private HashMap<String, String> adSizePerZone = new HashMap();
    @NotNull
    public static final String TAG = "AdProfilesRepository";

    @NotNull
    public final HashMap<String, NativeAdCustomColor> getCustomColorList() {
        return this.customColorList;
    }

    public final void setCustomColorList(@NotNull HashMap<String, NativeAdCustomColor> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.customColorList = hashMap;
    }

    @NotNull
    public final HashMap<String, String> getAdSizePerZone() {
        return this.adSizePerZone;
    }

    public final void setAdSizePerZone(@NotNull HashMap<String, String> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.adSizePerZone = hashMap;
    }

    @Nullable
    public final List<AdProfileModel> getAdProfiles(@NotNull String zoneName) {
        List<AdProfileModel> list;
        Intrinsics.checkNotNullParameter((Object)zoneName, (String)"zoneName");
        try {
            List<AdProfileModel> adProfileModelList2 = (List<AdProfileModel>)new Gson().fromJson(this.waterfallConfig.get(zoneName), new TypeToken<List<? extends AdProfileModel>>(){}.getType());
            Map map = this.adSizePerZone;
            List<AdProfileModel> list2 = adProfileModelList2;
            String string = list2 != null && (list2 = (AdProfileModel)CollectionsKt.first((List)list2)) != null ? ((AdProfileModel)((Object)list2)).getSize() : null;
            map.put(zoneName, string);
            adProfileModelList2 = this.changeColorIfNeeded(zoneName, adProfileModelList2);
        }
        catch (Exception e) {
            CLog.d(TAG, "getAdProfiles Exception " + e.getMessage());
            list = null;
        }
        return list;
    }

    public final void setZone(@NotNull String zoneName, @Nullable String element) {
        Intrinsics.checkNotNullParameter((Object)zoneName, (String)"zoneName");
        try {
            ((Map)this.waterfallConfig).put(zoneName, element);
        }
        catch (Exception e) {
            CLog.d(TAG, "setZone Exception " + e.getMessage());
        }
    }

    private final List<AdProfileModel> changeColorIfNeeded(String zoneName, List<AdProfileModel> adProfileModelList2) {
        block2: {
            if (!this.customColorList.containsKey(zoneName)) break block2;
            NativeAdCustomColor nativeAdCustomColor = this.customColorList.get(zoneName);
            List<AdProfileModel> list = adProfileModelList2;
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    AdProfileModel it = (AdProfileModel)element$iv;
                    boolean bl = false;
                    NativeAdCustomColor nativeAdCustomColor2 = nativeAdCustomColor;
                    it.setAdBackgroundColor(nativeAdCustomColor2 != null ? nativeAdCustomColor2.getAdBackgroundColor() : null);
                    NativeAdCustomColor nativeAdCustomColor3 = nativeAdCustomColor;
                    it.setCtaButtonColor(nativeAdCustomColor3 != null ? nativeAdCustomColor3.getCtaButtonColor() : null);
                    NativeAdCustomColor nativeAdCustomColor4 = nativeAdCustomColor;
                    it.setCtaButtonOutlineColor(nativeAdCustomColor4 != null ? nativeAdCustomColor4.getCtaButtonOutlineColor() : null);
                    NativeAdCustomColor nativeAdCustomColor5 = nativeAdCustomColor;
                    it.setCtaButtonTextColor(nativeAdCustomColor5 != null ? nativeAdCustomColor5.getCtaButtonTextColor() : null);
                    NativeAdCustomColor nativeAdCustomColor6 = nativeAdCustomColor;
                    it.setTextColor(nativeAdCustomColor6 != null ? nativeAdCustomColor6.getTextColor() : null);
                }
            }
        }
        return adProfileModelList2;
    }

    @NotNull
    public final AdsCardSize getAdSizeFromLoadedZoneName(@NotNull String zone) {
        AdsCardSize adsCardSize;
        AdsCardSize adsCardSize2;
        block3: {
            Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
            String string = this.adSizePerZone.get(zone);
            if (string == null) {
                return AdsCardSize.MEDIUM_RECTANGLE;
            }
            String sizeStr = string;
            AdsCardSize[] $this$firstOrNull$iv = AdsCardSize.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                AdsCardSize element$iv;
                AdsCardSize it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!StringsKt.equals((String)it.name(), (String)sizeStr, (boolean)true)) continue;
                adsCardSize2 = element$iv;
                break block3;
            }
            adsCardSize2 = adsCardSize = null;
        }
        if (adsCardSize2 == null) {
            adsCardSize = AdsCardSize.MEDIUM_RECTANGLE;
        }
        return adsCardSize;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/calldorado/base/repository/AdProfilesRepository$Companion;", "", "()V", "TAG", "", "base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

