/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.base.views;

import android.content.Context;
import android.view.ViewGroup;
import com.calldorado.base.AdClickOverlay;
import com.calldorado.base.OnSeenInterface;
import com.calldorado.base.VisibilityTracker;
import com.calldorado.base.loaders.AdLoader;
import com.calldorado.base.logging.CLog;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020!J\u0012\u0010&\u001a\u00020!2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010'\u001a\u00020!2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006)"}, d2={"Lcom/calldorado/base/views/CAdView;", "", "context", "Landroid/content/Context;", "adLoader", "Lcom/calldorado/base/loaders/AdLoader;", "(Landroid/content/Context;Lcom/calldorado/base/loaders/AdLoader;)V", "getAdLoader", "()Lcom/calldorado/base/loaders/AdLoader;", "getContext", "()Landroid/content/Context;", "listener", "Lcom/calldorado/base/OnSeenInterface;", "getListener", "()Lcom/calldorado/base/OnSeenInterface;", "setListener", "(Lcom/calldorado/base/OnSeenInterface;)V", "overlay", "Lcom/calldorado/base/AdClickOverlay;", "getOverlay", "()Lcom/calldorado/base/AdClickOverlay;", "setOverlay", "(Lcom/calldorado/base/AdClickOverlay;)V", "timeStart", "", "timeTotal", "tracker", "Lcom/calldorado/base/VisibilityTracker;", "getTracker", "()Lcom/calldorado/base/VisibilityTracker;", "setTracker", "(Lcom/calldorado/base/VisibilityTracker;)V", "destroy", "", "getView", "Landroid/view/ViewGroup;", "onPause", "onResume", "setAdOverlay", "setVisibilityTracker", "Companion", "base_release"})
public class CAdView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Context context;
    @NotNull
    private final AdLoader adLoader;
    @Nullable
    private VisibilityTracker tracker;
    @Nullable
    private AdClickOverlay overlay;
    private long timeStart;
    private long timeTotal;
    public OnSeenInterface listener;
    @NotNull
    public static final String TAG = "CAdView";

    public CAdView(@Nullable Context context, @NotNull AdLoader adLoader) {
        Intrinsics.checkNotNullParameter((Object)adLoader, (String)"adLoader");
        this.context = context;
        this.adLoader = adLoader;
        this.timeStart = System.currentTimeMillis();
    }

    @Nullable
    public final Context getContext() {
        return this.context;
    }

    @NotNull
    public final AdLoader getAdLoader() {
        return this.adLoader;
    }

    @Nullable
    protected final VisibilityTracker getTracker() {
        return this.tracker;
    }

    protected final void setTracker(@Nullable VisibilityTracker visibilityTracker) {
        this.tracker = visibilityTracker;
    }

    @Nullable
    protected final AdClickOverlay getOverlay() {
        return this.overlay;
    }

    protected final void setOverlay(@Nullable AdClickOverlay adClickOverlay) {
        this.overlay = adClickOverlay;
    }

    @NotNull
    public final OnSeenInterface getListener() {
        OnSeenInterface onSeenInterface = this.listener;
        if (onSeenInterface != null) {
            return onSeenInterface;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"listener");
        return null;
    }

    public final void setListener(@NotNull OnSeenInterface onSeenInterface) {
        Intrinsics.checkNotNullParameter((Object)onSeenInterface, (String)"<set-?>");
        this.listener = onSeenInterface;
    }

    @Nullable
    public ViewGroup getView() {
        return null;
    }

    public void destroy() {
        try {
            if (this.timeStart > 0L) {
                this.timeTotal += System.currentTimeMillis() - this.timeStart;
            }
            VisibilityTracker visibilityTracker = this.tracker;
            if (visibilityTracker != null) {
                visibilityTracker.stop();
            }
            this.getListener().onViewed(this.timeTotal);
            CLog.d(TAG, "Total time is " + this.timeTotal + " ms.");
        }
        catch (Exception e) {
            CLog.d(TAG, "destroy Exception " + e.getMessage());
        }
    }

    public final void onPause() {
        try {
            VisibilityTracker visibilityTracker = this.tracker;
            if (visibilityTracker != null) {
                visibilityTracker.pause();
            }
            long timePaused = System.currentTimeMillis();
            this.timeTotal += timePaused - this.timeStart;
            this.timeStart = 0L;
        }
        catch (Exception e) {
            CLog.d(TAG, "onPause Exception " + e.getMessage());
        }
    }

    public final void onResume() {
        try {
            VisibilityTracker visibilityTracker = this.tracker;
            if (visibilityTracker != null) {
                visibilityTracker.resume();
            }
            this.timeStart = System.currentTimeMillis();
        }
        catch (Exception e) {
            CLog.d(TAG, "onResume Exception " + e.getMessage());
        }
    }

    public void setVisibilityTracker(@Nullable VisibilityTracker tracker) {
        this.tracker = tracker;
    }

    public void setAdOverlay(@Nullable AdClickOverlay overlay) {
        this.overlay = overlay;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/calldorado/base/views/CAdView$Companion;", "", "()V", "TAG", "", "base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

