/*
 * Decompiled with CFR 0.152.
 */
package com.qualityinfo;

import android.annotation.TargetApi;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.webkit.WebView;
import androidx.work.WorkManager;
import com.qualityinfo.IC;
import com.qualityinfo.ICB;
import com.qualityinfo.IS;
import com.qualityinfo.internal.BGT;
import com.qualityinfo.internal.b7;
import com.qualityinfo.internal.bg;
import com.qualityinfo.internal.c9;
import com.qualityinfo.internal.ce;
import com.qualityinfo.internal.dc;
import com.qualityinfo.internal.e9;
import com.qualityinfo.internal.eh;
import com.qualityinfo.internal.f;
import com.qualityinfo.internal.fg;
import com.qualityinfo.internal.ge;
import com.qualityinfo.internal.i2;
import com.qualityinfo.internal.mg;
import com.qualityinfo.internal.n;
import com.qualityinfo.internal.n0;
import com.qualityinfo.internal.og;
import com.qualityinfo.internal.q1;
import com.qualityinfo.internal.qh;
import com.qualityinfo.internal.rb;
import com.qualityinfo.internal.sh;
import com.qualityinfo.internal.t1;
import com.qualityinfo.internal.t4;
import com.qualityinfo.internal.t5;
import com.qualityinfo.internal.t8;
import com.qualityinfo.internal.tf;
import com.qualityinfo.internal.tg;
import com.qualityinfo.internal.u6;
import com.qualityinfo.internal.uf;
import com.qualityinfo.internal.v3;
import com.qualityinfo.internal.ve;
import com.qualityinfo.internal.w;
import com.qualityinfo.internal.w8;
import com.qualityinfo.internal.wf;
import com.qualityinfo.internal.z7;
import com.qualityinfo.internal.zb;
import java.security.PublicKey;
import java.util.Map;

public class InsightCore {
    public static final String LIB_NAME = "insight Core SDK";
    public static final String LIB_COPYRIGHT = "\u00a9 2014 - 2024 umlaut communications GmbH";
    public static final String LIB_BUILD = "20241009113518";
    private static InsightCore D;
    private IC a;
    private ge b;
    private r c;
    private wf d;
    private t8 e;
    private IS f;
    private final Context g;
    private PublicKey h;
    private OnGuidChangedListener i;
    private OnLoggingEventListener j;
    private OnConnectivityTestListener k;
    private OnBackgroundTestListener l;
    private ve m;
    private i2 n;
    private n0 o;
    private zb p;
    private w8 q;
    private tg r;
    private fg s;
    private n t;
    private b7 u;
    private u6 v;
    private bg w;
    private q1 x;
    private t4 y;
    private eh z;
    private w A;
    private v3 B;
    private c9 C;

    public static void init(Context context, int n10) {
        InsightCore.b(context, n10);
    }

    public static void initAsync(final Context context, final int n10, final OnInsightCoreInitializedListener onInsightCoreInitializedListener) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                i i10 = onInsightCoreInitializedListener2;
                InsightCore.b(i10.context, onInsightCoreInitializedListener2.n10);
                OnInsightCoreInitializedListener onInsightCoreInitializedListener2 = i10.onInsightCoreInitializedListener;
                if (onInsightCoreInitializedListener2 != null) {
                    onInsightCoreInitializedListener2.onInitializationCompleted();
                }
            }
        });
    }

    private static void b(Context context, int n10) {
        try {
            Context context2 = context;
            InsightCore.init(context2, dc.a(context2.getResources().openRawResource(n10)));
            return;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error while opening the raw resource");
        }
    }

    public static synchronized void init(Context context, byte[] object) {
        Log.i((String)LIB_NAME, (String)"Initializing...");
        if (context != null) {
            if (object != null) {
                InsightCore insightCore;
                InsightCore insightCore2;
                ICB iCB;
                if (D != null) {
                    Log.i((String)LIB_NAME, (String)"Already initialized");
                    return;
                }
                try {
                    iCB = ICB.a(object);
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("configuration is invalid");
                }
                object = iCB;
                InsightCore insightCore3 = insightCore2 = insightCore;
                insightCore3(context);
                D = insightCore3;
                insightCore.h = object.a;
                IC iC = iCB.b;
                object = iC;
                insightCore2.a = object;
                iC.a(context);
                D.d();
                InsightCore.D.a.W2();
                if (InsightCore.D.f.o()) {
                    D.f();
                }
                D.g();
                Log.i((String)LIB_NAME, (String)"Initialized");
                return;
            }
            throw new IllegalArgumentException("config is null");
        }
        throw new IllegalArgumentException("context is null");
    }

    private InsightCore(Context context) {
        this.g = context.getApplicationContext();
    }

    private static InsightCore c() throws IllegalStateException {
        IllegalStateException illegalStateException;
        Object object = D;
        if (object != null) {
            return object;
        }
        object = illegalStateException;
        illegalStateException = new IllegalStateException("The insightCore is not initialized");
        Log.e((String)LIB_NAME, (String)"Attempting to access insightCore instance prior to successful initialization", (Throwable)object);
        throw illegalStateException;
    }

    private void d() {
        this.b = new ge();
        this.d = new wf(this.g);
        this.f = new IS(this.g);
        if (this.a.a()) {
            this.b();
        }
        InsightCore insightCore = this;
        insightCore.c = new r();
        insightCore.q = new w8(this.g);
        insightCore.r = new tg(this.g);
        insightCore.B = new v3(this.g);
        insightCore.n = new i2(this.g);
        insightCore.o = new n0(this.g);
        insightCore.p = new zb(this.g);
        Log.i((String)LIB_NAME, (String)"Internals initialized");
    }

    private void f() {
        InsightCore insightCore = this;
        insightCore.q.A();
        insightCore.r.k();
        insightCore.B.f();
        try {
            insightCore.g.registerReceiver((BroadcastReceiver)this.c, new IntentFilter("android.intent.action.SCREEN_OFF"));
        }
        catch (Exception exception) {
            Log.e((String)LIB_NAME, (String)("stopInternals: " + exception.getClass().getName()));
        }
        InsightCore.startInsightService();
        Log.i((String)LIB_NAME, (String)"Internals started");
    }

    private void i() {
        InsightCore insightCore = this;
        insightCore.y.e();
        insightCore.q.B();
        insightCore.r.m();
        insightCore.B.h();
        try {
            insightCore.g.unregisterReceiver((BroadcastReceiver)this.c);
        }
        catch (Exception exception) {
            Log.e((String)LIB_NAME, (String)("stopInternals: " + exception.getClass().getName()));
        }
        Log.i((String)LIB_NAME, (String)"Internals stopped");
    }

    public static synchronized boolean isInitialized() {
        return D != null;
    }

    private void b() {
        String string = this.f.b();
        String string2 = Settings.Secure.getString((ContentResolver)this.g.getContentResolver(), (String)"android_id");
        if (string != null && !string.isEmpty()) {
            if (!string.equals(string2)) {
                this.f.a(string2);
                InsightCore.refreshGuid();
            }
        } else {
            this.f.a(string2);
        }
    }

    public static tg getWifiController() {
        return InsightCore.c().r;
    }

    public static w8 getRadioController() {
        return InsightCore.c().q;
    }

    public static zb getStatsDatabase() {
        return InsightCore.c().p;
    }

    public static void setOnGuidChangedListener(OnGuidChangedListener onGuidChangedListener) {
        InsightCore.c().i = onGuidChangedListener;
    }

    public static OnGuidChangedListener getOnGuidChangedListener() {
        return InsightCore.c().i;
    }

    public static void setOnConnectivityTestListener(OnConnectivityTestListener onConnectivityTestListener) {
        InsightCore.c().k = onConnectivityTestListener;
    }

    public static OnBackgroundTestListener getOnBackgroundTestListener() {
        return InsightCore.c().l;
    }

    public static void setOnBackgroundTestListener(OnBackgroundTestListener onBackgroundTestListener) {
        InsightCore.c().l = onBackgroundTestListener;
    }

    public static OnConnectivityTestListener getOnConnectivityTestListener() {
        return InsightCore.c().k;
    }

    public static void setOnLoggingEventListener(OnLoggingEventListener onLoggingEventListener) {
        InsightCore.c().j = onLoggingEventListener;
    }

    public static OnLoggingEventListener getOnLoggingEventListener() {
        return InsightCore.c().j;
    }

    public static void startInsightService() {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (!InsightCore.isInitialized()) {
                    return;
                }
                if (InsightCore.isExpiredCore()) {
                    return;
                }
                if (!InsightCore.getInsightSettings().o()) {
                    return;
                }
                if (InsightCore.c().y == null) {
                    InsightCore.a(InsightCore.c(), new t4(InsightCore.c().g));
                }
                InsightCore.c().y.a();
            }
        });
    }

    public static boolean isExpiredCore() {
        if (InsightCore.getInsightConfig().h0() == -1L) {
            return false;
        }
        return ge.d() > InsightCore.getInsightConfig().h0();
    }

    public static void setCrowdDataCollectionEnabled(boolean bl) {
        boolean bl2 = bl;
        InsightCore.setCoverageMapperServiceEnabled(bl2);
        InsightCore.setTrafficAnalyzerEnabled(bl2);
        InsightCore.setVoiceServiceEnabled(bl2);
        InsightCore.setWifiScanServiceEnabled(bl2);
        InsightCore.setConnectivityTestEnabled(bl2);
        InsightCore.setBackgroundTestServiceEnabled(bl2);
    }

    public static void setTrafficAnalyzerEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getTrafficAnalyzerEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().m(bl);
                if (InsightCore.c().m == null) {
                    InsightCore.a(InsightCore.c(), new ve(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().F0()) {
                    InsightCore.c().m.c();
                } else {
                    InsightCore.c().m.e();
                }
            }
        });
    }

    public static boolean getTrafficAnalyzerEnabled() {
        return InsightCore.getInsightSettings().H();
    }

    public static void setMessagingServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getMessagingServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().j(bl);
                if (InsightCore.c().v == null) {
                    InsightCore.a(InsightCore.c(), new u6(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().D0()) {
                    InsightCore.c().v.a();
                } else {
                    InsightCore.c().v.b();
                }
            }
        });
    }

    public static boolean getMessagingServiceEnabled() {
        return InsightCore.getInsightSettings().B();
    }

    public static void setConnectivityTestEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getConnectivityTestEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().f(bl);
                if (InsightCore.isExpiredCore()) {
                    return;
                }
                if (InsightCore.c().x == null) {
                    InsightCore.a(InsightCore.c(), new q1(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().B0()) {
                    InsightCore.c().x.a();
                } else {
                    InsightCore.c().x.h();
                }
            }
        });
    }

    public static boolean getConnectivityTestEnabled() {
        return InsightCore.getInsightSettings().k();
    }

    public static void setCoverageMapperServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getCoverageMapperServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().h(bl);
                if (InsightCore.c().u == null) {
                    InsightCore.a(InsightCore.c(), new b7(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().C0()) {
                    InsightCore.c().u.g();
                } else {
                    InsightCore.c().u.l();
                }
            }
        });
    }

    public static boolean getCoverageMapperServiceEnabled() {
        return InsightCore.getInsightSettings().l();
    }

    public static void setAppUsageServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getAppUsageServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().c(bl);
                if (InsightCore.c().t == null) {
                    InsightCore.a(InsightCore.c(), new n(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().z0()) {
                    InsightCore.c().t.g();
                } else {
                    InsightCore.c().t.i();
                }
            }
        });
    }

    public static boolean getAppUsageServiceEnabled() {
        return InsightCore.getInsightSettings().d();
    }

    public static void setVoiceServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getVoiceServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().p(bl);
                if (InsightCore.c().s == null) {
                    InsightCore.a(InsightCore.c(), new fg(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().G0()) {
                    InsightCore.c().s.l();
                } else {
                    InsightCore.c().s.m();
                }
            }
        });
    }

    public static boolean getVoiceServiceEnabled() {
        return InsightCore.getInsightSettings().P();
    }

    public static void setVoWifiTestManagerEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getVoWifiTestManagerEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().o(bl);
                if (InsightCore.c().w == null) {
                    InsightCore.a(InsightCore.c(), new bg(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().H0()) {
                    InsightCore.c().w.n();
                } else {
                    InsightCore.c().w.p();
                }
            }
        });
    }

    public static boolean getVoWifiTestManagerEnabled() {
        return InsightCore.getInsightSettings().N();
    }

    public static void setWifiScanServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getWifiScanServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().q(bl);
                if (InsightCore.c().z == null) {
                    InsightCore.a(InsightCore.c(), new eh(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().I0()) {
                    InsightCore.c().z.d();
                } else {
                    InsightCore.c().z.e();
                }
            }
        });
    }

    public static boolean getWifiScanServiceEnabled() {
        return InsightCore.getInsightSettings().Q();
    }

    public static void setBackgroundTestServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getBackgroundTestServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().e(bl);
                if (InsightCore.c().A == null) {
                    InsightCore.a(InsightCore.c(), new w(InsightCore.c().g));
                }
                if (bl && !InsightCore.getInsightConfig().A0()) {
                    InsightCore.c().A.a();
                } else {
                    InsightCore.c().A.e();
                }
            }
        });
    }

    public static boolean getBackgroundTestServiceEnabled() {
        return InsightCore.getInsightSettings().f();
    }

    public static void setQoeManagerEnabled(boolean bl) {
        InsightCore.getInsightSettings().k(bl);
        if (bl && InsightCore.c().e == null) {
            InsightCore.c().e = new t8(InsightCore.c().g);
        }
    }

    public static boolean getQoeManagerEnabled() {
        return InsightCore.getInsightSettings().D();
    }

    public static void setRegistrationServiceEnabled(boolean bl) {
        InsightCore.getInsightSettings().l(true);
        if (bl && InsightCore.c().C == null) {
            InsightCore.c().C = new c9(InsightCore.c().g);
        }
    }

    public static boolean getRegistrationServiceEnabled() {
        return InsightCore.getInsightSettings().E();
    }

    public static void setInsightServiceEnabled(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.getInsightServiceEnabled() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().i(bl);
                if (bl) {
                    InsightCore.c().f();
                } else {
                    InsightCore.c().i();
                }
            }
        });
    }

    public static boolean getInsightServiceEnabled() {
        return InsightCore.getInsightSettings().o();
    }

    public static v3 getForegroundTestManager() {
        if (InsightCore.c().B == null) {
            InsightCore.c().B = new v3(InsightCore.c().g);
        }
        return InsightCore.c().B;
    }

    public static PublicKey getPublicKey() {
        return InsightCore.c().h;
    }

    public static synchronized ge getTimeServer() {
        return InsightCore.c().b;
    }

    public static String getGUID() {
        if (!InsightCore.isInitialized()) {
            return "InsightCore SDK not initialized";
        }
        return InsightCore.getInsightSettings().m();
    }

    public static String getProjectID() {
        if (!InsightCore.isInitialized()) {
            return "InsightCore SDK not initialized";
        }
        return InsightCore.getInsightConfig().B1();
    }

    public static void DEBUG_uploadFiles() {
        InsightCore.c().d.uploadFiles(true);
    }

    public static wf getUploadManager() {
        return InsightCore.c().d;
    }

    public static fg getVoiceManager() {
        return InsightCore.c().s;
    }

    public static i2 getDatabaseHelper() {
        return InsightCore.c().n;
    }

    public static t8 getQoeManager() {
        if (InsightCore.c().e == null) {
            InsightCore.c().e = new t8(InsightCore.c().g);
        }
        return InsightCore.c().e;
    }

    public static n0 getBluetoothController() {
        return InsightCore.c().o;
    }

    public static n getAppUsageManager() {
        return InsightCore.c().t;
    }

    public static bg getVoWifiTestManager() {
        if (InsightCore.c().w == null) {
            InsightCore.c().w = new bg(InsightCore.c().g);
        }
        return InsightCore.c().w;
    }

    public static b7 getNirManager() {
        if (InsightCore.c().u == null) {
            InsightCore.c().u = new b7(InsightCore.c().g);
        }
        return InsightCore.c().u;
    }

    public static w getBackgroundTestManager() {
        if (InsightCore.c().A == null) {
            InsightCore.c().A = new w(InsightCore.c().g);
        }
        return InsightCore.c().A;
    }

    public static c9 getRegistrationManager() {
        if (InsightCore.c().C == null) {
            InsightCore.c().C = new c9(InsightCore.c().g);
        }
        return InsightCore.c().C;
    }

    public static void consent(final boolean bl) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (!InsightCore.isInitialized()) {
                    return;
                }
                if (InsightCore.getInsightSettings().R() == bl) {
                    return;
                }
                InsightCore.getInsightSettings().g(bl);
                if (InsightCore.getInsightSettings().E()) {
                    InsightCore.c().C.a(e9.ConsentChanged);
                }
            }
        });
    }

    public static IS getInsightSettings() {
        return InsightCore.c().f;
    }

    public static IC getInsightConfig() {
        return InsightCore.c().a;
    }

    private void g() {
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (this.f.D() && this.e == null) {
            this.e = new t8(this.g);
        }
        if (this.f.E() && this.C == null) {
            this.C = new c9(this.g);
        }
        if (this.f.P() && !this.a.G0()) {
            if (this.s == null) {
                this.s = new fg(this.g);
            }
            this.s.l();
        }
        if (this.f.B() && !this.a.D0()) {
            if (this.v == null) {
                this.v = new u6(this.g);
            }
            this.v.a();
        }
        if (this.f.d() && !this.a.z0()) {
            if (this.t == null) {
                this.t = new n(this.g);
            }
            this.t.g();
        }
        if (this.f.H() && !this.a.F0()) {
            if (this.m == null) {
                this.m = new ve(this.g);
            }
            this.m.c();
        }
        if (this.f.N() && !this.a.H0()) {
            if (this.w == null) {
                this.w = new bg(this.g);
            }
            this.w.n();
        }
        if (this.f.Q() && !this.a.I0()) {
            if (this.z == null) {
                this.z = new eh(this.g);
            }
            this.z.d();
        }
        if (this.f.k() && !this.a.B0()) {
            if (this.x == null) {
                this.x = new q1(this.g);
            }
            this.x.a();
        }
        if (this.f.f() && !this.a.A0()) {
            if (this.A == null) {
                this.A = new w(this.g);
            }
            this.A.a();
        }
        if (this.f.l() && !this.a.C0()) {
            if (this.u == null) {
                this.u = new b7(this.g);
            }
            this.u.g();
        }
    }

    private void h() {
        Object object = ((InsightCore)this).t;
        if (object != null) {
            ((n)object).i();
        }
        if ((object = ((InsightCore)this).v) != null) {
            ((u6)object).b();
        }
        if ((object = ((InsightCore)this).u) != null) {
            ((b7)object).l();
        }
        if ((object = ((InsightCore)this).m) != null) {
            ((ve)object).e();
        }
        if ((object = ((InsightCore)this).s) != null) {
            ((fg)object).m();
        }
        if ((object = ((InsightCore)this).w) != null) {
            ((bg)object).p();
        }
        if ((object = ((InsightCore)this).x) != null) {
            ((q1)object).h();
        }
        if ((object = ((InsightCore)this).z) != null) {
            ((eh)object).e();
        }
        if ((object = ((InsightCore)this).A) != null) {
            ((w)object).e();
        }
        if ((this = ((InsightCore)this).y) != null) {
            ((t4)this).e();
        }
    }

    static void e() {
        InsightCore.c().h();
        InsightCore.startInsightService();
        InsightCore.c().g();
    }

    @TargetApi(value=21)
    public static void terminate(final Context context) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                e e10 = e10.context.getApplicationContext();
                if (InsightCore.isInitialized()) {
                    InsightCore.c().h();
                    InsightCore.getRadioController().B();
                    InsightCore.getWifiController().m();
                    if (InsightCore.c().c != null) {
                        InsightCore.c().g.unregisterReceiver((BroadcastReceiver)InsightCore.c().c);
                    }
                } else {
                    if (com.qualityinfo.internal.f.c((Context)e10)) {
                        WorkManager workManager = WorkManager.getInstance((Context)e10);
                        workManager.cancelAllWorkByTag("ConnectivityWorkerPeriodic");
                        workManager.cancelAllWorkByTag("BackgroundTestWorkerPeriodic");
                        workManager.cancelAllWorkByTag("InsightWorker");
                    }
                    if (Build.VERSION.SDK_INT >= 21 && (e10 = (JobScheduler)e10.getSystemService("jobscheduler")) != null) {
                        e e11 = e10;
                        e11.cancel(q1.e);
                        e11.cancel(com.qualityinfo.internal.w.e);
                        e11.cancel(t4.f);
                    }
                }
                D = null;
            }
        });
    }

    public static void reInitializeForegroundAppDetector() {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                if (InsightCore.c().t != null) {
                    InsightCore.c().t.d();
                }
            }
        });
    }

    public static void putUploadExtraInfo(String string, String string2) {
        if (string.length() != 0 && string2.length() != 0) {
            Object object = InsightCore.getUploadExtraInfo();
            int n10 = 0;
            int n11 = ((tf[])object).length;
            for (int i10 = 0; i10 < n11; ++i10) {
                tf tf2 = object[i10];
                if (!tf2.Key.equals(string)) continue;
                tf2.Value = string2;
                n10 = 1;
            }
            if (n10 == 0) {
                tf tf3;
                n10 = ((tf[])object).length + 1;
                tf[] tfArray = new tf[n10];
                tf[] tfArray2 = tfArray;
                object = tf3;
                tf3 = new tf(string, string2);
                int n12 = ((tf[])object).length;
                System.arraycopy(object, 0, tfArray2, 0, n12);
                tfArray[n10 - 1] = object;
                string = uf.a(tfArray);
            } else {
                string = uf.a(object);
            }
            InsightCore.getInsightSettings().c(string);
            return;
        }
    }

    public static void refreshGuid() {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                InsightCore.getInsightSettings().a(true);
            }
        });
    }

    public static tf[] getUploadExtraInfo() {
        tf[] tfArray = uf.a(InsightCore.getInsightSettings().J());
        if (tfArray == null) {
            tfArray = new tf[]{};
        }
        return tfArray;
    }

    public static void openPrivacyWebPage(Context object) {
        Context context = object;
        object = InsightCore.getInsightConfig().A1() + InsightCore.getGUID();
        context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)object)));
    }

    public static void setGuidMaxAge(final long l10) {
        ce.d().e().execute(new Runnable(){

            @Override
            public void run() {
                InsightCore.getInsightSettings().b(l10);
            }
        });
    }

    static /* synthetic */ t4 a(InsightCore insightCore, t4 t42) {
        insightCore.y = t42;
        return t42;
    }

    static /* synthetic */ ve a(InsightCore insightCore, ve ve2) {
        insightCore.m = ve2;
        return ve2;
    }

    static /* synthetic */ u6 a(InsightCore insightCore, u6 u62) {
        insightCore.v = u62;
        return u62;
    }

    static /* synthetic */ q1 a(InsightCore insightCore, q1 q12) {
        insightCore.x = q12;
        return q12;
    }

    static /* synthetic */ b7 a(InsightCore insightCore, b7 b72) {
        insightCore.u = b72;
        return b72;
    }

    static /* synthetic */ n a(InsightCore insightCore, n n10) {
        insightCore.t = n10;
        return n10;
    }

    static /* synthetic */ fg a(InsightCore insightCore, fg fg2) {
        insightCore.s = fg2;
        return fg2;
    }

    static /* synthetic */ bg a(InsightCore insightCore, bg bg2) {
        insightCore.w = bg2;
        return bg2;
    }

    static /* synthetic */ eh a(InsightCore insightCore, eh eh2) {
        insightCore.z = eh2;
        return eh2;
    }

    static /* synthetic */ w a(InsightCore insightCore, w w10) {
        insightCore.A = w10;
        return w10;
    }

    private class r
    extends BroadcastReceiver {
        private r() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null && intent.getAction() != null) {
                if (InsightCore.isExpiredCore()) {
                    InsightCore.this.h();
                    return;
                }
                InsightCore.startInsightService();
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                    if (InsightCore.getInsightSettings().e()) {
                        InsightCore.this.d.uploadFiles(false);
                    }
                    InsightCore.getInsightConfig().W2();
                }
                return;
            }
        }
    }

    public static interface OnInsightCoreInitializedListener {
        public void onInitializationCompleted();
    }

    public static interface OnLoggingEventListener {
        public void onLoggingEvent(t5 var1, long var2, Map<String, String> var4);
    }

    public static interface OnBackgroundTestListener {
        public void onBackgroundTestStart();

        public void onBackgroundTestChosen(BGT var1);

        public void onBandwidthTestStatusChanged(rb var1, z7 var2);

        public void onWebsiteLoadingStatus(WebView var1, og.a var2, mg var3);

        public void onYoutubeStatusChanged(WebView var1, qh.a var2, sh var3);

        public void onBackgroundTestEnd(BGT var1);
    }

    public static interface OnConnectivityTestListener {
        public void onConnectivityTestStart();

        public void onConnectivityTestEnd(t1 var1);
    }

    public static interface OnGuidChangedListener {
        public void OnGuidChanged(String var1);
    }
}

