/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.aftercall.card_views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.Layout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.ColorUtils;
import com.calldorado.CalldoradoApplication;
import com.calldorado.android.R;
import com.calldorado.configs.Configs;
import com.calldorado.log.B5B;
import com.calldorado.search.Search;
import com.calldorado.search.data_models.Contact;
import com.calldorado.search.manual_search.CDOSearchProcessListener;
import com.calldorado.stats.StatsReceiver;
import com.calldorado.translations.F2S;
import com.calldorado.ui.aftercall.CallerIdActivity;
import com.calldorado.ui.data_models.ColorCustomization;
import com.calldorado.ui.debug_dialog_items.ix0;
import com.calldorado.ui.shared_wic_aftercall.viewpager.CalldoradoStaticFeatureView;
import com.calldorado.ui.views.CircleImageView;
import com.calldorado.ui.views.CircleRelativeViewgroup;
import com.calldorado.ui.views.SvgFontView;
import com.calldorado.ui.views.custom.CdoSearchView;
import com.calldorado.util.ViewUtil;
import com.calldorado.util.xml.XMLAttributes;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class CardCallerInfo
extends LinearLayout {
    private static final String TAG = "CardCallerInfo";
    public static final int LAYOUT_TYPE_NO_NUMBER_NO_SEARCH = 0;
    public static final int LAYOUT_TYPE_NUMBER_WITH_SEARCH = 1;
    public static final int LAYOUT_TYPE_NUMBER_NO_SEARCH = 2;
    private final boolean isFromNotification;
    private Context context;
    private TextView callDurationTV;
    private TextView phoneNumberTV;
    private TextView contactNameTV;
    private TextView noNumberStatusTv;
    private TextView callStatusTV;
    private View ll_call;
    private View top_container;
    private View gradientBackground;
    private String callType;
    private String name;
    private String formattedPhoneNumber;
    private boolean isSpam;
    private boolean isManualSearch;
    private boolean searchFromWIC;
    private Search search;
    private long callDuration;
    private long aftercallTime;
    private RelativeLayout phoneImageContainer;
    private FrameLayout contactViewContainer;
    private View baseMainLayout;
    private AcContentViewListener acListener;
    private CalldoradoApplication calldoradoApplication;
    private XMLAttributes xmlAttributes;
    private CircleRelativeViewgroup crv = null;
    private CircleImageView civ = null;
    private ColorCustomization cc;
    private Configs clientConfig;
    private SvgFontView phoneIcon;
    private CdoSearchView searchViewEt;
    private boolean wasSearchCommited;
    private int layoutType = -1;
    private OnSearchEndListener onSearchEndListener;
    private boolean callerIdEnabled = true;

    /*
     * WARNING - void declaration
     */
    public CardCallerInfo(CallerIdActivity ac, View baseMainLayout, Context context, String callType, String name, String formattedPhoneNumber, long callDuration, boolean isSpam, Search search, long aftercallTime, boolean isFromNotification, boolean searchFromWIC, AcContentViewListener acListener, OnSearchEndListener listener) {
        super((Context)var3_4);
        void var16_15;
        void var13_12;
        void var11_11;
        void var15_14;
        void var4_5;
        void var10_10;
        void var9_9;
        void var14_13;
        void var7_8;
        void var6_7;
        void var5_6;
        void var2_3;
        void var3_4;
        this.baseMainLayout = var2_3;
        this.context = var3_4;
        this.name = var5_6;
        this.formattedPhoneNumber = var6_7;
        this.callDuration = var7_8;
        this.searchFromWIC = var14_13;
        this.isSpam = var9_9;
        this.search = var10_10;
        boolean bl = search != null && var10_10.Mc1();
        void v0 = var3_4;
        this.isManualSearch = bl;
        this.callType = var4_5;
        this.acListener = var15_14;
        this.aftercallTime = var11_11;
        this.isFromNotification = var13_12;
        this.onSearchEndListener = var16_15;
        this.wasSearchCommited = var14_13;
        this.calldoradoApplication = CalldoradoApplication.ix0((Context)v0);
        this.callerIdEnabled = this.calldoradoApplication.Mc1().fK6().dpy();
        this.xmlAttributes = XMLAttributes.getInstance((Context)v0);
        this.cc = this.calldoradoApplication.dpy();
        this.clientConfig = this.calldoradoApplication.Mc1();
        this.init();
        if (this.clientConfig.dpy() != null && this.clientConfig.dpy().IoQ()) {
            StatsReceiver.broadcastStats((Context)var3_4, "aftercall_search_screen_show", null);
        }
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setupSearch() {
        this.searchViewEt.setSearchListener(new CDOSearchProcessListener(this){
            final /* synthetic */ CardCallerInfo B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            @Override
            public void onSearchSent() {
                B5B.B5B(TAG, "onSearchSent: ");
            }

            @Override
            public void onSearchSuccess(boolean searchFromWic) {
                B5B.B5B(TAG, "onSearchSuccess! " + this.B5B.clientConfig.YYA().yxg());
                CardCallerInfo cardCallerInfo = this.B5B;
                cardCallerInfo.wasSearchCommited = true;
                cardCallerInfo.update(cardCallerInfo.clientConfig.YYA().yxg());
            }

            @Override
            public void onSearchFailed(String errorMessage) {
                CardCallerInfo cardCallerInfo = this.B5B;
                cardCallerInfo.wasSearchCommited = true;
                cardCallerInfo.update(cardCallerInfo.clientConfig.YYA().yxg());
            }

            @Override
            public void onTextChanged(String s) {
            }
        });
    }

    private void setCallStatusTV() {
        this.callStatusTV.setText((CharSequence)this.callType);
    }

    public static String formatSeconds(int timeInSeconds) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3;
        int n;
        int n2 = timeInSeconds / 3600;
        int n3 = n % 3600;
        n = n3 / 60;
        int n4 = n3 % 60;
        StringBuilder stringBuilder4 = stringBuilder3;
        stringBuilder3 = new StringBuilder();
        String string2 = n2 < 10 ? "0" : "";
        String string3 = stringBuilder4.append(string2).append(n2).toString();
        stringBuilder4 = stringBuilder2;
        stringBuilder2 = new StringBuilder();
        string2 = n < 10 ? "0" : "";
        String string4 = stringBuilder4.append(string2).append(n).toString();
        stringBuilder4 = stringBuilder;
        stringBuilder = new StringBuilder();
        string2 = n4 < 10 ? "0" : "";
        String string5 = stringBuilder4.append(string2).append(n4).toString();
        B5B.B5B(TAG, "hrStr = " + string3 + ";     mnStr = " + string4 + ",     secStr = " + string5);
        if (string3.equals("00")) {
            return string4 + ":" + string5;
        }
        return string3 + ":" + string4 + ":" + string5;
    }

    private void setDurationTV() {
        if (!this_.callerIdEnabled) {
            this_.callDurationTV.setText((CharSequence)((CalldoradoStaticFeatureView)this_.calldoradoApplication.fK6()).getAftercallSubtitleBottom());
        } else if (this_.isManualSearch && this_.searchViewEt.getVisibility() == 0) {
            this_.callDurationTV.setVisibility(8);
        } else {
            CardCallerInfo cardCallerInfo = this_;
            String string2 = F2S.B5B((Context)cardCallerInfo.context).KdS;
            Object this_ = string2 + ": " + CardCallerInfo.formatSeconds((int)this_.callDuration);
            cardCallerInfo.callDurationTV.setText((CharSequence)this_);
        }
    }

    private void checkForUsingExtendedCalldurationLayout(boolean fromInit) {
        this.callDurationTV.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ CardCallerInfo B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onGlobalLayout() {
                int n;
                Layout layout2 = this.B5B.callDurationTV.getLayout();
                if (layout2 != null && (n = layout2.getLineCount()) > 0 && layout2.getEllipsisCount(n - 1) > 0) {
                    B5B.B5B(TAG, "checkForUsingExtendedCalldurationLayout: text is ellipsized");
                    this.B5B.callDurationTV.setVisibility(8);
                }
                this.B5B.callDurationTV.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        });
    }

    private void setPhoneIconCollapsed() {
        if (this.phoneIcon == null) {
            this.phoneIcon = new SvgFontView(this.context, R.font.call);
            this.phoneIcon.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ CardCallerInfo B5B;
                {
                    void var1_1;
                    this.B5B = var1_1;
                }

                public void onClick(View v) {
                    this.B5B.acListener.B5B();
                }
            });
            ViewUtil.setSelectorOrRipple(this.context, (View)this.phoneIcon, true);
        }
        B5B.B5B(TAG, "isSpam = " + this.isSpam);
        if (this.isSpam) {
            this.phoneIcon.setTextColor(this.cc.IoQ(true));
        } else {
            this.phoneIcon.setTextColor(this.cc.IoQ(false));
        }
    }

    private void togglePhoneIcon() {
        if (this.phoneIcon != null) {
            if (TextUtils.isEmpty((CharSequence)this.formattedPhoneNumber)) {
                B5B.B5B(TAG, "togglePhoneIcon: GONE");
                this.phoneIcon.setVisibility(8);
            } else {
                B5B.B5B(TAG, "togglePhoneIcon: VISIBLE");
                this.phoneIcon.setVisibility(0);
            }
        }
    }

    private void setClickListeners() {
        CardCallerInfo cardCallerInfo = this;
        cardCallerInfo.phoneImageContainer.setContentDescription((CharSequence)F2S.B5B((Context)this.context).TtD);
        if (cardCallerInfo.acListener != null) {
            this.phoneImageContainer.setOnClickListener(new View.OnClickListener(this){
                final /* synthetic */ CardCallerInfo B5B;
                {
                    void var1_1;
                    this.B5B = var1_1;
                }

                public void onClick(View v) {
                    this.B5B.acListener.B5B();
                }
            });
        }
    }

    private void addAppLogo() {
        block3: {
            B5B.B5B(TAG, "addLogoIcon()");
            if (this.clientConfig.ix0().YYA() == -1) break block3;
            try {
                ((ImageView)this.baseMainLayout.findViewById(R.id.app_logo)).setImageBitmap(BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)this.clientConfig.ix0().YYA()));
            }
            catch (Exception exception) {
                B5B.ix0(TAG, "Failed to add BRAND");
                exception.printStackTrace();
            }
        }
    }

    private String getName() {
        if (!this.callerIdEnabled && this.calldoradoApplication.fK6() != null && this.calldoradoApplication.fK6() instanceof CalldoradoStaticFeatureView) {
            return ((CalldoradoStaticFeatureView)this.calldoradoApplication.fK6()).getAftercallTitle();
        }
        if (!(TextUtils.isEmpty((CharSequence)this.name) || this.name.equalsIgnoreCase(F2S.B5B((Context)this.context).H06) || this.name.equalsIgnoreCase(F2S.B5B((Context)this.context).Hhe))) {
            return this.name;
        }
        if (!TextUtils.isEmpty((CharSequence)this.formattedPhoneNumber)) {
            return F2S.B5B((Context)this.context).H06.replaceAll("\\p{P}", "");
        }
        return F2S.B5B((Context)this.context).XRK;
    }

    private void setContactNameIconNumberTV() {
        SvgFontView svgFontView;
        this.contactNameTV.setText((CharSequence)this.getName());
        SvgFontView svgFontView2 = svgFontView;
        svgFontView = new SvgFontView(this.context, R.font.call);
        if (this.isSpam) {
            svgFontView2.setTextColor(this.cc.H1u(true));
            this.contactNameTV.setTextColor(this.cc.IoQ(true));
            this.phoneNumberTV.setTextColor(this.cc.H1u(true));
            this.callDurationTV.setTextColor(this.cc.H1u(true));
            this.callStatusTV.setTextColor(this.cc.H1u(true));
        } else {
            svgFontView2.setTextColor(Color.parseColor((String)"#4D7109"));
            this.contactNameTV.setTextColor(this.cc.Mc1());
            this.phoneNumberTV.setTextColor(this.cc.Mc1());
            this.callDurationTV.setTextColor(this.cc.Mc1());
            this.callStatusTV.setTextColor(this.cc.Mc1());
        }
        ViewUtil.setSelectorOrRipple(this.context, (View)svgFontView2, true);
        this.phoneImageContainer.setGravity(17);
        svgFontView2.setSize(20);
        this.phoneImageContainer.addView((View)svgFontView2);
        if (!this.callerIdEnabled) {
            this.phoneImageContainer.setVisibility(8);
        } else {
            this.phoneImageContainer.setVisibility(0);
        }
        int n = Build.VERSION.SDK_INT;
        if ((n >= 28 && ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.READ_CALL_LOG") != 0 || n < 23 && !CalldoradoApplication.ix0(this.context).ETk().gGZ()) && TextUtils.isEmpty((CharSequence)this.formattedPhoneNumber) && !this.wasSearchCommited && this.calldoradoApplication.ETk().gGZ() && this.callerIdEnabled) {
            B5B.B5B(TAG, "setContactNameIconNumberTV: Layout 1 show search");
            this.layoutType = 0;
            this.searchViewEt.setVisibility(0);
            if (CalldoradoApplication.ix0(this.context).Mc1().ix0().WTS() != null) {
                this.searchViewEt.setText(CalldoradoApplication.ix0(this.context).Mc1().ix0().WTS());
                CalldoradoApplication.ix0(this.context).Mc1().ix0().gGZ("");
            }
            this.noNumberStatusTv.setVisibility(8);
            this.contactViewContainer.setVisibility(0);
            this.ll_call.setVisibility(0);
            this.contactNameTV.setVisibility(8);
            this.callDurationTV.setVisibility(0);
            this.phoneNumberTV.setVisibility(0);
            this.phoneNumberTV.setText((CharSequence)new SimpleDateFormat("HH:mm", Locale.US).format(CalldoradoApplication.ix0(this.context).ETk().IoQ()));
        } else if (!TextUtils.isEmpty((CharSequence)this.formattedPhoneNumber) && this.wasSearchCommited && this.callerIdEnabled) {
            String string2 = TAG;
            B5B.B5B(string2, "setContactNameIconNumberTV: Layout 2");
            this.layoutType = 1;
            this.searchViewEt.setVisibility(0);
            this.noNumberStatusTv.setVisibility(8);
            this.contactViewContainer.setVisibility(0);
            this.ll_call.setVisibility(0);
            this.contactNameTV.setVisibility(8);
            this.callDurationTV.setVisibility(0);
            this.phoneNumberTV.setVisibility(0);
            this.phoneNumberTV.setText((CharSequence)this.getName());
            this.callStatusTV.setVisibility(8);
            this.callDurationTV.setText((CharSequence)this.formattedPhoneNumber);
            this.searchViewEt.setText(this.formattedPhoneNumber);
            B5B.B5B(string2, "setContactNameIconNumberTV: setting number to " + this.getName());
        } else if (this.callerIdEnabled && (TextUtils.isEmpty((CharSequence)this.formattedPhoneNumber) || this.wasSearchCommited)) {
            this.noNumberStatusTv.setVisibility(8);
            this.contactViewContainer.setVisibility(0);
            this.ll_call.setVisibility(0);
            this.callDurationTV.setVisibility(0);
            this.phoneNumberTV.setVisibility(0);
            this.phoneNumberTV.setText((CharSequence)new SimpleDateFormat("HH:mm", Locale.US).format(CalldoradoApplication.ix0(this.context).ETk().IoQ()));
        } else {
            B5B.B5B(TAG, "setContactNameIconNumberTV: Layout 3");
            this.layoutType = 2;
            this.searchViewEt.setVisibility(8);
            this.noNumberStatusTv.setVisibility(8);
            this.contactViewContainer.setVisibility(0);
            this.ll_call.setVisibility(0);
            this.contactNameTV.setVisibility(0);
            this.callDurationTV.setVisibility(0);
            this.phoneNumberTV.setVisibility(0);
            if (this.callerIdEnabled) {
                this.phoneNumberTV.setText((CharSequence)this.formattedPhoneNumber);
            } else {
                this.phoneNumberTV.setText((CharSequence)((CalldoradoStaticFeatureView)this.calldoradoApplication.fK6()).getAftercallSubtitleTop());
                this.callStatusTV.setVisibility(8);
                this.callDurationTV.setVisibility(0);
            }
        }
        ViewUtil.setSelectorOrRipple(this.context, (View)this.phoneNumberTV, true);
    }

    private String getNoNumberStatus() {
        return F2S.B5B((Context)this.context).KET + " " + ix0.B5B(CalldoradoApplication.ix0(this.context).ETk().IoQ() + "").substring(0, 5) + " " + F2S.B5B((Context)this.context).Bj9 + " " + ix0.B5B(CalldoradoApplication.ix0(this.context).ETk().xfp() + "").substring(0, 5) + "\n" + F2S.B5B((Context)this.context).ylQ + " " + CardCallerInfo.formatSeconds((int)this.callDuration);
    }

    private void setContactImage() {
        LinearLayout.LayoutParams layoutParams;
        com.calldorado.ui.views.B5B b5B;
        com.calldorado.ui.views.B5B b5B2 = b5B;
        CircleImageView circleImageView = new com.calldorado.ui.views.B5B(this.context).esR();
        if (this.callerIdEnabled) {
            b5B2.B5B(this.search, 3);
        } else {
            circleImageView.setImageDrawable(((CalldoradoStaticFeatureView)this.calldoradoApplication.fK6()).getCircleImage());
        }
        if (this.isSpam) {
            this.name = F2S.B5B((Context)this.context).a_b;
        }
        CardCallerInfo cardCallerInfo = this;
        B5B.B5B(TAG, "setContactImage: Not searchFromWic");
        b5B2 = layoutParams;
        layoutParams = new LinearLayout.LayoutParams(-1, -1);
        cardCallerInfo.contactViewContainer.addView((View)circleImageView, (ViewGroup.LayoutParams)b5B2);
        cardCallerInfo.contactViewContainer.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ CardCallerInfo B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onClick(View view) {
                AcContentViewListener this_ = this_.B5B.acListener;
                if (this_ != null) {
                    this_.ix0();
                }
            }
        });
    }

    public void init() {
        this.phoneImageContainer = (RelativeLayout)this.baseMainLayout.findViewById(R.id.phone_image);
        this.callDurationTV = (TextView)this.baseMainLayout.findViewById(R.id.call_duration);
        this.contactNameTV = (TextView)this.baseMainLayout.findViewById(R.id.contact_name_mini);
        this.searchViewEt = (CdoSearchView)this.baseMainLayout.findViewById(R.id.aftercall_search_view);
        this.phoneNumberTV = (TextView)this.baseMainLayout.findViewById(R.id.phonenumber);
        this.contactViewContainer = (FrameLayout)this.baseMainLayout.findViewById(R.id.rl_contactview_container);
        this.ll_call = this.baseMainLayout.findViewById(R.id.ll_call);
        this.top_container = this.baseMainLayout.findViewById(R.id.top_container);
        this.noNumberStatusTv = (TextView)this.baseMainLayout.findViewById(R.id.no_number_status);
        this.callStatusTV = (TextView)this.baseMainLayout.findViewById(R.id.call_status);
        this.callStatusTV.setSelected(true);
        this.setupSearch();
        this.setBackgroundDrawable();
        this.setContactImage();
        this.setContactNameIconNumberTV();
        this.addAppLogo();
        this.setPhoneIconCollapsed();
        this.setCallStatusTV();
        this.setClickListeners();
        this.setDurationTV();
    }

    public void setBackgroundDrawable() {
        int n;
        Object object;
        if (this.isSpam) {
            GradientDrawable gradientDrawable;
            object = gradientDrawable;
            CardCallerInfo cardCallerInfo = this;
            n = cardCallerInfo.cc.ix0(true);
            int n2 = cardCallerInfo.cc.esR(true);
            gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.RIGHT_LEFT, new int[]{n, n2});
        } else {
            GradientDrawable gradientDrawable;
            int n3;
            if (this.clientConfig.YYA().ETk()) {
                CardCallerInfo cardCallerInfo = this;
                n3 = cardCallerInfo.cc.fK6();
                n = cardCallerInfo.cc.fK6();
            } else {
                CardCallerInfo cardCallerInfo = this;
                n3 = ColorUtils.setAlphaComponent((int)cardCallerInfo.cc.Mc1(), (int)25);
                n = ColorUtils.setAlphaComponent((int)cardCallerInfo.cc.Mc1(), (int)25);
            }
            float[] fArray = new float[3];
            Object object2 = fArray;
            Color.colorToHSV((int)n3, (float[])object2);
            Color.colorToHSV((int)n, (float[])object2);
            fArray[2] = fArray[2] * 0.8f;
            Color.HSVToColor((float[])fArray);
            object2 = gradientDrawable;
            gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.LEFT_RIGHT, new int[]{n3, n});
            object = object2;
        }
        boolean bl = this.isSpam;
        n = bl ? 1 : 0;
        if (bl) {
            CardCallerInfo cardCallerInfo = this;
            cardCallerInfo.top_container.setBackground((Drawable)object);
            cardCallerInfo.baseMainLayout.findViewById(R.id.dummy_id).setBackground((Drawable)object);
        } else {
            CardCallerInfo cardCallerInfo = this;
            cardCallerInfo.top_container.setBackgroundColor(this.cc.fK6(n != 0));
            cardCallerInfo.baseMainLayout.findViewById(R.id.dummy_id).setBackgroundColor(this.cc.fK6(this.isSpam));
        }
        this.ll_call.setBackground((Drawable)object);
    }

    public int getLayoutType() {
        return this.layoutType;
    }

    /*
     * WARNING - void declaration
     */
    public void updateView(Contact contact) {
        if (contact.esR() != null) {
            void var1_1;
            this.contactNameTV.setText((CharSequence)var1_1.esR());
        }
    }

    /*
     * WARNING - void declaration
     */
    public void update(Search search) {
        void var1_1;
        CardCallerInfo cardCallerInfo = this;
        cardCallerInfo.search = var1_1;
        cardCallerInfo.isManualSearch = true;
        if (search != null) {
            this.name = var1_1.ix0(this.context);
            if (!TextUtils.isEmpty((CharSequence)var1_1.fK6())) {
                this.formattedPhoneNumber = var1_1.fK6();
            }
            if (!TextUtils.isEmpty((CharSequence)var1_1.YYA())) {
                this.formattedPhoneNumber = var1_1.YYA();
            }
            if (Search.B5B((Search)var1_1) != null) {
                this.isSpam = var1_1.F2S();
            }
        }
        new Handler(Looper.getMainLooper()).post(() -> {
            CardCallerInfo cardCallerInfo = this;
            cardCallerInfo.setBackgroundDrawable();
            cardCallerInfo.setContactImage();
            cardCallerInfo.setContactNameIconNumberTV();
            cardCallerInfo.setPhoneIconCollapsed();
            cardCallerInfo.setCallStatusTV();
            cardCallerInfo.checkForUsingExtendedCalldurationLayout(false);
            cardCallerInfo.onSearchEndListener.B5B();
        });
    }

    /*
     * WARNING - void declaration
     */
    public void updateCallLogInfo(int callDuration) {
        void var1_1;
        this.callDuration = (long)var1_1;
        this.setDurationTV();
    }

    public String toString() {
        return "CardCallerInfo{callType='" + this.callType + '\'' + ", name='" + this.name + '\'' + ", formattedPhoneNumber='" + this.formattedPhoneNumber + '\'' + ", isSpam=" + this.isSpam + ", isManualSearch=" + this.isManualSearch + ", search=" + this.search + ", callDuration=" + this.callDuration + ", acListener=" + this.acListener + '}';
    }

    public static interface AcContentViewListener {
        public void B5B();

        public void ix0();
    }

    public static interface OnSearchEndListener {
        public void B5B();
    }
}

