/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.news;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.Group;
import androidx.core.graphics.ColorUtils;
import com.calldorado.CalldoradoApplication;
import com.calldorado.android.R;
import com.calldorado.stats.StatsReceiver;
import com.calldorado.ui.data_models.ColorCustomization;
import com.calldorado.ui.news.B5B;
import com.calldorado.ui.news.data.NewsItemKotlin;
import com.calldorado.ui.news.ix0;
import com.calldorado.util.IntentUtil;
import com.facebook.shimmer.ShimmerFrameLayout;

public class NewsCardLayout
extends LinearLayout
implements B5B.ix0 {
    private static final String TAG = "NewsCardLayout";
    private String topicId;
    private View view;
    private TextView titleTv;
    private TextView descTv;
    private AppCompatImageView imageView;
    private TextView dateTv;
    private TextView linkTv;
    private TextView seperatorTv;
    private ImageView expandBtn;
    private Context context;
    private boolean shouldTitleBeCategory;
    private int indexToFetch;
    private OnCardClickedListener clickListener;
    private OnCardFailedToLoadListener failedListener;
    private NewsItemKotlin newsItem;
    private ShimmerFrameLayout shimmerFrameLayout;
    private Group viewsGroup;
    private long mLastClickTime;
    private String mTopicName;

    /*
     * WARNING - void declaration
     */
    public NewsCardLayout(String topicId, boolean shouldTitleBeCategory, int index, Context context) {
        void var3_3;
        void var2_2;
        void var1_1;
        void var4_4;
        NewsCardLayout newsCardLayout = this;
        super((Context)var4_4);
        newsCardLayout.mLastClickTime = 0L;
        newsCardLayout.mTopicName = "";
        newsCardLayout.topicId = var1_1;
        newsCardLayout.context = var4_4;
        newsCardLayout.shouldTitleBeCategory = var2_2;
        newsCardLayout.indexToFetch = var3_3;
        newsCardLayout.init();
    }

    /*
     * WARNING - void declaration
     */
    public NewsCardLayout(Context context, @Nullable AttributeSet attrs) {
        void var2_2;
        void var1_1;
        NewsCardLayout newsCardLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2);
        newsCardLayout.shouldTitleBeCategory = true;
        newsCardLayout.mLastClickTime = 0L;
        newsCardLayout.mTopicName = "";
        newsCardLayout.init();
    }

    /*
     * WARNING - void declaration
     */
    public NewsCardLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        void var3_3;
        void var2_2;
        void var1_1;
        NewsCardLayout newsCardLayout = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        newsCardLayout.shouldTitleBeCategory = true;
        newsCardLayout.mLastClickTime = 0L;
        newsCardLayout.mTopicName = "";
        newsCardLayout.init();
    }

    private void init() {
        LinearLayout.LayoutParams layoutParams;
        ViewGroup.LayoutParams layoutParams2;
        com.calldorado.log.B5B.B5B(TAG, "init: " + this.topicId);
        ViewGroup.LayoutParams layoutParams3 = layoutParams2;
        layoutParams2 = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(layoutParams3);
        Context context = this.getContext();
        this.getContext();
        this.view = ((LayoutInflater)context.getSystemService("layout_inflater")).inflate(R.layout.cdo_livenews_layout, null);
        this.titleTv = (TextView)this.view.findViewById(R.id.cdo_livenews_title);
        this.descTv = (TextView)this.view.findViewById(R.id.cdo_livenews_desc);
        this.imageView = (AppCompatImageView)this.view.findViewById(R.id.cdo_livenews_iv);
        this.dateTv = (TextView)this.view.findViewById(R.id.cdo_livenews_date);
        this.linkTv = (TextView)this.view.findViewById(R.id.cdo_livenews_link);
        this.shimmerFrameLayout = (ShimmerFrameLayout)this.view.findViewById(R.id.cdo_livenews_shimmering);
        this.seperatorTv = (TextView)this.view.findViewById(R.id.cdo_livenews_seperator);
        this.expandBtn = (ImageView)this.view.findViewById(R.id.cdo_livenews_expand_btn);
        this.viewsGroup = (Group)this.view.findViewById(R.id.cdo_livenews_layout_group);
        this.viewsGroup.setVisibility(8);
        this.view.findViewById(R.id.cdo_livenews_placeholder).setVisibility(0);
        this.expandBtn.setVisibility(0);
        this.setupColors();
        B5B.B5B(this.getContext()).B5B(this.topicId, this, this.indexToFetch);
        this.setOnClickListener(this::onCardClicked);
        layoutParams3 = layoutParams;
        layoutParams = new LinearLayout.LayoutParams(-1, -2);
        this.addView(this.view, layoutParams3);
    }

    private void setupColors() {
        NewsCardLayout newsCardLayout = this;
        ColorCustomization colorCustomization = CalldoradoApplication.ix0(newsCardLayout.context).dpy();
        newsCardLayout.expandBtn.setColorFilter(colorCustomization.B5B(this.context), PorterDuff.Mode.SRC_IN);
        newsCardLayout.view.setBackgroundColor(colorCustomization.ix0());
        newsCardLayout.titleTv.setTextColor(colorCustomization.Mc1());
        newsCardLayout.descTv.setTextColor(colorCustomization.Mc1());
        newsCardLayout.dateTv.setTextColor(colorCustomization.Mc1());
        newsCardLayout.linkTv.setTextColor(colorCustomization.Mc1());
        newsCardLayout.seperatorTv.setTextColor(ColorUtils.setAlphaComponent((int)colorCustomization.Mc1(), (int)83));
    }

    private void onCardClicked(View v) {
        if (SystemClock.elapsedRealtime() - this.mLastClickTime < 1000L) {
            return;
        }
        NewsCardLayout newsCardLayout = this;
        newsCardLayout.mLastClickTime = SystemClock.elapsedRealtime();
        com.calldorado.ui.shared_wic_aftercall.viewpager.pages.cards_page.B5B.B5B(newsCardLayout.getContext()).B5B(this.topicId.hashCode());
        String string2 = newsCardLayout.mTopicName;
        if (string2 != null) {
            string2 = string2.replace(" ", "_").toLowerCase();
            StatsReceiver.broadcastStats(this.getContext(), "live_news_topic_" + string2, null);
        }
        this.clickListener.B5B(this.topicId);
    }

    private /* synthetic */ void lambda$onSingleNewsItemFetchComplete$1(NewsItemKotlin newsItem, String topicName) {
        if (newsItem != null) {
            ShimmerFrameLayout shimmerFrameLayout;
            ((NewsCardLayout)((Object)string2)).view.findViewById(R.id.cdo_livenews_placeholder).setVisibility(8);
            ((NewsCardLayout)((Object)string2)).newsItem = var1_1;
            if (((NewsCardLayout)((Object)string2)).shouldTitleBeCategory) {
                NewsCardLayout newsCardLayout = string2;
                newsCardLayout.titleTv.setText((CharSequence)shimmerFrameLayout);
                newsCardLayout.descTv.setText((CharSequence)((NewsItemKotlin)((Object)var1_1)).Mc1());
            } else {
                NewsCardLayout newsCardLayout = string2;
                newsCardLayout.titleTv.setText((CharSequence)((NewsItemKotlin)((Object)var1_1)).Mc1());
                newsCardLayout.descTv.setText((CharSequence)((NewsItemKotlin)((Object)var1_1)).H1u());
            }
            NewsCardLayout newsCardLayout = string2;
            newsCardLayout.dateTv.setText((CharSequence)ix0.B5B(((NewsCardLayout)((Object)string2)).context, ((NewsItemKotlin)((Object)var1_1)).gGZ()));
            newsCardLayout.linkTv.setText((CharSequence)((NewsItemKotlin)((Object)var1_1)).dpy().ix0());
            newsCardLayout.linkTv.setOnClickListener(arg_0 -> ((NewsCardLayout)((Object)string2)).lambda$onSingleNewsItemFetchComplete$0((NewsItemKotlin)((Object)var1_1), arg_0));
            OnCardFailedToLoadListener onCardFailedToLoadListener = var1_1;
            NewsCardLayout newsCardLayout2 = string2;
            String string2 = ((NewsItemKotlin)((Object)var1_1)).xfp();
            var1_1 = newsCardLayout2.imageView;
            shimmerFrameLayout = newsCardLayout2.shimmerFrameLayout;
            String string3 = ((NewsItemKotlin)((Object)onCardFailedToLoadListener)).F2S();
            ix0.B5B(newsCardLayout.context, string2, (AppCompatImageView)var1_1, shimmerFrameLayout, string3);
            newsCardLayout.viewsGroup.setVisibility(0);
        } else {
            NewsCardLayout newsCardLayout = string2;
            newsCardLayout.setVisibility(8);
            var1_1 = newsCardLayout.failedListener;
            if (var1_1 != null) {
                var1_1.B5B(((NewsCardLayout)((Object)string2)).topicId);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ void lambda$onSingleNewsItemFetchComplete$0(NewsItemKotlin newsItem, View view) {
        void var1_1;
        IntentUtil.webPageIntent(this.context, var1_1.fK6());
    }

    /*
     * WARNING - void declaration
     */
    public void setOnCardClicked(OnCardClickedListener listener) {
        void var1_1;
        this.clickListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setOnCardFailedListener(OnCardFailedToLoadListener failedListener) {
        void var1_1;
        this.failedListener = var1_1;
    }

    public NewsItemKotlin getNewsItem() {
        return this.newsItem;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onSingleNewsItemFetchComplete(String topicName, NewsItemKotlin newsItem) {
        Handler handler;
        void var2_2;
        void var1_1;
        com.calldorado.log.B5B.B5B(TAG, "onSingleNewsItemFetchComplete: " + (String)var1_1 + ", " + var2_2);
        this.mTopicName = var1_1;
        Handler handler2 = handler;
        handler2(Looper.getMainLooper());
        handler.post(() -> this.lambda$onSingleNewsItemFetchComplete$1((NewsItemKotlin)var2_2, (String)var1_1));
    }

    public static interface OnCardClickedListener {
        public void B5B(String var1);
    }

    public static interface OnCardFailedToLoadListener {
        public void B5B(String var1);
    }
}

