/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import com.calldorado.log.B5B;
import com.calldorado.util.CustomizationUtil;

@SuppressLint(value={"AppCompatCustomView"})
public class CircleImageView
extends ImageView {
    private static final ImageView.ScaleType SCALE_TYPE = ImageView.ScaleType.CENTER_CROP;
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -16777216;
    private static final int DEFAULT_FILL_COLOR = 0;
    private static final boolean DEFAULT_BORDER_OVERLAY = false;
    private static final String TAG = CircleImageView.class.getSimpleName();
    private String subTag;
    private final RectF mDrawableRect;
    private final RectF mBorderRect;
    private final Matrix mShaderMatrix;
    private final Paint mBitmapPaint;
    private final Paint mBorderPaint;
    private final Paint mFillPaint;
    private int mBorderColor;
    private int mBorderWidth;
    private int mFillColor;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private int mBitmapWidth;
    private int mBitmapHeight;
    private float mDrawableRadius;
    private float mBorderRadius;
    private ColorFilter mColorFilter;
    private boolean mReady;
    private boolean mSetupPending;
    private boolean mBorderOverlay;
    private Context context;
    private float cX;
    private float cY;

    /*
     * WARNING - void declaration
     */
    public CircleImageView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.subTag = TAG;
        this.mDrawableRect = new RectF();
        this.mBorderRect = new RectF();
        this.mShaderMatrix = new Matrix();
        this.mBitmapPaint = new Paint();
        this.mBorderPaint = new Paint();
        this.mFillPaint = new Paint();
        this.mBorderColor = -16777216;
        this.mBorderWidth = 0;
        this.mFillColor = 0;
        this.cX = 2.0f;
        this.cY = 2.0f;
        this.context = var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public CircleImageView(Context context, AttributeSet attrs) {
        this((Context)var1_1, (AttributeSet)var2_2, 0);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public CircleImageView(Context context, AttributeSet attrs, int defStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        CircleImageView circleImageView = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        circleImageView.subTag = TAG;
        circleImageView.mDrawableRect = new RectF();
        circleImageView.mBorderRect = new RectF();
        circleImageView.mShaderMatrix = new Matrix();
        circleImageView.mBitmapPaint = new Paint();
        circleImageView.mBorderPaint = new Paint();
        circleImageView.mFillPaint = new Paint();
        circleImageView.mBorderColor = -16777216;
        circleImageView.mBorderWidth = 0;
        circleImageView.mFillColor = 0;
        circleImageView.cX = 2.0f;
        circleImageView.cY = 2.0f;
        circleImageView.init();
    }

    private void init() {
        CircleImageView circleImageView = this;
        super.setScaleType(SCALE_TYPE);
        circleImageView.mReady = true;
        if (circleImageView.mSetupPending) {
            this.setup(true);
            this.mSetupPending = false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        Exception exception2;
        block5: {
            Canvas canvas;
            void v3;
            void v2;
            CircleImageView circleImageView;
            Canvas canvas2;
            if (drawable2 == null) {
                return null;
            }
            if (canvas2 instanceof BitmapDrawable) {
                return ((BitmapDrawable)canvas2).getBitmap();
            }
            try {
                CircleImageView circleImageView2 = canvas2 instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)canvas2.getIntrinsicWidth(), (int)canvas2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
                circleImageView = circleImageView2;
                void v1 = canvas2;
                v2 = v1;
                v3 = v1;
            }
            catch (Exception exception2) {
                break block5;
            }
            canvas2 = canvas;
            {
                int n = 0;
                int n2 = 0;
                int n3 = new Canvas((Bitmap)circleImageView2).getWidth();
                int n4 = canvas2.getHeight();
                v2.setBounds(n, n2, n3, n4);
                v3.draw(canvas2);
                return circleImageView;
            }
        }
        exception2.printStackTrace();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void setup(boolean isBitmap) {
        void var1_1;
        if (!this.mReady) {
            this.mSetupPending = true;
            B5B.B5B(this.subTag, "setup: not ready");
            return;
        }
        if (this.getWidth() == 0 && this.getHeight() == 0) {
            B5B.B5B(this.subTag, "setup: w&h == 0");
            return;
        }
        if (var1_1 != false && this.mBitmap == null) {
            this.invalidate();
            B5B.ix0(this.subTag, "bitmap==null");
            return;
        }
        if (var1_1 != false) {
            BitmapShader bitmapShader;
            BitmapShader bitmapShader2 = bitmapShader;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            bitmapShader = new BitmapShader(this.mBitmap, tileMode, tileMode);
            this.mBitmapShader = bitmapShader2;
        }
        this.mBitmapPaint.setAntiAlias(true);
        if (var1_1 != false) {
            this.mBitmapPaint.setShader((Shader)this.mBitmapShader);
        }
        this.mBorderPaint.setStyle(Paint.Style.STROKE);
        this.mBorderPaint.setAntiAlias(true);
        this.mBorderPaint.setColor(this.mBorderColor);
        this.mBorderPaint.setStrokeWidth((float)this.mBorderWidth);
        this.mFillPaint.setStyle(Paint.Style.FILL);
        this.mFillPaint.setAntiAlias(true);
        this.mFillPaint.setColor(this.mFillColor);
        if (var1_1 != false) {
            this.mBitmapHeight = this.mBitmap.getHeight();
            this.mBitmapWidth = this.mBitmap.getWidth();
        } else {
            this.mBitmapHeight = CustomizationUtil.getAvatarSize(this.context);
            this.mBitmapWidth = CustomizationUtil.getAvatarSize(this.context);
        }
        float f = this.getWidth();
        float f2 = this.getHeight();
        this.mBorderRect.set(0.0f, 0.0f, f, f2);
        this.mBorderRadius = Math.min((this.mBorderRect.height() - (float)this.mBorderWidth) / 2.0f, (this.mBorderRect.width() - (float)this.mBorderWidth) / 2.0f);
        this.mDrawableRect.set(this.mBorderRect);
        if (!this.mBorderOverlay) {
            int n = this.mBorderWidth;
            f = n;
            this.mDrawableRect.inset(f, (float)n);
        }
        this.mDrawableRadius = Math.min(this.mDrawableRect.height() / 2.0f, this.mDrawableRect.width() / 2.0f);
        this.updateShaderMatrix();
        this.invalidate();
    }

    private void updateShaderMatrix() {
        float f;
        CircleImageView circleImageView = this;
        float f2 = 0.0f;
        float f3 = 0.0f;
        circleImageView.mShaderMatrix.set(null);
        if ((float)circleImageView.mBitmapWidth * this.mDrawableRect.height() > this.mDrawableRect.width() * (float)this.mBitmapHeight) {
            CircleImageView circleImageView2 = this;
            f2 = circleImageView2.mDrawableRect.height() / (float)this.mBitmapHeight;
            float f4 = f = (circleImageView2.mDrawableRect.width() - (float)this.mBitmapWidth * f2) * 0.5f;
            f = f3;
            f3 = f4;
        } else {
            CircleImageView circleImageView3 = this;
            f3 = circleImageView3.mDrawableRect.width() / (float)this.mBitmapWidth;
            f = (circleImageView3.mDrawableRect.height() - (float)this.mBitmapHeight * f3) * 0.5f;
            float f5 = f3;
            f3 = f2;
            f2 = f5;
        }
        CircleImageView circleImageView4 = this;
        float f6 = f2;
        circleImageView4.mShaderMatrix.setScale(f6, f6);
        RectF rectF = this.mDrawableRect;
        f3 = (float)((int)(f3 + 0.5f)) + rectF.left;
        circleImageView4.mShaderMatrix.postTranslate(f3, (float)((int)(f + 0.5f)) + rectF.top);
        circleImageView4.mBitmapShader.setLocalMatrix(this.mShaderMatrix);
    }

    public ImageView.ScaleType getScaleType() {
        return SCALE_TYPE;
    }

    /*
     * WARNING - void declaration
     */
    public void setScaleType(ImageView.ScaleType scaleType) {
        void var1_1;
        if (scaleType == SCALE_TYPE) {
            return;
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var1_1;
        throw new IllegalArgumentException(String.format("ScaleType %s not supported.", objectArray2));
    }

    public void setAdjustViewBounds(boolean adjustViewBounds) {
        if (!adjustViewBounds) {
            return;
        }
        throw new IllegalArgumentException("adjustViewBounds not supported.");
    }

    /*
     * WARNING - void declaration
     */
    public void setcXY(float cXY) {
        void var1_1;
        CircleImageView circleImageView = this;
        circleImageView.cX = var1_1;
        circleImageView.cY = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_2;
        Paint paint;
        float f;
        float f2;
        float f3;
        if (this.mBitmap == null) {
            return;
        }
        B5B.B5B(TAG, "onDraw: " + this.mDrawableRadius + ", " + this.mBorderRadius + ", " + this.mBorderWidth);
        if (this.mFillColor != 0) {
            CircleImageView circleImageView = this;
            f3 = (float)circleImageView.getWidth() / 2.0f;
            f2 = (float)circleImageView.getHeight() / 2.0f;
            f = circleImageView.mDrawableRadius + 1.0f;
            paint = circleImageView.mFillPaint;
            var1_2.drawCircle(f3, f2, f, paint);
        }
        CircleImageView circleImageView = this;
        f3 = (float)circleImageView.getWidth() / this.cX;
        f2 = (float)circleImageView.getHeight() / this.cY;
        f = circleImageView.mDrawableRadius;
        paint = circleImageView.mBitmapPaint;
        var1_2.drawCircle(f3, f2, f, paint);
        if (this.mBorderWidth != 0) {
            CircleImageView circleImageView2 = this;
            float f4 = (float)circleImageView2.getWidth() / 2.0f;
            float f5 = (float)circleImageView2.getHeight() / 2.0f;
            f3 = circleImageView2.mBorderRadius;
            Paint paint2 = circleImageView2.mBorderPaint;
            var1_2.drawCircle(f4, f5, f3, paint2);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CircleImageView circleImageView = this;
        super.onSizeChanged((int)var1_1, (int)var2_2, (int)var3_3, (int)var4_4);
        circleImageView.setup(true);
    }

    public int getBorderColor() {
        return this.mBorderColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColor(@ColorInt int borderColor) {
        void var1_1;
        if (borderColor == this.mBorderColor) {
            return;
        }
        CircleImageView circleImageView = this;
        circleImageView.mBorderColor = var1_1;
        circleImageView.mBorderPaint.setColor((int)var1_1);
        circleImageView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColorResource(@ColorRes int borderColorRes) {
        void var1_1;
        CircleImageView circleImageView = this;
        circleImageView.setBorderColor(circleImageView.getContext().getResources().getColor((int)var1_1));
    }

    public int getFillColor() {
        return this.mFillColor;
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(@ColorInt int fillColor) {
        void var1_1;
        if (fillColor == this.mFillColor) {
            B5B.B5B(this.subTag, "setFillColor: color already set");
            return;
        }
        CircleImageView circleImageView = this;
        circleImageView.mFillColor = var1_1;
        circleImageView.mFillPaint.setColor((int)var1_1);
        circleImageView.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColorResource(@ColorRes int fillColorRes) {
        void var1_1;
        CircleImageView circleImageView = this;
        circleImageView.setFillColor(circleImageView.getContext().getResources().getColor((int)var1_1));
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderWidth(int borderWidth) {
        void var1_1;
        if (borderWidth == this.mBorderWidth) {
            return;
        }
        this.mBorderWidth = var1_1;
        this.setup(true);
    }

    public boolean isBorderOverlay() {
        return this.mBorderOverlay;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderOverlay(boolean borderOverlay) {
        void var1_1;
        if (borderOverlay == this.mBorderOverlay) {
            return;
        }
        this.mBorderOverlay = var1_1;
        this.setup(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageBitmap(Bitmap bm) {
        void var1_1;
        CircleImageView circleImageView = this;
        super.setImageBitmap((Bitmap)var1_1);
        circleImageView.mBitmap = var1_1;
        circleImageView.setup(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageDrawable(Drawable drawable2) {
        void var1_1;
        CircleImageView circleImageView = this;
        super.setImageDrawable((Drawable)var1_1);
        circleImageView.mBitmap = circleImageView.getBitmapFromDrawable((Drawable)var1_1);
        circleImageView.setup(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setImageResource(@DrawableRes int resId) {
        void var1_1;
        CircleImageView circleImageView = this;
        super.setImageResource((int)var1_1);
        circleImageView.mBitmap = circleImageView.getBitmapFromDrawable(circleImageView.getDrawable());
        circleImageView.setup(true);
    }

    public void setImageURI(Uri uri) {
        Bitmap bitmap;
        super.setImageURI((Uri)bitmap);
        if (uri != null) {
            CircleImageView circleImageView = this;
            bitmap = circleImageView.getBitmapFromDrawable(circleImageView.getDrawable());
        } else {
            bitmap = null;
        }
        this.mBitmap = bitmap;
        this.setup(true);
    }

    /*
     * WARNING - void declaration
     */
    public void setColorFilter(ColorFilter cf) {
        void var1_1;
        if (cf == this.mColorFilter) {
            return;
        }
        CircleImageView circleImageView = this;
        circleImageView.mColorFilter = var1_1;
        circleImageView.mBitmapPaint.setColorFilter((ColorFilter)var1_1);
        circleImageView.invalidate();
    }

    public boolean hasImage() {
        return this.mBitmap != null;
    }

    /*
     * WARNING - void declaration
     */
    public void setSubTag(String subTag) {
        void var1_1;
        this.subTag = TAG + " " + (String)var1_1;
    }
}

