/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import android.view.View;
import android.widget.RelativeLayout;
import com.calldorado.util.CustomizationUtil;

public class CircleRelativeViewgroup
extends RelativeLayout {
    private static final int DEFAULT_BORDER_WIDTH = 0;
    private static final int DEFAULT_BORDER_COLOR = -1;
    private static final int DEFAULT_FILL_COLOR = 0;
    private Paint mFillPaint;
    private float mDrawableRadius;
    private int mBorderColor;
    private int mBorderWidth;
    private int mFillColor;
    private Paint mBorderPaint;
    private float borderRadius;

    /*
     * WARNING - void declaration
     */
    public CircleRelativeViewgroup(Context context) {
        void var1_1;
        CircleRelativeViewgroup circleRelativeViewgroup = this;
        super((Context)var1_1);
        circleRelativeViewgroup.mBorderColor = -1;
        circleRelativeViewgroup.mBorderWidth = 0;
        circleRelativeViewgroup.mFillColor = 0;
        circleRelativeViewgroup.borderRadius = 0.0f;
        circleRelativeViewgroup.mDrawableRadius = CustomizationUtil.dpToPx(circleRelativeViewgroup.getContext(), 30);
        circleRelativeViewgroup.borderRadius = CustomizationUtil.dpToPx(circleRelativeViewgroup.getContext(), 3);
        circleRelativeViewgroup.init();
    }

    private void init() {
        Paint paint;
        Paint paint2;
        CircleRelativeViewgroup circleRelativeViewgroup = this;
        this.mFillPaint = new Paint();
        Paint.Style style2 = Paint.Style.FILL;
        this.mFillPaint.setStyle(style2);
        circleRelativeViewgroup.mFillPaint.setAntiAlias(true);
        circleRelativeViewgroup.mFillPaint.setColor(-16777216);
        Paint paint3 = paint2 = paint;
        paint3();
        this.mBorderPaint = paint3;
        paint.setStyle(style2);
        circleRelativeViewgroup.mBorderPaint.setAntiAlias(true);
        circleRelativeViewgroup.mBorderPaint.setColor(-1);
    }

    /*
     * WARNING - void declaration
     */
    private void substractChildren(Canvas canvas) {
        Paint paint;
        Rect rect;
        void var1_1;
        void v0 = var1_1;
        int n = v0.getWidth();
        int n2 = v0.getHeight();
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)v0.getWidth(), (int)var1_1.getHeight(), (Bitmap.Config)config);
        this.draw(new Canvas(bitmap));
        config = Bitmap.createBitmap((int)canvas.getWidth(), (int)var1_1.getHeight(), (Bitmap.Config)config);
        Rect rect2 = rect;
        rect = new Rect(0, 0, n, n2);
        new Canvas((Bitmap)config).drawRect(rect2, this.mFillPaint);
        Paint paint2 = paint;
        paint2(1);
        var1_1.drawBitmap((Bitmap)config, 0.0f, 0.0f, paint2);
        paint2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        var1_1.drawBitmap(bitmap, 0.0f, 0.0f, paint2);
        paint.setXfermode(null);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(2, paint2);
        }
    }

    public static Bitmap loadBitmapFromView(RelativeLayout v) {
        RelativeLayout relativeLayout;
        RelativeLayout relativeLayout2 = v;
        relativeLayout2.measure(View.MeasureSpec.makeMeasureSpec((int)relativeLayout2.getLayoutParams().width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)relativeLayout.getLayoutParams().height, (int)0x40000000));
        int n = relativeLayout2.getMeasuredWidth();
        int n2 = relativeLayout2.getMeasuredHeight();
        relativeLayout2.layout(0, 0, n, n2);
        Bitmap bitmap = Bitmap.createBitmap((int)relativeLayout2.getLayoutParams().width, (int)relativeLayout.getLayoutParams().height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        relativeLayout.draw(new Canvas(bitmap));
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public void setCircleRadius(int pixels) {
        void var1_1;
        this.mDrawableRadius = CustomizationUtil.dpToPx(this.getContext(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void dispatchDraw(Canvas canvas) {
        void var1_2;
        void v0 = var1_2;
        CircleRelativeViewgroup circleRelativeViewgroup = this;
        CircleRelativeViewgroup circleRelativeViewgroup2 = this;
        float f = (float)circleRelativeViewgroup2.getWidth() / 2.0f;
        float f2 = (float)circleRelativeViewgroup2.getHeight() / 2.0f;
        float f3 = circleRelativeViewgroup2.mDrawableRadius + this.borderRadius;
        Paint paint = circleRelativeViewgroup2.mBorderPaint;
        var1_2.drawCircle(f, f2, f3, paint);
        f3 = circleRelativeViewgroup.getWidth() / 2;
        f = circleRelativeViewgroup.getHeight() / 2;
        f2 = circleRelativeViewgroup.mDrawableRadius;
        paint = circleRelativeViewgroup.mFillPaint;
        v0.drawCircle(f3, f, f2, paint);
        super.dispatchDraw((Canvas)v0);
    }

    public int getBorderWidth() {
        return this.mBorderWidth;
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderWidth(int borderWidth) {
        void var1_1;
        this.mBorderWidth = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFillColor(int color2) {
        void var1_1;
        CircleRelativeViewgroup circleRelativeViewgroup = this;
        circleRelativeViewgroup.mFillPaint.setColor((int)var1_1);
        circleRelativeViewgroup.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setBorderColor(int color2) {
        void var1_1;
        CircleRelativeViewgroup circleRelativeViewgroup = this;
        circleRelativeViewgroup.mBorderPaint.setColor((int)var1_1);
        circleRelativeViewgroup.invalidate();
    }

    /*
     * WARNING - void declaration
     */
    public void setmDrawableRadius(float mDrawableRadius) {
        void var1_1;
        this.mDrawableRadius = var1_1;
    }
}

