/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

public class CustomLinearLayout
extends LinearLayout {
    private static final int[] R_styleable_LinearLayout = new int[]{16843049, 16843476, 16843561, 16843562};
    private static final int LinearLayout_divider = 0;
    private static final int LinearLayout_measureWithLargestChild = 1;
    private static final int LinearLayout_showDividers = 2;
    private static final int LinearLayout_dividerPadding = 3;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    private static final boolean IS_HONEYCOMB = Build.VERSION.SDK_INT >= 11;
    private Drawable mDivider;
    protected int mDividerWidth;
    protected int mDividerHeight;
    private int mShowDividers;
    private int mDividerPadding;
    private boolean mClipDivider;
    private boolean mUseLargestChild;

    /*
     * WARNING - void declaration
     */
    public CustomLinearLayout(Context context, AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
    }

    private void useLargestChildHorizontal() {
        int n;
        int n2 = this.getChildCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 = Math.max(this.getChildAt(n).getMeasuredWidth(), n3);
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            LinearLayout.LayoutParams layoutParams;
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
            if (layoutParams.weight > 0.0f) {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredHeight(), (int)0x40000000));
                n4 = n + n3;
            } else {
                n4 = n + view.getMeasuredWidth();
            }
            n = n4 + (layoutParams2.leftMargin + layoutParams2.rightMargin);
        }
        CustomLinearLayout customLinearLayout = this;
        int n5 = n + (this.getPaddingLeft() + this.getPaddingRight());
        customLinearLayout.setMeasuredDimension(n5, customLinearLayout.getMeasuredHeight());
    }

    private void useLargestChildVertical() {
        int n;
        int n2 = this.getChildCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            n3 = Math.max(this.getChildAt(n).getMeasuredHeight(), n3);
        }
        n = 0;
        for (int i = 0; i < n2; ++i) {
            int n4;
            LinearLayout.LayoutParams layoutParams;
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8) continue;
            LinearLayout.LayoutParams layoutParams2 = (LinearLayout.LayoutParams)view.getLayoutParams();
            if (layoutParams.weight > 0.0f) {
                int n5 = n;
                n = View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)0x40000000);
                view.measure(n, View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000));
                n4 = n5 + n3;
            } else {
                n4 = n + view.getMeasuredHeight();
            }
            n = n4 + (layoutParams2.leftMargin + layoutParams2.rightMargin);
        }
        CustomLinearLayout customLinearLayout = this;
        int n6 = n + (this.getPaddingLeft() + this.getPaddingRight());
        customLinearLayout.setMeasuredDimension(customLinearLayout.getMeasuredWidth(), n6);
    }

    /*
     * WARNING - void declaration
     */
    public void setShowDividers(int showDividers) {
        void var1_1;
        if (showDividers != this.mShowDividers) {
            CustomLinearLayout customLinearLayout = this;
            customLinearLayout.requestLayout();
            customLinearLayout.invalidate();
        }
        this.mShowDividers = var1_1;
    }

    public int getShowDividers() {
        return this.mShowDividers;
    }

    /*
     * WARNING - void declaration
     */
    public void setDividerDrawable(Drawable divider) {
        void var1_1;
        if (divider == this.mDivider) {
            return;
        }
        this.mDivider = var1_1;
        this.mClipDivider = var1_1 instanceof ColorDrawable;
        if (var1_1 != null) {
            this.mDividerWidth = var1_1.getIntrinsicWidth();
            this.mDividerHeight = var1_1.getIntrinsicHeight();
        } else {
            CustomLinearLayout customLinearLayout = this;
            customLinearLayout.mDividerWidth = 0;
            customLinearLayout.mDividerHeight = 0;
        }
        boolean bl = var1_1 == null;
        CustomLinearLayout customLinearLayout = this;
        customLinearLayout.setWillNotDraw(bl);
        customLinearLayout.requestLayout();
    }

    /*
     * WARNING - void declaration
     */
    public void setDividerPadding(int padding) {
        void var1_1;
        this.mDividerPadding = var1_1;
    }

    public int getDividerPadding() {
        return this.mDividerPadding;
    }

    public int getDividerWidth() {
        return this.mDividerWidth;
    }

    /*
     * WARNING - void declaration
     */
    protected void measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CustomLinearLayout customLinearLayout = this;
        int n = customLinearLayout.indexOfChild((View)var1_1);
        int n2 = customLinearLayout.getOrientation();
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)var1_1.getLayoutParams();
        if (customLinearLayout.hasDividerBeforeChildAt(n)) {
            if (n2 == 1) {
                layoutParams.topMargin = this.mDividerHeight;
            } else {
                layoutParams.leftMargin = this.mDividerWidth;
            }
        }
        if (n == (n = this.getChildCount()) - 1 && this.hasDividerBeforeChildAt(n)) {
            if (n2 == 1) {
                layoutParams.bottomMargin = this.mDividerHeight;
            } else {
                layoutParams.rightMargin = this.mDividerWidth;
            }
        }
        super.measureChildWithMargins((View)var1_1, (int)var2_2, (int)var3_3, (int)var4_4, (int)var5_5);
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(Canvas canvas) {
        void var1_1;
        if (this.mDivider != null) {
            if (this.getOrientation() == 1) {
                this.drawDividersVertical((Canvas)var1_1);
            } else {
                this.drawDividersHorizontal((Canvas)var1_1);
            }
        }
        super.onDraw((Canvas)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void drawDividersVertical(Canvas canvas) {
        void var1_1;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            View view2 = view;
            view = (LinearLayout.LayoutParams)view2.getLayoutParams();
            this.drawHorizontalDivider((Canvas)var1_1, view2.getTop() - view.topMargin);
        }
        if (this.hasDividerBeforeChildAt(n)) {
            View view = this.getChildAt(n - 1);
            int n2 = view == null ? this.getHeight() - this.getPaddingBottom() - this.mDividerHeight : view.getBottom();
            this.drawHorizontalDivider((Canvas)var1_1, n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    void drawDividersHorizontal(Canvas canvas) {
        void var1_1;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getChildAt(i);
            if (view == null || view.getVisibility() == 8 || !this.hasDividerBeforeChildAt(i)) continue;
            View view2 = view;
            view = (LinearLayout.LayoutParams)view2.getLayoutParams();
            this.drawVerticalDivider((Canvas)var1_1, view2.getLeft() - view.leftMargin);
        }
        if (this.hasDividerBeforeChildAt(n)) {
            View view = this.getChildAt(n - 1);
            int n2 = view == null ? this.getWidth() - this.getPaddingRight() - this.mDividerWidth : view.getRight();
            this.drawVerticalDivider((Canvas)var1_1, n2);
        }
    }

    void drawHorizontalDivider(Canvas canvas, int top) {
        if (this.mClipDivider && !IS_HONEYCOMB) {
            CustomLinearLayout customLinearLayout = this;
            var1_3.save();
            int n = customLinearLayout.getPaddingLeft() + this.mDividerPadding;
            int n2 = customLinearLayout.getWidth() - this.getPaddingRight() - this.mDividerPadding;
            void var4_7 = var2_4 + customLinearLayout.mDividerHeight;
            var1_3.clipRect(n, (int)var2_4, n2, (int)var4_7);
            this.mDivider.draw((Canvas)var1_3);
            var1_3.restore();
        } else {
            CustomLinearLayout customLinearLayout = this;
            CustomLinearLayout customLinearLayout2 = this;
            int n = customLinearLayout2.getPaddingLeft() + this.mDividerPadding;
            int n3 = customLinearLayout2.getWidth() - this.getPaddingRight() - this.mDividerPadding;
            void var4_8 = var2_4 + customLinearLayout2.mDividerHeight;
            customLinearLayout.mDivider.setBounds(n, (int)var2_4, n3, (int)var4_8);
            customLinearLayout.mDivider.draw((Canvas)var1_3);
        }
    }

    void drawVerticalDivider(Canvas canvas, int left) {
        if (this.mClipDivider && !IS_HONEYCOMB) {
            void v0 = var2_4;
            void v1 = var2_4;
            CustomLinearLayout customLinearLayout = this;
            var1_3.save();
            var2_4 = customLinearLayout.getPaddingTop() + this.mDividerPadding;
            void var3_5 = v1 + customLinearLayout.mDividerWidth;
            int n = this.getHeight() - this.getPaddingBottom() - this.mDividerPadding;
            var1_3.clipRect((int)v0, var2_4, (int)var3_5, n);
            this.mDivider.draw((Canvas)var1_3);
            var1_3.restore();
        } else {
            CustomLinearLayout customLinearLayout = this;
            void v4 = var2_4;
            void v5 = var2_4;
            CustomLinearLayout customLinearLayout2 = this;
            var2_4 = customLinearLayout2.getPaddingTop() + this.mDividerPadding;
            void var3_6 = v5 + customLinearLayout2.mDividerWidth;
            int n = this.getHeight() - this.getPaddingBottom() - this.mDividerPadding;
            customLinearLayout.mDivider.setBounds((int)v4, var2_4, (int)var3_6, n);
            customLinearLayout.mDivider.draw((Canvas)var1_3);
        }
    }

    protected boolean hasDividerBeforeChildAt(int childIndex) {
        int n;
        if (childIndex == 0) {
            return (this.mShowDividers & 1) != 0;
        }
        if (n == this.getChildCount()) {
            return (this.mShowDividers & 4) != 0;
        }
        if ((this.mShowDividers & 2) != 0) {
            void v0 = n;
            n = 0;
            for (void var2_2 = (v285437) - true; var2_2 >= 0; --var2_2) {
                if (this.getChildAt((int)var2_2).getVisibility() == 8) continue;
                n = 1;
                break;
            }
            return n;
        }
        return false;
    }

    public boolean isMeasureWithLargestChildEnabled() {
        return this.mUseLargestChild;
    }

    /*
     * WARNING - void declaration
     */
    public void setMeasureWithLargestChildEnabled(boolean enabled) {
        void var1_1;
        this.mUseLargestChild = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        void var2_2;
        int n;
        CustomLinearLayout customLinearLayout = this;
        super.onMeasure(n, (int)var2_2);
        if (customLinearLayout.mUseLargestChild) {
            n = this.getOrientation();
            if (n != 0) {
                if (n == 1) {
                    this.useLargestChildVertical();
                }
            } else {
                this.useLargestChildHorizontal();
            }
        }
    }
}

