/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;

public class CustomRatingBar
extends LinearLayout {
    private final int mMaxStars;
    private float mCurrentScore;
    private Drawable mStarOnResource;
    private Drawable mStarOffResource;
    private Drawable mStarHalfResource;
    private ImageView[] mStarsViews;
    private float mStarPadding;
    private IRatingBarCallbacks onScoreChanged;
    private int mLastStarId;
    private boolean mOnlyForDisplay;
    private double mLastX;
    private boolean mHalfStars;

    /*
     * WARNING - void declaration
     */
    public CustomRatingBar(Context context) {
        void var1_1;
        CustomRatingBar customRatingBar = this;
        super((Context)var1_1);
        customRatingBar.mMaxStars = 5;
        customRatingBar.mCurrentScore = 1.0f;
        customRatingBar.mStarPadding = 10.0f;
        customRatingBar.mHalfStars = false;
        customRatingBar.init();
    }

    /*
     * WARNING - void declaration
     */
    public CustomRatingBar(Context context, AttributeSet attrs) {
        void var2_2;
        void var1_1;
        CustomRatingBar customRatingBar = this;
        super((Context)var1_1, (AttributeSet)var2_2);
        customRatingBar.mMaxStars = 5;
        customRatingBar.mCurrentScore = 1.0f;
        customRatingBar.mStarPadding = 10.0f;
        customRatingBar.mHalfStars = false;
        customRatingBar.init();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=11)
    public CustomRatingBar(Context context, AttributeSet attrs, int defStyle) {
        void var3_3;
        void var2_2;
        void var1_1;
        CustomRatingBar customRatingBar = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        customRatingBar.mMaxStars = 5;
        customRatingBar.mCurrentScore = 1.0f;
        customRatingBar.mStarPadding = 10.0f;
        customRatingBar.mHalfStars = false;
        customRatingBar.init();
    }

    /*
     * WARNING - void declaration
     */
    @TargetApi(value=21)
    public CustomRatingBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        CustomRatingBar customRatingBar = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3, (int)var4_4);
        customRatingBar.mMaxStars = 5;
        customRatingBar.mCurrentScore = 1.0f;
        customRatingBar.mStarPadding = 10.0f;
        customRatingBar.mHalfStars = false;
        customRatingBar.init();
    }

    /*
     * WARNING - void declaration
     */
    private float getScoreForPosition(float x) {
        float f;
        void var1_2;
        if (this.mHalfStars) {
            return (float)Math.round((float)(var1_2 / ((float)this.getWidth() / 15.0f) / 3.0f * 2.0f)) / 2.0f;
        }
        float f2 = Math.round((float)(var1_2 / ((float)this.getWidth() / 5.0f)));
        if (f < 0.0f) {
            f2 = 1.0f;
        }
        return f2;
    }

    /*
     * WARNING - void declaration
     */
    private int getImageForScore(float score) {
        if (score > 0.0f) {
            void var1_1;
            return Math.round((float)var1_1) - 1;
        }
        return -1;
    }

    private void refreshStars() {
        float f = this.mCurrentScore;
        boolean bl = f != 0.0f && (double)f % 0.5 == 0.0 && this.mHalfStars;
        for (int i = 1; i <= 5; ++i) {
            float f2;
            float f3 = this.mCurrentScore;
            if ((float)i <= f2) {
                this.mStarsViews[i - 1].setImageDrawable(this.mStarOnResource);
                continue;
            }
            if (bl && (double)i - 0.5 <= (double)f3) {
                this.mStarsViews[i - 1].setImageDrawable(this.mStarHalfResource);
                continue;
            }
            this.mStarsViews[i - 1].setImageDrawable(this.mStarOffResource);
        }
    }

    private ImageView createStar() {
        LinearLayout.LayoutParams layoutParams;
        ImageView imageView;
        ImageView imageView2 = imageView;
        CustomRatingBar customRatingBar = customRatingBar3;
        ImageView imageView3 = imageView2;
        CustomRatingBar customRatingBar2 = customRatingBar3;
        imageView2(customRatingBar3.getContext());
        CustomRatingBar customRatingBar3 = layoutParams;
        new LinearLayout.LayoutParams((int)-1, (int)-1).weight = 1.0f;
        float f = customRatingBar2.mStarPadding;
        int n = (int)f;
        int n2 = (int)f;
        imageView3.setPadding(n, 0, n2, 0);
        imageView3.setAdjustViewBounds(true);
        imageView3.setScaleType(ImageView.ScaleType.FIT_CENTER);
        imageView3.setLayoutParams((ViewGroup.LayoutParams)customRatingBar3);
        imageView.setImageDrawable(customRatingBar.mStarOffResource);
        return imageView;
    }

    /*
     * WARNING - void declaration
     */
    private void animateStarPressed(ImageView star) {
        if (star != null) {
            void var1_1;
            ViewCompat.animate((View)var1_1).scaleX(1.2f).scaleY(1.2f).setDuration(100L).start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void animateStarRelease(ImageView star) {
        if (star != null) {
            void var1_1;
            ViewCompat.animate((View)var1_1).scaleX(1.0f).scaleY(1.0f).setDuration(100L).start();
        }
    }

    public IRatingBarCallbacks getOnScoreChanged() {
        return this.onScoreChanged;
    }

    /*
     * WARNING - void declaration
     */
    public void setOnScoreChanged(IRatingBarCallbacks onScoreChanged) {
        void var1_1;
        this.onScoreChanged = var1_1;
    }

    void init() {
        CustomRatingBar customRatingBar = this;
        customRatingBar.setOrientation(0);
        customRatingBar.setGravity(16);
        customRatingBar.mOnlyForDisplay = false;
        customRatingBar.mHalfStars = false;
    }

    public void setupStars() {
        this.mStarsViews = new ImageView[5];
        for (int i = 0; i < 5; ++i) {
            CustomRatingBar customRatingBar = this;
            ImageView imageView = customRatingBar.createStar();
            customRatingBar.addView((View)imageView);
            customRatingBar.mStarsViews[i] = imageView;
        }
        this.refreshStars();
    }

    public float getScore() {
        return this.mCurrentScore;
    }

    public void setScore(float score) {
        float f;
        f = (float)Math.round((float)(f * 2.0f)) / 2.0f;
        if (!this.mHalfStars) {
            f = Math.round(f);
        }
        this.mCurrentScore = f;
        this.refreshStars();
    }

    /*
     * WARNING - void declaration
     */
    public void setScrollToSelect(boolean enabled) {
        void var1_1;
        this.mOnlyForDisplay = var1_1 ^ 1;
    }

    public Drawable getStarOnResource() {
        return this.mStarOnResource;
    }

    /*
     * WARNING - void declaration
     */
    public void setStarOnResource(Drawable mStarOnResource) {
        void var1_1;
        this.mStarOnResource = var1_1;
    }

    public Drawable getStarOffResource() {
        return this.mStarOffResource;
    }

    /*
     * WARNING - void declaration
     */
    public void setStarOffResource(Drawable mStarOffResource) {
        void var1_1;
        this.mStarOffResource = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setOnlyForDisplay(boolean mOnlyForDisplay) {
        void var1_1;
        this.mOnlyForDisplay = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setStarPadding(float mStarPadding) {
        void var1_1;
        this.mStarPadding = var1_1;
    }

    public boolean isHalfStars() {
        return this.mHalfStars;
    }

    /*
     * WARNING - void declaration
     */
    public void setHalfStars(boolean halfStars) {
        void var1_1;
        this.mHalfStars = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ImageView getImageView(int position) {
        try {
            void var1_1;
            return this.mStarsViews[var1_1];
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        IRatingBarCallbacks iRatingBarCallbacks;
        if (this.mOnlyForDisplay) {
            return true;
        }
        int n = iRatingBarCallbacks.getAction();
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    if (Math.abs((double)iRatingBarCallbacks.getX() - this.mLastX) > 50.0) {
                        this.requestDisallowInterceptTouchEvent(true);
                    }
                    if ((this.mCurrentScore = this.getScoreForPosition(iRatingBarCallbacks.getX())) != this.mCurrentScore) {
                        this.animateStarRelease(this.getImageView(this.mLastStarId));
                        this.animateStarPressed(this.getImageView(this.getImageForScore(this.mCurrentScore)));
                        this.mLastStarId = this.getImageForScore(this.mCurrentScore);
                        this.refreshStars();
                        iRatingBarCallbacks = this.onScoreChanged;
                        if (iRatingBarCallbacks != null) {
                            iRatingBarCallbacks.B5B(this.mCurrentScore);
                        }
                    }
                }
            } else {
                this.animateStarRelease(this.getImageView(this.mLastStarId));
                this.mLastStarId = -1;
            }
        } else {
            float f;
            double d;
            this.mLastX = d = (double)iRatingBarCallbacks.getX();
            this.mCurrentScore = f = this.getScoreForPosition(iRatingBarCallbacks.getX());
            this.animateStarPressed(this.getImageView(this.getImageForScore(f)));
            this.mLastStarId = this.getImageForScore(this.mCurrentScore);
            if (this.mCurrentScore != this.mCurrentScore) {
                this.refreshStars();
                IRatingBarCallbacks iRatingBarCallbacks2 = this.onScoreChanged;
                if (iRatingBarCallbacks2 != null) {
                    iRatingBarCallbacks2.B5B(this.mCurrentScore);
                }
            }
        }
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public static interface IRatingBarCallbacks {
        public void B5B(float var1);
    }
}

