/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views.checkbox;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.calldorado.CalldoradoApplication;
import com.calldorado.log.B5B;

public class RoundedCheckBox
extends FrameLayout {
    private static final String TAG = "RoundedCheckBox";
    private static final int DEFAULT_SIZE_DP = 32;
    private static final int ANIMATION_TIME = 60;
    private boolean isChecked = false;
    private Context context;
    private int outerSize;
    private float innerSize = 0.6f;
    private int checkedColor;
    private int uncheckedColor = Color.parseColor((String)"#c7c7c7");
    private ViewGroup.LayoutParams layoutParams;
    private GradientDrawable outerCircle;
    private GradientDrawable innerCircle;
    private ImageView outerCircleIv;
    private ImageView innerCircleIv;
    private ScaleAnimation showScaleAnimation;
    private ScaleAnimation hideScaleAnimation;
    private int strokeWidth = 5;
    private boolean isInverted = false;
    private int strokeColor;

    /*
     * WARNING - void declaration
     */
    public RoundedCheckBox(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.context = var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public RoundedCheckBox(Context context, @Nullable AttributeSet attrs) {
        super((Context)var1_1, (AttributeSet)var2_2);
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public RoundedCheckBox(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.init();
    }

    private void init() {
        RoundedCheckBox roundedCheckBox = this;
        roundedCheckBox.checkedColor = CalldoradoApplication.ix0(roundedCheckBox.context).dpy().esR(this.context);
        roundedCheckBox.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
            final /* synthetic */ RoundedCheckBox B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onGlobalLayout() {
                FrameLayout.LayoutParams layoutParams;
                FrameLayout.LayoutParams layoutParams2;
                this.B5B.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                this.B5B.layoutParams = this.B5B.getLayoutParams();
                RoundedCheckBox roundedCheckBox = this.B5B;
                roundedCheckBox.outerSize = roundedCheckBox.layoutParams.height;
                roundedCheckBox.setClickable(true);
                RoundedCheckBox roundedCheckBox2 = this.B5B;
                ViewGroup.LayoutParams layoutParams3 = roundedCheckBox2.layoutParams;
                if (layoutParams3 != null) {
                    int n;
                    ViewGroup.LayoutParams layoutParams4 = layoutParams3;
                    layoutParams4.height = n = roundedCheckBox2.outerSize;
                    layoutParams4.width = n;
                }
                roundedCheckBox2.outerCircle = new GradientDrawable();
                this.B5B.outerCircle.setShape(1);
                this.B5B.outerCircle.setColor(0);
                roundedCheckBox2 = this.B5B;
                int n = roundedCheckBox2.outerSize;
                roundedCheckBox2.outerCircle.setSize(n, n);
                RoundedCheckBox roundedCheckBox3 = roundedCheckBox2 = this.B5B;
                int n2 = roundedCheckBox3.strokeWidth;
                roundedCheckBox2.outerCircle.setStroke(n2, roundedCheckBox3.uncheckedColor);
                this.B5B.strokeColor = this.B5B.uncheckedColor;
                this.B5B.innerCircle = new GradientDrawable();
                this.B5B.innerCircle.setShape(1);
                RoundedCheckBox roundedCheckBox4 = this.B5B;
                int n3 = roundedCheckBox4.outerSize;
                float f = roundedCheckBox4.innerSize;
                roundedCheckBox4.innerCircle.setSize((int)((float)n3 * f), (int)((float)n3 * f));
                RoundedCheckBox roundedCheckBox5 = this.B5B;
                roundedCheckBox5.innerCircle.setColor(roundedCheckBox5.checkedColor);
                this.B5B.outerCircleIv = new ImageView(this.B5B.context);
                roundedCheckBox5 = layoutParams2;
                layoutParams2 = new FrameLayout.LayoutParams(-1, -1);
                RoundedCheckBox roundedCheckBox6 = this.B5B;
                roundedCheckBox6.outerCircleIv.setImageDrawable((Drawable)roundedCheckBox6.outerCircle);
                this.B5B.innerCircleIv = new ImageView(this.B5B.context);
                roundedCheckBox6 = layoutParams;
                RoundedCheckBox roundedCheckBox7 = this.B5B;
                int n4 = roundedCheckBox7.outerSize;
                float f2 = roundedCheckBox7.innerSize;
                new FrameLayout.LayoutParams((int)((int)((float)n4 * f2)), (int)((int)((float)n4 * f2))).gravity = 17;
                RoundedCheckBox roundedCheckBox8 = this.B5B;
                roundedCheckBox8.innerCircleIv.setImageDrawable((Drawable)roundedCheckBox8.innerCircle);
                RoundedCheckBox roundedCheckBox9 = this.B5B;
                roundedCheckBox9.addView((View)roundedCheckBox9.innerCircleIv, 0, (ViewGroup.LayoutParams)roundedCheckBox6);
                RoundedCheckBox roundedCheckBox10 = this.B5B;
                roundedCheckBox10.addView((View)roundedCheckBox10.outerCircleIv, 1, (ViewGroup.LayoutParams)roundedCheckBox5);
                if (this.B5B.isInverted) {
                    B5B.B5B(TAG, "Show inverted layout");
                    this.B5B.outerCircleIv.setVisibility(8);
                } else {
                    B5B.B5B(TAG, "Show non-inverted layout");
                    this.B5B.innerCircleIv.setVisibility(8);
                }
                roundedCheckBox5 = this.B5B;
                roundedCheckBox6 = roundedCheckBox5.layoutParams;
                if (roundedCheckBox6 != null) {
                    roundedCheckBox5.setLayoutParams((ViewGroup.LayoutParams)roundedCheckBox6);
                }
                this.B5B.invalidate();
            }
        });
        roundedCheckBox.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ RoundedCheckBox B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onClick(View v) {
                B5B.B5B(TAG, "onClick: isChecked = " + this.B5B.isChecked);
                RoundedCheckBox roundedCheckBox = this.B5B;
                if (roundedCheckBox.isChecked) {
                    roundedCheckBox.startUnCheckedAnimation();
                } else {
                    roundedCheckBox.startCheckedAnimation();
                }
                this.B5B.isChecked ^= true;
            }
        });
        this.showScaleAnimation = new ScaleAnimation(1.0f, 0.0f, 1.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.showScaleAnimation.setDuration(60L);
        roundedCheckBox.showScaleAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        roundedCheckBox.showScaleAnimation.setFillAfter(true);
        this.hideScaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        this.hideScaleAnimation.setDuration(60L);
        roundedCheckBox.hideScaleAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        roundedCheckBox.hideScaleAnimation.setFillAfter(true);
    }

    private void startUnCheckedAnimation() {
        if (this.isInverted) {
            this.outerCircleIv.setVisibility(8);
        } else {
            RoundedCheckBox roundedCheckBox = this;
            roundedCheckBox.innerCircleIv.setVisibility(8);
            roundedCheckBox.innerCircleIv.startAnimation((Animation)this.showScaleAnimation);
            RoundedCheckBox roundedCheckBox2 = this;
            int n = roundedCheckBox2.strokeWidth;
            roundedCheckBox.outerCircle.setStroke(n, roundedCheckBox2.uncheckedColor);
        }
    }

    private void startCheckedAnimation() {
        if (this.isInverted) {
            this.outerCircleIv.setVisibility(0);
        } else {
            RoundedCheckBox roundedCheckBox = this;
            roundedCheckBox.innerCircleIv.setVisibility(0);
            roundedCheckBox.innerCircleIv.startAnimation((Animation)this.hideScaleAnimation);
            RoundedCheckBox roundedCheckBox2 = this;
            int n = roundedCheckBox2.strokeWidth;
            roundedCheckBox.outerCircle.setStroke(n, roundedCheckBox2.checkedColor);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setInverted(boolean isInverted) {
        void var1_1;
        RoundedCheckBox roundedCheckBox = this;
        B5B.B5B(TAG, "setInverted " + ((Object)((Object)this)).toString());
        roundedCheckBox.isInverted = var1_1;
        roundedCheckBox.innerCircleIv.setVisibility(0);
        roundedCheckBox.outerCircleIv.setVisibility(8);
    }

    /*
     * WARNING - void declaration
     */
    public void setChecked(boolean checked) {
        void var1_1;
        B5B.B5B(TAG, "setChecked: isChecked: " + this.isChecked + ", checked: " + (boolean)var1_1);
        if (checked) {
            this.startCheckedAnimation();
        } else {
            this.startUnCheckedAnimation();
        }
        this.isChecked = var1_1;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeWidth(int width) {
        void var1_1;
        this.strokeWidth = var1_1;
        this.outerCircle.setStroke((int)var1_1, this.strokeColor);
    }

    /*
     * WARNING - void declaration
     */
    public void setStrokeColor(int color2) {
        void var1_1;
        this.strokeColor = var1_1;
        this.outerCircle.setStroke(this.strokeWidth, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerColor(int color2) {
        void var1_1;
        this.innerCircle.setColor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setInnerSizeFactor(float f) {
        void var1_2;
        this.innerSize = var1_2;
        int n = this.outerSize;
        this.innerCircle.setSize((int)((float)n * var1_2), (int)((float)n * var1_2));
    }

    /*
     * WARNING - void declaration
     */
    public void setColorChecked(int colorChecked) {
        void var1_1;
        this.checkedColor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setUncheckedColor(int uncheckedColor) {
        void var1_1;
        this.uncheckedColor = var1_1;
    }
}

