/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views.custom;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Looper;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.core.graphics.ColorUtils;
import androidx.core.graphics.drawable.DrawableCompat;
import com.calldorado.CalldoradoApplication;
import com.calldorado.android.R;
import com.calldorado.search.manual_search.CDOPhoneNumber;
import com.calldorado.search.manual_search.CDOSearchProcessListener;
import com.calldorado.stats.StatsReceiver;
import com.calldorado.translations.F2S;
import com.calldorado.ui.wic.WicLayoutBase;
import com.calldorado.util.CustomizationUtil;
import com.calldorado.util.TelephonyUtil;

public class CdoSearchView
extends FrameLayout {
    private static final String TAG = "CdoSearchView";
    private Context context;
    private WicLayoutBase.FocusListener focusListener;
    private CDOSearchProcessListener searchListener;
    private AppCompatEditText editText;
    private String lastSearchedNumber;
    private boolean isFromWic;
    Handler refresh;

    /*
     * WARNING - void declaration
     */
    public CdoSearchView(Context context) {
        super((Context)var1_1);
        void var1_1;
        this.lastSearchedNumber = "";
        this.isFromWic = true;
        this.refresh = new Handler(Looper.getMainLooper());
        this.context = var1_1;
        this.init();
    }

    /*
     * WARNING - void declaration
     */
    public CdoSearchView(Context context, AttributeSet attrs) {
        void var2_2;
        void var1_1;
        CdoSearchView cdoSearchView = this;
        super((Context)var1_1, (AttributeSet)var2_2);
        this.lastSearchedNumber = "";
        this.isFromWic = true;
        this.refresh = new Handler(Looper.getMainLooper());
        this.context = var1_1;
        cdoSearchView.initAttributeSet((Context)var1_1, (AttributeSet)var2_2);
        cdoSearchView.init();
    }

    /*
     * WARNING - void declaration
     */
    public CdoSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        void var3_3;
        void var2_2;
        void var1_1;
        CdoSearchView cdoSearchView = this;
        super((Context)var1_1, (AttributeSet)var2_2, (int)var3_3);
        this.lastSearchedNumber = "";
        this.isFromWic = true;
        this.refresh = new Handler(Looper.getMainLooper());
        this.context = var1_1;
        cdoSearchView.initAttributeSet((Context)var1_1, (AttributeSet)var2_2);
        cdoSearchView.init();
    }

    /*
     * WARNING - void declaration
     */
    private void initAttributeSet(Context context, AttributeSet attrs) {
        void var2_2;
        TypedArray typedArray = context.obtainStyledAttributes((AttributeSet)var2_2, R.styleable.CdoSearchView, 0, 0);
        try {
            this.isFromWic = typedArray.getBoolean(R.styleable.CdoSearchView_isFromWic, true);
        }
        catch (Throwable throwable) {
            typedArray.recycle();
            throw throwable;
        }
        typedArray.recycle();
    }

    private void init() {
        int n;
        CdoSearchView cdoSearchView = this;
        int n2 = n = CustomizationUtil.dpToPx(cdoSearchView.context, 16);
        new FrameLayout.LayoutParams(n2, n2).gravity = 8388629;
        n = CustomizationUtil.dpToPx(this.context, 6);
        new FrameLayout.LayoutParams(n2, n2).setMargins(0, 0, n, 0);
        cdoSearchView.editText = new AppCompatEditText(this.context);
        cdoSearchView.refresh.post(() -> {
            this.editText.setGravity(17);
            this.editText.setHint((CharSequence)F2S.B5B((Context)this.context).EyZ);
            this.editText.setTextSize(2, 12.0f);
            this.editText.setImeOptions(6);
            this.editText.setInputType(3);
            this.editText.setHorizontallyScrolling(true);
            int n = CustomizationUtil.dpToPx(this.context, 8);
            int n2 = CustomizationUtil.dpToPx(this.context, 4);
            this.editText.setPadding(0, CustomizationUtil.dpToPx(this.context, 4), n, n2);
            n = R.drawable.cdo_ic_clear_text;
            this.editText.setCompoundDrawablesWithIntrinsicBounds(0, 0, n, 0);
            if (CalldoradoApplication.ix0(this.context).Mc1().YYA().ETk()) {
                GradientDrawable gradientDrawable = (GradientDrawable)AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.cdo_round_et_background);
                gradientDrawable.setStroke(3, CalldoradoApplication.ix0(this.context).dpy().fK6());
                gradientDrawable.setColor(CalldoradoApplication.ix0(this.context).dpy().fK6(false));
                this.editText.setBackground(DrawableCompat.wrap((Drawable)gradientDrawable));
                this.editText.setTextColor(CalldoradoApplication.ix0(this.context).dpy().dpy(false));
            } else {
                GradientDrawable gradientDrawable = (GradientDrawable)AppCompatResources.getDrawable((Context)this.context, (int)R.drawable.cdo_round_et_background);
                gradientDrawable.setStroke(3, ColorUtils.setAlphaComponent((int)CalldoradoApplication.ix0(this.context).dpy().Mc1(), (int)25));
                gradientDrawable.setColor(ColorUtils.setAlphaComponent((int)CalldoradoApplication.ix0(this.context).dpy().Mc1(), (int)25));
                this.editText.setBackground(DrawableCompat.wrap((Drawable)gradientDrawable));
                this.editText.setTextColor(CalldoradoApplication.ix0(this.context).dpy().Mc1());
                this.editText.setHintTextColor(ColorUtils.setAlphaComponent((int)CalldoradoApplication.ix0(this.context).dpy().Mc1(), (int)95));
            }
        });
        cdoSearchView.editText.setOnTouchListener(new View.OnTouchListener(this){
            final /* synthetic */ CdoSearchView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean onTouch(View v, MotionEvent event) {
                void var2_2;
                if (TextUtils.isEmpty((CharSequence)this_.B5B.editText.getText().toString())) {
                    com.calldorado.log.B5B.B5B(CdoSearchView.TAG, "onTouch: Getting focus");
                    WicLayoutBase.FocusListener this_ = this_.B5B.focusListener;
                    if (this_ != null) {
                        this_.B5B();
                    }
                    return false;
                }
                if (var2_2.getAction() == 1 && !TextUtils.isEmpty((CharSequence)this_.B5B.editText.getText().toString()) && var2_2.getRawX() >= (float)(this_.B5B.getRight() - CustomizationUtil.dpToPx(this_.B5B.context, 40))) {
                    this_.B5B.refresh.post(() -> {
                        B5B b5B = this;
                        b5B.B5B.editText.setText((CharSequence)"");
                        int n = R.drawable.cdo_ic_wic_search;
                        b5B.B5B.editText.setCompoundDrawablesWithIntrinsicBounds(0, 0, n, 0);
                    });
                }
                return false;
            }
        });
        cdoSearchView.editText.setOnEditorActionListener(new TextView.OnEditorActionListener(this){
            final /* synthetic */ CdoSearchView this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    void var1_1;
                    WicLayoutBase.FocusListener focusListener = this.this$0.focusListener;
                    if (focusListener != null) {
                        focusListener.ix0();
                    }
                    ((InputMethodManager)var1_1.getContext().getSystemService("input_method")).hideSoftInputFromWindow(var1_1.getWindowToken(), 0);
                    CdoSearchView cdoSearchView = this.this$0;
                    cdoSearchView.handleSearch(cdoSearchView.editText.getText().toString());
                    return true;
                }
                return false;
            }
        });
        cdoSearchView.editText.addTextChangedListener(new TextWatcher(this){
            final /* synthetic */ CdoSearchView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Drawable drawable2;
                ix0 ix02 = this;
                com.calldorado.log.B5B.B5B(CdoSearchView.TAG, "onTextChanged: handle text changed: " + drawable2);
                CalldoradoApplication.ix0(ix02.B5B.context).Mc1().ix0().gGZ(drawable2.toString());
                CDOSearchProcessListener cDOSearchProcessListener = ix02.B5B.searchListener;
                if (cDOSearchProcessListener != null) {
                    cDOSearchProcessListener.onTextChanged(drawable2.toString());
                }
                if (drawable2.length() > 0) {
                    Handler handler;
                    drawable2 = AppCompatResources.getDrawable((Context)this.B5B.context, (int)R.drawable.cdo_ic_clear_text);
                    cDOSearchProcessListener = handler;
                    cDOSearchProcessListener(Looper.getMainLooper());
                    handler.post(() -> {
                        void var1_1;
                        this.B5B.editText.setCompoundDrawablesWithIntrinsicBounds(null, null, (Drawable)var1_1, null);
                    });
                } else if (drawable2.length() == 0) {
                    new Handler(Looper.getMainLooper()).post(() -> {
                        int n = R.drawable.cdo_ic_wic_search;
                        this.B5B.editText.setCompoundDrawablesWithIntrinsicBounds(0, 0, n, 0);
                    });
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        cdoSearchView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        cdoSearchView.addView((View)cdoSearchView.editText, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    private synchronized void handleSearch(String txt) {
        CDOSearchProcessListener cDOSearchProcessListener;
        CDOPhoneNumber cDOPhoneNumber;
        CDOSearchProcessListener cDOSearchProcessListener2;
        com.calldorado.log.B5B.B5B(TAG, "handleSearch: #1  txt = " + (String)((Object)cDOSearchProcessListener2));
        if (!this.isFromWic) {
            StatsReceiver.broadcastStats(this.context, "aftercall_search_commited", null);
        }
        if (((String)((Object)cDOSearchProcessListener2)).isEmpty()) {
            return;
        }
        if (!TelephonyUtil.isValidPhoneNumber((String)((Object)cDOSearchProcessListener2))) {
            this.refresh.post(() -> {
                CdoSearchView cdoSearchView = this;
                cdoSearchView.editText.setText((CharSequence)"");
                cdoSearchView.editText.setHint((CharSequence)"Invalid number");
            });
            return;
        }
        CdoSearchView cdoSearchView = this;
        cdoSearchView.lastSearchedNumber = cDOSearchProcessListener2;
        cdoSearchView.refresh.post(() -> this.editText.setEnabled(false));
        com.calldorado.search.manual_search.B5B.B5B(cdoSearchView.context).ix0(false);
        CDOPhoneNumber cDOPhoneNumber2 = cDOPhoneNumber;
        cDOPhoneNumber = new CDOPhoneNumber((String)((Object)cDOSearchProcessListener2));
        cDOSearchProcessListener2 = cDOSearchProcessListener;
        cDOSearchProcessListener = new CDOSearchProcessListener(this){
            final /* synthetic */ CdoSearchView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            @Override
            public void onSearchSent() {
                CDOSearchProcessListener cDOSearchProcessListener = this.B5B.searchListener;
                if (cDOSearchProcessListener != null) {
                    cDOSearchProcessListener.onSearchSent();
                }
                esR esR2 = this;
                esR2.B5B.refresh.post(() -> {
                    esR esR2 = this_;
                    Object this_ = esR2.B5B;
                    ((CdoSearchView)((Object)((Object)this_))).editText.setText((CharSequence)F2S.B5B((Context)((CdoSearchView)((Object)((Object)this_))).context).Iga);
                    esR2.B5B.editText.setCompoundDrawablesWithIntrinsicBounds(0, 0, 0, 0);
                });
                esR2.B5B.sendSearchStat();
                com.calldorado.log.B5B.esR(CdoSearchView.TAG, "onSearchSent()");
                if (CalldoradoApplication.ix0(esR2.B5B.context).ETk().H1u() != 2 && CalldoradoApplication.ix0(this.B5B.context).ETk().H1u() != 1) {
                    StatsReceiver.broadCastAfterCallClickEvent(this.B5B.context, "aftercall_click_searchongoogle");
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onSearchSuccess(boolean searchFromWIc) {
                esR esR2 = this;
                esR2.B5B.sendSearchStat();
                com.calldorado.log.B5B.esR(CdoSearchView.TAG, "onSearchSuccess()");
                CDOSearchProcessListener cDOSearchProcessListener = esR2.B5B.searchListener;
                if (cDOSearchProcessListener != null) {
                    void var1_1;
                    cDOSearchProcessListener.onSearchSuccess((boolean)var1_1);
                }
                this.B5B.refresh.post(() -> {
                    esR esR2 = this;
                    CdoSearchView cdoSearchView = esR2.B5B;
                    cdoSearchView.setText(cdoSearchView.lastSearchedNumber);
                    esR2.B5B.editText.setEnabled(true);
                });
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onSearchFailed(String errorMessage) {
                void var1_1;
                if (errorMessage == "ERROR_SEARCH_LIMIT_PER_MINUTE_REACHED") {
                    Context context = this.B5B.context;
                    Toast.makeText((Context)context, (CharSequence)F2S.B5B((Context)context).Qva, (int)1).show();
                }
                com.calldorado.log.B5B.esR(CdoSearchView.TAG, "onSearchFailed() " + (String)var1_1);
                CDOSearchProcessListener cDOSearchProcessListener = this.B5B.searchListener;
                if (cDOSearchProcessListener != null) {
                    cDOSearchProcessListener.onSearchFailed((String)var1_1);
                }
                this.B5B.refresh.post(() -> {
                    esR esR2 = this;
                    CdoSearchView cdoSearchView = esR2.B5B;
                    cdoSearchView.setText(cdoSearchView.lastSearchedNumber);
                    esR2.B5B.editText.setEnabled(true);
                });
            }

            @Override
            public void onTextChanged(String s) {
            }
        };
        boolean bl = this.isFromWic;
        com.calldorado.B5B.B5B(cdoSearchView.context, cDOPhoneNumber2, cDOSearchProcessListener2, bl);
    }

    private void sendSearchStat() {
        if (CalldoradoApplication.ix0(this.context).ETk().H1u() == 1) {
            StatsReceiver.broadCastWicClickEvent(this.context, "wic_a_search_during_ring");
        } else {
            StatsReceiver.broadCastWicClickEvent(this.context, "wic_a_search_during_call");
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        void var1_1;
        WicLayoutBase.FocusListener focusListener;
        if (event.getKeyCode() == 4 && (focusListener = this.focusListener) != null) {
            focusListener.ix0();
        }
        return super.dispatchKeyEventPreIme((KeyEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setText(String s) {
        void var1_1;
        this.editText.setText((CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSearchListener(CDOSearchProcessListener searchListener) {
        void var1_1;
        this.searchListener = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setFocusListener(WicLayoutBase.FocusListener focusListener) {
        void var1_1;
        this.focusListener = var1_1;
    }
}

