/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.views.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.method.ScrollingMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import com.calldorado.CalldoradoApplication;
import com.calldorado.android.R;

public class ReadMoreTextView
extends AppCompatTextView {
    private static final String TAG = "ReadMoreTextView";
    private static final int TRIM_MODE_LINES = 0;
    private static final int TRIM_MODE_LENGTH = 1;
    private static final int DEFAULT_TRIM_LENGTH = 240;
    private static final int DEFAULT_TRIM_LINES = 2;
    private static final int INVALID_END_INDEX = -1;
    private static final boolean DEFAULT_SHOW_TRIM_EXPANDED_TEXT = true;
    private static final String ELLIPSIZE = "... ";
    private CharSequence text;
    private TextView.BufferType bufferType;
    private int trimLength;
    private CharSequence trimExpandedText;
    private ReadMoreClickableSpan viewMoreSpan;
    private int colorClickableText;
    private boolean showTrimExpandedText;
    private int trimMode;
    private int lineEndIndex;
    private int trimLines;

    /*
     * WARNING - void declaration
     */
    public ReadMoreTextView(Context context) {
        this((Context)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ReadMoreTextView(Context context, AttributeSet attrs) {
        TypedArray typedArray;
        void var1_1;
        ReadMoreTextView readMoreTextView = this;
        super((Context)var1_1, (AttributeSet)typedArray);
        this.trimMode = 0;
        typedArray = var1_1.obtainStyledAttributes((AttributeSet)typedArray, R.styleable.ReadMoreTextView);
        ReadMoreTextView readMoreTextView2 = this;
        readMoreTextView2.trimLength = typedArray.getInt(R.styleable.ReadMoreTextView_trimLength, 240);
        readMoreTextView2.trimExpandedText = "READ MORE";
        this.trimLines = typedArray.getInt(R.styleable.ReadMoreTextView_trimLines, 2);
        this.colorClickableText = typedArray.getColor(R.styleable.ReadMoreTextView_colorClickableText, CalldoradoApplication.ix0((Context)var1_1).dpy().esR((Context)var1_1));
        this.showTrimExpandedText = typedArray.getBoolean(R.styleable.ReadMoreTextView_showTrimExpandedText, true);
        this.trimMode = typedArray.getInt(R.styleable.ReadMoreTextView_trimMode, 0);
        typedArray.recycle();
        readMoreTextView.setLinksClickable(false);
        readMoreTextView.setOnClickListener(view -> com.calldorado.log.B5B.B5B(TAG, "onClick: 2"));
        readMoreTextView.viewMoreSpan = new ReadMoreClickableSpan();
        readMoreTextView.onGlobalLayoutLineEndIndex();
        readMoreTextView.setText();
    }

    private void setText() {
        ReadMoreTextView readMoreTextView = this_;
        Object this_ = readMoreTextView.getDisplayableText();
        super.setText((CharSequence)this_, readMoreTextView.bufferType);
        readMoreTextView.setMovementMethod(ScrollingMovementMethod.getInstance());
        readMoreTextView.setHighlightColor(0);
        readMoreTextView.invalidate();
    }

    private CharSequence getDisplayableText() {
        ReadMoreTextView readMoreTextView = this;
        return readMoreTextView.getTrimmedText(readMoreTextView.text);
    }

    /*
     * WARNING - void declaration
     */
    private CharSequence getTrimmedText(CharSequence text) {
        void var1_1;
        if (this.trimMode == 1 && var1_1 != null && var1_1.length() > this.trimLength) {
            return this.updateCollapsedText();
        }
        if (this.trimMode == 0 && var1_1 != null && this.lineEndIndex > 0 && this.getLayout().getLineCount() > this.trimLines) {
            return this.updateCollapsedText();
        }
        return var1_1;
    }

    private CharSequence updateCollapsedText() {
        ReadMoreTextView readMoreTextView = this_;
        int n = readMoreTextView.text.length();
        int n2 = readMoreTextView.trimMode;
        if (n2 != 0) {
            if (n2 == 1) {
                n = this_.trimLength + 1;
            }
        } else {
            n = this_.lineEndIndex - (this_.trimExpandedText.length() + 5) - 20;
            if (n < 0) {
                n = this_.trimLength + 1;
            }
        }
        ReadMoreTextView readMoreTextView2 = this_;
        ReadMoreTextView this_ = new SpannableStringBuilder(this_.text, 0, n).append((CharSequence)ELLIPSIZE).append(this_.trimExpandedText);
        return readMoreTextView2.addClickableSpan((SpannableStringBuilder)this_, readMoreTextView2.trimExpandedText);
    }

    /*
     * WARNING - void declaration
     */
    private CharSequence addClickableSpan(SpannableStringBuilder s, CharSequence trimText) {
        void var2_3;
        SpannableStringBuilder spannableStringBuilder = s;
        Object object = object.viewMoreSpan;
        int n = spannableStringBuilder.length() - var2_3.length();
        int n2 = spannableStringBuilder.length();
        spannableStringBuilder.setSpan(object, n, n2, 33);
        return spannableStringBuilder;
    }

    private void onGlobalLayoutLineEndIndex() {
        if (this.trimMode == 0) {
            this.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(this){
                final /* synthetic */ ReadMoreTextView B5B;
                {
                    void var1_1;
                    this.B5B = var1_1;
                }

                public void onGlobalLayout() {
                    ViewTreeObserver viewTreeObserver = this.B5B.getViewTreeObserver();
                    if (Build.VERSION.SDK_INT >= 16) {
                        viewTreeObserver.removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    B5B b5B = this;
                    b5B.B5B.refreshLineEndIndex();
                    b5B.B5B.setText();
                }
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void refreshLineEndIndex() {
        Exception exception2;
        block6: {
            try {
                int n = this.trimLines;
                if (n == 0) {
                    this.lineEndIndex = this.getLayout().getLineEnd(0);
                    return;
                }
                if (n > 0 && this.getLineCount() >= this.trimLines) {
                    this.lineEndIndex = this.getLayout().getLineEnd(this.trimLines - 1);
                    return;
                }
            }
            catch (Exception exception2) {
                break block6;
            }
            this.lineEndIndex = -1;
            return;
        }
        exception2.printStackTrace();
    }

    /*
     * WARNING - void declaration
     */
    public void setText(CharSequence text, TextView.BufferType type) {
        void var2_2;
        void var1_1;
        this.text = var1_1;
        this.bufferType = var2_2;
        this.setText();
    }

    /*
     * WARNING - void declaration
     */
    public void setTrimLength(int trimLength) {
        void var1_1;
        this.trimLength = var1_1;
        this.setText();
    }

    /*
     * WARNING - void declaration
     */
    public void setColorClickableText(int colorClickableText) {
        void var1_1;
        this.colorClickableText = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrimCollapsedText(CharSequence trimCollapsedText) {
        void var1_1;
        this.trimExpandedText = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrimExpandedText(CharSequence trimExpandedText) {
        void var1_1;
        this.trimExpandedText = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrimMode(int trimMode) {
        void var1_1;
        this.trimMode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setTrimLines(int trimLines) {
        void var1_1;
        this.trimLines = var1_1;
    }

    private class ReadMoreClickableSpan
    extends ClickableSpan {
        private ReadMoreClickableSpan() {
        }

        public void onClick(View widget) {
            com.calldorado.log.B5B.B5B(ReadMoreTextView.TAG, "onClick: ");
        }

        public void updateDrawState(TextPaint ds) {
            ds.setColor(ReadMoreTextView.this.colorClickableText);
        }
    }
}

