/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.ui.wic.dancing_dots;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableString;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatTextView;
import com.calldorado.ui.wic.dancing_dots.JumpingSpan;

public class DotsTextView
extends AppCompatTextView {
    private JumpingSpan dotOne;
    private JumpingSpan dotTwo;
    private JumpingSpan dotThree;
    private int showSpeed;
    private int jumpHeight;
    private boolean autoPlay;
    private boolean isPlaying;
    private boolean isHide;
    private int period;
    private long startTime;
    private boolean lockDotOne;
    private boolean lockDotTwo;
    private boolean lockDotThree;
    private Handler handler;
    private AnimatorSet mAnimatorSet;
    private float textWidth;

    /*
     * WARNING - void declaration
     */
    public DotsTextView(Context context) {
        AnimatorSet animatorSet;
        void var1_1;
        DotsTextView dotsTextView = this_;
        super((Context)var1_1);
        dotsTextView.showSpeed = 700;
        DotsTextView this_ = animatorSet;
        animatorSet = new AnimatorSet();
        dotsTextView.mAnimatorSet = this_;
        dotsTextView.init();
    }

    private void init() {
        SpannableString spannableString;
        JumpingSpan jumpingSpan;
        JumpingSpan jumpingSpan2;
        JumpingSpan jumpingSpan3;
        Handler handler;
        Object object = handler;
        handler = new Handler(Looper.getMainLooper());
        this.handler = object;
        this.period = 1000;
        this.jumpHeight = (int)(this.getTextSize() / 4.0f);
        this.autoPlay = true;
        object = jumpingSpan3;
        jumpingSpan3 = new JumpingSpan();
        this.dotOne = object;
        object = jumpingSpan2;
        jumpingSpan2 = new JumpingSpan();
        this.dotTwo = object;
        object = jumpingSpan;
        jumpingSpan = new JumpingSpan();
        this.dotThree = object;
        object = spannableString;
        new SpannableString((CharSequence)"...").setSpan((Object)this.dotOne, 0, 1, 33);
        object.setSpan((Object)this.dotTwo, 1, 2, 33);
        object.setSpan((Object)this.dotThree, 2, 3, 33);
        TextView.BufferType bufferType = TextView.BufferType.SPANNABLE;
        this.setText((CharSequence)object, bufferType);
        this.textWidth = this.getPaint().measureText(".", 0, 1);
        object = this.createDotJumpAnimator(this.dotOne, 0L);
        object.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ DotsTextView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                this.B5B.invalidate();
            }
        });
        Animator[] animatorArray = new Animator[3];
        animatorArray[0] = object;
        long l = this.period / 6;
        animatorArray[1] = this.createDotJumpAnimator(this.dotTwo, l);
        l = this.period * 2 / 6;
        animatorArray[2] = this.createDotJumpAnimator(this.dotThree, l);
        this.mAnimatorSet.playTogether(animatorArray);
        this.isPlaying = this.autoPlay;
        if (this.isPlaying) {
            this.start();
        }
    }

    /*
     * WARNING - void declaration
     */
    private ObjectAnimator createDotJumpAnimator(JumpingSpan jumpingSpan, long delay) {
        void var2_4;
        float f = -this.jumpHeight;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = 0.0f;
        fArray[1] = f;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)jumpingSpan), (String)"translationY", (float[])fArray2);
        objectAnimator.setEvaluator(new TypeEvaluator(this){
            final /* synthetic */ DotsTextView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public Number B5B(float fraction, Number from, Number to) {
                void var2_3;
                void var3_4;
                double d = Math.sin((double)fraction * Math.PI * 2.0);
                return Math.max(0.0, d) * (double)(var3_4.floatValue() - var2_3.floatValue());
            }
        });
        objectAnimator.setDuration((long)this.period);
        objectAnimator.setStartDelay((long)var2_4);
        objectAnimator.setRepeatCount(-1);
        objectAnimator.setRepeatMode(1);
        return objectAnimator;
    }

    /*
     * WARNING - void declaration
     */
    private void setAllAnimationsRepeatCount(int repeatCount) {
        for (Animator animator : ((DotsTextView)((Object)this)).mAnimatorSet.getChildAnimations()) {
            void var1_1;
            if (!(animator instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animator).setRepeatCount((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ObjectAnimator createDotHideAnimator(JumpingSpan span, float widthMultiplier) {
        void var2_2;
        void var1_1;
        return this.createDotHorizontalAnimator((JumpingSpan)var1_1, 0.0f, -this.textWidth * var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ObjectAnimator createDotShowAnimator(JumpingSpan span, int widthMultiplier) {
        void var2_2;
        void var1_1;
        return this.createDotHorizontalAnimator((JumpingSpan)var1_1, -this.textWidth * (float)var2_2, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    private ObjectAnimator createDotHorizontalAnimator(JumpingSpan span, float from, float to) {
        void var3_3;
        void var2_2;
        float[] fArray = new float[2];
        float[] fArray2 = fArray;
        fArray[0] = var2_2;
        fArray[1] = var3_3;
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)((Object)span), (String)"translationX", (float[])fArray2);
        objectAnimator.setDuration((long)this.showSpeed);
        return objectAnimator;
    }

    public void start() {
        DotsTextView dotsTextView = this;
        dotsTextView.isPlaying = true;
        dotsTextView.setAllAnimationsRepeatCount(-1);
        dotsTextView.mAnimatorSet.start();
    }

    public void stop() {
        this.isPlaying = false;
        this.setAllAnimationsRepeatCount(0);
    }

    public void hide() {
        DotsTextView dotsTextView = this;
        dotsTextView.createDotHideAnimator(dotsTextView.dotThree, 2.0f).start();
        ObjectAnimator objectAnimator = dotsTextView.createDotHideAnimator(dotsTextView.dotTwo, 1.0f);
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ DotsTextView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                this.B5B.invalidate();
            }
        });
        objectAnimator.start();
        dotsTextView.isHide = true;
    }

    public void show() {
        DotsTextView dotsTextView = this;
        dotsTextView.createDotShowAnimator(dotsTextView.dotThree, 2).start();
        ObjectAnimator objectAnimator = dotsTextView.createDotShowAnimator(dotsTextView.dotTwo, 1);
        objectAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ DotsTextView B5B;
            {
                void var1_1;
                this.B5B = var1_1;
            }

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                this.B5B.invalidate();
            }
        });
        objectAnimator.start();
        dotsTextView.isHide = false;
    }

    public void showAndPlay() {
        DotsTextView dotsTextView = this;
        dotsTextView.show();
        dotsTextView.start();
    }

    public void hideAndStop() {
        DotsTextView dotsTextView = this;
        dotsTextView.hide();
        dotsTextView.stop();
    }

    public boolean isHide() {
        return this.isHide;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    /*
     * WARNING - void declaration
     */
    public void setJumpHeight(int jumpHeight) {
        void var1_1;
        this.jumpHeight = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPeriod(int period) {
        void var1_1;
        this.period = var1_1;
    }
}

