/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.os.AsyncTask;
import android.os.Build;
import androidx.annotation.NonNull;
import com.calldorado.CalldoradoApplication;
import com.calldorado.log.B5B;
import com.calldorado.tasks.ExponentialPollTask;
import com.calldorado.ui.debug_dialog_items.interfaces.NetworkCallbacks;
import com.calldorado.ui.debug_dialog_items.ix0;
import com.calldorado.ui.debug_dialog_items.model.NetworkModel;
import com.calldorado.ui.debug_dialog_items.model.NetworkModelList;
import com.calldorado.util.GenericCompletedListener;
import com.calldorado.util.NetworkUtil;
import java.util.AbstractCollection;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CdoNetworkManager
implements GenericCompletedListener {
    private static final String TAG = "CdoNetworkManager";
    private static CdoNetworkManager instance;
    private Context context;
    private CdoNetworkListener cdoNetworkListener;
    private boolean isDefaultNetworkCallbackSet = false;
    private CalldoradoApplication calldoradoApplication;
    private NetworkModelList networkModelsList;
    private NetworkCallbacks networkCallbacks;
    private ExponentialPollTask exponentialPollTask;
    private ConnectivityManager.NetworkCallback networkCallback;

    /*
     * WARNING - void declaration
     */
    private CdoNetworkManager(@NonNull Context context, @NonNull CdoNetworkListener cdoNetworkListener) {
        void var2_2;
        void var1_1;
        this.context = var1_1;
        this.cdoNetworkListener = var2_2;
        this.calldoradoApplication = CalldoradoApplication.ix0((Context)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CdoNetworkManager getInstance(@NonNull Context context, @NonNull CdoNetworkListener cdoNetworkListener) {
        if (instance != null) return instance;
        Class<CdoNetworkManager> clazz = CdoNetworkManager.class;
        synchronized (CdoNetworkManager.class) {
            try {
                void var1_1;
                Context context2;
                if (instance != null) return instance;
                instance = new CdoNetworkManager(context2, (CdoNetworkListener)var1_1);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return instance;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    private void startExponentialPollingTask() {
        ExponentialPollTask exponentialPollTask = this.exponentialPollTask;
        if (exponentialPollTask != null) {
            exponentialPollTask.cancel(true);
        }
        this.exponentialPollTask = new ExponentialPollTask(this.context, this);
        this.exponentialPollTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
    }

    /*
     * WARNING - void declaration
     */
    private void save(NetworkModel networkModel) {
        void var1_1;
        if (this.networkModelsList == null) {
            this.readNetworkItemsStored();
        }
        CdoNetworkManager cdoNetworkManager = this;
        ((AbstractCollection)cdoNetworkManager.networkModelsList).add(var1_1);
        ix0.B5B(cdoNetworkManager.context, this.networkModelsList);
    }

    private boolean isAnyNetworkThreadRunning() {
        Object this_ = this_.exponentialPollTask;
        return this_ != null && this_.getStatus() == AsyncTask.Status.RUNNING;
    }

    private boolean shouldUseNetworkCallback() {
        return Build.VERSION.SDK_INT >= 26;
    }

    public void setupNetworkListener() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.networkCallback = new ConnectivityManager.NetworkCallback(this){
                final /* synthetic */ CdoNetworkManager this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                public void onAvailable(@NotNull Network network) {
                    Object object;
                    1 v0 = this;
                    super.onAvailable((Network)object);
                    B5B.esR(TAG, "onAvailable network info = " + object.toString());
                    if (v0.this$0.calldoradoApplication.Mc1().xfp().hFU()) {
                        NetworkModel networkModel;
                        1 v1 = this;
                        object = NetworkUtil.getAllNetworkDetails(this.this$0.context) + " Speed:" + NetworkUtil.getDownStreamBandwidthInKbps(this.this$0.context) + "Kbps";
                        Object object2 = networkModel;
                        long l = System.currentTimeMillis();
                        networkModel = new NetworkModel(UUID.randomUUID().toString(), "onAvailable", (String)object, null, l);
                        v1.this$0.save((NetworkModel)object2);
                        object = v1.this$0;
                        object2 = ((CdoNetworkManager)object).networkCallbacks;
                        if (object2 != null) {
                            object2.B5B("onAvailable", ((CdoNetworkManager)object).networkModelsList);
                        }
                    }
                    1 v3 = this;
                    v3.this$0.cdoNetworkListener.onNetworkAvailable();
                    v3.this$0.unregisterNetworkListener();
                }

                /*
                 * WARNING - void declaration
                 */
                public void onLosing(@NotNull Network network, int maxMsToLive) {
                    void var2_2;
                    void var1_1;
                    super.onLosing((Network)var1_1, (int)var2_2);
                }

                public void onLost(@NotNull Network network) {
                    Object object;
                    1 v0 = this_;
                    super.onLost((Network)object);
                    B5B.esR(TAG, "onLost network info = " + object.toString());
                    if (v0.this$0.calldoradoApplication.Mc1().xfp().hFU()) {
                        NetworkModel networkModel;
                        1 v1 = this_;
                        Object this_ = NetworkUtil.getAllNetworkDetails(this_.this$0.context) + " Speed:" + NetworkUtil.getDownStreamBandwidthInKbps(this_.this$0.context) + "Kbps";
                        object = networkModel;
                        long l = System.currentTimeMillis();
                        networkModel = new NetworkModel(UUID.randomUUID().toString(), "onLost", (String)this_, null, l);
                        v1.this$0.save((NetworkModel)object);
                        this_ = v1.this$0;
                        object = ((CdoNetworkManager)this_).networkCallbacks;
                        if (object != null) {
                            object.B5B("onLost", ((CdoNetworkManager)this_).networkModelsList);
                        }
                    }
                }

                public void onUnavailable() {
                    1 v0 = this_;
                    super.onUnavailable();
                    B5B.esR(TAG, "onUnavailable");
                    if (v0.this$0.calldoradoApplication.Mc1().xfp().hFU()) {
                        NetworkModel networkModel;
                        1 v1 = this_;
                        Object this_ = NetworkUtil.getAllNetworkDetails(this_.this$0.context) + " Speed:" + NetworkUtil.getDownStreamBandwidthInKbps(this_.this$0.context) + "Kbps";
                        Object object = networkModel;
                        long l = System.currentTimeMillis();
                        networkModel = new NetworkModel(UUID.randomUUID().toString(), "onUnavailable", (String)this_, null, l);
                        v1.this$0.save((NetworkModel)object);
                        this_ = v1.this$0;
                        object = ((CdoNetworkManager)this_).networkCallbacks;
                        if (object != null) {
                            object.B5B("onUnavailable", ((CdoNetworkManager)this_).networkModelsList);
                        }
                    }
                }

                /*
                 * WARNING - void declaration
                 */
                public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                    void var2_2;
                    void var1_1;
                    super.onCapabilitiesChanged((Network)var1_1, (NetworkCapabilities)var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                public void onLinkPropertiesChanged(@NotNull Network network, @NotNull LinkProperties linkProperties) {
                    void var2_2;
                    void var1_1;
                    super.onLinkPropertiesChanged((Network)var1_1, (LinkProperties)var2_2);
                }
            };
            if (!this.isDefaultNetworkCallbackSet) {
                if (this.context.getSystemService("connectivity") != null) {
                    CdoNetworkManager cdoNetworkManager = this;
                    ConnectivityManager connectivityManager = (ConnectivityManager)cdoNetworkManager.context.getSystemService("connectivity");
                    if (cdoNetworkManager.shouldUseNetworkCallback() && connectivityManager != null) {
                        this.isDefaultNetworkCallbackSet = true;
                        connectivityManager.registerDefaultNetworkCallback(this.networkCallback);
                    } else {
                        B5B.B5B(TAG, "setupNetworkListener: Starting polling thread!");
                        this.startExponentialPollingTask();
                    }
                } else {
                    B5B.B5B(TAG, "Context null");
                }
            }
        }
        B5B.B5B(TAG, "isDefaultNetworkCallbackSet = " + this.isDefaultNetworkCallbackSet);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterNetworkListener() {
        Throwable throwable2;
        block10: {
            CdoNetworkManager cdoNetworkManager = this;
            B5B.B5B(TAG, "unregistering network listener ");
            try {
                block9: {
                    try {
                        Object object = (ConnectivityManager)cdoNetworkManager.context.getSystemService("connectivity");
                        if (cdoNetworkManager.shouldUseNetworkCallback()) {
                            if (object != null) {
                                object.unregisterNetworkCallback(this.networkCallback);
                            }
                            break block9;
                        }
                        object = this.exponentialPollTask;
                        if (object == null) break block9;
                        object.cancel(true);
                    }
                    catch (Throwable throwable2) {
                        break block10;
                    }
                }
                this.isDefaultNetworkCallbackSet = false;
                return;
            }
            catch (Exception exception) {}
            {
                B5B.ix0(TAG, "network listener was not initialized");
                this.isDefaultNetworkCallbackSet = false;
            }
            return;
        }
        this.isDefaultNetworkCallbackSet = false;
        throw throwable2;
    }

    public void readNetworkItemsStored() {
        this.networkModelsList = ix0.B5B(this.context);
    }

    /*
     * WARNING - void declaration
     */
    public void setNetworkCallbacks(NetworkCallbacks networkCallbacks) {
        void var1_1;
        this.networkCallbacks = var1_1;
    }

    public NetworkModelList getNetworkModelsList() {
        NetworkModelList networkModelList = this.networkModelsList;
        if (networkModelList == null || ((AbstractCollection)networkModelList).isEmpty()) {
            this.readNetworkItemsStored();
        }
        return this.networkModelsList;
    }

    public void onComplete(Object isNetworkConnected) {
        if (((Boolean)isNetworkConnected).booleanValue()) {
            B5B.esR(TAG, "Network restored!");
            ExponentialPollTask exponentialPollTask = this.exponentialPollTask;
            if (exponentialPollTask != null) {
                try {
                    exponentialPollTask.cancel(true);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.cdoNetworkListener.onNetworkAvailable();
        }
    }

    public static interface CdoNetworkListener {
        public void onNetworkAvailable();
    }
}

