/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ActivityManager;
import android.bluetooth.BluetoothManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Point;
import android.location.LocationManager;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import com.calldorado.log.B5B;
import com.calldorado.permissions.esR;
import com.calldorado.util.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.TypeCastException;

public class DeviceUtil {
    private static String UNDEFINED = "undefined";
    private static String UNAVAILABLE = "unavailable";
    public static TelephonyManager telephonyManager;
    public static LocationManager locationManager;
    public static Debug.MemoryInfo debugMemory;
    public static Configuration configManager;
    public static PackageManager packageManager;
    private static ActivityManager.MemoryInfo memoryManager;
    private static BluetoothManager bluetoothManager;
    private static WifiManager wifiManager;
    public static Intent batteryStatus;
    private static Context context;
    private static final List DEVICE_MANUFACTURER_EXCEPTIONS_LIST;
    private static final Set<String> DEVICE_MANUFACTURER_EXCEPTIONS_SET;

    @SuppressLint(value={"NewApi"})
    public static void init(Context _context) {
        IntentFilter intentFilter;
        debugMemory = new Debug.MemoryInfo();
        Debug.getMemoryInfo((Debug.MemoryInfo)debugMemory);
        context = _context;
        memoryManager = new ActivityManager.MemoryInfo();
        ((ActivityManager)context.getSystemService("activity")).getMemoryInfo(memoryManager);
        Context context = intentFilter;
        intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        batteryStatus = DeviceUtil.context.registerReceiver(null, (IntentFilter)context);
        configManager = DeviceUtil.context.getResources().getConfiguration();
        packageManager = DeviceUtil.context.getPackageManager();
        if (esR.esR(DeviceUtil.context, "android.permission.READ_PHONE_STATE")) {
            telephonyManager = (TelephonyManager)DeviceUtil.context.getSystemService("phone");
        }
        if (esR.esR(DeviceUtil.context, "android.permission.ACCESS_WIFI_STATE")) {
            wifiManager = (WifiManager)DeviceUtil.context.getSystemService("wifi");
        }
        if (esR.esR(DeviceUtil.context, "android.permission.ACCESS_COARSE_LOCATION")) {
            locationManager = (LocationManager)DeviceUtil.context.getSystemService("location");
        }
        if (esR.esR(DeviceUtil.context, "android.permission.BLUETOOTH")) {
            bluetoothManager = (BluetoothManager)DeviceUtil.context.getSystemService("bluetooth");
        }
    }

    public static String getPackageName(ApplicationInfo appInfo) {
        String string2;
        string2 = packageManager.getInstallerPackageName(((ApplicationInfo)string2).packageName);
        if ((appInfo.flags & 1) != 0) {
            return "System";
        }
        if (string2 == null) {
            return "Side Load";
        }
        if (string2.equals("com.android.vending")) {
            return "Google Play Store";
        }
        if (string2.equals("com.amazon.venezia")) {
            return "Amazon App Store";
        }
        if (string2.equals("com.sec.android.app.samsungapps")) {
            return "Samsung App Store";
        }
        return UNAVAILABLE;
    }

    public static String getAppName(Context context) {
        Context context2;
        PackageManager packageManager = context.getPackageManager();
        Context context3 = context2;
        context2 = null;
        String string2 = "Unknown";
        try {
            context2 = packageManager.getApplicationInfo(context3.getApplicationInfo().packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        if (context2 != null) {
            string2 = (String)packageManager.getApplicationLabel((ApplicationInfo)context2);
        }
        return string2;
    }

    public static String getBatteryLevel() {
        String string2 = String.valueOf(batteryStatus.getIntExtra("level", -1));
        return string2.equals("-1") ? UNDEFINED : string2 + " %";
    }

    public static String isBatteryPresent() {
        return batteryStatus.getBooleanExtra("present", true) ? "YES" : "NO";
    }

    public static String getBatteryTechnology() {
        return batteryStatus.getExtras().getString("technology");
    }

    public static String getBatteryTemperature() {
        String string2 = String.valueOf(batteryStatus.getIntExtra("temperature", -1) / 10);
        return string2.equals("-1") ? UNDEFINED : string2 + " C";
    }

    public static String getBatteryVoltage() {
        String string2 = String.valueOf(batteryStatus.getIntExtra("voltage", -1));
        return string2.equals("-1") ? UNDEFINED : string2 + " mV";
    }

    public static String getBatteryHealthState() {
        switch (batteryStatus.getIntExtra("health", -1)) {
            default: {
                return UNDEFINED;
            }
            case 7: {
                return "COLD";
            }
            case 6: {
                return "FAILURE";
            }
            case 5: {
                return "OVER VOLTAGE";
            }
            case 4: {
                return "DEAD";
            }
            case 3: {
                return "OVERHEAT";
            }
            case 2: {
                return "GOOD";
            }
            case 1: 
        }
        return "UNKNOWN";
    }

    public static String getBatteryPlugSource() {
        int n = batteryStatus.getIntExtra("plugged", -1);
        if (n != 1) {
            if (n != 2) {
                if (n != 4) {
                    return UNDEFINED;
                }
                return "WIRELESS";
            }
            return "HSB PORT";
        }
        return "AC CHARGER";
    }

    public static String getBatteryStatus() {
        switch (batteryStatus.getIntExtra("status", -1)) {
            default: {
                return UNDEFINED;
            }
            case 5: {
                return "FULL";
            }
            case 4: {
                return "NOT CHARGING";
            }
            case 3: {
                return "DISCHARGING";
            }
            case 2: {
                return "CHARGING";
            }
            case 1: 
        }
        return "UNKNOWN";
    }

    public static String getDataActivity() {
        switch (telephonyManager.getDataActivity()) {
            default: {
                return UNDEFINED;
            }
            case 4: {
                return "DORMANT";
            }
            case 3: {
                return "IN OUT";
            }
            case 2: {
                return "OUT";
            }
            case 1: {
                return "IN";
            }
            case 0: 
        }
        return "NONE";
    }

    public static String getSimState() {
        switch (telephonyManager.getSimState()) {
            default: {
                return UNDEFINED;
            }
            case 5: {
                return "READY";
            }
            case 4: {
                return "LOCKED";
            }
            case 3: {
                return "PUK REQUIRED";
            }
            case 2: {
                return "PIN REQUIRED";
            }
            case 1: {
                return "ABSENT";
            }
            case 0: 
        }
        return "UNKNOW";
    }

    public static String getDataState() {
        switch (telephonyManager.getDataState()) {
            default: {
                return UNDEFINED;
            }
            case 3: {
                return "SUSPENDED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 0: 
        }
        return "DESCONNECTED";
    }

    public static String getPhoneType() {
        switch (telephonyManager.getPhoneType()) {
            default: {
                return UNDEFINED;
            }
            case 3: {
                return "SIP";
            }
            case 2: {
                return "CDMA";
            }
            case 1: {
                return "GSM";
            }
            case 0: 
        }
        return "NONE";
    }

    public static String getNetworkClass(Context context) {
        Context context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (context2 != null && context2.isConnected()) {
            if (context2.getType() == 1) {
                return "WIFI";
            }
            if (context2.getType() == 0) {
                switch (context2.getSubtype()) {
                    default: {
                        return "?";
                    }
                    case 20: {
                        return "5G";
                    }
                    case 13: 
                    case 18: 
                    case 19: {
                        return "4G";
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return "3G";
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: 
                }
                return "2G";
            }
            return "?";
        }
        return "-";
    }

    public static String getCallState() {
        int n = telephonyManager.getCallState();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return UNDEFINED;
                }
                return "OFFHOOK";
            }
            return "RINGING";
        }
        return "IDLE";
    }

    public static String isNetworkRoaming() {
        if (telephonyManager.isNetworkRoaming()) {
            return "YES";
        }
        return "NO";
    }

    public static String isVoiceCapable() {
        if (Build.VERSION.SDK_INT >= 22) {
            if (telephonyManager.isVoiceCapable()) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String isSmsCapable() {
        if (Build.VERSION.SDK_INT >= 22) {
            if (telephonyManager.isSmsCapable()) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String isWorldPhone() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (telephonyManager.isWorldPhone()) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String isTtyModeSupported() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (telephonyManager.isTtyModeSupported()) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String getPhoneCount() {
        if (Build.VERSION.SDK_INT >= 23) {
            return String.valueOf(telephonyManager.getPhoneCount());
        }
        return UNAVAILABLE;
    }

    public static String getRingerMode() {
        int n = ((AudioManager)context.getSystemService("audio")).getRingerMode();
        if (n != 0) {
            if (n != 1) {
                if (n != 2) {
                    return UNDEFINED;
                }
                return "NORMAL";
            }
            return "VIBRATE";
        }
        return "SILENT";
    }

    @SuppressLint(value={"NewApi", "MissingPermission"})
    public static String getBluetoothState() {
        BluetoothManager bluetoothManager = DeviceUtil.bluetoothManager;
        if (bluetoothManager != null) {
            if (bluetoothManager.getAdapter().isEnabled()) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String getUiMode(int option) {
        int n;
        int n2 = option & 0x30;
        n &= 0xF;
        String string2 = "";
        if (n2 != 0) {
            if (n2 != 16) {
                if (n2 == 32) {
                    string2 = string2 + "NIGHT YES, ";
                }
            } else {
                string2 = string2 + "NIGHT NO, ";
            }
        } else {
            string2 = string2 + "NIGHT UNDEFINED, ";
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                string2 = string2 + "TYPE WATCH";
                break;
            }
            case 5: {
                string2 = string2 + "TYPE APPLIANCE";
                break;
            }
            case 4: {
                string2 = string2 + "TYPE TELEVISION";
                break;
            }
            case 3: {
                string2 = string2 + "TYPE CAR";
                break;
            }
            case 2: {
                string2 = string2 + "TYPE DESK";
                break;
            }
            case 1: {
                string2 = string2 + "TYPE NORMAL";
                break;
            }
            case 0: {
                string2 = string2 + "TYPE UNDEFINED";
            }
        }
        if (string2.isEmpty()) {
            string2 = UNDEFINED;
        }
        return string2;
    }

    public static String getScreenLayout(int option) {
        int n;
        int n2 = option & 0xC0;
        int n3 = n;
        n = n3 & 0x30;
        int n4 = n3 & 0x300;
        int n5 = n3 & 0xF;
        String string2 = "";
        if (n2 != 0) {
            if (n2 != 6) {
                if (n2 != 64) {
                    if (n2 == 128) {
                        string2 = string2 + "LAYOUTDIR RTL, ";
                    }
                } else {
                    string2 = string2 + "LAYOUTDIR LTR, ";
                }
            } else {
                string2 = string2 + "TLAYOUTDIR SHIFT, ";
            }
        } else {
            string2 = string2 + "TLAYOUTDIR UNDEFINED, ";
        }
        if (n != 0) {
            if (n != 16) {
                if (n == 32) {
                    string2 = string2 + "LONG YES, ";
                }
            } else {
                string2 = string2 + "LONG NO, ";
            }
        } else {
            string2 = string2 + "LONG UNDEFINED, ";
        }
        if (n4 != 0) {
            if (n4 != 3) {
                if (n4 != 256) {
                    if (n4 == 512) {
                        string2 = string2 + "ROUND YES, ";
                    }
                } else {
                    string2 = string2 + "ROUND NO, ";
                }
            } else {
                string2 = string2 + "SIZE LARGE, ";
            }
        } else {
            string2 = string2 + "SIZE UNDEFINED, ";
        }
        if (n5 != 0) {
            if (n5 != 1) {
                if (n5 != 2) {
                    if (n5 == 4) {
                        string2 = string2 + "SIZE XLARGE";
                    }
                } else {
                    string2 = string2 + "SIZE NORMAL";
                }
            } else {
                string2 = string2 + "SIZE SMALL";
            }
        } else {
            string2 = string2 + "SIZE UNDEFINED";
        }
        if (string2.isEmpty()) {
            string2 = UNDEFINED;
        }
        return string2;
    }

    public static String getDensityDpi(int option) {
        switch (option) {
            default: {
                return UNDEFINED;
            }
            case 640: {
                return "XXX HIGH";
            }
            case 560: {
                return "560";
            }
            case 480: {
                return "XX HIGH";
            }
            case 420: {
                return "420";
            }
            case 400: {
                return "400";
            }
            case 360: {
                return "360";
            }
            case 320: {
                return "X HIGH";
            }
            case 280: {
                return "280";
            }
            case 240: {
                return "HIGH";
            }
            case 213: {
                return "TV";
            }
            case 160: {
                return "MEDIUM";
            }
            case 120: 
        }
        return "LOW";
    }

    public static String getKeyboard(int option) {
        if (option != 1) {
            int n;
            if (n != 2) {
                if (n != 3) {
                    return UNDEFINED;
                }
                return "12KEY";
            }
            return "QWERTY";
        }
        return "NO KEYS";
    }

    public static String isKeyboardHidden(int option) {
        if (option != 1) {
            int n;
            if (n != 2) {
                return UNDEFINED;
            }
            return "YES";
        }
        return "NO";
    }

    public static String getNavigation(int option) {
        switch (option) {
            default: {
                return UNDEFINED;
            }
            case 4: {
                return "WHEEL";
            }
            case 3: {
                return "TRACKBALL";
            }
            case 2: {
                return "DPAD";
            }
            case 1: 
        }
        return "NO NAV";
    }

    public static String isNavigationHidden(int option) {
        if (option != 1) {
            int n;
            if (n != 2) {
                return UNDEFINED;
            }
            return "YES";
        }
        return "NO";
    }

    public static String getOrientation(int option) {
        if (option != 1) {
            int n;
            if (n != 2) {
                return UNDEFINED;
            }
            return "LANDSCAPE";
        }
        return "PORTRAIT";
    }

    public static String getTouchScreenType(int option) {
        if (option != 1) {
            int n;
            if (n != 3) {
                return UNDEFINED;
            }
            return "FINGER";
        }
        return "NO TOUCH";
    }

    public static String isHardKeyboardHidden(int option) {
        if (option != 1) {
            int n;
            if (n != 2) {
                return UNDEFINED;
            }
            return "YES";
        }
        return "NO";
    }

    public static String getCpuAbis() {
        String string2 = "";
        if (Build.VERSION.SDK_INT >= 21) {
            int n = 0;
            while (true) {
                String[] stringArray = Build.SUPPORTED_ABIS;
                if (n >= Build.SUPPORTED_ABIS.length) break;
                string2 = string2 + stringArray[n] + ", ";
                ++n;
            }
            if (!string2.isEmpty()) {
                return string2;
            }
        }
        return Build.CPU_ABI + ", " + Build.CPU_ABI2;
    }

    public static boolean isLocationEnabled() {
        int n = 0;
        if (Build.VERSION.SDK_INT >= 19) {
            try {
                n = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"location_mode");
            }
            catch (Settings.SettingNotFoundException settingNotFoundException) {
                settingNotFoundException.printStackTrace();
            }
            return n != 0;
        }
        return TextUtils.isEmpty((CharSequence)Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"location_providers_allowed")) ^ true;
    }

    public static String getAndroidId() {
        String string2;
        block4: {
            string2 = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
            if (string2 != null) break block4;
            try {
                string2 = "";
            }
            catch (Exception exception) {
                string2 = "";
            }
        }
        if (string2.length() == 0) {
            string2 = UUID.randomUUID().toString();
        }
        return string2;
    }

    public static String getUserAgent() {
        return new WebView(context).getSettings().getUserAgentString();
    }

    public static String isExternalStorageRemovable() {
        return Environment.isExternalStorageRemovable() ? "YES" : "NO";
    }

    public static String isExternalStorageEmulated() {
        if (Build.VERSION.SDK_INT >= 11) {
            return Environment.isExternalStorageEmulated() ? "YES" : "NO";
        }
        return UNAVAILABLE;
    }

    public static String getAvailableInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l = statFs.getBlockSize();
        return DeviceUtil.formatSize((long)statFs.getAvailableBlocks() * l);
    }

    public static String getTotalInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = new StatFs(file.getPath());
        long l = statFs.getBlockSize();
        return DeviceUtil.formatSize((long)statFs.getBlockCount() * l);
    }

    public static String getAvailableExternalMemorySize() {
        if (DeviceUtil.externalMemoryAvailable()) {
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = new StatFs(file.getPath());
            long l = statFs.getBlockSize();
            return DeviceUtil.formatSize((long)statFs.getAvailableBlocks() * l);
        }
        return UNAVAILABLE;
    }

    public static String getTotalExternalMemorySize() {
        if (DeviceUtil.externalMemoryAvailable()) {
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = new StatFs(file.getPath());
            long l = statFs.getBlockSize();
            return DeviceUtil.formatSize((long)statFs.getBlockCount() * l);
        }
        return UNAVAILABLE;
    }

    public static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String formatSize(long size) {
        StringBuilder stringBuilder;
        String string2 = " KB";
        if (size >= 1024L) {
            string2 = " MB";
            if ((var0 /= 1024L) >= 1024L) {
                string2 = " GB";
                var0 /= 1024L;
            }
        }
        StringBuilder stringBuilder2 = stringBuilder;
        for (int i = new StringBuilder(Long.toString(var0)).length() - 3; i > 0; i -= 3) {
            stringBuilder2.insert(i, ',');
        }
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(string2);
        return stringBuilder3.toString();
    }

    public static DisplayMetrics getMetrics() {
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics2);
        return displayMetrics;
    }

    public static String getTotalRam() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(DeviceUtil.memoryManager.totalMem);
        }
        return UNAVAILABLE;
    }

    public static String getAvailableRam() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(DeviceUtil.memoryManager.availMem);
        }
        return UNAVAILABLE;
    }

    public static String getThresholdRam() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(DeviceUtil.memoryManager.threshold);
        }
        return UNAVAILABLE;
    }

    public static String isRamMemoryLow() {
        if (Build.VERSION.SDK_INT >= 19) {
            if (DeviceUtil.memoryManager.lowMemory) {
                return "YES";
            }
            return "NO";
        }
        return UNAVAILABLE;
    }

    public static String getWifiState() {
        WifiManager wifiManager = DeviceUtil.wifiManager;
        if (wifiManager != null) {
            if (wifiManager.isWifiEnabled()) {
                return "ON";
            }
            return "OFF";
        }
        return UNAVAILABLE;
    }

    public static String getLocationState() {
        if (DeviceUtil.isLocationEnabled()) {
            return "ON";
        }
        return "OFF";
    }

    public static String getTotalSharedClean() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(debugMemory.getTotalSharedClean());
        }
        return UNAVAILABLE;
    }

    public static String getTotalPrivateClean() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(debugMemory.getTotalPrivateClean());
        }
        return UNAVAILABLE;
    }

    public static String getTotalSwappablePss() {
        if (Build.VERSION.SDK_INT >= 19) {
            return DeviceUtil.formatSize(debugMemory.getTotalSwappablePss());
        }
        return UNAVAILABLE;
    }

    public static boolean isDeviceExcepted(String manufacturer) {
        String string2;
        return DEVICE_MANUFACTURER_EXCEPTIONS_SET.contains(string2);
    }

    public static int getScreenWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getRealScreenHeight(Activity context) {
        Exception exception2;
        int n;
        block6: {
            Activity activity;
            Point point;
            String string2;
            CharSequence charSequence;
            n = DeviceUtil.getScreenHeight((Context)context);
            String string3 = Util.TAG;
            B5B.B5B(string3, "getRealScreenHeight()    screenHeight = " + n);
            try {
                charSequence = new StringBuilder().append("manufacturer = ");
                string2 = Build.MANUFACTURER;
            }
            catch (Exception exception2) {
                break block6;
            }
            {
                StringBuilder stringBuilder = ((StringBuilder)charSequence).append(string2).append(",      model = ");
                charSequence = Build.MODEL;
                {
                    B5B.B5B(string3, stringBuilder.append((String)charSequence).toString());
                }
            }
            Point point2 = point;
            point = new Point();
            if (string2.equals("samsung") && (((String)charSequence).contains("SM-G950F") || ((String)charSequence).contains("SM-G955") || ((String)charSequence).contains("SM-G960") || ((String)charSequence).contains("SM-G965F"))) {
                B5B.B5B(string3, "using real screen height");
                activity.getWindowManager().getDefaultDisplay().getRealSize(point2);
                n = point2.y;
                B5B.B5B(string3, "getRealScreenHeight()    realScreenHeight = " + n);
                return n;
            }
            if (!string2.equals("Xiaomi")) return n;
            if (!((String)charSequence).contains("MI 8")) return n;
            B5B.B5B(string3, "using real screen height");
            if (Build.VERSION.SDK_INT < 17) return n;
            activity.getWindowManager().getDefaultDisplay().getRealSize(point2);
            n = point2.y;
            B5B.B5B(string3, "getRealScreenHeight()    realScreenHeight = " + n);
            return n;
        }
        exception2.printStackTrace();
        return n;
    }

    public static double getScreenInches(Context context, WindowManager windowManager) {
        Context context2;
        DisplayMetrics displayMetrics;
        DisplayMetrics displayMetrics2;
        void v0 = displayMetrics2;
        displayMetrics2 = displayMetrics;
        displayMetrics = new DisplayMetrics();
        v0.getDefaultDisplay().getMetrics(displayMetrics2);
        return Math.sqrt(Math.pow((float)DeviceUtil.getScreenWidth(context) / displayMetrics2.xdpi, 2.0) + Math.pow((float)DeviceUtil.getScreenHeight(context2) / displayMetrics2.ydpi, 2.0));
    }

    public static int getStatusBarHeight(Context context) {
        int n = 0;
        int n2 = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n2 > 0) {
            Context context2;
            n = context2.getResources().getDimensionPixelSize(n2);
        }
        return n;
    }

    public static boolean isJellybeanOrAbove() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isAndroid5OrAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isAndroid6OrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static boolean isRunningAndTargetingO(Context context) {
        Context context2;
        return Build.VERSION.SDK_INT >= 26 && DeviceUtil.getTargetSdk(context2) >= 26;
    }

    public static int getTargetSdk(Context context) {
        int n = 0;
        try {
            Context context2;
            n = context.getPackageManager().getApplicationInfo((String)context2.getPackageName(), (int)0).targetSdkVersion;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public static boolean isEmulator() {
        String string2 = Build.FINGERPRINT;
        return string2.startsWith("generic") || string2.startsWith("unknown") || (string2 = Build.MODEL).contains("google_sdk") || string2.contains("Emulator") || string2.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || "google_sdk".equals(Build.PRODUCT);
    }

    public static String getDeviceManufacturer() {
        String string2 = Build.MANUFACTURER.toLowerCase();
        return string2.contains("samsung") ? "samsung" : (string2.contains("huawei") ? "huawei" : (string2.contains("xiaomi") ? "xiaomi" : (string2.contains("motorola") ? "motorola" : (string2.contains("oppo") ? "oppo" : (string2.equals("lg") ? "lg" : (string2.contains("vivo") ? "vivo" : (string2.contains("sony") ? "sony" : (string2.contains("lenovo") ? "lenovo" : (string2.contains("asus") ? "asus" : (string2.contains("amlogic") ? "amlogic" : (!string2.contains("tct") && !string2.contains("alcatel") ? (string2.contains("tecno") ? "tecno" : (string2.contains("amazon") ? "amazon" : (string2.contains("zte") ? "zte" : (string2.contains("hmd") ? "hmdGlobal" : (string2.contains("itel") ? "itel" : (string2.contains("infinix") ? "infinix" : "unknown_manufacturer")))))) : "alcatel")))))))))));
    }

    /*
     * WARNING - void declaration
     */
    public static void dismissKeyboard(Context context, View view) {
        void var1_1;
        if (context != null && var1_1 != null) {
            Context context2;
            ((InputMethodManager)context2.getSystemService("input_method")).hideSoftInputFromWindow(var1_1.getWindowToken(), 0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getNavigationOverlayHeight(Activity activity, View bottomLeftView, boolean isAppRunningFullScreen) {
        Activity activity2;
        void var1_2;
        Object object;
        if (!isAppRunningFullScreen) {
            return 0;
        }
        Activity activity3 = object;
        int[] nArray = new int[2];
        object = nArray;
        var1_2.getLocationOnScreen(nArray);
        int n = DeviceUtil.getRealScreenHeight(activity3);
        int n2 = var1_2.getMeasuredHeight();
        n2 = n - n2;
        B5B.B5B(Util.TAG, "navigationOverlayHeight = " + (n2 - object[1]));
        if (n > 0 && (activity2 = object[1]) > 0) {
            return n2 - activity2;
        }
        return 0;
    }

    public static boolean isEdgeDevice() {
        boolean bl;
        block7: {
            block6: {
                Method method;
                bl = false;
                try {
                    method = Class.forName("com.samsung.android.sdk.look.SlookImpl").getDeclaredMethod("isFeatureEnabled", Integer.TYPE);
                }
                catch (Exception exception) {}
                Object object = 7;
                object = method.invoke(null, object);
                if (object == null) break block6;
                bl = (Boolean)object;
                break block7;
            }
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        return bl;
    }

    static {
        List<String> list;
        DEVICE_MANUFACTURER_EXCEPTIONS_LIST = list = Arrays.asList("GENERAL_MOBILE");
        DEVICE_MANUFACTURER_EXCEPTIONS_SET = new HashSet<String>(list);
    }
}

