/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.CalldoradoApplication;
import com.calldorado.configs.Configs;
import com.calldorado.translations.F2S;
import com.calldorado.util.Util;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/calldorado/util/LegislationUtil;", "", "()V", "marylandLegislationTime", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "minnesotaLegislationTime", "newJerseyLegislationTime", "tennesseeLegislationTime", "getDefaultBodyText", "", "context", "Landroid/content/Context;", "states", "Lcom/calldorado/util/LegislationUtil$UsaStates;", "getDefaultTitleText", "getStateListFromUSALegislationUser", "", "usaLegislationUser", "Lcom/calldorado/util/LegislationUtil$USALegislationUser;", "getUSAUserLegislationType", "isLegislationInEffect", "", "calendar", "USALegislationUser", "UsaStates", "sdk_calldoradoRelease"})
@StabilityInferred(parameters=0)
public final class LegislationUtil {
    @NotNull
    public static final LegislationUtil INSTANCE = new LegislationUtil();
    private static final Calendar newJerseyLegislationTime;
    private static final Calendar tennesseeLegislationTime;
    private static final Calendar minnesotaLegislationTime;
    private static final Calendar marylandLegislationTime;
    public static final int $stable;

    private LegislationUtil() {
    }

    @JvmStatic
    @NotNull
    public static final USALegislationUser getUSAUserLegislationType(@NotNull Context context) {
        TimeZone timeZone;
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Configs configs = CalldoradoApplication.ix0(context2).Mc1();
        if (configs.xfp().MXh()) {
            return USALegislationUser.PST;
        }
        if (configs.xfp().Y_D()) {
            return USALegislationUser.MST;
        }
        if (configs.xfp()._C4()) {
            return USALegislationUser.EST;
        }
        if (configs.xfp().YYA()) {
            return USALegislationUser.CST;
        }
        if (configs.xfp().cvX()) {
            return USALegislationUser.USA;
        }
        String string2 = Util.getDeviceCountryCode((Context)timeZone);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getDeviceCountryCode(context)");
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"us", (boolean)false, (int)2, null)) {
            timeZone = TimeZone.getDefault();
            String string4 = timeZone.getID();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tz.id");
            if (!StringsKt.contains$default((CharSequence)string4, (CharSequence)"Los_Angeles", (boolean)false, (int)2, null)) {
                String string5 = timeZone.getDisplayName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"tz.displayName");
                if (!StringsKt.contains$default((CharSequence)string5, (CharSequence)"Pacific Standard Time", (boolean)false, (int)2, null)) {
                    String string6 = timeZone.getID();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"tz.id");
                    if (!StringsKt.contains$default((CharSequence)string6, (CharSequence)"Denver", (boolean)false, (int)2, null)) {
                        String string7 = timeZone.getID();
                        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"tz.id");
                        if (!StringsKt.contains$default((CharSequence)string7, (CharSequence)"Phoenix", (boolean)false, (int)2, null)) {
                            String string8 = timeZone.getDisplayName();
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"tz.displayName");
                            if (!StringsKt.contains$default((CharSequence)string8, (CharSequence)"Mountain Standard Time", (boolean)false, (int)2, null)) {
                                String string9 = timeZone.getID();
                                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"tz.id");
                                if (!StringsKt.contains$default((CharSequence)string9, (CharSequence)"New_York", (boolean)false, (int)2, null)) {
                                    String string10 = timeZone.getDisplayName();
                                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"tz.displayName");
                                    if (!StringsKt.contains$default((CharSequence)string10, (CharSequence)"Eastern Standard Time", (boolean)false, (int)2, null)) {
                                        String string11 = timeZone.getID();
                                        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"tz.id");
                                        if (!StringsKt.contains$default((CharSequence)string11, (CharSequence)"Chicago", (boolean)false, (int)2, null)) {
                                            String string12 = timeZone.getDisplayName();
                                            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"tz.displayName");
                                            if (!StringsKt.contains$default((CharSequence)string12, (CharSequence)"Central Standard Time", (boolean)false, (int)2, null)) {
                                                return USALegislationUser.USA;
                                            }
                                        }
                                        return USALegislationUser.CST;
                                    }
                                }
                                return USALegislationUser.EST;
                            }
                        }
                    }
                    return USALegislationUser.MST;
                }
            }
            return USALegislationUser.PST;
        }
        return USALegislationUser.OUTSIDE_USA;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isLegislationInEffect(Calendar calendar) {
        void var1_1;
        return Calendar.getInstance().getTimeInMillis() >= var1_1.getTimeInMillis();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getDefaultTitleText(@NotNull Context context, @NotNull UsaStates states) {
        void var1_1;
        Context context2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)states), (String)"states");
        return switch (WhenMappings.$EnumSwitchMapping$1[var1_1.ordinal()]) {
            default -> "";
            case 16 -> F2S.B5B((Context)context2).WBR;
            case 15 -> F2S.B5B((Context)context2).bpn;
            case 14 -> F2S.B5B((Context)context2).KG3;
            case 13 -> F2S.B5B((Context)context2).can;
            case 12 -> F2S.B5B((Context)context2).tyA;
            case 11 -> F2S.B5B((Context)context2).J3s;
            case 10 -> F2S.B5B((Context)context2).YFD;
            case 9 -> F2S.B5B((Context)context2).YD3;
            case 8 -> F2S.B5B((Context)context2).TSU;
            case 7 -> F2S.B5B((Context)context2).eZ6;
            case 6 -> F2S.B5B((Context)context2).g0o;
            case 5 -> F2S.B5B((Context)context2).DZs;
            case 4 -> F2S.B5B((Context)context2).E7Z;
            case 3 -> F2S.B5B((Context)context2).Hzv;
            case 2 -> F2S.B5B((Context)context2).fBA;
            case 1 -> F2S.B5B((Context)context2).spE;
        };
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String getDefaultBodyText(@NotNull Context context, @NotNull UsaStates states) {
        void var1_1;
        Context context2;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)states), (String)"states");
        return switch (WhenMappings.$EnumSwitchMapping$1[var1_1.ordinal()]) {
            default -> "";
            case 16 -> F2S.B5B((Context)context2).ZPb;
            case 15 -> F2S.B5B((Context)context2).KoD;
            case 14 -> F2S.B5B((Context)context2).onD;
            case 13 -> F2S.B5B((Context)context2).AHQ;
            case 12 -> F2S.B5B((Context)context2).adW;
            case 11 -> F2S.B5B((Context)context2).GKU;
            case 10 -> F2S.B5B((Context)context2).Rm7;
            case 9 -> F2S.B5B((Context)context2).vr2;
            case 8 -> F2S.B5B((Context)context2).p5X;
            case 7 -> F2S.B5B((Context)context2).oJm;
            case 6 -> F2S.B5B((Context)context2).YAg;
            case 5 -> F2S.B5B((Context)context2).sBQ;
            case 4 -> F2S.B5B((Context)context2).qlk;
            case 3 -> F2S.B5B((Context)context2).lF4;
            case 2 -> F2S.B5B((Context)context2).KAL;
            case 1 -> F2S.B5B((Context)context2).aiY;
        };
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2025);
        calendar.set(2, 0);
        calendar.set(5, 15);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        newJerseyLegislationTime = calendar;
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(1, 2025);
        calendar2.set(2, 6);
        calendar2.set(5, 1);
        calendar2.set(10, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        tennesseeLegislationTime = calendar2;
        Calendar calendar3 = Calendar.getInstance();
        calendar3.set(1, 2025);
        calendar3.set(2, 6);
        calendar3.set(5, 31);
        calendar3.set(10, 0);
        calendar3.set(12, 0);
        calendar3.set(13, 0);
        minnesotaLegislationTime = calendar3;
        Calendar calendar4 = Calendar.getInstance();
        calendar4.set(1, 2025);
        calendar4.set(2, 9);
        calendar4.set(5, 1);
        calendar4.set(10, 0);
        calendar4.set(12, 0);
        calendar4.set(13, 0);
        marylandLegislationTime = calendar4;
        $stable = 8;
    }

    @NotNull
    public final List<UsaStates> getStateListFromUSALegislationUser(@NotNull USALegislationUser usaLegislationUser) {
        LegislationUtil legislationUtil;
        Intrinsics.checkNotNullParameter((Object)((Object)usaLegislationUser), (String)"usaLegislationUser");
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)legislationUtil)).ordinal()]) {
            default: {
                throw new NoWhenBranchMatchedException();
            }
            case 6: {
                Object object = CollectionsKt.listOf((Object)((Object)UsaStates.OUTSIDE_USA));
                break;
            }
            case 5: {
                Object object = CollectionsKt.listOf((Object)((Object)UsaStates.NON_LEGISLATION_STATE));
                break;
            }
            case 4: {
                Object object = CollectionsKt.mutableListOf((Object[])new UsaStates[]{UsaStates.IOWA, UsaStates.NEBRASKA, UsaStates.TEXAS});
                legislationUtil = INSTANCE;
                Calendar calendar = tennesseeLegislationTime;
                Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"tennesseeLegislationTime");
                if (legislationUtil.isLegislationInEffect(calendar)) {
                    object.add(UsaStates.TENNESSEE);
                }
                Calendar calendar2 = minnesotaLegislationTime;
                Intrinsics.checkNotNullExpressionValue((Object)calendar2, (String)"minnesotaLegislationTime");
                if (legislationUtil.isLegislationInEffect(calendar2)) {
                    object.add(UsaStates.MINNESOTA);
                }
                Object object2 = object;
                CollectionsKt.sort((List)object2);
                object2.add(UsaStates.NON_LEGISLATION_STATE);
                break;
            }
            case 3: {
                Object object = CollectionsKt.mutableListOf((Object[])new UsaStates[]{UsaStates.CONNECTICUT, UsaStates.DELAWARE, UsaStates.NEW_HAMPSHIRE, UsaStates.VIRGINIA});
                legislationUtil = INSTANCE;
                Calendar calendar = newJerseyLegislationTime;
                Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"newJerseyLegislationTime");
                if (legislationUtil.isLegislationInEffect(calendar)) {
                    object.add(UsaStates.NEW_JERSEY);
                }
                Calendar calendar3 = marylandLegislationTime;
                Intrinsics.checkNotNullExpressionValue((Object)calendar3, (String)"marylandLegislationTime");
                if (legislationUtil.isLegislationInEffect(calendar3)) {
                    object.add(UsaStates.MARYLAND);
                }
                Object object3 = object;
                CollectionsKt.sort((List)object3);
                object3.add(UsaStates.NON_LEGISLATION_STATE);
                break;
            }
            case 2: {
                Object object = CollectionsKt.listOf((Object[])new UsaStates[]{UsaStates.COLORADO, UsaStates.MONTANA, UsaStates.OREGON, UsaStates.TEXAS, UsaStates.UTAH, UsaStates.NON_LEGISLATION_STATE});
                break;
            }
            case 1: {
                Object object = CollectionsKt.listOf((Object[])new UsaStates[]{UsaStates.CALIFORNIA, UsaStates.OREGON, UsaStates.NON_LEGISLATION_STATE});
            }
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/calldorado/util/LegislationUtil$USALegislationUser;", "", "(Ljava/lang/String;I)V", "USA", "PST", "MST", "EST", "CST", "OUTSIDE_USA", "sdk_calldoradoRelease"})
    public static enum USALegislationUser {
        USA,
        PST,
        MST,
        EST,
        CST,
        OUTSIDE_USA;

    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0017\b\u0086\u0001\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018\u00a8\u0006\u001a"}, d2={"Lcom/calldorado/util/LegislationUtil$UsaStates;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "CALIFORNIA", "OREGON", "COLORADO", "MONTANA", "TEXAS", "UTAH", "CONNECTICUT", "VIRGINIA", "DELAWARE", "IOWA", "NON_LEGISLATION_STATE", "NEW_HAMPSHIRE", "NEW_JERSEY", "MARYLAND", "NEBRASKA", "TENNESSEE", "MINNESOTA", "OUTSIDE_USA", "Companion", "sdk_calldoradoRelease"})
    public static enum UsaStates {
        CALIFORNIA("California"),
        OREGON("Oregon"),
        COLORADO("Colorado"),
        MONTANA("Montana"),
        TEXAS("Texas"),
        UTAH("Utah"),
        CONNECTICUT("Connecticut"),
        VIRGINIA("Virginia"),
        DELAWARE("Delaware"),
        IOWA("Iowa"),
        NON_LEGISLATION_STATE("None of the above"),
        NEW_HAMPSHIRE("New Hampshire"),
        NEW_JERSEY("New Jersey"),
        MARYLAND("Maryland"),
        NEBRASKA("Nebraska "),
        TENNESSEE("Tennessee "),
        MINNESOTA("Minnesota"),
        OUTSIDE_USA("");

        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String value;

        /*
         * WARNING - void declaration
         */
        private UsaStates(String value) {
            void var3_3;
            this.value = var3_3;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/calldorado/util/LegislationUtil$UsaStates$Companion;", "", "()V", "fromString", "Lcom/calldorado/util/LegislationUtil$UsaStates;", "text", "", "sdk_calldoradoRelease"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final UsaStates fromString(@NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                for (UsaStates usaStates : UsaStates.values()) {
                    void var1_1;
                    if (!StringsKt.equals((String)usaStates.getValue(), (String)var1_1, (boolean)true)) continue;
                    return usaStates;
                }
                return NON_LEGISLATION_STATE;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[USALegislationUser.values().length];
            int[] nArray2 = nArray;
            try {
                nArray[USALegislationUser.PST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[USALegislationUser.MST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[USALegislationUser.EST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[USALegislationUser.CST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[USALegislationUser.USA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[USALegislationUser.OUTSIDE_USA.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray2;
            int[] nArray3 = new int[UsaStates.values().length];
            nArray2 = nArray3;
            try {
                nArray3[UsaStates.CALIFORNIA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.OREGON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.COLORADO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.MONTANA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.TEXAS.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.UTAH.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.CONNECTICUT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.VIRGINIA.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.DELAWARE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.IOWA.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.NEW_HAMPSHIRE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.NEW_JERSEY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.MARYLAND.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.NEBRASKA.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.TENNESSEE.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray2[UsaStates.MINNESOTA.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$1 = nArray2;
        }
    }
}

