/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.app.AlarmManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import androidx.core.app.NotificationCompat;
import com.calldorado.CalldoradoApplication;
import com.calldorado.android.R;
import com.calldorado.configs.Configs;
import com.calldorado.notifications.CallReminderNotificationReceiver;
import com.calldorado.notifications.ReoptinNotificationReceiver;
import com.calldorado.search.Search;
import com.calldorado.stats.StatsReceiver;
import com.calldorado.translations.F2S;
import com.calldorado.ui.aftercall.CallerIdActivity;
import com.calldorado.ui.settings.B5B;
import com.calldorado.util.IntentUtil;
import com.calldorado.util.PermissionsUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

public class NotificationUtil {
    public static final String TAG = "NotificationUtil";
    public static final String FREE_SLOT = "none:0";
    public static final int OVERLAY_NOTIFICATION_ID = 14423;
    private static final int REMINDER_FACTOR = 1;
    private static final int REOPTIN_FACTOR = 11;

    /*
     * WARNING - void declaration
     */
    public static void createNotificationChannel(Context context, String notificationChannel, String desc, String id2) {
        if (Build.VERSION.SDK_INT >= 26) {
            void var2_2;
            void var1_1;
            void var3_3;
            NotificationChannel notificationChannel2;
            Context context2;
            Context context3 = context2;
            context2 = notificationChannel2;
            context2((String)var3_3, (CharSequence)var1_1, 3);
            notificationChannel2.setDescription((String)var2_2);
            notificationChannel2.setShowBadge(false);
            ((NotificationManager)context3.getSystemService(NotificationManager.class)).createNotificationChannel((NotificationChannel)context2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void scheduleReoptinNotification(Context context, int notificationId, long futureInMillis) {
        Exception exception2;
        block11: {
            void var1_2;
            block10: {
                void var2_3;
                int n;
                AlarmManager alarmManager;
                Context context2;
                block9: {
                    block8: {
                        Intent intent;
                        Intent intent2;
                        void v3;
                        Context context3;
                        Context context4;
                        try {
                            Intent intent3;
                            Context context5 = context;
                            context4 = context5;
                            context3 = context5;
                            v3 = var1_2;
                            intent2 = intent3;
                            intent3 = new Intent(context2, ReoptinNotificationReceiver.class);
                            intent = intent3;
                            intent3.putExtra("notificationId", (int)var1_2);
                        }
                        catch (Exception exception2) {}
                        intent.setAction("com.calldorado.android.intent.NOTIFICATION_SHOW");
                        context2 = PendingIntent.getBroadcast((Context)context4, (int)v3, (Intent)intent2, (int)0xC000000);
                        alarmManager = (AlarmManager)context3.getSystemService("alarm");
                        if (alarmManager != null) break block8;
                        return;
                    }
                    n = Build.VERSION.SDK_INT;
                    if (n < 23) break block9;
                    alarmManager.setExactAndAllowWhileIdle(0, (long)var2_3, (PendingIntent)context2);
                    break block10;
                    break block11;
                }
                if (n >= 19) {
                    alarmManager.setExact(0, (long)var2_3, (PendingIntent)context2);
                } else {
                    alarmManager.set(0, (long)var2_3, (PendingIntent)context2);
                }
            }
            com.calldorado.log.B5B.esR(TAG, "scheduleReoptinNotification id = " + (int)var1_2);
            return;
        }
        com.calldorado.log.B5B.ix0(TAG, exception2.getMessage());
    }

    public static void sendOverlayNotification(Context context) {
        Context context2;
        Intent intent;
        Context context3 = context;
        NotificationUtil.createOverlayNotificationChannel(context3);
        String string2 = F2S.B5B((Context)context3).LjS;
        Intent intent2 = intent;
        new Intent(context2, CallerIdActivity.class).putExtra("overlayNotification", true);
        intent2.setFlags(0x14000000);
        intent2 = PendingIntent.getActivity((Context)context3, (int)0, (Intent)intent2, (int)0x4000000);
        string2 = new NotificationCompat.Builder(context2, "14423").setContentTitle((CharSequence)string2).setSmallIcon(R.drawable.cdo_ic_overlay_notification).setPriority(2).setCategory("call").setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setWhen(System.currentTimeMillis()).setAutoCancel(true);
        NotificationManager notificationManager = (NotificationManager)context3.getSystemService("notification");
        int n = Build.VERSION.SDK_INT;
        if (n >= 34) {
            if (notificationManager.canUseFullScreenIntent()) {
                string2.setFullScreenIntent((PendingIntent)intent2, true);
            } else {
                com.calldorado.log.B5B.xfp(TAG, "Can't use FSIP");
                string2.setContentIntent((PendingIntent)intent2);
            }
        } else {
            string2.setFullScreenIntent((PendingIntent)intent2, true);
        }
        notificationManager.notify(14423, string2.build());
        if (n >= 24 && !notificationManager.areNotificationsEnabled()) {
            return;
        }
        Context context4 = context2;
        com.calldorado.log.B5B.B5B(TAG, "sendOverlayNotification: Notify");
        StatsReceiver.broadcastNotificationsStats(context4, "overlay_permission_notification_shown_first");
        IntentUtil.sendFirebaseEventIfPossible(context4, "WB_Notification_Displayed", IntentUtil.EXTERNAL_BROADCAST_TYPE.firebase, "");
        com.calldorado.log.B5B.B5B("STATS BABY", "overlay_permission_notification_shown_first");
    }

    private static void createOverlayNotificationChannel(Context context) {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel notificationChannel;
            Context context2;
            Context context3 = context2;
            context2 = notificationChannel;
            new NotificationChannel("14423", (CharSequence)"Caller ID Channel", 4).setDescription("Get call information results in the end of every call");
            context2.setShowBadge(false);
            NotificationManager notificationManager = (NotificationManager)context3.getSystemService(NotificationManager.class);
            if (notificationManager != null) {
                notificationManager.createNotificationChannel((NotificationChannel)context2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void cancelScheduledUpdateoptinNotification(Context context, int id2) {
        AlarmManager alarmManager;
        Context context2;
        void var1_2;
        block6: {
            Intent intent;
            Context context3 = context;
            Context context4 = context3;
            Context context5 = context3;
            void v3 = var1_2;
            Intent intent2 = intent;
            intent = new Intent(context2, ReoptinNotificationReceiver.class);
            Intent intent3 = intent;
            intent.putExtra("notificationId", (int)var1_2);
            intent3.setAction("com.calldorado.android.intent.NOTIFICATION_SHOW");
            context2 = PendingIntent.getBroadcast((Context)context4, (int)v3, (Intent)intent2, (int)0xC000000);
            alarmManager = (AlarmManager)context5.getSystemService("alarm");
            if (alarmManager != null) break block6;
            return;
        }
        try {
            alarmManager.cancel((PendingIntent)context2);
            com.calldorado.log.B5B.esR(TAG, "cancelScheduledReoptinNotification id = " + (int)var1_2);
        }
        catch (Exception exception) {
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void cancelScheduledReoptinNotification(Context context, int notificationId) {
        AlarmManager alarmManager;
        Context context2;
        void var1_2;
        block6: {
            Intent intent;
            Context context3 = context;
            Context context4 = context3;
            Context context5 = context3;
            void v3 = var1_2;
            Intent intent2 = intent;
            intent = new Intent(context2, ReoptinNotificationReceiver.class);
            Intent intent3 = intent;
            intent.putExtra("notificationId", (int)var1_2);
            intent3.setAction("com.calldorado.android.intent.NOTIFICATION_SHOW");
            context2 = PendingIntent.getBroadcast((Context)context4, (int)v3, (Intent)intent2, (int)0xC000000);
            alarmManager = (AlarmManager)context5.getSystemService("alarm");
            if (alarmManager != null) break block6;
            return;
        }
        try {
            alarmManager.cancel((PendingIntent)context2);
            com.calldorado.log.B5B.esR(TAG, "cancelScheduledReoptinNotification id = " + (int)var1_2);
        }
        catch (Exception exception) {
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cancelAllScheduledReoptinNotifications(Context context) {
        Exception exception2;
        block4: {
            try {
                Iterator<Integer> iterator = PermissionsUtil.getShowDays(CalldoradoApplication.ix0(context).Mc1().gGZ().fK6()).iterator();
                while (iterator.hasNext()) {
                    Context context2;
                    NotificationUtil.cancelScheduledReoptinNotification(context2, iterator.next() * 11);
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            com.calldorado.log.B5B.esR(TAG, "cancelAllScheduledReoptinNotifications");
            return;
        }
        com.calldorado.log.B5B.ix0(TAG, exception2.getMessage());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeAllExistingReoptinNotifications(Context context) {
        Exception exception2;
        block4: {
            try {
                Iterator<Integer> iterator = PermissionsUtil.getShowDays(CalldoradoApplication.ix0(context).Mc1().gGZ().fK6()).iterator();
                while (iterator.hasNext()) {
                    Context context2;
                    NotificationUtil.removeExistingNotification(context2, iterator.next() * 11);
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            com.calldorado.log.B5B.esR(TAG, "removeAllExistingReoptinNotifications");
            return;
        }
        com.calldorado.log.B5B.ix0(TAG, exception2.getMessage());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void cancelAllScheduledUpdateOptinNotifications(Context context) {
        Exception exception2;
        block4: {
            try {
                Configs configs = CalldoradoApplication.ix0(context).Mc1();
                for (int i = 0; i < configs.YYA().Qaz().split(",").length; ++i) {
                    Context context2;
                    NotificationUtil.cancelScheduledUpdateoptinNotification(context2, i + 101);
                }
            }
            catch (Exception exception2) {
                break block4;
            }
            {
                com.calldorado.log.B5B.esR(TAG, "cancelAllScheduledReoptinNotifications");
                return;
            }
        }
        com.calldorado.log.B5B.ix0(TAG, exception2.getMessage());
    }

    public static void removeAllExistingUpdateOptinNotifications(Context context) {
        int n = CalldoradoApplication.ix0(context).Mc1().YYA().Qaz().split(",").length;
        for (int i = 0; i < n; ++i) {
            try {
                Context context2;
                NotificationUtil.removeExistingNotification(context2, i + 101);
                continue;
            }
            catch (Exception exception) {
                com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
                break;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeExistingNotification(Context context, int notificationId) {
        try {
            var2_3 = (NotificationManager)context.getSystemService("notification");
            if (var2_3 == null) {
                return;
            }
        }
        catch (Exception var0_1) {
        }
        {
            var0 = CalldoradoApplication.ix0((Context)var0).Mc1();
        }
        {
            v0 = new ArrayList<String>();
            v0.addAll(Arrays.asList(var0.ix0().xfp().split(";")));
        }
        {
            var3_4 = "";
            var4_5 = false;
            var5_6 = v0.iterator();
lbl15:
            // 3 sources

            ** while (var5_6.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            var6_7 = (String)var5_6.next();
            if (var6_7.contains(Integer.toString((int)var1_2))) {
                var5_6.remove();
                var4_5 = true;
                continue;
            }
            ** GOTO lbl-1000
lbl22:
            // 1 sources

            ** GOTO lbl27
        }
        com.calldorado.log.B5B.ix0(NotificationUtil.TAG, var0_1.getMessage());
        return;
lbl-1000:
        // 1 sources

        {
            var3_4 = var3_4 + var6_7 + ";";
            ** GOTO lbl15
lbl27:
            // 1 sources

            if (var4_5) {
                var0.ix0().ix0(var3_4);
            }
            var2_3.cancel((int)var1_2);
            com.calldorado.log.B5B.esR(NotificationUtil.TAG, "removeExistingNotification id = " + (int)var1_2);
            return;
        }
    }

    public static void removeAllNotifications(Context context) {
        Context context2;
        block3: {
            context2 = (NotificationManager)context.getSystemService("notification");
            if (context2 != null) break block3;
            return;
        }
        try {
            context2.cancelAll();
            com.calldorado.log.B5B.esR(TAG, "removeAllNotifications");
        }
        catch (Exception exception) {
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
        }
    }

    public static void scheduleReoptinNotifications(Context context) {
        block5: {
            Context context2;
            Configs configs;
            block6: {
                configs = CalldoradoApplication.ix0(context).Mc1();
                if (!configs.gGZ().tCZ()) break block5;
                if (PermissionsUtil.isCalldoradoAccepted(context2)) break block6;
                if ((!configs.YYA().hRf().equals("install") || !PermissionsUtil.isTriggerActivated(configs.gGZ().fK6(), "install")) && (!configs.YYA().hRf().equals("update") || !PermissionsUtil.isTriggerActivated(configs.gGZ().fK6(), "update"))) break block5;
                for (int n : PermissionsUtil.getShowHours(configs.gGZ().fK6())) {
                    for (int n2 : PermissionsUtil.getShowDays(configs.gGZ().fK6())) {
                        Calendar calendar;
                        Calendar calendar2 = calendar = Calendar.getInstance();
                        calendar2.add(5, n2);
                        calendar2.set(11, n);
                        calendar2.set(12, 0);
                        calendar2.set(13, 0);
                        long l = calendar.getTimeInMillis();
                        NotificationUtil.scheduleReoptinNotification(context2, n2 *= 11, l);
                        com.calldorado.log.B5B.B5B(TAG, "scheduleReoptinNotification id = " + n2 + " when = " + calendar.getTime().toString());
                    }
                }
                break block5;
            }
            if (B5B.B5B(context2).tCZ() && (configs.YYA().hRf().equals("settings") && PermissionsUtil.isTriggerActivated(configs.gGZ().xfp(), "settings") || configs.YYA().hRf().equals("update") && PermissionsUtil.isTriggerActivated(configs.gGZ().xfp(), "update"))) {
                for (int n : PermissionsUtil.getShowHours(configs.gGZ().xfp())) {
                    for (int n3 : PermissionsUtil.getShowDays(configs.gGZ().xfp())) {
                        Calendar calendar;
                        Calendar calendar3 = calendar = Calendar.getInstance();
                        calendar3.add(5, n3);
                        calendar3.set(11, n);
                        calendar3.set(12, 0);
                        calendar3.set(13, 0);
                        long l = calendar.getTimeInMillis();
                        NotificationUtil.scheduleReoptinNotification(context2, n3 *= 11, l);
                        com.calldorado.log.B5B.B5B(TAG, "scheduleReoptinNotification id = " + n3 + " when = " + calendar.getTime().toString());
                    }
                }
            }
        }
    }

    public static void initAftercallNotificationList(Configs config) {
        Configs configs = config;
        int n = NotificationUtil.getItensAllowedPerTime(configs.ix0().fK6());
        String string2 = configs.ix0().IoQ();
        String[] stringArray = string2.split(",");
        if (string2.isEmpty() || stringArray.length < n) {
            Configs configs2;
            for (int i = stringArray.length; i <= n; ++i) {
                string2 = i == 1 ? string2.concat(FREE_SLOT) : string2.concat(",").concat(FREE_SLOT);
            }
            configs2.ix0().B5B(string2);
            com.calldorado.log.B5B.B5B(TAG, "initAftercallNotificationList = " + string2);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void scheduleAfterCallNotification(Context context, Search search, Bundle extras) {
        block16: {
            try {
                var3_4 = CalldoradoApplication.ix0(context).Mc1();
            }
            catch (Exception var0_1) {
                break block16;
            }
            var4_6 = NotificationUtil.getDelayInMinutes(var3_4.ix0().fK6());
            var5_7 = Calendar.getInstance();
            if (var3_4.xfp().ETk()) {
                var5_7.add(14, 0);
            } else {
                var5_7.add(12, var4_6);
            }
            var5_8 = var5_7.getTimeInMillis();
            var7_9 = var2_3.getInt("screen_type");
            var8_10 = NotificationUtil.isTypeEnabled(var3_4.ix0().fK6(), var7_9);
            if (var4_6 < 0 || !var8_10) ** GOTO lbl63
            var4_6 = NotificationUtil.addNotificationToList(var0 /* !! */ , var7_9, String.valueOf(var2_3.getLong("aftercallTime")));
            if (NotificationUtil.checkIfNotificationShouldShow(var0 /* !! */ , (Search)var1_2, var7_9) == false) return;
            if (var1_2 == null) return;
            v0 = var0 /* !! */ ;
            var3_4.ix0().B5B(var1_2.YYA(), var4_6, var7_9);
            var3_4 = v1;
            {
                v2 = var2_3;
                v3 = var3_4;
                v4 = var2_3;
                v5 = var3_4;
                v6 = v5;
                v7 = v5;
                v5(var0 /* !! */ , CallReminderNotificationReceiver.class);
                v5.putExtra("screen_type", var7_9);
            }
            {
                v6.putExtra("notificationId", var4_6);
            }
            {
                v7.putExtra("search", Search.xfp((Search)var1_2).toString());
            }
            {
                var0 /* !! */  = "screenName";
                v3.putExtra((String)var0 /* !! */ , v4.getString("screenName"));
            }
            {
                var0 /* !! */  = "phoneStateData";
                v1.putExtra((String)var0 /* !! */ , v2.getString("phoneStateData"));
            }
            {
                v1.setAction("com.calldorado.android.intent.NOTIFICATION_SHOW");
            }
            {
                var0 /* !! */  = PendingIntent.getBroadcast((Context)v0, (int)var4_6, (Intent)v1, (int)0xC000000);
                var1_2 = (AlarmManager)v0.getSystemService("alarm");
                if (var1_2 != null) ** GOTO lbl48
            }
            {
                com.calldorado.log.B5B.ix0(NotificationUtil.TAG, "Notification not scheduled -> alarmManager = null");
                return;
lbl48:
                // 1 sources

                var3_5 = Build.VERSION.SDK_INT;
                if (var3_5 < 23) ** GOTO lbl52
            }
            {
                block17: {
                    var1_2.setExactAndAllowWhileIdle(0, var5_8, (PendingIntent)var0 /* !! */ );
                    break block17;
lbl52:
                    // 1 sources

                    if (var3_5 >= 19) {
                        var1_2.setExact(0, var5_8, (PendingIntent)var0 /* !! */ );
                    } else {
                        var1_2.set(0, var5_8, (PendingIntent)var0 /* !! */ );
                    }
                }
                v8 = NotificationUtil.TAG;
                com.calldorado.log.B5B.esR(v8, "callDuration " + var2_3.getLong("callDuration"));
                com.calldorado.log.B5B.esR(v8, "screenType " + var7_9 + " " + var2_3.getString("screenName"));
                com.calldorado.log.B5B.esR(v8, "aftercallTime " + new Date(var2_3.getLong("aftercallTime")).toString());
                com.calldorado.log.B5B.esR(v8, "scheduleAfterCallNotification id = " + var4_6);
                return;
lbl63:
                // 1 sources

                com.calldorado.log.B5B.ix0(NotificationUtil.TAG, "Notification not scheduled -> delay = " + var4_6 + " typeEnabled = " + var8_10);
                return;
            }
        }
        com.calldorado.log.B5B.ix0(NotificationUtil.TAG, var0_1.getMessage());
    }

    /*
     * WARNING - void declaration
     */
    private static boolean checkIfNotificationShouldShow(Context context, Search search, int screenType) {
        boolean bl = true;
        for (String string2 : Arrays.asList(CalldoradoApplication.ix0(context).Mc1().ix0().xfp().split(";"))) {
            Context context2;
            void var2_2;
            void var1_1;
            if (var1_1 == null || !string2.contains(var1_1.YYA())) continue;
            bl = false;
            String[] stringArray = string2.split(",");
            if (stringArray.length <= 2 || !NotificationUtil.hasNotificationPriority((int)var2_2, Integer.parseInt(stringArray[2]))) continue;
            NotificationUtil.removeExistingNotification(context2, Integer.parseInt(stringArray[1]));
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean hasNotificationPriority(int newNotificationType, int oldNotificationType) {
        int n;
        void var1_1;
        if (newNotificationType == 3 && var1_1 != 3) {
            return true;
        }
        if (n == 4) {
            return var1_1 != 4 && var1_1 != 3;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isTypeEnabled(String config, int screenType) {
        String[] stringArray = config.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            void var1_2;
            String string2;
            try {
                string2 = stringArray[i];
            }
            catch (Exception exception) {}
            if (!string2.contains("types")) continue;
            if (!string2.contains(NotificationUtil.convertScreenTypeToKey((int)var1_2))) continue;
            return true;
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
            break;
        }
        return false;
    }

    public static int getItensAllowedPerTime(String config) {
        String[] stringArray = config.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            try {
                string2 = stringArray[i];
            }
            catch (Exception exception) {}
            if (!string2.contains("limit")) continue;
            return Math.abs(Integer.parseInt(string2.split("=")[1]));
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
            break;
        }
        return 0;
    }

    public static int getDelayInMinutes(String config) {
        String[] stringArray = config.split(";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2;
            try {
                string2 = stringArray[i];
            }
            catch (Exception exception) {}
            if (!string2.contains("delay")) continue;
            return Integer.parseInt(string2.split("=")[1]);
            com.calldorado.log.B5B.ix0(TAG, exception.getMessage());
            break;
        }
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateNotificationList(Context context, String screenKey, int index) {
        block10: {
            var0 = CalldoradoApplication.ix0(context).Mc1();
            var3_4 = var0.ix0().IoQ().split(",");
            var4_5 = v0;
            try {
                v0 = new ArrayList<String>();
                for (var5_6 = 0; var5_6 < var3_4.length; ++var5_6) {
                    if (var5_6 != var2_3) ** break block9
                    v1 = var4_5.add(var1_2);
                }
            }
            catch (Exception var0_1) {}
            {
                v1 = var4_5.add(var3_4[var5_6]);
                continue;
            }
            var1_2 = "";
            break block10;
            com.calldorado.log.B5B.ix0(NotificationUtil.TAG, var0_1.getMessage());
            return;
        }
        for (var2_3 = 0; var2_3 < var4_5.size(); ++var2_3) {
            var1_2 = var2_3 == 0 ? var1_2.concat((String)var4_5.get(var2_3)) : var1_2.concat(",").concat((String)var4_5.get(var2_3));
        }
        {
            var0.ix0().B5B(var1_2);
            com.calldorado.log.B5B.B5B(NotificationUtil.TAG, "updateNotificationList = " + var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int addNotificationToList(Context context, int type, String time) {
        Exception exception2;
        int n;
        block5: {
            void var2_3;
            ArrayList<String> arrayList;
            Context context2;
            n = -1;
            String[] stringArray = CalldoradoApplication.ix0(context2).Mc1().ix0().IoQ().split(",");
            String string2 = NotificationUtil.convertScreenTypeToKey(type);
            ArrayList<String> arrayList2 = arrayList;
            try {
                arrayList = new ArrayList<String>();
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList2.add(stringArray[i]);
                }
            }
            catch (Exception exception2) {}
            {
                continue;
            }
            int n2 = arrayList2.contains(FREE_SLOT) ? arrayList2.indexOf(FREE_SLOT) : NotificationUtil.getIndexToBeReplaced(stringArray, string2);
            break block5;
            n = n2;
            com.calldorado.log.B5B.B5B(TAG, "notificationId with less priority = " + n);
            NotificationUtil.updateNotificationList(context2, string2.concat(":").concat((String)var2_3), n);
            return n;
        }
        com.calldorado.log.B5B.ix0(TAG, exception2.getMessage());
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int getIndexToBeReplaced(String[] typeList, String screenKey) {
        void var1_2;
        String[] stringArray;
        ArrayList<Long> arrayList;
        ArrayList<String> arrayList2;
        ArrayList<String> arrayList3 = arrayList2;
        arrayList2 = new ArrayList<String>();
        ArrayList<Long> arrayList4 = arrayList;
        arrayList = new ArrayList<Long>();
        long[] lArray = new long[typeList.length];
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(":");
            arrayList3.add(stringArray2[0]);
            Long l = Long.valueOf(stringArray2[1]);
            lArray[i] = l;
            arrayList4.add(l);
        }
        void v3 = var1_2;
        Arrays.sort(lArray);
        v3.hashCode();
        int n2 = -1;
        switch (v3.hashCode()) {
            default: {
                break;
            }
            case 3314326: {
                if (!var1_2.equals("last")) break;
                n2 = 2;
                break;
            }
            case -934885341: {
                if (!var1_2.equals("redial")) break;
                n2 = 1;
                break;
            }
            case -1073880421: {
                if (!var1_2.equals("missed")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                if (!arrayList3.contains("last")) break;
                n = NotificationUtil.getOldestIndexFromScreen("last", lArray, arrayList4, arrayList3);
                break;
            }
            case 1: {
                if (arrayList3.contains("last")) {
                    n = NotificationUtil.getOldestIndexFromScreen("last", lArray, arrayList4, arrayList3);
                    break;
                }
                if (!arrayList3.contains("redial")) break;
                n = NotificationUtil.getOldestIndexFromScreen("redial", lArray, arrayList4, arrayList3);
                break;
            }
            case 0: {
                if (arrayList3.contains("last")) {
                    n = NotificationUtil.getOldestIndexFromScreen("last", lArray, arrayList4, arrayList3);
                    break;
                }
                if (arrayList3.contains("redial")) {
                    n = NotificationUtil.getOldestIndexFromScreen("redial", lArray, arrayList4, arrayList3);
                    break;
                }
                if (!arrayList3.contains("missed")) break;
                n = NotificationUtil.getOldestIndexFromScreen("missed", lArray, arrayList4, arrayList3);
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static int getOldestIndexFromScreen(String screenKey, long[] timeListOrdered, ArrayList timeListNew, ArrayList typeListNew) {
        void var1_1;
        for (int i = 0; i < ((void)var1_1).length; ++i) {
            void var3_3;
            String string2;
            void var2_2;
            int n = var2_2.indexOf((long)var1_1[i]);
            if (!string2.equals(var3_3.get(n))) continue;
            return n;
        }
        return -1;
    }

    private static String convertScreenTypeToKey(int screenType) {
        String string2 = "last";
        if (screenType != 3) {
            int n;
            if (n == 4) {
                string2 = "redial";
            }
        } else {
            string2 = "missed";
        }
        return string2;
    }

    private static int convertScreenKeyToType(String screenKey) {
        String string2 = screenKey;
        int n = 9;
        string2.hashCode();
        if (!string2.equals("missed")) {
            String string3;
            if (string3.equals("redial")) {
                n = 4;
            }
        } else {
            n = 3;
        }
        return n;
    }
}

