/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.app.Activity;
import android.app.Dialog;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.core.app.ActivityCompat;
import com.calldorado.CalldoradoApplication;
import com.calldorado.data.Country;
import com.calldorado.log.B5B;
import com.calldorado.permissions.esR;
import com.calldorado.search.Search;
import com.calldorado.search.data_models.Address;
import com.calldorado.search.data_models.Item;
import com.calldorado.search.data_models.Phone;
import com.calldorado.search.manual_search.CDOPhoneNumber;
import com.calldorado.search.manual_search.CDOSearchProcessListener;
import com.calldorado.translations.F2S;
import com.calldorado.ui.aftercall.CallerIdActivity;
import com.calldorado.util.CustomizationUtil;
import com.calldorado.util.GenericCompletedListener;
import com.calldorado.util.IntentUtil;
import com.calldorado.util.PermissionsUtil;
import com.calldorado.util.Util;
import com.calldorado.util.constants.EmergencyNumbers;
import com.calldorado.util.constants.PhoneCountryCodeHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TelephonyUtil {
    private static final String TAG = "TelephonyUtil";
    private static HashMap<String, String> countryNameTableMap;
    private static HashMap<String, String> isoCountryNameMap;
    private static HashMap<Integer, String> mccCodeTable;
    public static HashMap<String, Integer> countryCodeTableMap;
    private static List<Country> allCountries;
    private static final String HUAWEI_MANUFACTURE = "HUAWEI";

    public static String normalizePhone(String phone) {
        String string2;
        if (phone == null) {
            return null;
        }
        int n = (string2 = string2.replace(" ", "").replace("-", "").replace("(", "").replace(")", "")).lastIndexOf("*");
        if (n != -1) {
            string2 = string2 + string2.substring(0, n);
        }
        if (string2.startsWith("000")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static String normalizePhoneForWic(String phone) {
        String string2;
        if (phone == null) {
            return null;
        }
        int n = (string2 = string2.replace("-", "").replace("(", "").replace(")", "")).lastIndexOf("*");
        if (n != -1) {
            string2 = string2 + string2.substring(0, n);
        }
        if (string2.startsWith("000")) {
            string2 = string2.substring(2);
        }
        return string2;
    }

    public static String trimHiddenNumber(String phone) {
        String string2;
        if (phone != null) {
            if (string2.startsWith("0#")) {
                int n = (string2 = string2.substring(2)).indexOf("#");
                if (n != -1) {
                    string2 = n == string2.length() ? "" : string2.substring(n + 1);
                }
            } else if (string2.startsWith("*") || string2.startsWith("#")) {
                int n = (string2 = string2.substring(1)).indexOf("#");
                if (n == -1) {
                    n = string2.indexOf("*");
                }
                if (n != -1) {
                    string2 = n == string2.length() ? "" : string2.substring(n + 1);
                }
            }
        }
        return string2;
    }

    public static boolean isHiddenPhone(String phone) {
        String string2;
        return phone == null || string2.length() == 0 || string2.compareTo("-1") == 0 || string2.compareTo("(-1)") == 0 || string2.compareTo("-2") == 0 || string2.compareTo("(-2)") == 0;
    }

    public static boolean comparePhones(String phone1, String phone2) {
        String string2;
        if (phone1 != null && string2 != null) {
            String string3;
            String string4;
            string4 = TelephonyUtil.normalizePhone(string4);
            string2 = TelephonyUtil.normalizePhone(string2);
            if (string4.length() > 6) {
                String string5 = string4;
                string3 = string5.substring(string5.length() - 6);
            } else {
                string3 = string4;
            }
            if (string3.length() < 6 && string2.compareTo(string3) == 0) {
                return true;
            }
            if (string3.length() >= 6 && string2.contains(string3)) {
                return true;
            }
            if (string2.length() > 6) {
                String string6 = string2;
                string2 = string6.substring(string6.length() - 6);
            }
            if (string2.length() < 6 && string4.compareTo(string2) == 0) {
                return true;
            }
            if (string2.length() >= 6 && string4.contains(string2)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidPhoneNumber(String phoneNumber) {
        if (phoneNumber != null) {
            String string2;
            for (int i = 0; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c < '0' || c > '9') continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isIncorrectLength(String phoneNumber) {
        String string2;
        return phoneNumber == null || TextUtils.isEmpty((CharSequence)string2) || string2.length() >= 128;
    }

    public static boolean hasIllegalChars(String phoneNumber) {
        return phoneNumber.split("[:!\";<>=|&?]", 2).length > 1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean hasInputErrors(CDOPhoneNumber cdoPhoneNumber, CDOSearchProcessListener cdoSearchProcessListener) {
        void var1_1;
        CDOPhoneNumber cDOPhoneNumber;
        if (cdoPhoneNumber != null && cDOPhoneNumber.getPhoneNumber() != null) {
            if (!TelephonyUtil.isIncorrectLength(cDOPhoneNumber.getPhoneNumber())) {
                if (!TelephonyUtil.hasIllegalChars(cDOPhoneNumber.getPhoneNumber())) {
                    return false;
                }
                try {
                    throw new Exception("Phonenumber contains illegal characters");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (var1_1 != null) {
                        var1_1.onSearchFailed("ERROR_PHONENUMBER_CONTAINS_ILLEGAL_CHARS");
                    }
                    return true;
                }
            }
            try {
                throw new Exception("Phonenumber is not correct length");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (var1_1 != null) {
                    var1_1.onSearchFailed("ERROR_PHONENUMBER_INCORRECT_LENGTH");
                }
                return true;
            }
        }
        if (var1_1 != null) {
            var1_1.onSearchFailed("ERROR_PHONENUMBER_NULL");
        }
        return true;
    }

    public static boolean hasReadCallLogPermission(Context context) {
        Context context2;
        String string2 = Build.MANUFACTURER;
        String string3 = TAG;
        B5B.B5B(string3, "model is = " + string2);
        if (string2.equals(HUAWEI_MANUFACTURE)) {
            return false;
        }
        int n = context2.getApplicationContext().checkCallingOrSelfPermission("android.permission.READ_CALL_LOG");
        B5B.B5B(string3, "Permission to read from log: " + n);
        return n == 0;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEmergenzyNumber(String mcc, String number) {
        void var1_1;
        String[] stringArray;
        B5B.B5B(TAG, "mcc = " + (String)stringArray + " : number = " + (String)var1_1);
        boolean bl = false;
        if (number != null && stringArray != null && (stringArray = EmergencyNumbers.emergencyMap.get(stringArray)) != null) {
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (!stringArray[i].equals(var1_1)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static String printIntentExtra(Intent intent) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        Bundle bundle = intent.getExtras();
        int n = 0;
        if (bundle != null) {
            for (String string2 : bundle.keySet()) {
                Intent intent2;
                stringBuilder2.append(string2).append("=").append(intent2.getExtras().get(string2));
                if (n++ == bundle.size() - 1) continue;
                stringBuilder2.append(",");
            }
        }
        return stringBuilder2.toString();
    }

    public static int getPhoneState(Intent intent) {
        Object object;
        int n = 0;
        if (intent.getExtras() != null && object.getExtras().getString("state") != null) {
            object = object.getExtras().getString("state");
            B5B.B5B(TAG, "TelephonyManager.EXTRA_STATE: " + (String)object);
            if (TelephonyManager.EXTRA_STATE_IDLE.equals(object)) {
                n = 0;
            } else if (TelephonyManager.EXTRA_STATE_OFFHOOK.equals(object)) {
                n = 2;
            } else if (TelephonyManager.EXTRA_STATE_RINGING.equals(object)) {
                n = 1;
            }
        }
        return n;
    }

    public static String getPhoneStateString(int state) {
        int n;
        return state != 0 ? (n != 1 ? (n != 2 ? TelephonyManager.EXTRA_STATE_IDLE : TelephonyManager.EXTRA_STATE_OFFHOOK) : TelephonyManager.EXTRA_STATE_RINGING) : TelephonyManager.EXTRA_STATE_IDLE;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNotIdleState(int previousState, int currentState) {
        void var1_1;
        int n;
        return currentState != 0 && TelephonyUtil.isFirstStateChange(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isIdleState(int previousState, int currentState) {
        void var1_1;
        int n;
        return currentState == 0 && TelephonyUtil.isFirstStateChange(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFirstStateChange(int previousState, int currentState) {
        void var1_1;
        return previousState != var1_1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isDeviceLocked(Context context) {
        Context context2;
        boolean bl = false;
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        if (keyguardManager != null && keyguardManager.inKeyguardRestrictedInputMode()) {
            bl = true;
        }
        context2 = (PowerManager)context2.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 20) {
            if (context2 == null) return bl;
            if (context2.isInteractive()) return bl;
            return true;
        }
        if (context2 == null) return bl;
        if (context2.isScreenOn()) return bl;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFirstBroadcast(int previousState, int currentState) {
        int n;
        void var1_1;
        return TelephonyUtil.isNotIdleState(previousState, (int)var1_1) && n != 1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isFirstBroadcast(String previousState, String currentState) {
        void var1_1;
        String string2;
        return !Objects.equals(currentState, TelephonyManager.EXTRA_STATE_IDLE) && !Objects.equals(string2, var1_1) && !Objects.equals(string2, TelephonyManager.EXTRA_STATE_RINGING);
    }

    /*
     * WARNING - void declaration
     */
    public static String getPhoneNumberISO(Context context, String phoneNumber) {
        try {
            void var1_1;
            int n = Integer.parseInt(TelephonyUtil.splitPhoneNumber(context, (String)var1_1)[1]);
            Object object = n;
            if (n != -1) {
                if (mccCodeTable == null) {
                    mccCodeTable = new PhoneCountryCodeHolder().getMccCodeTable();
                }
                if (mccCodeTable.containsKey(object)) {
                    return mccCodeTable.get(object);
                }
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean isPhoneNumberInEEA(Context context, String phoneNumber) {
        Object object;
        int n;
        String string2;
        try {
            int n2 = Integer.parseInt(TelephonyUtil.splitPhoneNumber(context, string2)[1]);
            n = n2;
            object = n2;
            string2 = Util.TAG;
        }
        catch (Exception exception) {
            return false;
        }
        B5B.B5B(string2, "isPhoneNumberInEEA()     numberPrefix = " + object);
        if (n != -1) {
            if (mccCodeTable == null) {
                mccCodeTable = new PhoneCountryCodeHolder().getMccCodeTable();
            }
            if (mccCodeTable.containsKey(object)) {
                object = mccCodeTable.get(object);
                B5B.B5B(string2, "isPhoneNumberInEEA()    cc = " + (String)object);
                if (object != null && !((String)object).isEmpty() && (((String)(object = ((String)object).toUpperCase())).equals("AT") || ((String)object).equals("BE") || ((String)object).equals("BG") || ((String)object).equals("HR") || ((String)object).equals("CY") || ((String)object).equals("CZ") || ((String)object).equals("DK") || ((String)object).equals("EE") || ((String)object).equals("FI") || ((String)object).equals("FR") || ((String)object).equals("DE") || ((String)object).equals("GR") || ((String)object).equals("HU") || ((String)object).equals("IE") || ((String)object).equals("IT") || ((String)object).equals("LV") || ((String)object).equals("LT") || ((String)object).equals("LU") || ((String)object).equals("MT") || ((String)object).equals("NL") || ((String)object).equals("PL") || ((String)object).equals("PT") || ((String)object).equals("RO") || ((String)object).equals("SK") || ((String)object).equals("SI") || ((String)object).equals("ES") || ((String)object).equals("SE") || ((String)object).equals("GB") || ((String)object).equals("IS") || ((String)object).equals("LI") || ((String)object).equals("NO"))) {
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static Country getSimCountry(Context context) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 53->61)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<Country> getAllCountries() {
        ArrayList<Country> arrayList;
        ArrayList<Country> arrayList2 = arrayList;
        arrayList = new ArrayList<Country>();
        if (allCountries != null) {
            B5B.B5B(Util.TAG, "getAllCountries()     reusing country list to reduce ANRs");
            return allCountries;
        }
        B5B.B5B(Util.TAG, "getAllCountries()     failed reusing country list ");
        TelephonyUtil.createIsoCountryNameMap();
        if (countryNameTableMap == null || countryCodeTableMap == null) {
            TelephonyUtil.initPhoneMaps();
        }
        Iterator<Map.Entry<String, String>> iterator = countryNameTableMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Country country;
            String string2 = iterator.next().getValue();
            if (TextUtils.isEmpty((CharSequence)string2)) continue;
            Country country2 = country;
            String string3 = string2;
            if (!new Country(string3, TelephonyUtil.getIsoCountryName(string3.toUpperCase()), countryCodeTableMap.get(string2).toString()).H1u()) continue;
            arrayList2.add(country2);
        }
        allCountries = arrayList2;
        return allCountries;
    }

    public static String getPhonePrefix(String countryCode) {
        if (!TextUtils.isEmpty((CharSequence)countryCode)) {
            String string2;
            if (countryCodeTableMap == null) {
                countryCodeTableMap = new PhoneCountryCodeHolder().getCountryCodeTable();
            }
            if (countryCodeTableMap.containsKey(string2)) {
                return countryCodeTableMap.get(string2) + "";
            }
            return null;
        }
        return null;
    }

    private static void createIsoCountryNameMap() {
        isoCountryNameMap = new HashMap();
        for (String string2 : Locale.getISOCountries()) {
            String string3 = new Locale("", string2).getDisplayCountry();
            if (string2 == null || string3 == null) continue;
            isoCountryNameMap.put(string2, string3);
        }
    }

    private static void initPhoneMaps() {
        PhoneCountryCodeHolder phoneCountryCodeHolder = new PhoneCountryCodeHolder();
        countryCodeTableMap = phoneCountryCodeHolder.getCountryCodeTable();
        countryNameTableMap = phoneCountryCodeHolder.getCountryNameTable();
    }

    private static String getIsoCountryName(String countryCode) {
        String string2;
        HashMap<String, String> hashMap = isoCountryNameMap;
        if (hashMap != null) {
            return hashMap.get(string2);
        }
        TelephonyUtil.createIsoCountryNameMap();
        return isoCountryNameMap.get(string2);
    }

    /*
     * WARNING - void declaration
     */
    public static String getPhoneNo(Context context, String phoneNo, Search search, String prefix, boolean fromNotification) {
        String string2;
        String string3;
        block15: {
            String string4;
            void var2_6;
            block14: {
                block12: {
                    block13: {
                        Context context2;
                        if (!fromNotification && !CalldoradoApplication.ix0(context2).ETk().esR().equals(CalldoradoApplication.ix0(context2).ETk().ix0())) {
                            B5B.B5B(Util.TAG, "getPhoneNo: Using formatted number from the server");
                            return CalldoradoApplication.ix0(context2).ETk().ix0();
                        }
                        string3 = Util.TAG;
                        B5B.B5B(string3, "getPhoneNo()    phoneNo = " + string2);
                        if (var2_6 == null) break block12;
                        string4 = null;
                        if (var2_6.xfp() != null && !var2_6.xfp().isEmpty() && var2_6.xfp().get(0) != null && ((Item)var2_6.xfp().get(0)).KUB() != null && !((Item)var2_6.xfp().get(0)).KUB().isEmpty() && ((Item)var2_6.xfp().get(0)).KUB().get(0) != null) {
                            string4 = ((Phone)((Item)var2_6.xfp().get(0)).KUB().get(0)).ix0();
                        }
                        if (string4 == null || string4.equals(string2)) break block13;
                        string4 = TelephonyUtil.getCountryZipCode(string2, (Search)var2_6, context2);
                        B5B.B5B(string3, "search.phoneNo = " + ((Item)var2_6.xfp().get(0)).KUB() + ",        countryZipCode = " + string4);
                        break block14;
                    }
                    return string2;
                }
                if (string4 == null) break block15;
                B5B.B5B(string3, "prefix not null");
                string2 = '+' + string4 + string2;
            }
            if (string2 != null) {
                B5B.B5B(string3, "phoneNo not null");
                if (var2_6 != null) {
                    if (!string2.isEmpty()) {
                        if (string2.charAt(0) == '+') {
                            if (!string4.isEmpty() && string2.substring(1, string4.length() + 1).equals(string4)) {
                                String string5 = "(" + string2;
                                int n = string4.length() + 2;
                                string2 = string5.substring(0, n);
                                String string6 = string2 + ")";
                                return string6 + string5.substring(n);
                            }
                        } else if (string2.length() > 3 && string2.startsWith("00") && string2.substring(2, string4.length() + 2).equals(string4)) {
                            String string7 = "(" + string2;
                            int n = string4.length() + 3;
                            B5B.B5B(string3, "First space index: " + n);
                            string2 = string7.substring(0, n);
                            B5B.B5B(string3, "Pre space string: " + string2);
                            String string8 = string2 + ")";
                            return string8 + " " + string7.substring(n);
                        }
                    }
                    return string2;
                }
                return string2;
            }
            return string2;
        }
        B5B.B5B(string3, "returning number as defined by server");
        return string2;
    }

    public static String getCountryZipCode(String phoneNo, Search search, Context context) {
        String string2;
        String string3 = "";
        if (phoneNo != null && string2.length() > 1) {
            Object object;
            Object object2;
            string2 = null;
            if (object2 != null && Search.H1u((Search)object2) && ((Search)object2).xfp() != null && ((Search)object2).xfp().size() > 0 && ((Item)((Search)object2).xfp().get(0)).B5B() != null && ((Item)((Search)object2).xfp().get(0)).B5B().size() > 0) {
                string2 = ((Address)((Item)((Search)object2).xfp().get(0)).B5B().get(0)).esR();
                B5B.B5B(Util.TAG, "getCountryZipCode()     country = " + string2);
            }
            for (Country country : TelephonyUtil.getAllCountries()) {
                if ((string2 == null || country == null || country.B5B() == null || !country.B5B().toLowerCase().equals(string2.toLowerCase())) && (string2 == null || country == null || country.esR() == null || !country.esR().toLowerCase().equals(string2.toLowerCase()))) continue;
                string2 = country.ix0();
                B5B.B5B(Util.TAG, "getCountryZipCode()    zipCode found in loop1    zip = " + string2);
                return string2;
            }
            object2 = "";
            if ((object = TelephonyUtil.getSimCountry((Context)object)) != null) {
                object2 = ((Country)object).B5B();
            }
            for (Country country : TelephonyUtil.getAllCountries()) {
                if ((string2 == null || country == null || country.B5B() == null || !country.B5B().toLowerCase().equals(((String)object2).toLowerCase())) && (string2 == null || country == null || country.esR() == null || !country.esR().toLowerCase().equals(((String)object2).toLowerCase()))) continue;
                string3 = country.ix0();
                B5B.B5B(Util.TAG, "getCountryZipCode()    zipCode found in loop2    zip = " + string3);
            }
        }
        return string3;
    }

    /*
     * Exception decompiling
     */
    public static Country extractCountryFromNumber(Context context, Search search, String phoneNo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [7 : 350->364)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     */
    public static String[] splitPhoneNumber(Context context, String number) {
        void var1_1;
        Object object = TelephonyUtil.getCleanPhoneNo(context, (String)var1_1);
        B5B.B5B(Util.TAG, "fullNumber = " + (String)object);
        if (object != null && ((String)object).contains(";")) {
            if (((String[])(object = ((String)object).split(";"))).length == 1) {
                object = object[0];
                return new String[]{object, ""};
            }
            return object;
        }
        if (object != null) {
            return new String[]{"", object};
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getCleanPhoneNo(Context context, String phone1) {
        void object2;
        String string2 = Util.TAG;
        B5B.B5B(string2, "getCleanPhoneNo()    phone1 = " + (String)object2);
        String string3 = null;
        if (phone1 != null && !object2.isEmpty()) {
            string3 = object2.charAt(0) == '+' ? '+' + object2.substring(1).replaceAll("\\s+", "") : object2.replaceAll("\\s+", "");
        }
        if (countryCodeTableMap == null) {
            countryCodeTableMap = new PhoneCountryCodeHolder().getCountryCodeTable();
        }
        B5B.B5B(string2, "getCleanPhoneNo()    phone = " + string3);
        if (string3 != null) {
            if (string3.length() > 1) {
                String string4 = "";
                if (string3.charAt(0) != '+' && !string3.substring(0, 2).equals("00") && string3.charAt(0) != '(') {
                    void var1_4;
                    B5B.B5B(string2, "getCleanPhoneNo()    phone3 = ");
                    if (TelephonyUtil.getSimCountry((Context)var0) != null) {
                        try {
                            String string5 = TelephonyUtil.getSimCountry((Context)var0).ix0();
                        }
                        catch (NullPointerException nullPointerException) {
                            B5B.B5B(Util.TAG, "getCleanNo()   phone = " + string3);
                            return string3;
                        }
                    }
                    B5B.B5B(string2, "getCleanNo()   phone + \";\" + countryZipCode = " + string3 + ";" + (String)var1_4);
                    return string3 + ";" + (String)var1_4;
                }
                for (Map.Entry entry : countryCodeTableMap.entrySet()) {
                    int n;
                    int n2;
                    int n3;
                    String string6 = entry.getValue() + "";
                    if (string3.charAt(0) == '+' && string3.length() > string6.length() && string3.substring(1, n3 = string6.length() + 1).equals(string6)) {
                        return string3.substring(string6.length() + 1) + ";" + string6;
                    }
                    if (string3.substring(0, 2).equals("00") && string3.length() > string6.length() + 1 && string3.substring(2, n2 = string6.length() + 2).equals(string6)) {
                        return string3.substring(string6.length() + 2) + ";" + string6;
                    }
                    if (string3.charAt(0) != '(' || !string3.contains(")") || string3.length() <= string3.indexOf(41) || !string3.substring(0, n = string3.indexOf(41)).contains(string6)) continue;
                    B5B.B5B(Util.TAG, "getCleanNo()   phone.substring(phone.indexOf(')') + 1) + \";\" + countryZipCode = " + string3.substring(string3.indexOf(41) + 1) + ";" + string6);
                    return string3.substring(string3.indexOf(41) + 1) + ";" + string6;
                }
            } else {
                void var1_10;
                String string7 = "";
                if (TelephonyUtil.getSimCountry((Context)var0) != null) {
                    try {
                        String string8 = TelephonyUtil.getSimCountry((Context)var0).ix0();
                    }
                    catch (NullPointerException nullPointerException) {
                        B5B.B5B(Util.TAG, "getCleanNo()   phone = " + string3);
                        return string3;
                    }
                }
                return string3 + ";" + (String)var1_10;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getForeignCountryName(Context context, String phone, boolean returnNullOnSimCountry) {
        Object object;
        String string2;
        String string3;
        String string4;
        block14: {
            String string5;
            void v0;
            void var1_1;
            string4 = null;
            try {
                void var2_2;
                String[] stringArray = TelephonyUtil.splitPhoneNumber(context, (String)var1_1);
                string3 = null;
                string2 = null;
                if (stringArray != null) {
                    string3 = stringArray[1];
                }
                v0 = var2_2;
                string5 = Util.TAG;
            }
            catch (Exception exception) {
                return string4;
            }
            B5B.B5B(string5, "getForeignCountryName()    phoneNumber = " + (String)var1_1 + ",      prefix = " + string3);
            if (v0 != false) {
                if (string3 == null) return null;
                if (string3.equals(TelephonyUtil.getSimCountry(object).ix0())) {
                    return null;
                }
            }
            if (countryCodeTableMap == null) {
                countryCodeTableMap = new PhoneCountryCodeHolder().getCountryCodeTable();
            }
            if (mccCodeTable == null) {
                mccCodeTable = new PhoneCountryCodeHolder().getMccCodeTable();
            }
            B5B.B5B(string5, "zipOk: " + string3);
            if (string3 == null) return string4;
            object = null;
            try {
                object = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {}
            if (object == null) break block14;
            if (mccCodeTable.containsKey(object)) {
                string2 = mccCodeTable.get(object);
            }
        }
        string4 = new Locale("", string2).getDisplayCountry();
        B5B.B5B(Util.TAG, "extracted countryCode: " + string3 + ",     countryName: " + string4 + ",      phoneZipCode = " + object);
        return string4;
    }

    public static boolean isCountryInEEA(Context context) {
        Object object;
        String string2 = "";
        try {
            string2 = ((TelephonyManager)context.getSystemService("phone")).getSimCountryIso();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            try {
                string2 = ((TelephonyManager)object.getSystemService("phone")).getNetworkCountryIso();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            try {
                string2 = object.getResources().getConfiguration().locale.getCountry();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        B5B.B5B(Util.TAG, "isCountryInEEA code " + string2);
        return !TextUtils.isEmpty((CharSequence)string2) && (((String)(object = string2.toUpperCase())).equals("AT") || ((String)object).equals("BE") || ((String)object).equals("BG") || ((String)object).equals("HR") || ((String)object).equals("CY") || ((String)object).equals("CZ") || ((String)object).equals("DK") || ((String)object).equals("EE") || ((String)object).equals("FI") || ((String)object).equals("FR") || ((String)object).equals("DE") || ((String)object).equals("GR") || ((String)object).equals("HU") || ((String)object).equals("IE") || ((String)object).equals("IT") || ((String)object).equals("LV") || ((String)object).equals("LT") || ((String)object).equals("LU") || ((String)object).equals("MT") || ((String)object).equals("NL") || ((String)object).equals("PL") || ((String)object).equals("PT") || ((String)object).equals("RO") || ((String)object).equals("SK") || ((String)object).equals("SI") || ((String)object).equals("ES") || ((String)object).equals("SE") || ((String)object).equals("GB") || ((String)object).equals("IS") || ((String)object).equals("LI") || ((String)object).equals("NO"));
    }

    public static boolean isUserInUSA(Context context) {
        Context context2;
        String string2 = "";
        try {
            string2 = ((TelephonyManager)context.getSystemService("phone")).getSimCountryIso();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            try {
                string2 = ((TelephonyManager)context2.getSystemService("phone")).getNetworkCountryIso();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            try {
                string2 = context2.getResources().getConfiguration().locale.getCountry();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        B5B.B5B(Util.TAG, "isUserInUSA: cc:" + string2);
        return !TextUtils.isEmpty((CharSequence)string2) && string2.toUpperCase().equals("US");
    }

    /*
     * WARNING - void declaration
     */
    public static String getCountryLocaleTranslated(Context context, String countryZipCode, boolean returnNullOnSimCountry) {
        Object object;
        void var1_1;
        if (countryZipCode != null && !var1_1.isEmpty() && !var1_1.equals(TelephonyUtil.getSimCountry(object).ix0())) {
            object = new Locale("", (String)var1_1).getDisplayCountry();
            B5B.B5B(Util.TAG, "Translated countryName: " + (String)object);
            return object;
        }
        return null;
    }

    public static void handleCallClick(Activity context, String phoneNumber) {
        Object object;
        String[] stringArray;
        String string2 = CallerIdActivity.vR_;
        B5B.B5B(string2, "oncall clicked phoneNumber=" + (String)stringArray);
        if (phoneNumber != null && !stringArray.isEmpty()) {
            int n;
            try {
                n = object.getPackageManager().getPackageInfo((String)object.getPackageName(), (int)0).applicationInfo.targetSdkVersion;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                B5B.B5B(CallerIdActivity.vR_, "NameNotFoundException: " + nameNotFoundException.getMessage());
                n = 23;
            }
            int n2 = Build.VERSION.SDK_INT;
            if (n2 >= 23 && n >= 23) {
                Object object2 = CallerIdActivity.vR_;
                B5B.B5B((String)object2, "On android M");
                if (esR.esR(object.getApplicationContext(), "android.permission.READ_PHONE_STATE")) {
                    GenericCompletedListener genericCompletedListener;
                    B5B.B5B((String)object2, "On android M - On has permissions");
                    object2 = genericCompletedListener;
                    genericCompletedListener = new GenericCompletedListener((Activity)object){
                        final /* synthetic */ Activity val$context;
                        {
                            this.val$context = activity;
                        }

                        public void onComplete(Object onCallFailed) {
                            Activity activity = this.val$context;
                            Toast.makeText((Context)activity, (CharSequence)F2S.B5B((Context)activity)._ge, (int)0).show();
                        }
                    };
                    IntentUtil.callIntent((Context)object, (String)stringArray, (GenericCompletedListener)object2);
                    object.finish();
                } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)object, (String)"android.permission.READ_PHONE_STATE")) {
                    IntentUtil.goToSettings((Activity)object);
                } else {
                    ArrayList<String> arrayList;
                    B5B.B5B((String)object2, "On android M - On needs permissions");
                    object = arrayList;
                    new ArrayList<String>().add("android.permission.READ_PHONE_STATE");
                    ActivityCompat.requestPermissions((Activity)CallerIdActivity.F2S(), (String[])((ArrayList)object).toArray(new String[1]), (int)68);
                }
            } else {
                String string3 = CallerIdActivity.vR_;
                B5B.B5B(string3, "Under android M");
                if (esR.esR(object.getApplicationContext(), "android.permission.READ_PHONE_STATE")) {
                    GenericCompletedListener genericCompletedListener;
                    B5B.B5B(string3, "Under android M - has permission, phone=" + (String)stringArray + " targetSdkVersion=" + n + ", Build.VERSION.SDK_INT=" + n2);
                    GenericCompletedListener genericCompletedListener2 = genericCompletedListener;
                    genericCompletedListener = new GenericCompletedListener((Activity)object){
                        final /* synthetic */ Activity val$context;
                        {
                            this.val$context = activity;
                        }

                        public void onComplete(Object onCallFailed) {
                            Activity activity = this.val$context;
                            Toast.makeText((Context)activity, (CharSequence)F2S.B5B((Context)activity)._ge, (int)0).show();
                        }
                    };
                    IntentUtil.callIntent((Context)object, (String)stringArray, genericCompletedListener2);
                    object.finish();
                } else if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)object, (String)"android.permission.READ_PHONE_STATE")) {
                    IntentUtil.goToSettings((Activity)object);
                } else {
                    ArrayList<String> arrayList;
                    B5B.B5B(string3, "Under android M - needs permission");
                    object = arrayList;
                    new ArrayList<String>().add("android.permission.READ_PHONE_STATE");
                    ActivityCompat.requestPermissions((Activity)CallerIdActivity.F2S(), (String[])((ArrayList)object).toArray(new String[1]), (int)68);
                }
            }
            return;
        }
        stringArray = new StringBuilder().append("onCall()   number is empty     device = ");
        int n = Build.VERSION.SDK_INT;
        B5B.B5B(string2, stringArray.append(n).toString());
        if (n >= 28 && PermissionsUtil.isPermissionOnManifest((Context)object, "android.permission.READ_CALL_LOG") && !esR.esR((Context)object, "android.permission.READ_CALL_LOG")) {
            B5B.B5B(string2, "onCall() 1");
            if (object.shouldShowRequestPermissionRationale("android.permission.READ_CALL_LOG")) {
                B5B.B5B(string2, "onCall() 2");
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "android.permission.READ_CALL_LOG";
                ActivityCompat.requestPermissions((Activity)object, (String[])stringArray, (int)70);
            } else {
                CustomizationUtil.MaterialDialogListener materialDialogListener;
                B5B.B5B(string2, "onCall() 3");
                stringArray = F2S.B5B((Context)object).RPA;
                string2 = F2S.B5B((Context)object).WW_;
                String string4 = F2S.B5B((Context)object).E6h;
                CustomizationUtil.MaterialDialogListener materialDialogListener2 = materialDialogListener;
                materialDialogListener = new CustomizationUtil.MaterialDialogListener((Activity)object){
                    final /* synthetic */ Activity val$context;
                    {
                        this.val$context = activity;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void onButtonYes(Dialog dialog) {
                        void var1_1;
                        Intent intent;
                        Intent intent2;
                        Intent intent3 = intent2 = intent;
                        intent3();
                        intent3.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                        intent.setData(Uri.fromParts((String)"package", (String)this.val$context.getPackageName(), null));
                        this.val$context.startActivity(intent2);
                        if (dialog != null && var1_1.isShowing()) {
                            var1_1.dismiss();
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void onButtonNo(Dialog dialog) {
                        void var1_1;
                        if (dialog != null && var1_1.isShowing()) {
                            var1_1.dismiss();
                        }
                    }
                };
                CustomizationUtil.getMaterialDesignDialog((Activity)object, "", (String)stringArray, string2, string4, materialDialogListener2).show();
            }
        } else {
            Intent intent;
            B5B.B5B(string2, "onCall() 4");
            stringArray = intent;
            intent = new Intent("android.intent.action.DIAL");
            object.startActivity((Intent)stringArray);
        }
    }
}

