/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.Html;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.FontRes;
import androidx.annotation.NonNull;
import com.calldorado.CalldoradoApplication;
import com.calldorado.log.B5B;
import com.calldorado.ui.views.SvgFontView;
import com.calldorado.ui.views.custom.CalldoradoCustomView;
import com.calldorado.util.AppUtils;
import com.calldorado.util.CustomizationUtil;
import com.calldorado.util.DeviceUtil;
import com.calldorado.util.GenericCompletedListener;
import com.calldorado.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;

public class ViewUtil {
    public static final String NO_COLOR = "#00000000";
    public static final String SELECTED_COLOR = "#D4D4D4";
    private static final String TAG = "ViewUtil";
    public static final String RIPPLE_COLOR_NORMAL = "#D1D1D1";
    public static final String RIPPLE_COLOR_FOCUSED = "#B3B3B3";
    public static final String RIPPLE_COLOR_PRESSED = "#8A8A8A";
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    /*
     * WARNING - void declaration
     */
    public static void setRipple(Context context, View v, boolean isBorderless) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var2_2;
            Context context2;
            void var1_1;
            var1_1.setBackground(ViewUtil.getColorRippleDrawable(context2.getApplicationContext(), (View)var1_1, Color.parseColor((String)RIPPLE_COLOR_PRESSED), (boolean)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setRipple(Context context, View view, int rippleColor, boolean isBorderless) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var3_3;
            void var2_2;
            Context context2;
            void var1_1;
            var1_1.setBackground(ViewUtil.getColorRippleDrawable2(context2.getApplicationContext(), (View)var1_1, (int)var2_2, (boolean)var3_3));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setRipple(Context context, View v, boolean isBorderless, int pressedColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var2_2;
            void var3_3;
            Context context2;
            void var1_1;
            var1_1.setBackground(ViewUtil.getColorRippleDrawable(context2.getApplicationContext(), (View)var1_1, (int)var3_3, (boolean)var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable convertBitmapToDrawable(Context context, Bitmap bitmap) {
        void var1_1;
        Context context2;
        return new BitmapDrawable(context2.getResources(), (Bitmap)var1_1);
    }

    public static Bitmap getRoundCornerBitmap(Bitmap bitmap, int radius) {
        Rect rect;
        RectF rectF;
        Paint paint;
        Canvas canvas;
        Bitmap bitmap2;
        int n;
        if (bitmap == null) {
            void v0 = n;
            return Bitmap.createBitmap((int)v0, (int)v0, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        int n2 = bitmap2.getWidth();
        int n3 = bitmap2.getHeight();
        Bitmap bitmap3 = Bitmap.createBitmap((int)n2, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap bitmap4 = bitmap3;
        Bitmap bitmap5 = bitmap2;
        Canvas canvas2 = canvas;
        Bitmap bitmap6 = bitmap2;
        canvas2(bitmap4);
        bitmap4 = paint;
        Bitmap bitmap7 = bitmap2;
        bitmap4(1);
        bitmap2 = rectF;
        float f = n2;
        float f2 = n3;
        rectF = new RectF(0.0f, 0.0f, f, f2);
        float f3 = n;
        canvas2.drawRoundRect((RectF)bitmap2, f3, f3, (Paint)bitmap4);
        PorterDuff.Mode mode = PorterDuff.Mode.SRC_IN;
        bitmap4.setXfermode((Xfermode)new PorterDuffXfermode(mode));
        canvas2.drawBitmap(bitmap7, null, (RectF)bitmap2, (Paint)bitmap4);
        Rect rect2 = rect;
        void v10 = n;
        n = n3 - n;
        rect = new Rect((int)v10, 0, n2, n);
        bitmap4.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        canvas2.drawRect(rect2, (Paint)bitmap4);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(mode));
        canvas.drawBitmap(bitmap6, null, (RectF)bitmap2, (Paint)bitmap4);
        bitmap5.recycle();
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable changeDrawableColor(Drawable drawable2, int color2) {
        Drawable drawable3;
        void var1_1;
        LightingColorFilter lightingColorFilter;
        LightingColorFilter lightingColorFilter2 = lightingColorFilter;
        lightingColorFilter = new LightingColorFilter(Color.parseColor((String)"#FF000000"), (int)var1_1);
        if (drawable2 != null) {
            drawable3.setColorFilter((ColorFilter)lightingColorFilter2);
        }
        return drawable3;
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable cloneDrawable(Drawable drawable2, int color2) {
        void var1_1;
        Drawable drawable3 = drawable2.getConstantState().newDrawable().mutate();
        drawable3.setColorFilter((ColorFilter)new LightingColorFilter(Color.parseColor((String)"#FF000000"), (int)var1_1));
        return drawable3;
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable convertViewToDrawable(Context context, View view) {
        Drawable drawable2 = null;
        if (view != null) {
            Context context2;
            void var1_2;
            void v0 = var1_2;
            v0.setDrawingCacheEnabled(true);
            v0.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            int n = v0.getMeasuredWidth();
            int n2 = v0.getMeasuredHeight();
            v0.layout(0, 0, n, n2);
            v0.buildDrawingCache(true);
            drawable2 = ViewUtil.convertBitmapToDrawable(context2, Bitmap.createBitmap((Bitmap)v0.getDrawingCache()));
            var1_2.setDrawingCacheEnabled(false);
        }
        return drawable2;
    }

    public static Bitmap convertViewToBitmap(View view) {
        Bitmap bitmap = null;
        if (view != null) {
            int n;
            int n2;
            View view2;
            View view3;
            View view4;
            View view5;
            View view6;
            View view7;
            try {
                View view8;
                View view9 = view8;
                view7 = view9;
                view6 = view9;
                view5 = view9;
                view4 = view9;
                view3 = view9;
                view2 = view9;
                view9.setDrawingCacheEnabled(true);
                view9.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                n2 = 0;
                n = 0;
            }
            catch (Exception exception) {}
            int n3 = view3.getMeasuredWidth();
            int n4 = view2.getMeasuredHeight();
            view5.layout(n2, n, n3, n4);
            view4.buildDrawingCache(true);
            bitmap = Bitmap.createBitmap((Bitmap)view7.getDrawingCache());
            view6.setDrawingCacheEnabled(false);
        }
        return bitmap;
    }

    public static int getBorderlessRippleEffect(Context context) {
        Context context2;
        TypedValue typedValue;
        TypedValue typedValue2 = typedValue;
        typedValue2();
        context2.getTheme().resolveAttribute(16843868, typedValue2, true);
        return typedValue.resourceId;
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable getColorRippleDrawable(Context context, View view, int pressedColor, boolean isBorderless) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var1_1;
            Context context2;
            void var3_3;
            TypedValue typedValue;
            TypedValue typedValue2 = typedValue;
            typedValue = new TypedValue();
            if (var3_3 != false) {
                context2.getTheme().resolveAttribute(16843868, typedValue2, true);
            } else {
                context2.getTheme().resolveAttribute(16843534, typedValue2, true);
            }
            void v1 = var1_1;
            v1.setBackgroundResource(typedValue2.resourceId);
            if (v1.getBackground() instanceof RippleDrawable) {
                void var2_2;
                context2 = (RippleDrawable)var1_1.getBackground();
                context2.setColor(ViewUtil.getColorStateList((int)var2_2));
            } else {
                context2 = ViewUtil.setSelector(SELECTED_COLOR, NO_COLOR);
            }
            return context2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Drawable getColorRippleDrawable2(Context context, View view, int pressedColor, boolean isBorderless) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var1_1;
            Context context2;
            void var3_3;
            TypedValue typedValue;
            TypedValue typedValue2 = typedValue;
            typedValue = new TypedValue();
            if (var3_3 != false) {
                context2.getTheme().resolveAttribute(16843868, typedValue2, true);
            } else {
                context2.getTheme().resolveAttribute(16843534, typedValue2, true);
            }
            void v1 = var1_1;
            v1.setBackgroundResource(typedValue2.resourceId);
            if (v1.getBackground() instanceof RippleDrawable) {
                context2 = (RippleDrawable)var1_1.getBackground();
                context2.setColor(ViewUtil.getPressedColorSelector(((ColorDrawable)var1_1.getBackground()).getColor(), (int)var2_2));
            } else {
                context2 = ViewUtil.setSelector((int)var2_2, ((ColorDrawable)var1_1.getBackground()).getColor());
            }
            return context2;
        }
        return null;
    }

    public static int generateViewId() {
        int n;
        int n2;
        AtomicInteger atomicInteger;
        do {
            if ((n = (n2 = (atomicInteger = sNextGeneratedId).get()) + 1) <= 0xFFFFFF) continue;
            n = 1;
        } while (!atomicInteger.compareAndSet(n2, n));
        return n2;
    }

    /*
     * WARNING - void declaration
     */
    public static void onGlobalLayout(View view, GenericCompletedListener genericCompletedListener) {
        if (view != null) {
            void var1_1;
            View view2;
            view2.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
                final /* synthetic */ GenericCompletedListener val$genericCompletedListener;
                final /* synthetic */ View val$view;
                {
                    this.val$genericCompletedListener = genericCompletedListener;
                    this.val$view = view;
                }

                public void onGlobalLayout() {
                    1 v0 = this;
                    v0.val$genericCompletedListener.onComplete("Layout ready!");
                    View view = v0.val$view;
                    if (view != null) {
                        view.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                }
            });
        }
    }

    public static void setId(View view) {
        view.setId(View.generateViewId());
    }

    public static void setBackgroundAttr(Context context, View view) {
        Context context2;
        TypedValue typedValue;
        TypedValue typedValue2 = typedValue;
        typedValue2();
        context2.getTheme().resolveAttribute(16843534, typedValue2, true);
        view.setBackgroundResource(typedValue.resourceId);
    }

    /*
     * WARNING - void declaration
     */
    public static void setBackground(View view, Drawable background) {
        void var1_1;
        view.setBackground((Drawable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static void setSelectorOrRipple(Context context, View view, boolean isBorderless) {
        if (DeviceUtil.isAndroid5OrAbove()) {
            try {
                void var2_2;
                Context context2;
                ViewUtil.setRipple(context2, (View)var1_1, (boolean)var2_2);
            }
            catch (ClassCastException classCastException) {
                var1_1.setBackground((Drawable)ViewUtil.setSelector(SELECTED_COLOR, NO_COLOR));
            }
        } else {
            var1_1.setBackground((Drawable)ViewUtil.setSelector(SELECTED_COLOR, NO_COLOR));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setCircularRipple(Context context, View view, int rippleColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            void var2_2;
            ColorStateList colorStateList;
            RippleDrawable rippleDrawable;
            void v0 = var1_1;
            var0 = rippleDrawable;
            TypedValue typedValue = var1_1;
            var1_1 = colorStateList;
            int[] nArray = new int[]{};
            int[][] nArrayArray = new int[1][];
            int[][] nArrayArray2 = nArrayArray;
            nArrayArray[0] = nArray;
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = var2_2;
            colorStateList = new ColorStateList((int[][])nArrayArray2, nArray);
            rippleDrawable = new RippleDrawable((ColorStateList)var1_1, typedValue.getBackground(), null);
            v0.setBackground((Drawable)var0);
        } else {
            TypedValue typedValue;
            void v6 = var1_1;
            var1_1 = typedValue;
            var1_1();
            var0.getTheme().resolveAttribute(16843534, var1_1, true);
            v6.setBackgroundResource(typedValue.resourceId);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void setSelectorOrRipple(Context context, View view, int rippleColor, boolean isBorderless) {
        if (DeviceUtil.isAndroid5OrAbove()) {
            try {
                void var3_3;
                void var2_2;
                Context context2;
                ViewUtil.setRipple(context2, (View)var1_1, (int)var2_2, (boolean)var3_3);
            }
            catch (ClassCastException classCastException) {
                var1_1.setBackground((Drawable)ViewUtil.setSelector(SELECTED_COLOR, NO_COLOR));
            }
        } else {
            var1_1.setBackground((Drawable)ViewUtil.setSelector(SELECTED_COLOR, NO_COLOR));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static GradientDrawable setCornerAndBg(Context context, int cornerInDp, int color2) {
        void var1_2;
        Context context2;
        void var2_3;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3 = gradientDrawable2 = gradientDrawable;
        gradientDrawable3(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{var2_3, var2_3});
        gradientDrawable3.mutate();
        float f = CustomizationUtil.dpToPx(context2, (int)var1_2);
        gradientDrawable.setCornerRadii(new float[]{f, f, f, f, f, f, f, f});
        return gradientDrawable;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static View validate(View view) {
        Exception exception2;
        if (view != null) {
            try {
                View view2;
                return view2.getRootView();
            }
            catch (Exception exception2) {
            }
        } else {
            B5B.ix0(CalldoradoCustomView.TAG, "getRootView() null");
            return null;
        }
        B5B.B5B(CalldoradoCustomView.TAG, "getRootView() failed", exception2);
        return null;
    }

    public static Bitmap getBitmapFromDrawable(@NonNull Drawable drawable2) {
        Canvas canvas;
        Bitmap bitmap;
        Drawable drawable3;
        try {
            bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable3.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        Drawable drawable4 = drawable3;
        Drawable drawable5 = drawable4;
        Drawable drawable6 = drawable4;
        drawable3 = canvas;
        canvas = new Canvas(bitmap);
        int n = 0;
        int n2 = 0;
        int n3 = canvas.getWidth();
        int n4 = canvas.getHeight();
        drawable5.setBounds(n, n2, n3, n4);
        drawable6.draw((Canvas)drawable3);
        return bitmap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap convertDrawableToBitmap(PackageManager mPackageManager, String packageName) {
        block9: {
            PackageManager.NameNotFoundException nameNotFoundException2;
            block8: {
                Canvas canvas;
                PackageManager packageManager;
                PackageManager packageManager2;
                LayerDrawable layerDrawable;
                PackageManager packageManager3;
                Drawable drawable2;
                try {
                    packageManager3 = mPackageManager.getApplicationIcon((String)drawable2);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException2) {
                    break block8;
                }
                if (packageManager3 instanceof BitmapDrawable) {
                    return ((BitmapDrawable)packageManager3).getBitmap();
                }
                if (Build.VERSION.SDK_INT < 26 || !(packageManager3 instanceof AdaptiveIconDrawable)) break block9;
                PackageManager packageManager4 = packageManager3;
                packageManager3 = ((AdaptiveIconDrawable)packageManager4).getBackground();
                drawable2 = ((AdaptiveIconDrawable)packageManager4).getForeground();
                Drawable[] drawableArray = new Drawable[2];
                Drawable[] drawableArray2 = drawableArray;
                {
                    drawableArray[0] = packageManager3;
                    drawableArray[1] = drawable2;
                }
                packageManager3 = layerDrawable;
                {
                    drawable2 = Bitmap.createBitmap((int)new LayerDrawable(drawableArray2).getIntrinsicWidth(), (int)packageManager3.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                {
                    PackageManager packageManager5 = packageManager3;
                    packageManager2 = packageManager5;
                    packageManager = packageManager5;
                }
                packageManager3 = canvas;
                {
                    int n = 0;
                    int n2 = 0;
                    int n3 = new Canvas((Bitmap)drawable2).getWidth();
                    int n4 = packageManager3.getHeight();
                    packageManager2.setBounds(n, n2, n3, n4);
                    packageManager.draw((Canvas)packageManager3);
                    return drawable2;
                }
            }
            nameNotFoundException2.printStackTrace();
        }
        return null;
    }

    public static Bitmap convertAppIconToSquared(Context context) {
        block4: {
            Object object;
            ImageView imageView;
            ImageView imageView2 = imageView;
            Context context2 = object;
            ImageView imageView3 = imageView2;
            imageView3(object);
            imageView3.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(CustomizationUtil.convertDpToPixel(19, object), CustomizationUtil.convertDpToPixel(19, object)));
            B5B.B5B(TAG, "adding icon to contentView2");
            object = AppUtils.getAppLogo(context2);
            imageView.setImageBitmap(ViewUtil.decodeSampledBitmapFromByteArray(AppUtils.getAppLogo(context2), 70, 70));
            imageView.setScaleType(ImageView.ScaleType.FIT_XY);
            if (((Context)object).length <= 0) break block4;
            try {
                return ViewUtil.drawableToBitmap(imageView2.getDrawable());
            }
            catch (NullPointerException nullPointerException) {
                B5B.ix0(TAG, "app_icon bitmap is missing!");
            }
        }
        return null;
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        Canvas canvas;
        Drawable drawable3;
        BitmapDrawable bitmapDrawable;
        if (drawable2 instanceof BitmapDrawable && (bitmapDrawable = (BitmapDrawable)drawable3).getBitmap() != null) {
            return bitmapDrawable.getBitmap();
        }
        if (drawable3.getIntrinsicWidth() > 0 && drawable3.getIntrinsicHeight() > 0) {
            bitmapDrawable = Bitmap.createBitmap((int)drawable3.getIntrinsicWidth(), (int)drawable3.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        } else {
            bitmapDrawable = Bitmap.Config.ARGB_8888;
            bitmapDrawable = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)bitmapDrawable);
        }
        Drawable drawable4 = drawable3;
        drawable3 = canvas;
        int n = new Canvas((Bitmap)bitmapDrawable).getWidth();
        int n2 = drawable3.getHeight();
        drawable4.setBounds(0, 0, n, n2);
        drawable4.draw((Canvas)drawable3);
        return bitmapDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static void setRoundBackground(View view, int color2, int radius) {
        void var1_1;
        View view2;
        void var2_2;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3 = gradientDrawable2 = gradientDrawable;
        gradientDrawable3();
        gradientDrawable3.setShape(0);
        gradientDrawable2.setCornerRadius((float)CustomizationUtil.convertDpToPixel((int)var2_2, view2.getContext()));
        gradientDrawable.setColor((int)var1_1);
        ViewUtil.setBackground(view, (Drawable)gradientDrawable);
    }

    /*
     * WARNING - void declaration
     */
    public static void correctWidth(TextView textView, int desiredWidth) {
        TextView textView2;
        Rect rect;
        Paint paint;
        void var1_1;
        B5B.B5B(Util.TAG, "desiredWidth = " + (int)var1_1);
        Paint paint2 = paint;
        paint2();
        Rect rect2 = rect;
        rect = new Rect();
        paint2.setTypeface(textView2.getTypeface());
        float f = textView2.getTextSize();
        paint2.setTextSize(f);
        String string2 = textView2.getText().toString();
        paint.getTextBounds(string2, 0, string2.length(), rect2);
        while (rect2.width() > var1_1) {
            String string3 = string2;
            B5B.B5B(Util.TAG, "textSize = " + f);
            paint2.setTextSize(f -= 1.0f);
            paint2.getTextBounds(string3, 0, string3.length(), rect2);
        }
        textView2.setTextSize(0, f);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeSampledBitmapFromByteArray(byte[] res, int reqWidth, int reqHeight) {
        void var2_2;
        void var1_1;
        byte[] byArray;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = ViewUtil.calculateInSampleSize(options, (int)var1_1, (int)var2_2);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])res, (int)0, (int)res.length, (BitmapFactory.Options)options2);
    }

    public static void invalidateAllChildrenRecursively(ViewGroup parent) {
        ViewGroup viewGroup;
        for (int i = 0; i < viewGroup.getChildCount(); ++i) {
            View view = viewGroup.getChildAt(i);
            if (view instanceof ViewGroup) {
                ViewUtil.invalidateAllChildrenRecursively((ViewGroup)view);
                viewGroup.invalidate();
                continue;
            }
            if (view == null) continue;
            view.invalidate();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected static RippleDrawable createSaveRippleBg(int normalColor, int focusedColor, int pressedColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            ColorDrawable colorDrawable;
            void var2_3;
            void var1_1;
            int n;
            ColorStateList colorStateList = ViewUtil.getPressedColorSelector(n, (int)var1_1, (int)var2_3);
            ColorDrawable colorDrawable2 = colorDrawable;
            colorDrawable = new ColorDrawable(n);
            return new RippleDrawable(colorStateList, (Drawable)colorDrawable2, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static ColorStateList getPressedColorSelector(int normalColor, int focused, int pressedColor) {
        int n;
        void var1_1;
        void var2_2;
        int[] nArray = new int[]{};
        int[][] nArrayArray = new int[6][];
        int[][] nArrayArray2 = nArrayArray;
        int[] nArray2 = new int[1];
        int[] nArray3 = nArray2;
        nArray2[0] = 16842919;
        nArrayArray[0] = nArray3;
        int[] nArray4 = new int[1];
        nArray3 = nArray4;
        nArray4[0] = 16842908;
        nArrayArray[1] = nArray3;
        int[] nArray5 = new int[1];
        nArray3 = nArray5;
        nArray5[0] = 16843518;
        nArrayArray[2] = nArray3;
        int[] nArray6 = new int[1];
        nArray3 = nArray6;
        nArray6[0] = 16842910;
        nArrayArray[3] = nArray3;
        int[] nArray7 = new int[1];
        nArray3 = nArray7;
        nArray7[0] = 0x10100A1;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = nArray;
        int[] nArray8 = new int[6];
        nArray = nArray8;
        nArray8[0] = var2_2;
        nArray8[1] = var1_1;
        nArray8[2] = var2_2;
        nArray8[3] = var2_2;
        nArray8[4] = var2_2;
        nArray8[5] = n;
        return new ColorStateList((int[][])nArrayArray2, nArray);
    }

    /*
     * WARNING - void declaration
     */
    public static StateListDrawable createButtonBg(Context context, int[] normalColors, int[] pressedColors, int strokeColor, float cornerRadius) {
        void var2_2;
        GradientDrawable gradientDrawable;
        void var4_4;
        void var3_3;
        Context context2;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3;
        GradientDrawable gradientDrawable4;
        GradientDrawable gradientDrawable5 = gradientDrawable4 = gradientDrawable3;
        GradientDrawable.Orientation orientation = GradientDrawable.Orientation.TOP_BOTTOM;
        gradientDrawable5(orientation, (int[])gradientDrawable2);
        gradientDrawable5.setShape(0);
        gradientDrawable4.setStroke(CustomizationUtil.dpToPx(context2, 1), (int)var3_3);
        gradientDrawable3.setCornerRadius((float)var4_4);
        GradientDrawable gradientDrawable6 = gradientDrawable2 = gradientDrawable;
        gradientDrawable6(orientation, (int[])var2_2);
        gradientDrawable6.setShape(0);
        gradientDrawable2.setStroke(CustomizationUtil.dpToPx(context2, 1), (int)var3_3);
        gradientDrawable.setCornerRadius((float)var4_4);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)gradientDrawable2);
        stateListDrawable.addState(new int[]{16842910}, (Drawable)gradientDrawable4);
        return stateListDrawable;
    }

    protected static ShapeDrawable applyTestBackground() {
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.getPaint().setStyle(Paint.Style.FILL);
        shapeDrawable.getPaint().setColor(0);
        shapeDrawable.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable.getPaint().setStrokeWidth(1.0f);
        shapeDrawable.getPaint().setColor(-65536);
        return shapeDrawable;
    }

    protected static Drawable buildRatingBarDrawables(Bitmap[] images) {
        LayerDrawable layerDrawable;
        LayerDrawable layerDrawable2;
        int[] nArray = new int[3];
        int[] nArray2 = nArray;
        nArray[0] = 0x1020000;
        nArray[1] = 16908303;
        nArray[2] = 16908301;
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray[0] = 5.0f;
        fArray[1] = 5.0f;
        fArray[2] = 5.0f;
        fArray[3] = 5.0f;
        fArray[4] = 5.0f;
        fArray[5] = 5.0f;
        fArray[6] = 5.0f;
        fArray[7] = 5.0f;
        Drawable[] drawableArray = new Drawable[images.length];
        for (int i = 0; i < ((Bitmap[])layerDrawable2).length; ++i) {
            ClipDrawable clipDrawable;
            BitmapShader bitmapShader;
            ShapeDrawable shapeDrawable;
            ShapeDrawable shapeDrawable2 = shapeDrawable;
            BitmapShader bitmapShader2 = bitmapShader;
            bitmapShader = new BitmapShader((Bitmap)layerDrawable2[i], Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
            new ShapeDrawable((Shape)new RoundRectShape(fArray2, null, null)).getPaint().setShader((Shader)bitmapShader2);
            bitmapShader2 = clipDrawable;
            clipDrawable = new ClipDrawable((Drawable)shapeDrawable2, 3, 1);
            drawableArray[i] = i == 0 ? shapeDrawable2 : bitmapShader2;
        }
        layerDrawable2 = layerDrawable;
        layerDrawable = new LayerDrawable(drawableArray);
        for (int i = 0; i < 3; ++i) {
            layerDrawable2.setId(i, nArray2[i]);
        }
        return layerDrawable2;
    }

    /*
     * WARNING - void declaration
     */
    public static LayerDrawable getItemViewBg(Context context, float cornerRadius, int boxBgColor, int strokeWidth, int strokeColor) {
        void var2_2;
        void var4_6;
        void var1_1;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        Context context2 = gradientDrawable2;
        gradientDrawable2 = new GradientDrawable();
        GradientDrawable gradientDrawable3 = gradientDrawable;
        Context context3 = context2;
        gradientDrawable3();
        float[] fArray = new float[8];
        float[] fArray2 = fArray;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = var1_1;
        fArray[5] = var1_1;
        fArray[6] = var1_1;
        fArray[7] = var1_1;
        context3.setColor((int)var4_6);
        context3.setShape(0);
        context3.setCornerRadii(fArray2);
        gradientDrawable.setColor((int)var2_2);
        gradientDrawable.setShape(0);
        gradientDrawable.setCornerRadii(fArray2);
        gradientDrawable.setBounds(gradientDrawable.copyBounds());
        LayerDrawable layerDrawable = new LayerDrawable(new Drawable[]{context2, gradientDrawable3});
        layerDrawable.setLayerInset(0, 0, 0, 0, 0);
        layerDrawable.setLayerInset(1, 1, 0, 1, 1);
        return layerDrawable;
    }

    public static LayerDrawable getDialogBackground(Context context) {
        LayerDrawable layerDrawable;
        Context context2;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3;
        GradientDrawable gradientDrawable4 = gradientDrawable3;
        gradientDrawable3 = new GradientDrawable();
        GradientDrawable gradientDrawable5 = gradientDrawable2 = gradientDrawable;
        GradientDrawable gradientDrawable6 = gradientDrawable4;
        gradientDrawable2();
        gradientDrawable6.setColor(CalldoradoApplication.ix0(context2).dpy().ix0());
        gradientDrawable6.setShape(0);
        gradientDrawable4.setStroke(1, context2.getResources().getColor(17170445));
        gradientDrawable5.setColor(CalldoradoApplication.ix0(context2).dpy().ix0());
        gradientDrawable5.setShape(0);
        gradientDrawable.setStroke(1, context2.getResources().getColor(17170445));
        gradientDrawable.setBounds(gradientDrawable.copyBounds());
        LayerDrawable layerDrawable2 = layerDrawable;
        Context context3 = context2;
        LayerDrawable layerDrawable3 = layerDrawable2;
        layerDrawable3(new Drawable[]{gradientDrawable4, gradientDrawable2});
        layerDrawable3.setLayerInset(0, 0, 0, 0, 0);
        int n = CustomizationUtil.dpToPx(context3, 2);
        int n2 = CustomizationUtil.dpToPx(context3, 2);
        int n3 = CustomizationUtil.dpToPx(context3, 2);
        int n4 = CustomizationUtil.dpToPx(context3, 2);
        layerDrawable.setLayerInset(1, n, n2, n3, n4);
        return layerDrawable;
    }

    public static LayerDrawable getDialogButtonBackground(Context context) {
        LayerDrawable layerDrawable;
        Context context2;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3;
        GradientDrawable gradientDrawable4;
        GradientDrawable gradientDrawable5 = gradientDrawable4;
        gradientDrawable4 = new GradientDrawable();
        GradientDrawable gradientDrawable6 = gradientDrawable3;
        gradientDrawable3 = new GradientDrawable();
        GradientDrawable gradientDrawable7 = gradientDrawable2 = gradientDrawable;
        GradientDrawable gradientDrawable8 = gradientDrawable6;
        GradientDrawable gradientDrawable9 = gradientDrawable5;
        gradientDrawable2();
        gradientDrawable9.setColor(Color.parseColor((String)"#456281"));
        gradientDrawable9.setShape(0);
        gradientDrawable5.setStroke(1, context2.getResources().getColor(17170445));
        gradientDrawable8.setColor(Color.parseColor((String)"#33000000"));
        gradientDrawable8.setShape(0);
        gradientDrawable6.setStroke(1, context2.getResources().getColor(17170445));
        gradientDrawable7.setColor(CalldoradoApplication.ix0(context2).dpy().H1u());
        gradientDrawable7.setShape(0);
        gradientDrawable.setStroke(1, context2.getResources().getColor(17170445));
        LayerDrawable layerDrawable2 = layerDrawable;
        Context context3 = context2;
        Context context4 = context2;
        LayerDrawable layerDrawable3 = layerDrawable2;
        layerDrawable3(new Drawable[]{gradientDrawable5, gradientDrawable6, gradientDrawable2});
        layerDrawable3.setLayerInset(0, 0, 0, 0, 0);
        int n = CustomizationUtil.dpToPx(context4, 1);
        int n2 = CustomizationUtil.dpToPx(context4, 1);
        layerDrawable2.setLayerInset(1, n, n2, 0, 0);
        n = CustomizationUtil.dpToPx(context3, 1);
        n2 = CustomizationUtil.dpToPx(context3, 1);
        int n3 = CustomizationUtil.dpToPx(context3, 1);
        int n4 = CustomizationUtil.dpToPx(context3, 1);
        layerDrawable.setLayerInset(2, n, n2, n3, n4);
        return layerDrawable;
    }

    public static LayerDrawable getFirstTimeDialogButtonBackground(Context context) {
        LayerDrawable layerDrawable;
        Context context2;
        GradientDrawable gradientDrawable;
        GradientDrawable gradientDrawable2;
        GradientDrawable gradientDrawable3;
        GradientDrawable gradientDrawable4 = gradientDrawable3;
        gradientDrawable3 = new GradientDrawable();
        GradientDrawable gradientDrawable5 = gradientDrawable2;
        gradientDrawable2 = new GradientDrawable();
        GradientDrawable gradientDrawable6 = gradientDrawable;
        gradientDrawable = new GradientDrawable();
        if (CalldoradoApplication.ix0(context).dpy().H1u() == Color.parseColor((String)"#FFFCF5")) {
            gradientDrawable4.setColor(Color.parseColor((String)"#43a047"));
        } else {
            gradientDrawable4.setColor(CalldoradoApplication.ix0(context2).dpy().xfp());
        }
        gradientDrawable4.setShape(0);
        gradientDrawable4.setStroke(1, context2.getResources().getColor(17170445));
        if (CalldoradoApplication.ix0(context2).dpy().H1u() == Color.parseColor((String)"#FFFCF5")) {
            gradientDrawable5.setColor(Color.parseColor((String)"#43a047"));
        } else {
            gradientDrawable5.setColor(CalldoradoApplication.ix0(context2).dpy().xfp());
        }
        gradientDrawable5.setShape(0);
        gradientDrawable5.setStroke(1, context2.getResources().getColor(17170445));
        if (CalldoradoApplication.ix0(context2).dpy().H1u() == Color.parseColor((String)"#FFFCF5")) {
            gradientDrawable6.setColor(Color.parseColor((String)"#43a047"));
        } else {
            gradientDrawable6.setColor(CalldoradoApplication.ix0(context2).dpy().xfp());
        }
        gradientDrawable6.setShape(0);
        gradientDrawable6.setStroke(1, context2.getResources().getColor(17170445));
        LayerDrawable layerDrawable2 = layerDrawable;
        Context context3 = context2;
        Context context4 = context2;
        LayerDrawable layerDrawable3 = layerDrawable2;
        layerDrawable3(new Drawable[]{gradientDrawable4, gradientDrawable5, gradientDrawable6});
        layerDrawable3.setLayerInset(0, 0, 0, 0, 0);
        int n = CustomizationUtil.dpToPx(context4, 1);
        int n2 = CustomizationUtil.dpToPx(context4, 1);
        layerDrawable2.setLayerInset(1, n, n2, 0, 0);
        n = CustomizationUtil.dpToPx(context3, 1);
        n2 = CustomizationUtil.dpToPx(context3, 1);
        int n3 = CustomizationUtil.dpToPx(context3, 1);
        int n4 = CustomizationUtil.dpToPx(context3, 1);
        layerDrawable.setLayerInset(2, n, n2, n3, n4);
        return layerDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static StateListDrawable setSelector(String pressedColor, String normalColor) {
        void var1_4;
        Canvas canvas;
        Rect rect;
        String string2;
        Canvas canvas2;
        Rect rect2;
        Rect rect3 = rect2;
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)new Rect(0, 0, 1, 1).width(), (int)rect3.height(), (Bitmap.Config)config);
        Canvas canvas3 = canvas2;
        canvas3(bitmap);
        int n = Color.parseColor((String)string2);
        Paint paint = new Paint();
        paint.setColor(n);
        canvas2.drawRect(rect3, paint);
        new RectF().round(rect3);
        Rect rect4 = rect;
        rect3 = Bitmap.createBitmap((int)new Rect(0, 0, 1, 1).width(), (int)rect4.height(), (Bitmap.Config)config);
        config = canvas;
        config((Bitmap)rect3);
        int n2 = Color.parseColor((String)var1_4);
        Paint paint2 = new Paint();
        paint2.setColor(n2);
        canvas.drawRect(rect4, paint2);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)new BitmapDrawable(bitmap));
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)new BitmapDrawable((Bitmap)rect3));
        return stateListDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static StateListDrawable setSelector(int pressedColor, int normalColor) {
        void var1_2;
        Rect rect;
        int n;
        Rect rect2;
        Rect rect3 = rect2;
        Bitmap.Config config = Bitmap.Config.ARGB_8888;
        Bitmap bitmap = Bitmap.createBitmap((int)new Rect(0, 0, 1, 1).width(), (int)rect3.height(), (Bitmap.Config)config);
        Canvas canvas = new Canvas(bitmap);
        Paint paint = new Paint();
        paint.setColor(n);
        canvas.drawRect(rect3, paint);
        new RectF().round(rect3);
        Rect rect4 = rect;
        rect3 = Bitmap.createBitmap((int)new Rect(0, 0, 1, 1).width(), (int)rect4.height(), (Bitmap.Config)config);
        Canvas canvas2 = new Canvas((Bitmap)rect3);
        Paint paint2 = new Paint();
        paint2.setColor((int)var1_2);
        canvas2.drawRect(rect4, paint2);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{16842919}, (Drawable)new BitmapDrawable(bitmap));
        stateListDrawable.addState(StateSet.WILD_CARD, (Drawable)new BitmapDrawable((Bitmap)rect3));
        return stateListDrawable;
    }

    /*
     * WARNING - void declaration
     */
    public static int adjustAlpha(int color2, float factor) {
        void var1_1;
        int n;
        int n2 = n;
        n = Color.red((int)n2);
        int n3 = Color.green((int)n2);
        int n4 = Color.blue((int)n2);
        return Color.argb((int)Math.round((float)Color.alpha((int)color2) * var1_1), (int)n, (int)n3, (int)n4);
    }

    /*
     * WARNING - void declaration
     */
    public static ColorStateList getPressedColorSelector(int normalColor, int pressedColor) {
        int n;
        void var1_1;
        int[] nArray = new int[]{};
        int[][] nArrayArray = new int[4][];
        int[][] nArrayArray2 = nArrayArray;
        int[] nArray2 = new int[1];
        int[] nArray3 = nArray2;
        nArray2[0] = 16842919;
        nArrayArray[0] = nArray3;
        int[] nArray4 = new int[1];
        nArray3 = nArray4;
        nArray4[0] = 16842908;
        nArrayArray[1] = nArray3;
        int[] nArray5 = new int[1];
        nArray3 = nArray5;
        nArray5[0] = 16843518;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = nArray;
        int[] nArray6 = new int[4];
        nArray = nArray6;
        nArray6[0] = var1_1;
        nArray6[1] = var1_1;
        nArray6[2] = var1_1;
        nArray6[3] = n;
        return new ColorStateList((int[][])nArrayArray2, nArray);
    }

    public static ColorStateList getColorStateList(int pressedColor) {
        int n;
        int[] nArray = new int[]{};
        int[][] nArrayArray = new int[1][];
        int[][] nArrayArray2 = nArrayArray;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[1];
        nArray = nArray2;
        nArray2[0] = n;
        return new ColorStateList((int[][])nArrayArray2, nArray);
    }

    /*
     * WARNING - void declaration
     */
    public static ColorStateList getColorStateList(int bgColor, int pressedColor) {
        void var1_1;
        int n;
        int[] nArray = new int[]{};
        int[] nArray2 = new int[]{};
        int[][] nArrayArray = new int[2][];
        int[][] nArrayArray2 = nArrayArray;
        nArrayArray[0] = nArray;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray = nArray3;
        nArray3[0] = n;
        nArray3[1] = var1_1;
        return new ColorStateList((int[][])nArrayArray2, nArray);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        void var1_1;
        Resources resources;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)resources, (int)var1_1, (BitmapFactory.Options)options2);
        options.inSampleSize = ViewUtil.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTargetDensity = 0;
        options.inTempStorage = new byte[32768];
        return BitmapFactory.decodeResource((Resources)res, (int)var1_1, (BitmapFactory.Options)options2);
    }

    public static Bitmap decodeSampledBitmapFromFile(String pathName) {
        String string2;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = ViewUtil.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        options.inDither = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[32768];
        return BitmapFactory.decodeFile((String)pathName, (BitmapFactory.Options)options);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Bitmap decodeSampledBitmapFromStream(InputStream inputStream, int width, int height) {
        void var2_4;
        void var1_2;
        BitmapFactory.Options options;
        InputStream inputStream2;
        ByteArrayOutputStream byteArrayOutputStream;
        block6: {
            IOException iOException2;
            block5: {
                ByteArrayOutputStream byteArrayOutputStream2;
                if (inputStream == null) {
                    return null;
                }
                byteArrayOutputStream = byteArrayOutputStream2;
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while (true) {
                    int n;
                    try {
                        n = inputStream2.read(byArray);
                        if (n <= -1) break;
                    }
                    catch (IOException iOException2) {
                        break block5;
                    }
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                break block6;
            }
            iOException2.printStackTrace();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream = options;
        byteArrayOutputStream();
        ((BitmapFactory.Options)byteArrayOutputStream).inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)inputStream2, null, (BitmapFactory.Options)byteArrayOutputStream);
        int n = ViewUtil.calculateInSampleSize(options, (int)var1_2, (int)var2_4);
        String string2 = TAG;
        ByteArrayOutputStream byteArrayOutputStream3 = byteArrayOutputStream;
        B5B.B5B(string2, "inSampleSize=" + n);
        ((BitmapFactory.Options)byteArrayOutputStream3).inSampleSize = n;
        ((BitmapFactory.Options)byteArrayOutputStream3).inJustDecodeBounds = false;
        ((BitmapFactory.Options)byteArrayOutputStream3).inDither = false;
        ((BitmapFactory.Options)byteArrayOutputStream3).inPurgeable = true;
        ((BitmapFactory.Options)byteArrayOutputStream3).inInputShareable = true;
        ((BitmapFactory.Options)byteArrayOutputStream3).inTempStorage = new byte[16384];
        B5B.B5B(string2, "options.outWidth=" + ((BitmapFactory.Options)byteArrayOutputStream).outWidth + ", options.outHeight=" + ((BitmapFactory.Options)byteArrayOutputStream).outHeight);
        return BitmapFactory.decodeStream((InputStream)byteArrayInputStream, null, (BitmapFactory.Options)byteArrayOutputStream);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeSampledBitmapFromByteArray(byte[] image, Context context) {
        byte[] byArray;
        BitmapFactory.Options options;
        void var1_1;
        int n = CustomizationUtil.convertDpToPixel(100, (Context)var1_1);
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length, (BitmapFactory.Options)options2);
        options.inSampleSize = ViewUtil.calculateInSampleSize(options, n, n);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeByteArray((byte[])image, (int)0, (int)image.length, (BitmapFactory.Options)options2);
    }

    private static int calculateInSampleSize(BitmapFactory.Options options) {
        BitmapFactory.Options options2;
        long l = Runtime.getRuntime().maxMemory();
        int n = 817;
        int n2 = 817;
        if (l > 23000000L) {
            n = 700;
            n2 = 700;
        }
        if (l > 32000000L) {
            n = 820;
            n2 = 820;
        }
        if (l > 64000000L) {
            n = 1130;
            n2 = 1130;
        }
        int n3 = options2.outHeight;
        int n4 = options2.outWidth;
        int n5 = 1;
        if (n3 > n2 || n4 > n) {
            n5 = l > 23000000L ? (n4 > n3 ? (n4 = (int)Math.floor((float)n4 / (float)n)) : (n4 = (int)Math.floor((float)n3 / (float)n2))) : (n4 > n3 ? (n4 = Math.round((float)n4 / (float)n)) : (n4 = Math.round((float)n3 / (float)n2)));
            if (n5 == 0) {
                n5 = 1;
            }
        }
        return n5;
    }

    /*
     * WARNING - void declaration
     */
    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        void var1_2;
        void var2_3;
        BitmapFactory.Options options2;
        int n = options.outHeight;
        int n2 = options2.outWidth;
        int n3 = 1;
        if (n > var2_3 || n2 > var1_2) {
            int n4 = n2;
            n2 = n / 2;
            n = n4 / 2;
            while (n2 / n3 >= var2_3 && n / n3 >= var1_2) {
                n3 *= 2;
            }
        }
        return n3;
    }

    public static int getWindowType(Context context) {
        int n = 2010;
        if (Build.VERSION.SDK_INT >= 26) {
            n = 2038;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static FrameLayout getIconSmall(Context mContext, @FontRes int id2, String color2) {
        void var2_2;
        void var1_1;
        FrameLayout.LayoutParams layoutParams;
        Context context;
        FrameLayout frameLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        Context context2 = context;
        int n = CustomizationUtil.dpToPx(context2, 30);
        layoutParams = new FrameLayout.LayoutParams(n, CustomizationUtil.dpToPx(context2, 30));
        SvgFontView svgFontView = new SvgFontView(context, (int)var1_1);
        svgFontView.setSize(30);
        svgFontView.setGravity(17);
        svgFontView.setColor(Color.parseColor((String)var2_2));
        frameLayout.addView((View)svgFontView, (ViewGroup.LayoutParams)layoutParams2);
        return frameLayout;
    }

    /*
     * WARNING - void declaration
     */
    public static FrameLayout getIconLarge(Context mContext, int iconResource) {
        void var1_1;
        ImageView imageView;
        FrameLayout.LayoutParams layoutParams;
        Context context;
        FrameLayout frameLayout = new FrameLayout(context);
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        Context context2 = context;
        int n = CustomizationUtil.dpToPx(context2, 50);
        layoutParams = new FrameLayout.LayoutParams(n, CustomizationUtil.dpToPx(context2, 50));
        ImageView imageView2 = imageView;
        new ImageView(context).setImageResource((int)var1_1);
        imageView2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        frameLayout.addView((View)imageView2);
        return frameLayout;
    }

    /*
     * WARNING - void declaration
     */
    public static void makeTextViewResizable(TextView tv, int maxLine, String expandText, boolean viewMore) {
        void var3_3;
        void var2_2;
        void var1_1;
        TextView textView;
        if (tv.getTag() == null) {
            TextView textView2 = textView;
            textView2.setTag((Object)textView2.getText());
        }
        textView.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){
            final /* synthetic */ int val$maxLine;
            final /* synthetic */ String val$expandText;
            final /* synthetic */ boolean val$viewMore;
            {
                this.val$maxLine = n;
                this.val$expandText = string2;
                this.val$viewMore = bl;
            }

            public void onGlobalLayout() {
                textView.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                int n = this.val$maxLine;
                if (n == 0) {
                    n = textView.getLayout().getLineEnd(0);
                    textView.setText((CharSequence)(textView.getText().subSequence(0, n - this.val$expandText.length() + 1) + " " + this.val$expandText));
                    textView.setMovementMethod(LinkMovementMethod.getInstance());
                    TextView textView2 = textView;
                    textView2.setText((CharSequence)ViewUtil.addClickablePartTextViewResizable(Html.fromHtml((String)textView2.getText().toString()), textView, this.val$maxLine, this.val$expandText, this.val$viewMore), TextView.BufferType.SPANNABLE);
                } else if (n > 0 && textView.getLineCount() >= this.val$maxLine) {
                    n = textView.getLayout().getLineEnd(this.val$maxLine - 1);
                    textView.setText((CharSequence)(textView.getText().subSequence(0, n - this.val$expandText.length() + 1) + " " + this.val$expandText));
                    textView.setMovementMethod(LinkMovementMethod.getInstance());
                    TextView textView3 = textView;
                    textView3.setText((CharSequence)ViewUtil.addClickablePartTextViewResizable(Html.fromHtml((String)textView3.getText().toString()), textView, this.val$maxLine, this.val$expandText, this.val$viewMore), TextView.BufferType.SPANNABLE);
                } else {
                    n = textView.getLayout().getLineEnd(textView.getLayout().getLineCount() - 1);
                    textView.setText((CharSequence)(textView.getText().subSequence(0, n) + " " + this.val$expandText));
                    textView.setMovementMethod(LinkMovementMethod.getInstance());
                    TextView textView4 = textView;
                    textView4.setText((CharSequence)ViewUtil.addClickablePartTextViewResizable(Html.fromHtml((String)textView4.getText().toString()), textView, n, this.val$expandText, this.val$viewMore), TextView.BufferType.SPANNABLE);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static SpannableStringBuilder addClickablePartTextViewResizable(Spanned strSpanned, TextView tv, int maxLine, String spanableText, boolean viewMore) {
        void var3_6;
        Object object;
        SpannableStringBuilder spannableStringBuilder;
        String string2 = strSpanned.toString();
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
        spannableStringBuilder = new SpannableStringBuilder((CharSequence)object);
        if (string2.contains((CharSequence)var3_6)) {
            void var1_1;
            void var4_7;
            com.calldorado.ui.views.custom.B5B b5B;
            object = b5B;
            b5B = new com.calldorado.ui.views.custom.B5B(false, (boolean)var4_7, (TextView)var1_1){
                final /* synthetic */ boolean val$viewMore;
                final /* synthetic */ TextView val$tv;
                {
                    void var1_1;
                    this.val$viewMore = bl;
                    this.val$tv = textView;
                    super((boolean)var1_1);
                }

                public void onClick(View widget) {
                    if (this.val$viewMore) {
                        3 v0 = this;
                        TextView textView = v0.val$tv;
                        textView.setLayoutParams(textView.getLayoutParams());
                        TextView textView2 = v0.val$tv;
                        textView2.setText((CharSequence)textView2.getTag().toString(), TextView.BufferType.SPANNABLE);
                        v0.val$tv.invalidate();
                        ViewUtil.makeTextViewResizable(v0.val$tv, -1, "See Less", false);
                    } else {
                        3 v3 = this;
                        TextView textView = v3.val$tv;
                        textView.setLayoutParams(textView.getLayoutParams());
                        TextView textView3 = v3.val$tv;
                        textView3.setText((CharSequence)textView3.getTag().toString(), TextView.BufferType.SPANNABLE);
                        v3.val$tv.invalidate();
                        ViewUtil.makeTextViewResizable(v3.val$tv, 3, ".. See More", true);
                    }
                }
            };
            int n = string2.indexOf((String)var3_6);
            int n2 = string2.indexOf((String)var3_6) + var3_6.length();
            spannableStringBuilder2.setSpan(object, n, n2, 0);
        }
        return spannableStringBuilder2;
    }
}

