/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util.crypt;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Base64;
import com.calldorado.log.B5B;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCbcWithIntegrity {
    private static final boolean ALLOW_BROKEN_PRNG = false;
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String CIPHER = "AES";
    private static final int AES_KEY_LENGTH_BITS = 128;
    private static final int IV_LENGTH_BYTES = 16;
    private static final int PBE_ITERATION_COUNT = 10000;
    private static final int PBE_SALT_LENGTH_BITS = 128;
    private static final String PBE_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int BASE64_FLAGS = 2;
    static final AtomicBoolean prngFixed = new AtomicBoolean(false);
    private static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final int HMAC_KEY_LENGTH_BITS = 256;
    private static AesCbcWithIntegrity instance = null;
    private static final String TAG = AesCbcWithIntegrity.class.getSimpleName();
    private Context context;

    /*
     * WARNING - void declaration
     */
    private AesCbcWithIntegrity(Context context) {
        void var1_1;
        this.context = var1_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AesCbcWithIntegrity getInstance(Context context) {
        Context context2;
        if (instance != null) return instance;
        if (context2 == null) return instance;
        Class<AesCbcWithIntegrity> clazz = AesCbcWithIntegrity.class;
        synchronized (AesCbcWithIntegrity.class) {
            try {
                if (instance != null) return instance;
                instance = new AesCbcWithIntegrity(context2);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    private byte[] randomBytes(int length) throws GeneralSecurityException {
        SecureRandom secureRandom;
        ((AesCbcWithIntegrity)((Object)secureRandom2)).fixPrng();
        SecureRandom secureRandom2 = secureRandom;
        secureRandom = new SecureRandom();
        byte[] byArray = new byte[length];
        secureRandom2.nextBytes(byArray);
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void fixPrng() {
        AtomicBoolean atomicBoolean = prngFixed;
        if (atomicBoolean.get()) return;
        Class<PrngFixes> clazz = PrngFixes.class;
        synchronized (PrngFixes.class) {
            try {
                if (atomicBoolean.get()) return;
                PrngFixes.apply(this.context);
                atomicBoolean.set(true);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] copyOfRange(byte[] from, int start, int end) {
        void var1_2;
        void var2_3;
        int n = end - var2_3;
        byte[] byArray = new byte[n];
        System.arraycopy(var1_2, (int)var2_3, byArray, 0, n);
        return byArray;
    }

    public String keyString(SecretKeys keys) {
        return keys.toString();
    }

    public SecretKeys keys(String keysStr) throws InvalidKeyException {
        Object[] objectArray = keysStr.split(":");
        if (objectArray.length == 2) {
            Object object = Base64.decode((String)objectArray[0], (int)2);
            if (((byte[])object).length == 16) {
                byte[] byArray = Base64.decode((String)objectArray[1], (int)2);
                objectArray = byArray;
                if (byArray.length == 32) {
                    SecretKeySpec secretKeySpec;
                    SecretKeySpec secretKeySpec2;
                    SecretKeySpec secretKeySpec3 = secretKeySpec2;
                    int n = ((byte[])object).length;
                    secretKeySpec2 = new SecretKeySpec((byte[])object, 0, n, CIPHER);
                    object = secretKeySpec;
                    secretKeySpec = new SecretKeySpec((byte[])objectArray, HMAC_ALGORITHM);
                    return new SecretKeys(secretKeySpec3, (SecretKey)object);
                }
                throw new InvalidKeyException("Base64 decoded key is not 256 bytes");
            }
            throw new InvalidKeyException("Base64 decoded key is not 128 bytes");
        }
        throw new IllegalArgumentException("Cannot parse aesKey:hmacKey");
    }

    public SecretKeys generateKey() throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        AesCbcWithIntegrity aesCbcWithIntegrity = this_;
        aesCbcWithIntegrity.fixPrng();
        KeyGenerator keyGenerator = KeyGenerator.getInstance(CIPHER);
        keyGenerator.init(128);
        SecretKey this_ = keyGenerator.generateKey();
        byte[] byArray = aesCbcWithIntegrity.randomBytes(32);
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        secretKeySpec = new SecretKeySpec(byArray, HMAC_ALGORITHM);
        return new SecretKeys(this_, secretKeySpec2);
    }

    /*
     * WARNING - void declaration
     */
    public SecretKeys generateKeyFromPassword(String password, byte[] salt) throws GeneralSecurityException {
        void var2_2;
        void var1_1;
        return this.generateKeyFromPassword((String)var1_1, (byte[])var2_2, 10000);
    }

    /*
     * WARNING - void declaration
     */
    public SecretKeys generateKeyFromPassword(String password, byte[] salt, int iterationCount) throws GeneralSecurityException {
        SecretKeySpec secretKeySpec;
        SecretKeySpec secretKeySpec2;
        void var3_3;
        SecretKeySpec secretKeySpec3;
        Object object;
        PBEKeySpec pBEKeySpec;
        AesCbcWithIntegrity aesCbcWithIntegrity = this_;
        aesCbcWithIntegrity.fixPrng();
        Object this_ = pBEKeySpec;
        pBEKeySpec = new PBEKeySpec(object.toCharArray(), (byte[])secretKeySpec3, (int)var3_3, 384);
        byte[] byArray = SecretKeyFactory.getInstance(PBE_ALGORITHM).generateSecret((KeySpec)this_).getEncoded();
        this_ = byArray;
        object = aesCbcWithIntegrity.copyOfRange(byArray, 0, 16);
        this_ = aesCbcWithIntegrity.copyOfRange((byte[])this_, 16, 48);
        secretKeySpec3 = secretKeySpec2;
        secretKeySpec2 = new SecretKeySpec((byte[])object, CIPHER);
        object = secretKeySpec;
        secretKeySpec = new SecretKeySpec((byte[])this_, HMAC_ALGORITHM);
        return new SecretKeys(secretKeySpec3, (SecretKey)object);
    }

    /*
     * WARNING - void declaration
     */
    public SecretKeys generateKeyFromPassword(String password, String salt) throws GeneralSecurityException {
        void var2_2;
        void var1_1;
        return this.generateKeyFromPassword((String)var1_1, (String)var2_2, 10000);
    }

    /*
     * WARNING - void declaration
     */
    public SecretKeys generateKeyFromPassword(String password, String salt, int iterationCount) throws GeneralSecurityException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.generateKeyFromPassword((String)var1_1, Base64.decode((String)var2_2, (int)2), (int)var3_3);
    }

    public byte[] generateSalt() throws GeneralSecurityException {
        return this.randomBytes(128);
    }

    public String saltString(byte[] salt) {
        return Base64.encodeToString((byte[])salt, (int)2);
    }

    public byte[] generateIv() throws GeneralSecurityException {
        return this.randomBytes(16);
    }

    /*
     * WARNING - void declaration
     */
    public CipherTextIvMac encrypt(String plaintext, SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        void var2_2;
        void var1_1;
        return this.encrypt((String)var1_1, (SecretKeys)var2_2, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public CipherTextIvMac encrypt(String plaintext, SecretKeys secretKeys, String encoding) throws UnsupportedEncodingException, GeneralSecurityException {
        void var2_2;
        void var3_3;
        void var1_1;
        return this.encrypt(var1_1.getBytes((String)var3_3), (SecretKeys)var2_2);
    }

    public CipherTextIvMac encrypt(byte[] plaintext, SecretKeys secretKeys) throws GeneralSecurityException {
        byte[] byArray;
        IvParameterSpec ivParameterSpec;
        Object object;
        AesCbcWithIntegrity aesCbcWithIntegrity = this_;
        void v1 = object;
        Object this_ = ((AesCbcWithIntegrity)this_).generateIv();
        Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
        SecretKey secretKey = ((SecretKeys)object).getConfidentialityKey();
        object = ivParameterSpec;
        ivParameterSpec = new IvParameterSpec((byte[])this_);
        cipher.init(1, (Key)secretKey, (AlgorithmParameterSpec)object);
        byte[] byArray2 = cipher.getIV();
        this_ = byArray2;
        byArray = cipher.doFinal(byArray);
        object = CipherTextIvMac.ivCipherConcat(byArray2, byArray);
        object = aesCbcWithIntegrity.generateMac((byte[])object, v1.getIntegrityKey());
        return new CipherTextIvMac(byArray, (byte[])this_, (byte[])object);
    }

    /*
     * WARNING - void declaration
     */
    public String decryptString(CipherTextIvMac civ, SecretKeys secretKeys, String encoding) throws UnsupportedEncodingException, GeneralSecurityException {
        void var3_3;
        void var2_2;
        void var1_1;
        return new String(this.decrypt((CipherTextIvMac)var1_1, (SecretKeys)var2_2), (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public String decryptString(CipherTextIvMac civ, SecretKeys secretKeys) throws UnsupportedEncodingException, GeneralSecurityException {
        void var2_2;
        void var1_1;
        return this.decryptString((CipherTextIvMac)var1_1, (SecretKeys)var2_2, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] decrypt(CipherTextIvMac civ, SecretKeys secretKeys) throws GeneralSecurityException {
        void var2_2;
        void var1_1;
        AesCbcWithIntegrity aesCbcWithIntegrity = this_;
        AesCbcWithIntegrity aesCbcWithIntegrity2 = this_;
        Object this_ = CipherTextIvMac.ivCipherConcat(var1_1.getIv(), var1_1.getCipherText());
        if (aesCbcWithIntegrity.constantTimeEq((byte[])(this_ = (Object)aesCbcWithIntegrity2.generateMac((byte[])this_, var2_2.getIntegrityKey())), var1_1.getMac())) {
            IvParameterSpec ivParameterSpec;
            Cipher cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            this_ = ivParameterSpec;
            ivParameterSpec = new IvParameterSpec(var1_1.getIv());
            cipher.init(2, (Key)var2_2.getConfidentialityKey(), (AlgorithmParameterSpec)this_);
            return cipher.doFinal(var1_1.getCipherText());
        }
        throw new GeneralSecurityException("MAC stored in civ does not match computed MAC.");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] generateMac(byte[] byteCipherText, SecretKey integrityKey) throws NoSuchAlgorithmException, InvalidKeyException {
        void var1_1;
        void var2_2;
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init((Key)var2_2);
        return mac.doFinal((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean constantTimeEq(byte[] a, byte[] b) {
        void var1_2;
        void var2_3;
        if (a.length != ((void)var2_3).length) {
            return false;
        }
        int n = 0;
        for (int i = 0; i < ((void)var1_2).length; ++i) {
            n |= var1_2[i] ^ var2_3[i];
        }
        return n == 0;
    }

    public static class SecretKeys {
        private SecretKey confidentialityKey;
        private SecretKey integrityKey;

        /*
         * WARNING - void declaration
         */
        public SecretKeys(SecretKey confidentialityKeyIn, SecretKey integrityKeyIn) {
            void var2_2;
            void var1_1;
            SecretKeys secretKeys = this;
            secretKeys.setConfidentialityKey((SecretKey)var1_1);
            secretKeys.setIntegrityKey((SecretKey)var2_2);
        }

        public SecretKey getConfidentialityKey() {
            return this.confidentialityKey;
        }

        /*
         * WARNING - void declaration
         */
        public void setConfidentialityKey(SecretKey confidentialityKey) {
            void var1_1;
            this.confidentialityKey = var1_1;
        }

        public SecretKey getIntegrityKey() {
            return this.integrityKey;
        }

        /*
         * WARNING - void declaration
         */
        public void setIntegrityKey(SecretKey integrityKey) {
            void var1_1;
            this.integrityKey = var1_1;
        }

        public String toString() {
            return Base64.encodeToString((byte[])this.getConfidentialityKey().getEncoded(), (int)2) + ":" + Base64.encodeToString((byte[])this.getIntegrityKey().getEncoded(), (int)2);
        }

        public int hashCode() {
            return (31 + this.confidentialityKey.hashCode()) * 31 + this.integrityKey.hashCode();
        }

        public boolean equals(Object obj) {
            SecretKeys secretKeys;
            if (this == secretKeys) {
                return true;
            }
            if (secretKeys == null) {
                return false;
            }
            if (this.getClass() != secretKeys.getClass()) {
                return false;
            }
            secretKeys = secretKeys;
            if (!this.integrityKey.equals(secretKeys.integrityKey)) {
                return false;
            }
            return this.confidentialityKey.equals(secretKeys.confidentialityKey);
        }
    }

    public static class CipherTextIvMac {
        private final byte[] cipherText;
        private final byte[] iv;
        private final byte[] mac;

        /*
         * WARNING - void declaration
         */
        public CipherTextIvMac(byte[] c, byte[] i, byte[] h) {
            void var3_4;
            void var1_1;
            void var2_3;
            CipherTextIvMac cipherTextIvMac = object;
            void v1 = var2_3;
            CipherTextIvMac cipherTextIvMac2 = object;
            void v3 = var1_1;
            CipherTextIvMac cipherTextIvMac3 = object;
            byte[] byArray = new byte[((void)var1_1).length];
            Object object = byArray;
            cipherTextIvMac3.cipherText = byArray;
            int n = ((void)v3).length;
            System.arraycopy(v3, 0, object, 0, n);
            byte[] byArray2 = new byte[((void)var2_3).length];
            object = byArray2;
            cipherTextIvMac2.iv = byArray2;
            n = ((void)v1).length;
            System.arraycopy(v1, 0, object, 0, n);
            byte[] byArray3 = new byte[((void)var3_4).length];
            object = byArray3;
            cipherTextIvMac.mac = byArray3;
            n = h.length;
            System.arraycopy(h, 0, object, 0, n);
        }

        public CipherTextIvMac(String base64IvAndCiphertext) {
            String[] stringArray = base64IvAndCiphertext.split(":");
            if (stringArray.length == 3) {
                this.iv = Base64.decode((String)stringArray[0], (int)2);
                this.mac = Base64.decode((String)stringArray[1], (int)2);
                this.cipherText = Base64.decode((String)stringArray[2], (int)2);
                return;
            }
            throw new IllegalArgumentException("Cannot parse iv:ciphertext:mac");
        }

        /*
         * WARNING - void declaration
         */
        public static byte[] ivCipherConcat(byte[] iv, byte[] cipherText) {
            byte[] byArray;
            void var1_2;
            byte[] byArray2 = new byte[iv.length + ((void)var1_2).length];
            void v0 = var1_2;
            int n = byArray.length;
            System.arraycopy(byArray, 0, byArray2, 0, n);
            n = byArray.length;
            int n2 = ((void)v0).length;
            System.arraycopy(v0, 0, byArray2, n, n2);
            return byArray2;
        }

        public byte[] getCipherText() {
            return this.cipherText;
        }

        public byte[] getIv() {
            return this.iv;
        }

        public byte[] getMac() {
            return this.mac;
        }

        public String toString() {
            CipherTextIvMac cipherTextIvMac = this_;
            String this_ = Base64.encodeToString((byte[])cipherTextIvMac.iv, (int)2);
            String string2 = Base64.encodeToString((byte[])cipherTextIvMac.cipherText, (int)2);
            return String.format((String)this_ + ":" + Base64.encodeToString((byte[])cipherTextIvMac.mac, (int)2) + ":" + string2, new Object[0]);
        }

        public int hashCode() {
            return ((31 + Arrays.hashCode(this.cipherText)) * 31 + Arrays.hashCode(this.iv)) * 31 + Arrays.hashCode(this.mac);
        }

        public boolean equals(Object obj) {
            CipherTextIvMac cipherTextIvMac;
            if (this == cipherTextIvMac) {
                return true;
            }
            if (cipherTextIvMac == null) {
                return false;
            }
            if (this.getClass() != cipherTextIvMac.getClass()) {
                return false;
            }
            cipherTextIvMac = cipherTextIvMac;
            if (!Arrays.equals(this.cipherText, cipherTextIvMac.cipherText)) {
                return false;
            }
            if (!Arrays.equals(this.iv, cipherTextIvMac.iv)) {
                return false;
            }
            return Arrays.equals(this.mac, cipherTextIvMac.mac);
        }
    }

    public static final class PrngFixes {
        private static final int VERSION_CODE_JELLY_BEAN_MR2 = 18;
        public static boolean USE_DEVICE_IDENTIFIERS_IN_SEED = false;
        private static final String TAG = "PrngFixes";

        private PrngFixes() {
        }

        public static void apply(Context context) {
            Context context2 = context;
            PrngFixes.applyOpenSSLFix(context2);
            PrngFixes.installLinuxPRNGSecureRandom(context2);
        }

        private static void applyOpenSSLFix(Context context) throws SecurityException {
            int n;
            block9: {
                Context context2;
                Object object;
                Method method;
                if (Build.VERSION.SDK_INT > 18) {
                    return;
                }
                try {
                    method = Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_seed", byte[].class);
                    context2 = object;
                    object = null;
                }
                catch (Exception exception) {
                    throw new SecurityException("Failed to seed OpenSSL PRNG", exception);
                }
                byte[] byArray = PrngFixes.generateSeed(context2);
                method.invoke(object, new Object[]{byArray});
                Method method2 = Class.forName("org.apache.harmony.xnet.provider.jsse.NativeCrypto").getMethod("RAND_load_file", String.class, Long.TYPE);
                object = 1024;
                n = (Integer)method2.invoke(null, "/dev/urandom", object);
                if (n != 1024) break block9;
                return;
            }
            throw new IOException("Unexpected number of bytes read from Linux PRNG: " + n);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static void installLinuxPRNGSecureRandom(Context context) throws SecurityException {
            if (Build.VERSION.SDK_INT > 18) {
                return;
            }
            var1_1 = Security.getProviders("SecureRandom.SHA1PRNG");
            var2_3 = Security.class;
            synchronized (Security.class) {
                block10: {
                    if (var1_1 == null) ** GOTO lbl9
                    try {
                        if (var1_1.length >= 1 && var1_1[0].getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) break block10;
lbl9:
                        // 2 sources

                        Security.insertProviderAt(new LinuxPRNGSecureRandomProvider((Context)var0), 1);
                    }
                    catch (Throwable v0) {
                        ** GOTO lbl27
                    }
                }
                var0 = v1;
                {
                    if (!new SecureRandom().getProvider().getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) {
                        throw new SecurityException("new SecureRandom() backed by wrong Provider: " + var0.getProvider().getClass());
                    }
                    var0 = null;
                    try {
                        var0 = SecureRandom.getInstance("SHA1PRNG");
                    }
                    catch (NoSuchAlgorithmException var1_2) {
                        new SecurityException("SHA1PRNG not available", var1_2);
                    }
                    if (var0.getProvider().getClass().getSimpleName().equals(LinuxPRNGSecureRandomProvider.class.getSimpleName())) {
                        // ** MonitorExit[var2_3] (shouldn't be in output)
                        return;
                    }
                    throw new SecurityException("SecureRandom.getInstance(\"SHA1PRNG\") backed by wrong Provider: " + var0.getProvider().getClass());
lbl27:
                    // 1 sources

                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
                throw v0;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static byte[] generateSeed(Context context) {
            DataOutputStream dataOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
            }
            catch (IOException iOException) {
                throw new SecurityException("Failed to generate seed", iOException);
            }
            DataOutputStream dataOutputStream2 = dataOutputStream;
            new DataOutputStream(byteArrayOutputStream2).writeLong(System.currentTimeMillis());
            dataOutputStream2.writeLong(System.nanoTime());
            dataOutputStream2.writeInt(Process.myPid());
            dataOutputStream2.writeInt(Process.myUid());
            if (USE_DEVICE_IDENTIFIERS_IN_SEED) {
                Context context2;
                ((OutputStream)dataOutputStream2).write(PrngFixes.getBuildFingerprintAndDeviceSerial(context2));
            }
            ((OutputStream)dataOutputStream2).close();
            return byteArrayOutputStream2.toByteArray();
        }

        @SuppressLint(value={"MissingPermission", "NewApi"})
        private static String getDeviceSerialNumber(Context context) {
            try {
                return (String)Build.class.getField("SERIAL").get(null);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private static byte[] getBuildFingerprintAndDeviceSerial(Context context) {
            Object object;
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            String string2 = Build.FINGERPRINT;
            if (string2 != null) {
                stringBuilder2.append(string2);
            }
            if ((object = PrngFixes.getDeviceSerialNumber(object)) != null) {
                stringBuilder2.append((String)object);
            }
            try {
                return stringBuilder2.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException("UTF-8 encoding not supported");
            }
        }

        private static class LinuxPRNGSecureRandomProvider
        extends Provider {
            /*
             * WARNING - void declaration
             */
            public LinuxPRNGSecureRandomProvider(Context context) {
                void var1_1;
                LinuxPRNGSecureRandomProvider linuxPRNGSecureRandomProvider = this;
                super("LinuxPRNG", 1.0, "A Linux-specific random number provider that uses /dev/urandom");
                LinuxPRNGSecureRandom.setContext((Context)var1_1);
                ((Dictionary)linuxPRNGSecureRandomProvider).put("SecureRandom.SHA1PRNG", LinuxPRNGSecureRandom.class.getName());
                ((Dictionary)linuxPRNGSecureRandomProvider).put("SecureRandom.SHA1PRNG ImplementedIn", "Software");
            }
        }

        public static class LinuxPRNGSecureRandom
        extends SecureRandomSpi {
            private static final File URANDOM_FILE = new File("/dev/urandom");
            private static final Object sLock = new Object();
            private static DataInputStream sUrandomIn;
            private static OutputStream sUrandomOut;
            private static Context context;
            private boolean mSeeded;

            public static void setContext(Context context) {
                LinuxPRNGSecureRandom.context = context;
            }

            /*
             * Loose catch block
             * Enabled aggressive exception aggregation
             */
            private DataInputStream getUrandomInputStream() {
                Object object = sLock;
                synchronized (object) {
                    Throwable throwable2;
                    block6: {
                        block5: {
                            if (sUrandomIn != null) break block5;
                            try {
                                sUrandomIn = new DataInputStream(new FileInputStream(URANDOM_FILE));
                                break block5;
                                catch (Throwable throwable2) {
                                    break block6;
                                }
                            }
                            catch (IOException iOException) {
                                throw new SecurityException("Failed to open " + URANDOM_FILE + " for reading", iOException);
                            }
                        }
                        return sUrandomIn;
                    }
                    throw throwable2;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private OutputStream getUrandomOutputStream() throws IOException {
                Object object = sLock;
                synchronized (object) {
                    Throwable throwable2;
                    block4: {
                        block3: {
                            try {
                                if (sUrandomOut != null) break block3;
                                sUrandomOut = new FileOutputStream(URANDOM_FILE);
                            }
                            catch (Throwable throwable2) {
                                break block4;
                            }
                        }
                        return sUrandomOut;
                    }
                    throw throwable2;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected void engineSetSeed(byte[] bytes) {
                block12: {
                    block11: {
                        v0 = this;
                        v1 = v0;
                        v2 = v0;
                        var2_2 = LinuxPRNGSecureRandom.sLock;
                        {
                            catch (IOException v3) {
                                break block11;
                            }
                            try {
                                ** synchronized (var2_2)
                            }
                            catch (Throwable v4) {
                                break block12;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    v5 = v1.getUrandomOutputStream();
                                    v6 = v5;
                                    v7 = v5;
                                    v8 = var1_1;
                                }
                                catch (Throwable v9) {}
                                {
                                    throw v9;
                                }
                            }
                        }
                        {
                            v6.write((byte[])v8);
                            v7.flush();
                        }
lbl23:
                        // 2 sources

                        while (true) {
                            v2.mSeeded = true;
                            return;
                        }
                    }
                    v2 = this;
                    B5B.xfp(PrngFixes.class.getSimpleName(), "Failed to mix seed into " + LinuxPRNGSecureRandom.URANDOM_FILE);
                    ** while (true)
                }
                this.mSeeded = true;
                throw v4;
            }

            /*
             * Exception decompiling
             */
            @Override
            protected void engineNextBytes(byte[] bytes) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [9 : 48->49)] java.io.IOException
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @Override
            protected byte[] engineGenerateSeed(int size) {
                byte[] byArray = new byte[size];
                this.engineNextBytes(byArray);
                return byArray;
            }
        }
    }
}

