/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util.crypt;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Base64;
import com.calldorado.log.B5B;
import com.calldorado.util.DeviceUtil;
import com.calldorado.util.crypt.AesCbcWithIntegrity;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.SecretKeySpec;

public class SecurePreferences
implements SharedPreferences {
    private static final int ORIGINAL_ITERATION_COUNT = 10000;
    public static final String SALT_INPUT = "unknown";
    private static boolean sLoggingEnabled = false;
    private static final String TAG = "com.calldorado.util.crypt.SecurePreferences";
    private SharedPreferences sharedPreferences;
    private AesCbcWithIntegrity.SecretKeys keys;
    private String salt;
    private String sharedPrefFilename;
    private AesCbcWithIntegrity aesCbcWithIntegrity;
    private boolean usingSerialAsSalt;

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context) {
        this((Context)var1_1, "", null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String salt) {
        this((Context)var1_1, null, "", (String)var2_2, null, 10000, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, int iterationCount) {
        this((Context)var1_1, "", null, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String password, String sharedPrefFilename) {
        this((Context)var1_1, (String)var2_2, null, (String)var3_3, 10000);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String password, String sharedPrefFilename, boolean decryptionWithDeviceFingerprintAndSerial) {
        this((Context)var1_1, (String)var2_2, null, (String)var3_3, 10000, (boolean)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String password, String sharedPrefFilename, int iterationCount) {
        this((Context)var1_1, null, (String)var2_2, null, (String)var3_3, (int)var4_4, false);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, AesCbcWithIntegrity.SecretKeys secretKey, String sharedPrefFilename) {
        this((Context)var1_1, (AesCbcWithIntegrity.SecretKeys)var2_2, null, null, (String)var3_3, 0, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, AesCbcWithIntegrity.SecretKeys secretKey, String sharedPrefFilename, boolean decryptionWithDeviceFingerprintAndSerial) {
        this((Context)var1_1, (AesCbcWithIntegrity.SecretKeys)var2_2, null, null, (String)var3_3, 0, (boolean)var4_4);
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String password, String salt, String sharedPrefFilename, int iterationCount) {
        this((Context)var1_1, null, (String)var2_2, (String)var3_3, (String)var4_4, (int)var5_5, false);
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SecurePreferences(Context context, String password, String salt, String sharedPrefFilename, int iterationCount, boolean decryptionWithDeviceFingerprintAndSerial) {
        this((Context)var1_1, null, (String)var2_2, (String)var3_3, (String)var4_4, (int)var5_5, (boolean)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurePreferences(Context context, AesCbcWithIntegrity.SecretKeys secretKey, String password, String salt, String sharedPrefFilename, int iterationCount, boolean decryptionWithDeviceFingerprintAndSerial) {
        GeneralSecurityException generalSecurityException2;
        block8: {
            block9: {
                String string2;
                block7: {
                    void var3_4;
                    void var4_5;
                    void var7_8;
                    String string3;
                    SecurePreferences securePreferences = this;
                    securePreferences.usingSerialAsSalt = false;
                    if (securePreferences.sharedPreferences == null) {
                        void var5_6;
                        this.sharedPreferences = this.getSharedPreferenceFile((Context)string3, (String)var5_6);
                    }
                    this.setDecryptionWithDeviceFingerprintAndSerial((boolean)var7_8);
                    this.aesCbcWithIntegrity = AesCbcWithIntegrity.getInstance((Context)string3);
                    this.salt = var4_5;
                    if (string2 != null) {
                        this.keys = string2;
                        return;
                    }
                    if (!TextUtils.isEmpty((CharSequence)var3_4)) {
                        SecurePreferences securePreferences2 = this;
                        securePreferences2.generateNewKeys((String)var3_4, securePreferences2.getSalt((Context)string3, "constructor"));
                        return;
                    }
                    try {
                        void var6_7;
                        SecurePreferences securePreferences3 = this;
                        string3 = securePreferences3.generateAesKeyName((Context)string3, (int)var6_7);
                        string2 = securePreferences3.sharedPreferences.getString(string3, null);
                        if (string2 != null) break block7;
                    }
                    catch (GeneralSecurityException generalSecurityException2) {
                        break block8;
                    }
                    SecurePreferences securePreferences4 = this;
                    securePreferences4.keys = securePreferences4.aesCbcWithIntegrity.generateKey();
                    if (!securePreferences4.sharedPreferences.edit().putString(string3, this.keys.toString()).commit()) {
                        B5B.xfp(TAG, "Key not committed to prefs");
                    }
                    break block9;
                }
                this.keys = this.aesCbcWithIntegrity.keys(string2);
            }
            if (this.keys == null) throw new GeneralSecurityException("Problem generating Key");
            return;
        }
        if (!sLoggingEnabled) throw new IllegalStateException(generalSecurityException2);
        B5B.ix0(TAG, "Error init:" + generalSecurityException2.getMessage());
        throw new IllegalStateException(generalSecurityException2);
    }

    /*
     * WARNING - void declaration
     */
    private SharedPreferences getSharedPreferenceFile(Context context, String prefFilename) {
        void var1_1;
        void var2_2;
        this.sharedPrefFilename = var2_2;
        if (TextUtils.isEmpty((CharSequence)prefFilename)) {
            return PreferenceManager.getDefaultSharedPreferences((Context)var1_1);
        }
        return var1_1.getSharedPreferences((String)var2_2, 0);
    }

    /*
     * WARNING - void declaration
     */
    private String generateAesKeyName(Context context, int iterationCount) throws GeneralSecurityException {
        void var2_2;
        byte[] byArray;
        SecurePreferences securePreferences = this_;
        void v1 = byArray;
        String this_ = v1.getPackageName();
        byArray = securePreferences.getSalt((Context)v1, "generateAesKeyName").getBytes();
        return SecurePreferences.hashPrefKey(securePreferences.aesCbcWithIntegrity.generateKeyFromPassword(this_, byArray, (int)var2_2).toString());
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"HardwareIds", "NewApi", "MissingPermission"})
    private String generateSalt(Context context) {
        SecurePreferences securePreferences = this_;
        Object this_ = SALT_INPUT;
        if (securePreferences.usingSerialAsSalt) {
            void var1_1;
            if (Build.VERSION.SDK_INT >= 28 && DeviceUtil.getTargetSdk((Context)var1_1) >= 28 && var1_1.checkSelfPermission("android.permission.READ_PHONE_STATE") == 0) {
                B5B.B5B(TAG, "generateSalt: Generating salt with getSerial().");
                this_ = Build.getSerial();
            } else {
                B5B.B5B(TAG, "generateSalt: Generating salt with old method.");
                this_ = SecurePreferences.getOldSalt((Context)var1_1);
            }
        }
        B5B.B5B(TAG, "generateSalt: " + (String)this_);
        return this_;
    }

    public static String getOldSalt(Context context) {
        String string2;
        block4: {
            Context context2;
            string2 = (String)Build.class.getField("SERIAL").get(null);
            if (!TextUtils.isEmpty((CharSequence)string2)) break block4;
            try {
                B5B.B5B(TAG, "getOldSalt: deviceSerial is empty.");
                string2 = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
            }
            catch (Exception exception) {
                B5B.B5B(TAG, "getOldSalt: Using ANDROID_ID");
                string2 = Settings.Secure.getString((ContentResolver)context2.getContentResolver(), (String)"android_id");
            }
        }
        B5B.B5B(TAG, "getOldSalt: Returning " + string2);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private String getSalt(Context context, String from) {
        if (TextUtils.isEmpty((CharSequence)this.salt)) {
            void var1_1;
            void var2_2;
            B5B.B5B(TAG, "generating salt from " + (String)var2_2);
            return this.generateSalt((Context)var1_1);
        }
        return this.salt;
    }

    /*
     * WARNING - void declaration
     */
    public static String hashPrefKey(String prefKey) {
        String string2;
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        MessageDigest messageDigest2 = messageDigest;
        MessageDigest messageDigest3 = messageDigest;
        byte[] byArray = string2.getBytes("UTF-8");
        int n = 0;
        try {
            messageDigest2.update(byArray, n, byArray.length);
            return Base64.encodeToString((byte[])messageDigest3.digest(), (int)2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        if (sLoggingEnabled) {
            void var0_4;
            B5B.ix0(TAG, "Problem generating hash", (Exception)var0_4);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String decrypt(String ciphertext) {
        AesCbcWithIntegrity.CipherTextIvMac cipherTextIvMac;
        void var1_4;
        if (TextUtils.isEmpty((CharSequence)ciphertext)) {
            return var1_4;
        }
        SecurePreferences securePreferences = this;
        AesCbcWithIntegrity.CipherTextIvMac cipherTextIvMac2 = cipherTextIvMac;
        try {
            cipherTextIvMac = new AesCbcWithIntegrity.CipherTextIvMac((String)var1_4);
            return securePreferences.aesCbcWithIntegrity.decryptString(cipherTextIvMac2, this.keys);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        if (sLoggingEnabled) {
            void var0_3;
            B5B.ix0(TAG, "decrypt", (Exception)var0_3);
        }
        return null;
    }

    public static boolean isLoggingEnabled() {
        return sLoggingEnabled;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        sLoggingEnabled = loggingEnabled;
    }

    public static void migrateFromSecPrefs(Context context) {
        Map<String, String> map;
        map = new SecurePreferences((Context)map, "fioAseg3DR228UjdWlitF", "cdo_prefs_sec").getAll();
        SharedPreferences sharedPreferences = context.getSharedPreferences("cdo_prefs_unsec", 0);
        if (!map.isEmpty()) {
            SecurePreferences.migrateToNewPref(sharedPreferences, SecurePreferences.getCleanMap(map));
        }
    }

    private static Map<String, String> getCleanMap(Map<String, String> oldPrefMap) {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : oldPrefMap.entrySet()) {
            String string2 = SecurePreferences.matchHashedKey(entry.getKey());
            if (string2.isEmpty()) continue;
            hashMap2.put(string2, entry.getValue());
        }
        return hashMap2;
    }

    private static HashMap<String, String> createKeyHashMap() {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        hashMap2.put(SecurePreferences.hashPrefKey("cfgQWCB"), "cfgQWCB");
        hashMap2.put(SecurePreferences.hashPrefKey("bypassActionRec"), "bypassActionRec");
        hashMap2.put(SecurePreferences.hashPrefKey("showAds"), "showAds");
        hashMap2.put(SecurePreferences.hashPrefKey("p3Conditions"), "p3Conditions");
        hashMap2.put(SecurePreferences.hashPrefKey("searchThrottle"), "searchThrottle");
        hashMap2.put(SecurePreferences.hashPrefKey("targetingPriotrity"), "targetingPriotrity");
        hashMap2.put(SecurePreferences.hashPrefKey("isBlockHomeEnabled"), "isBlockHomeEnabled");
        hashMap2.put(SecurePreferences.hashPrefKey("statBundleSize"), "statBundleSize");
        hashMap2.put(SecurePreferences.hashPrefKey("accountID"), "accountID");
        hashMap2.put(SecurePreferences.hashPrefKey("serverAdresse"), "serverAdresse");
        hashMap2.put(SecurePreferences.hashPrefKey("advertisingON"), "advertisingON");
        hashMap2.put(SecurePreferences.hashPrefKey("isEEATermsAccepted"), "isEEATermsAccepted");
        hashMap2.put(SecurePreferences.hashPrefKey("sendStatsLimit"), "sendStatsLimit");
        hashMap2.put(SecurePreferences.hashPrefKey("HostAppDataConfig"), "HostAppDataConfig");
        hashMap2.put(SecurePreferences.hashPrefKey("firstAppPackageName"), "firstAppPackageName");
        hashMap2.put(SecurePreferences.hashPrefKey("acceptedConditions"), "acceptedConditions");
        hashMap2.put(SecurePreferences.hashPrefKey("blockTimeString"), "blockTimeString");
        hashMap2.put(SecurePreferences.hashPrefKey("cfgGuid"), "cfgGuid");
        hashMap2.put(SecurePreferences.hashPrefKey("billingInfo"), "billingInfo");
        hashMap2.put(SecurePreferences.hashPrefKey("killSwitch"), "killSwitch");
        hashMap2.put(SecurePreferences.hashPrefKey("tutelaEnabled"), "tutelaEnabled");
        hashMap2.put(SecurePreferences.hashPrefKey("adidString"), "adidString");
        hashMap2.put(SecurePreferences.hashPrefKey("aftercallDelayThreshold"), "aftercallDelayThreshold");
        hashMap2.put(SecurePreferences.hashPrefKey("tutelaConditions"), "tutelaConditions");
        return hashMap2;
    }

    private static String matchHashedKey(String encodedKey) {
        String string2;
        HashMap<String, String> hashMap = SecurePreferences.createKeyHashMap();
        if (hashMap.containsKey(string2)) {
            return hashMap.get(string2);
        }
        return "";
    }

    private static void migrateToNewPref(SharedPreferences secSharedPrefs, Map<String, String> decodedKeyValueMap) {
        Iterator iterator;
        SharedPreferences sharedPreferences;
        if (decodedKeyValueMap.isEmpty()) {
            return;
        }
        sharedPreferences = sharedPreferences.edit();
        for (Map.Entry entry : iterator.entrySet()) {
            if (SecurePreferences.isMatchingBooleanPref((String)entry.getValue())) {
                sharedPreferences.putBoolean((String)entry.getKey(), Boolean.parseBoolean((String)entry.getValue()));
                continue;
            }
            if (SecurePreferences.isMatchingLongPref((String)entry.getKey())) {
                sharedPreferences.putLong((String)entry.getKey(), Long.parseLong((String)entry.getValue()));
                continue;
            }
            if (SecurePreferences.isMatchingIntPref((String)entry.getKey())) {
                sharedPreferences.putInt((String)entry.getKey(), Integer.parseInt((String)entry.getValue()));
                continue;
            }
            sharedPreferences.putString((String)entry.getKey(), (String)entry.getValue());
        }
        sharedPreferences.apply();
    }

    private static boolean isMatchingIntPref(String key) {
        String string2;
        return key.equals("searchThrottle") || string2.equals("statBundleSize") || string2.equals("sendStatsLimit") || string2.equals("blockTimeString");
    }

    private static boolean isMatchingLongPref(String key) {
        return key.equals("aftercallDelayThreshold");
    }

    private static boolean isMatchingBooleanPref(String key) {
        String string2;
        return key.equals("true") || string2.equals("false");
    }

    public void destroyKeys() {
        this.keys = null;
    }

    /*
     * WARNING - void declaration
     */
    public String decodeKey(String prefKey) {
        int n;
        Object object;
        MessageDigest messageDigest;
        SecretKeySpec secretKeySpec;
        Object object2 = Base64.decode((String)prefKey, (int)2);
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        Object object3 = object2;
        secretKeySpec = new SecretKeySpec((byte[])object3, 0, ((Object)object3).length, "AES");
        String string2 = TAG;
        B5B.B5B(string2, "decodeKey: " + secretKeySpec2.getAlgorithm() + ", " + secretKeySpec2.getFormat() + ", " + secretKeySpec2.getEncoded());
        try {
            void var1_3;
            B5B.B5B(string2, "decodeKey: " + (String)var1_3 + " turns to base64 decoded " + new String((byte[])object2, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
            object = object2;
            n = 0;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (sLoggingEnabled) {
                B5B.ix0(TAG, "Problem generating hash", noSuchAlgorithmException);
            }
            return null;
        }
        messageDigest.update((byte[])object, n, ((Object)object).length);
        return messageDigest.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String encrypt(String cleartext) {
        GeneralSecurityException generalSecurityException2;
        block6: {
            void var1_3;
            if (TextUtils.isEmpty((CharSequence)cleartext)) {
                return var1_3;
            }
            try {
                return this.aesCbcWithIntegrity.encrypt((String)var1_3, this.keys).toString();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (GeneralSecurityException generalSecurityException2) {
                break block6;
            }
            if (sLoggingEnabled) {
                B5B.ix0(TAG, "encrypt", unsupportedEncodingException);
            }
            return null;
        }
        if (sLoggingEnabled) {
            B5B.ix0(TAG, "encrypt", generalSecurityException2);
        }
        return null;
    }

    public Map<String, String> getAll() {
        HashMap<String, String> hashMap;
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>();
        for (Map.Entry exception : this.sharedPreferences.getAll().entrySet()) {
            Object v;
            try {
                v = exception.getValue();
                if (v == null) continue;
            }
            catch (Exception exception2) {
                if (!sLoggingEnabled) continue;
                B5B.ix0(TAG, "error during getAll", exception2);
                continue;
            }
            if (v.equals(this.keys.toString())) continue;
            HashMap<String, String> hashMap3 = hashMap2;
            SecurePreferences securePreferences = this;
            Object v2 = v;
            String string2 = (String)exception.getKey();
            hashMap3.put(string2, securePreferences.decrypt(v2.toString()));
        }
        return hashMap2;
    }

    /*
     * WARNING - void declaration
     */
    public String getString(String key, String defaultValue) {
        void var2_2;
        void var1_1;
        String string2 = ((SecurePreferences)((Object)this_)).sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        String this_ = ((SecurePreferences)((Object)this_)).decrypt(string2);
        if (string2 != null && this_ != null) {
            return this_;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String getEncryptedString(String key, String defaultValue) {
        Object object;
        void var1_1;
        String this_ = ((SecurePreferences)((Object)this_)).sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        if (this_ != null) {
            object = this_;
        }
        return object;
    }

    @TargetApi(value=11)
    public Set<String> getStringSet(String key, Set<String> defaultValues) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2;
        Object object;
        if ((object = this.sharedPreferences.getStringSet(SecurePreferences.hashPrefKey((String)object), null)) == null) {
            return hashSet2;
        }
        hashSet2 = hashSet;
        hashSet = new HashSet<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            hashSet2.add(this.decrypt((String)object.next()));
        }
        return hashSet2;
    }

    /*
     * WARNING - void declaration
     */
    public int getInt(String key, int defaultValue) {
        void var2_2;
        void var1_1;
        String string2 = this.sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        if (string2 == null) {
            return (int)var2_2;
        }
        try {
            return Integer.parseInt(this.decrypt(string2));
        }
        catch (Exception exception) {
            this.edit().putInt((String)var1_1, (int)var2_2).apply();
            exception.printStackTrace();
            return (int)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public long getLong(String key, long defaultValue) {
        void var2_2;
        void var1_1;
        String string2 = this.sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        if (string2 == null) {
            return (long)var2_2;
        }
        try {
            return Long.parseLong(this.decrypt(string2));
        }
        catch (Exception exception) {
            this.edit().putLong((String)var1_1, (long)var2_2).apply();
            exception.printStackTrace();
            return (long)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public float getFloat(String key, float defaultValue) {
        void var2_2;
        void var1_1;
        String string2 = this.sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        if (string2 == null) {
            return (float)var2_2;
        }
        try {
            return Float.parseFloat(this.decrypt(string2));
        }
        catch (Exception exception) {
            this.edit().putFloat((String)var1_1, (float)var2_2).apply();
            exception.printStackTrace();
            return (float)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBoolean(String key, boolean defaultValue) {
        void var2_2;
        void var1_1;
        String string2 = this.sharedPreferences.getString(SecurePreferences.hashPrefKey((String)var1_1), null);
        if (string2 == null) {
            return (boolean)var2_2;
        }
        try {
            return Boolean.parseBoolean(this.decrypt(string2));
        }
        catch (NumberFormatException numberFormatException) {
            this.edit().putBoolean((String)var1_1, (boolean)var2_2).apply();
            numberFormatException.printStackTrace();
            return (boolean)var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(String key) {
        void var1_1;
        return this.sharedPreferences.contains(SecurePreferences.hashPrefKey((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"CommitPrefEdits", "ApplySharedPref"})
    public void handlePasswordChange(String newPassword, Context context, int iterationCount) throws GeneralSecurityException {
        HashMap hashMap;
        void var3_3;
        AesCbcWithIntegrity.SecretKeys secretKeys;
        SharedPreferences sharedPreferences;
        SecurePreferences securePreferences = this;
        Object object = securePreferences.getSalt((Context)sharedPreferences, "handlePasswordChange").getBytes();
        secretKeys = securePreferences.aesCbcWithIntegrity.generateKeyFromPassword((String)((Object)secretKeys), (byte[])object, (int)var3_3);
        Object object22 = securePreferences.sharedPreferences.getAll();
        object = hashMap;
        hashMap = new HashMap(object22.size());
        for (String string2 : object22.keySet()) {
            Object v = object22.get(string2);
            if (!(v instanceof String)) continue;
            object.put(string2, this.decrypt((String)v));
        }
        SecurePreferences securePreferences2 = this;
        securePreferences2.destroyKeys();
        SharedPreferences.Editor editor = securePreferences2.sharedPreferences.edit();
        editor.clear();
        editor.commit();
        securePreferences2.sharedPreferences = null;
        sharedPreferences = this.getSharedPreferenceFile((Context)sharedPreferences, securePreferences2.sharedPrefFilename);
        this.sharedPreferences = sharedPreferences;
        this.keys = secretKeys;
        secretKeys = sharedPreferences.edit();
        for (Object object22 : object.keySet()) {
            secretKeys.putString((String)object22, this.encrypt((String)object.get(object22)));
        }
        secretKeys.commit();
    }

    /*
     * WARNING - void declaration
     */
    public void handlePasswordChange(String newPassword, Context context) throws GeneralSecurityException {
        void var2_2;
        void var1_1;
        this.handlePasswordChange((String)var1_1, (Context)var2_2, 10000);
    }

    /*
     * WARNING - void declaration
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        void var1_1;
        this.sharedPreferences.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener, boolean decryptKeys) {
        if (!decryptKeys) {
            void var1_1;
            this.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        void var1_1;
        this.sharedPreferences.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)var1_1);
    }

    public Editor edit() {
        return new Editor(this);
    }

    /*
     * WARNING - void declaration
     */
    public void setDecryptionWithDeviceFingerprintAndSerial(boolean enable) {
        void var1_1;
        B5B.esR(TAG, "setting DecryptionWithDeviceFingerprintAndSerial to " + (boolean)var1_1);
        this.usingSerialAsSalt = AesCbcWithIntegrity.PrngFixes.USE_DEVICE_IDENTIFIERS_IN_SEED = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void generateNewKeys(String password, String salt) {
        void var1_2;
        byte[] byArray;
        SecurePreferences securePreferences;
        try {
            securePreferences = this;
            this.destroyKeys();
            byArray = byArray.getBytes();
        }
        catch (Exception exception) {
            if (sLoggingEnabled) {
                B5B.ix0(TAG, "Error init using user password:" + exception.getMessage());
            }
            throw new IllegalStateException(exception);
        }
        AesCbcWithIntegrity.SecretKeys secretKeys = securePreferences.aesCbcWithIntegrity.generateKeyFromPassword((String)var1_2, byArray, 10000);
        this.keys = secretKeys;
        if (secretKeys != null) {
            return;
        }
        throw new GeneralSecurityException("Problem generating Key From Password");
    }

    public final class Editor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor mEditor;
        private boolean shouldHashKey = true;
        final /* synthetic */ SecurePreferences this$0;

        /*
         * WARNING - void declaration
         */
        private Editor(SecurePreferences this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.mEditor = var1_1.sharedPreferences.edit();
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putUnencryptedString(String key, String value) {
            void var2_2;
            void var1_1;
            Editor editor = this;
            editor.mEditor.putString(SecurePreferences.hashPrefKey((String)var1_1), (String)var2_2);
            return editor;
        }

        @TargetApi(value=11)
        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            String string2;
            Iterator<String> iterator;
            HashSet<String> hashSet;
            HashSet<String> hashSet2 = hashSet;
            hashSet = new HashSet<String>(iterator.size());
            for (String string3 : values) {
                hashSet2.add(this.this$0.encrypt(string3));
            }
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putStringSet(string2, hashSet2);
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putString(String key, String value) {
            void var2_2;
            String string2;
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putString(string2, this.this$0.encrypt((String)var2_2));
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putInt(String key, int value) {
            void var2_2;
            String string2;
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putString(string2, this.this$0.encrypt(Integer.toString((int)var2_2)));
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putLong(String key, long value) {
            void var2_2;
            String string2;
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putString(string2, this.this$0.encrypt(Long.toString((long)var2_2)));
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putFloat(String key, float value) {
            void var2_2;
            String string2;
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putString(string2, this.this$0.encrypt(Float.toString((float)var2_2)));
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            void var2_2;
            String string2;
            if (this.shouldHashKey) {
                string2 = SecurePreferences.hashPrefKey(string2);
            }
            Editor editor = this;
            editor.mEditor.putString(string2, this.this$0.encrypt(Boolean.toString((boolean)var2_2)));
            return editor;
        }

        /*
         * WARNING - void declaration
         */
        public SharedPreferences.Editor remove(String key) {
            void var1_1;
            Editor editor = this;
            editor.mEditor.remove(SecurePreferences.hashPrefKey((String)var1_1));
            return editor;
        }

        public SharedPreferences.Editor clear() {
            Editor editor = this;
            editor.mEditor.clear();
            return editor;
        }

        public boolean commit() {
            return this.mEditor.commit();
        }

        @TargetApi(value=9)
        public void apply() {
            if (Build.VERSION.SDK_INT >= 9) {
                this.mEditor.apply();
            } else {
                this.commit();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void useHashedKey(boolean enabled) {
            void var1_1;
            this.shouldHashKey = var1_1;
        }
    }
}

