/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.util.history;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import com.calldorado.util.history.HistoryModel;
import java.util.List;

@Dao
public interface HistoryDAO {
    @Query(value="SELECT * FROM history")
    public List<HistoryModel> getAll();

    @Query(value="SELECT * FROM history WHERE id IN (:historyId) LIMIT 1")
    public List<HistoryModel> loadById(String var1);

    @Query(value="SELECT * FROM history WHERE calldorado_version IN (:calldoradoVersion)")
    public List<HistoryModel> loadByCdoVersion(String var1);

    @Query(value="SELECT * FROM history WHERE app_code IN (:appVersionCode) LIMIT 1")
    public HistoryModel loadByAppVersionCode(long var1);

    @Query(value="SELECT app_code FROM history WHERE app_code = (:appVersionCode)")
    public long hasAppVersionCode(long var1);

    @Query(value="SELECT * FROM history WHERE app_name LIMIT 1")
    public HistoryModel loadByAppVersionName();

    @Query(value="SELECT * FROM history ORDER BY timestamp DESC LIMIT 1")
    public HistoryModel findNewest();

    @Insert
    public void insertAll(HistoryModel ... var1);

    @Delete
    public void delete(HistoryModel var1);
}

