/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.c1o.sdk.framework;

import android.annotation.SuppressLint;
import android.app.ApplicationExitInfo;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.calldorado.c1o.sdk.framework.AnaSDKService;
import com.calldorado.c1o.sdk.framework.TUn6;
import com.calldorado.c1o.sdk.framework.TUw;
import com.calldorado.c1o.sdk.framework.TUwTU;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

@RequiresApi(value=30)
final class TUdTU {
    private String rQ = TUn6.rJ();
    private int rR = TUn6.rH();
    private int rS = TUn6.rH();
    private String rT = TUn6.rJ();
    private long rU;
    private int rV;
    private long kD;
    private String rW;

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"WrongConstant"})
    TUdTU(ApplicationExitInfo exitInfo) {
        TUn6.rH();
        this.rU = -16384L;
        this.rV = TUn6.rH();
        TUn6.rH();
        this.kD = -16384L;
        this.rW = TUn6.rJ();
        if (exitInfo.getDescription() != null) {
            this.rQ = exitInfo.getDescription();
        }
        this.rR = exitInfo.getImportance();
        this.rS = exitInfo.getPackageUid();
        this.rT = exitInfo.getProcessName();
        if (exitInfo.getPss() > 0L) {
            this.rU = exitInfo.getPss();
        }
        this.rV = exitInfo.getReason();
        this.kD = exitInfo.getTimestamp();
        try {
            InputStream traceInputStream;
            block12: {
                block11: {
                    traceInputStream = exitInfo.getTraceInputStream();
                    try {
                        if (traceInputStream != null) {
                            void var3_5;
                            BufferedReader reader = new BufferedReader(new InputStreamReader(traceInputStream));
                            StringBuilder trace = new StringBuilder();
                            String nextLine = reader.readLine();
                            while (nextLine != null) {
                                trace.append(nextLine);
                                nextLine = reader.readLine();
                            }
                            this.rW = var3_5.toString();
                        }
                        if (traceInputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (traceInputStream != null) {
                            try {
                                traceInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    break block12;
                }
                return;
            }
            traceInputStream.close();
        }
        catch (IOException e) {
            void var1_2;
            this.rW = TUn6.rI();
            TUw.b(TUwTU.rY.sb, "TUApplicationExitInfo", "IOException reading trace stream: " + e.getMessage(), (Exception)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    public final String toString() {
        void var1_1;
        JSONObject json = new JSONObject();
        try {
            String string;
            json.put("description", (Object)this.rQ);
            TUdTU tUdTU = this;
            switch (tUdTU.rR) {
                case 100: {
                    string = "IMPORTANCE_FOREGROUND";
                    break;
                }
                case 125: {
                    string = "IMPORTANCE_FOREGROUND_SERVICE";
                    break;
                }
                case 150: 
                case 325: {
                    string = "IMPORTANCE_TOP_SLEEPING";
                    break;
                }
                case 200: {
                    string = "IMPORTANCE_VISIBLE";
                    break;
                }
                case 130: 
                case 230: {
                    string = "IMPORTANCE_PERCEPTIBLE";
                    break;
                }
                case 350: {
                    string = "IMPORTANCE_CANT_SAVE_STATE";
                    break;
                }
                case 300: {
                    string = "IMPORTANCE_SERVICE";
                    break;
                }
                case 400: {
                    string = "IMPORTANCE_CACHED";
                    break;
                }
                case 1000: {
                    string = "IMPORTANCE_GONE";
                    break;
                }
                case 500: {
                    string = "IMPORTANCE_EMPTY";
                    break;
                }
                default: {
                    string = String.valueOf(tUdTU.rR);
                }
            }
            json.put("importance", (Object)string);
            json.put("packageUid", this.rS);
            json.put("processName", (Object)this.rT);
            json.put("pss", this.rU);
            json.put("reason", (Object)this.kJ());
            json.put("timestamp", this.kD);
            json.put("trace", (Object)this.rW);
        }
        catch (JSONException e) {
            void var2_3;
            TUw.b(TUwTU.rY.sb, "TUApplicationExitInfo", "Failed to serialize: " + e.getMessage(), (Exception)var2_3);
        }
        return var1_1.toString();
    }

    final long iZ() {
        return this.kD;
    }

    final String kJ() {
        switch (this.rV) {
            case 0: {
                return "REASON_UNKNOWN";
            }
            case 1: {
                return "REASON_EXIT_SELF";
            }
            case 2: {
                return "REASON_SIGNALED";
            }
            case 3: {
                return "REASON_LOW_MEMORY";
            }
            case 4: {
                return "REASON_CRASH";
            }
            case 5: {
                return "REASON_CRASH_NATIVE";
            }
            case 6: {
                return "REASON_ANR";
            }
            case 7: {
                return "REASON_INITIALIZATION_FAILURE";
            }
            case 8: {
                return "REASON_PERMISSION_CHANGE";
            }
            case 9: {
                return "REASON_EXCESSIVE_RESOURCE_USAGE";
            }
            case 10: {
                return "REASON_USER_REQUESTED";
            }
            case 11: {
                return "REASON_USER_STOPPED";
            }
            case 12: {
                return "REASON_DEPENDENCY_DIED";
            }
            case 13: {
                return "REASON_OTHER";
            }
        }
        return String.valueOf(this.rV);
    }

    final boolean kK() {
        return !this.rW.equals(TUn6.rJ()) && !this.rW.equals(TUn6.rI());
    }

    /*
     * WARNING - void declaration
     */
    final boolean kL() {
        String serviceClass = "";
        try {
            serviceClass = AnaSDKService.class.getName();
            String packageDomain = serviceClass.substring(0, serviceClass.indexOf(46, 4));
            return this.rW.contains(packageDomain);
        }
        catch (Exception e) {
            void var2_3;
            void var1_1;
            TUw.b(TUwTU.rX.sc, "TUApplicationExitInfo", "Programming error - wrong service class name: " + (String)var1_1 + " Exception: " + e.getMessage(), (Exception)var2_3);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static ArrayList<Long> Z(Context context) {
        void var1_2;
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            context = context.getSharedPreferences("TUApplicationExitInfoV2", 0);
            String anrs = context.getString("ANR_TIMESTAMPS_PREF_KEY", "");
            String st = new StringTokenizer(anrs, ",");
            while (((StringTokenizer)((Object)st)).hasMoreTokens()) {
                result.add(Long.parseLong(((StringTokenizer)((Object)st)).nextToken()));
            }
        }
        catch (Exception e) {
            void var0_1;
            TUw.b(TUwTU.rY.sb, "TUApplicationExitInfo", "Exception reading ANR prefs: " + e.getMessage(), (Exception)var0_1);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    static void a(Context context, ArrayList<Long> anrTimestamps) {
        try {
            void var2_3;
            Iterator iterator;
            Context preferences = context.getSharedPreferences("TUApplicationExitInfoV2", 0);
            StringBuilder builder = new StringBuilder();
            String prefix = "";
            iterator = ((ArrayList)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                Long timestamp = (Long)iterator.next();
                builder.append(prefix).append(timestamp);
                prefix = ",";
            }
            preferences.edit().putString("ANR_TIMESTAMPS_PREF_KEY", var2_3.toString()).apply();
            return;
        }
        catch (Exception e) {
            void var0_1;
            TUw.b(TUwTU.rY.sb, "TUApplicationExitInfo", "Exception writing ANR prefs: " + e.getMessage(), (Exception)var0_1);
            return;
        }
    }
}

