/*
 * Decompiled with CFR 0.152.
 */
package com.qualityinfo;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import com.qualityinfo.ConnectivityService;
import com.qualityinfo.IC;
import com.qualityinfo.ICB;
import com.qualityinfo.IS;
import com.qualityinfo.internal.as;
import com.qualityinfo.internal.br;
import com.qualityinfo.internal.bv;
import com.qualityinfo.internal.fc;
import com.qualityinfo.internal.gc;
import com.qualityinfo.internal.ge;
import com.qualityinfo.internal.gf;
import com.qualityinfo.internal.gg;
import com.qualityinfo.internal.gh;
import com.qualityinfo.internal.gi;
import com.qualityinfo.internal.gm;
import com.qualityinfo.internal.go;
import com.qualityinfo.internal.gq;
import com.qualityinfo.internal.hq;
import com.qualityinfo.internal.ib;
import com.qualityinfo.internal.ih;
import com.qualityinfo.internal.l;
import com.qualityinfo.internal.nu;
import com.qualityinfo.internal.oa;
import com.qualityinfo.internal.od;
import com.qualityinfo.internal.oh;
import com.qualityinfo.internal.p;
import com.qualityinfo.internal.pf;
import com.qualityinfo.internal.pk;
import com.qualityinfo.internal.q;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Map;

public class InsightCore {
    public static final String LIB_NAME = "insight Core SDK";
    public static final String LIB_COPYRIGHT = "\u00a9 2014 - 2022 umlaut communications GmbH";
    public static final String LIB_BUILD = "20221115120445";
    private static InsightCore a;
    private IC b;
    private nu c;
    private a d;
    private od e;
    private ib f;
    private IS g;
    private Context h;
    private PublicKey i;
    private OnGuidChangedListener j;
    private OnLoggingEventListener k;
    private OnConnectivityTestListener l;
    private oa m;
    private br n;
    private l o;
    private bv p;
    private p q;
    private q r;
    private hq s;
    private gq t;
    private gi u;
    private gh v;
    private gm w;
    private ge x;
    private gg y;
    private go z;
    private gc A;
    private gf B;

    public static void init(Context context, int n2) {
        byte[] byArray;
        try {
            InputStream inputStream = context.getResources().openRawResource(n2);
            byArray = pf.a(inputStream);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error while opening the raw resource");
        }
        InsightCore.init(context, byArray);
    }

    public static boolean isInitialized() {
        return a != null;
    }

    public static void init(Context context, byte[] byArray) {
        ICB iCB;
        if (context == null) {
            throw new IllegalArgumentException("context is null");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("config is null");
        }
        if (a != null) {
            return;
        }
        try {
            iCB = ICB.a(byArray);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("configuration is invalid");
        }
        a = new InsightCore(context);
        InsightCore.a.i = iCB.a;
        InsightCore.a.b = iCB.b;
        a.a();
        a.c();
        InsightCore.startServices();
        Log.i((String)LIB_NAME, (String)"Initialized");
    }

    private InsightCore(Context context) {
        this.h = context.getApplicationContext();
    }

    private void a() {
        this.c = new nu();
        this.e = new od(this.h);
        this.g = new IS(this.h);
        if (InsightCore.getInsightConfig().ce()) {
            this.b();
        }
        this.d = new a();
        this.q = new p(this.h);
        this.q.b();
        this.r = new q(this.h);
        this.r.a();
        if (this.g.t()) {
            this.f = new ib(this.h);
        }
        this.B = new gf(this.h);
        this.B.a();
        this.n = new br(this.h);
        this.o = new l(this.h);
        this.p = new bv(this.h);
        IntentFilter intentFilter = new IntentFilter("android.intent.action.SCREEN_OFF");
        this.h.registerReceiver((BroadcastReceiver)this.d, intentFilter);
    }

    private void b() {
        String string = this.g.Q();
        String string2 = Settings.Secure.getString((ContentResolver)this.h.getContentResolver(), (String)"android_id");
        if (string == null || string.isEmpty()) {
            this.g.f(string2);
        } else if (!string.equals(string2)) {
            this.g.f(string2);
            InsightCore.refreshGuid();
        }
    }

    public static q getWifiController() {
        return InsightCore.a.r;
    }

    public static p getRadioController() {
        return InsightCore.a.q;
    }

    public static bv getStatsDatabase() {
        return InsightCore.a.p;
    }

    public static void setTrafficAnalyzerEnabled(boolean bl2) {
        if (InsightCore.getTrafficAnalyzerEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.l(bl2);
        if (bl2) {
            if (InsightCore.a.m == null) {
                InsightCore.a.m = new oa(InsightCore.a.h);
            }
            InsightCore.a.m.a();
        } else if (InsightCore.a.m != null) {
            InsightCore.a.m.b();
            InsightCore.a.m = null;
        }
    }

    public static boolean getTrafficAnalyzerEnabled() {
        return InsightCore.a.g.q();
    }

    public static void setOnGuidChangedListener(OnGuidChangedListener onGuidChangedListener) {
        InsightCore.a.j = onGuidChangedListener;
    }

    public static OnGuidChangedListener getOnGuidChangedListener() {
        return InsightCore.a.j;
    }

    public static void setOnConnectivityTestListener(OnConnectivityTestListener onConnectivityTestListener) {
        InsightCore.a.l = onConnectivityTestListener;
    }

    public static OnConnectivityTestListener getOnConnectivityTestListener() {
        return InsightCore.a.l;
    }

    public static void setOnLoggingEventListener(OnLoggingEventListener onLoggingEventListener) {
        InsightCore.a.k = onLoggingEventListener;
    }

    public static OnLoggingEventListener getOnLoggingEventListener() {
        return InsightCore.a.k;
    }

    public static void startServices() {
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (InsightCore.a.y == null) {
            InsightCore.a.y = new gg(InsightCore.a.h);
        }
        InsightCore.a.y.a();
    }

    public static boolean isExpiredCore() {
        if (InsightCore.getInsightConfig().aN() == -1L) {
            return false;
        }
        return nu.b() > InsightCore.getInsightConfig().aN();
    }

    public static void setMessagingServiceEnabled(boolean bl2) {
        if (InsightCore.getMessagingServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.i(bl2);
        if (InsightCore.a.v == null) {
            InsightCore.a.v = new gh(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.v.a();
        } else {
            InsightCore.a.v.b();
        }
    }

    public static boolean getMessagingServiceEnabled() {
        return InsightCore.a.g.j();
    }

    public static void setConnectivityTestEnabled(boolean bl2) {
        if (InsightCore.getConnectivityTestEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.d(bl2);
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (InsightCore.a.x == null) {
            InsightCore.a.x = new ge(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.x.a();
        } else if (!InsightCore.getConnectivityKeepaliveEnabled()) {
            InsightCore.a.x.b();
        }
    }

    public static boolean getConnectivityTestEnabled() {
        return InsightCore.a.g.e();
    }

    public static void setConnectivityKeepaliveEnabled(boolean bl2) {
        if (InsightCore.getConnectivityKeepaliveEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.e(bl2);
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (InsightCore.a.x == null) {
            InsightCore.a.x = new ge(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.x.a();
        } else if (!InsightCore.getConnectivityTestEnabled()) {
            InsightCore.a.x.b();
        }
    }

    public static boolean getConnectivityKeepaliveEnabled() {
        return InsightCore.a.g.f();
    }

    public static void runConnectivityTestInForeground(boolean bl2, Notification notification) {
        if (!InsightCore.a.g.e()) {
            return;
        }
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (!oh.a(InsightCore.a.h)) {
            return;
        }
        Intent intent = new Intent(InsightCore.a.h, ConnectivityService.class);
        intent.putExtra("com.p3group.insight.extra.EXTRA_FOREGROUND", bl2);
        intent.putExtra("com.p3group.insight.extra.EXTRA_NOTIFICATION", (Parcelable)notification);
        InsightCore.a.h.startService(intent);
    }

    public static void setCoverageMapperServiceEnabled(boolean bl2) {
        if (InsightCore.getCoverageMapperServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.g(bl2);
        if (InsightCore.a.u == null) {
            InsightCore.a.u = new gi(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.u.a();
        } else {
            InsightCore.a.u.b();
        }
    }

    public static boolean getCoverageMapperServiceEnabled() {
        return InsightCore.a.g.i();
    }

    public static void setAppUsageServiceEnabled(boolean bl2) {
        if (InsightCore.getAppUsageServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.f(bl2);
        if (InsightCore.a.t == null) {
            InsightCore.a.t = new gq(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.t.b();
        } else {
            InsightCore.a.t.c();
        }
    }

    public static boolean getAppUsageServiceEnabled() {
        return InsightCore.a.g.h();
    }

    public static void setVoiceServiceEnabled(boolean bl2) {
        if (InsightCore.getVoiceServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.j(bl2);
        if (InsightCore.a.s == null) {
            InsightCore.a.s = new hq(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.s.b();
        } else {
            InsightCore.a.s.c();
        }
    }

    public static boolean getVoiceServiceEnabled() {
        return InsightCore.a.g.l();
    }

    public static void setVoWifiTestManagerEnabled(boolean bl2) {
        if (InsightCore.getVoWifiTestManagerEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.k(bl2);
        if (InsightCore.a.w == null) {
            InsightCore.a.w = new gm(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.w.a();
        } else {
            InsightCore.a.w.b();
        }
    }

    public static boolean getVoWifiTestManagerEnabled() {
        return InsightCore.a.g.o();
    }

    public static void setWifiScanServiceEnabled(boolean bl2) {
        if (InsightCore.getWifiScanServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.p(bl2);
        if (InsightCore.a.z == null) {
            InsightCore.a.z = new go(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.z.a();
        } else {
            InsightCore.a.z.b();
        }
    }

    public static boolean getWifiScanServiceEnabled() {
        return InsightCore.a.g.L();
    }

    public static void setBackgroundTestServiceEnabled(boolean bl2) {
        if (InsightCore.getBackgroundTestServiceEnabled() == bl2) {
            return;
        }
        InsightCore.a.g.q(bl2);
        if (InsightCore.a.A == null) {
            InsightCore.a.A = new gc(InsightCore.a.h);
        }
        if (bl2) {
            InsightCore.a.A.a();
        } else {
            InsightCore.a.A.b();
        }
    }

    public static boolean getBackgroundTestServiceEnabled() {
        return InsightCore.a.g.M();
    }

    public static gf getForegroundTestManager() {
        if (InsightCore.a.B == null) {
            InsightCore.a.B = new gf(InsightCore.a.h);
        }
        return InsightCore.a.B;
    }

    public static PublicKey getPublicKey() {
        return InsightCore.a.i;
    }

    public static synchronized nu getTimeServer() {
        return InsightCore.a.c;
    }

    public static String getGUID() {
        return InsightCore.a.g.d();
    }

    public static void DEBUG_uploadFiles() {
        InsightCore.a.e.a(true);
    }

    public static od getUploadManager() {
        return InsightCore.a.e;
    }

    public static hq getVoiceManager() {
        return InsightCore.a.s;
    }

    public static br getDatabaseHelper() {
        return InsightCore.a.n;
    }

    public static ib getQoeManager() {
        if (InsightCore.a.f == null) {
            InsightCore.a.f = new ib(InsightCore.a.h);
        }
        return InsightCore.a.f;
    }

    public static boolean getQoeManagerEnabled() {
        return InsightCore.a.g.t();
    }

    public static void setQoeManagerEnabled(boolean bl2) {
        InsightCore.a.g.n(bl2);
        if (bl2 && InsightCore.a.f == null) {
            InsightCore.a.f = new ib(InsightCore.a.h);
        }
    }

    public static l getBluetoothController() {
        return InsightCore.a.o;
    }

    public static gq getAppUsageManager() {
        return InsightCore.a.t;
    }

    public static gm getVoWifiTestManager() {
        if (InsightCore.a.w == null) {
            InsightCore.a.w = new gm(InsightCore.a.h);
        }
        return InsightCore.a.w;
    }

    public static gi getNirManager() {
        if (InsightCore.a.u == null) {
            InsightCore.a.u = new gi(InsightCore.a.h);
        }
        return InsightCore.a.u;
    }

    public static gc getBackgroundTestManager() {
        if (InsightCore.a.A == null) {
            InsightCore.a.A = new gc(InsightCore.a.h);
        }
        return InsightCore.a.A;
    }

    public static void register(boolean bl2) {
        if (InsightCore.a.g.s()) {
            InsightCore.a.g.c(bl2);
        }
    }

    public static IS getInsightSettings() {
        return InsightCore.a.g;
    }

    public static IC getInsightConfig() {
        return InsightCore.a.b;
    }

    private void c() {
        if (InsightCore.isExpiredCore()) {
            return;
        }
        if (this.g.q()) {
            this.m = new oa(this.h);
            this.m.a();
        }
        if (this.g.l()) {
            this.s = new hq(this.h);
            this.s.b();
        }
        if (this.g.h()) {
            this.t = new gq(this.h);
            this.t.b();
        }
        if (this.g.i()) {
            this.u = new gi(this.h);
            this.u.a();
        }
        if (this.g.j()) {
            this.v = new gh(this.h);
            this.v.a();
        }
        if (this.g.o()) {
            this.w = new gm(this.h);
            this.w.a();
        }
        if (this.g.e() || this.g.f()) {
            this.x = new ge(this.h);
            this.x.a();
        }
        if (this.g.L()) {
            this.z = new go(this.h);
            this.z.a();
        }
        if (this.g.M()) {
            this.A = new gc(this.h);
            this.A.a();
        }
    }

    private void d() {
        if (this.t != null) {
            this.t.c();
        }
        if (this.v != null) {
            this.v.b();
        }
        if (this.u != null) {
            this.u.b();
        }
        if (this.m != null) {
            this.m.b();
        }
        if (this.s != null) {
            this.s.c();
        }
        if (this.w != null) {
            this.w.b();
        }
        if (this.x != null) {
            this.x.b();
        }
        if (this.z != null) {
            this.z.b();
        }
        if (this.A != null) {
            this.A.b();
        }
        if (this.B != null) {
            this.B.b();
        }
        if (this.y != null) {
            this.y.b();
        }
    }

    @TargetApi(value=21)
    public static void terminate(Context context) {
        JobScheduler jobScheduler;
        Context context2 = context.getApplicationContext();
        if (InsightCore.isInitialized()) {
            a.d();
            InsightCore.getRadioController().c();
            InsightCore.getWifiController().b();
            if (InsightCore.a.d != null) {
                InsightCore.a.h.unregisterReceiver((BroadcastReceiver)InsightCore.a.d);
            }
        } else if (!oh.a(context2) && (jobScheduler = (JobScheduler)context2.getSystemService("jobscheduler")) != null) {
            jobScheduler.cancel(ge.a);
            jobScheduler.cancel(gg.a);
        }
        a = null;
    }

    public static void reInitializeForegroundAppDetector() {
        if (InsightCore.a.t != null) {
            InsightCore.a.t.a();
        }
    }

    public static void putUploadExtraInfo(String string, String string2) {
        String string3;
        if (string.length() == 0 || string2.length() == 0) {
            return;
        }
        as[] asArray = InsightCore.getUploadExtraInfo();
        boolean bl2 = false;
        for (as as2 : asArray) {
            if (!as2.Key.equals(string)) continue;
            as2.Value = string2;
            bl2 = true;
        }
        if (!bl2) {
            as[] asArray2 = new as[asArray.length + 1];
            as as3 = new as(string, string2);
            for (int i2 = 0; i2 < asArray.length; ++i2) {
                asArray2[i2] = asArray[i2];
            }
            asArray2[asArray2.length - 1] = as3;
            string3 = pk.a(asArray2);
        } else {
            string3 = pk.a(asArray);
        }
        InsightCore.getInsightSettings().c(string3);
    }

    public static void refreshGuid() {
        InsightCore.a.g.b(true);
    }

    public static as[] getUploadExtraInfo() {
        String string = InsightCore.getInsightSettings().z();
        as[] asArray = pk.a(string);
        if (asArray == null) {
            asArray = new as[]{};
        }
        return asArray;
    }

    public static void openPrivacyWebPage(Context context) {
        String string = InsightCore.getInsightConfig().bD() + InsightCore.getGUID();
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        context.startActivity(intent);
    }

    public static void setGuidMaxAge(long l2) {
        InsightCore.a.g.m(l2);
    }

    private class a
    extends BroadcastReceiver {
        private a() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent == null || intent.getAction() == null) {
                return;
            }
            if (InsightCore.isExpiredCore()) {
                InsightCore.this.d();
                return;
            }
            InsightCore.startServices();
            if (intent.getAction().equals("android.intent.action.SCREEN_OFF") && InsightCore.getInsightSettings().c()) {
                InsightCore.this.e.a(false);
            }
        }
    }

    public static interface OnLoggingEventListener {
        public void onLoggingEvent(fc var1, long var2, Map<String, String> var4);
    }

    public static interface OnConnectivityTestListener {
        public void onConnectivityTestStart();

        public void onConnectivityTestEnd(ih var1);
    }

    public static interface OnGuidChangedListener {
        public void OnGuidChanged(String var1);
    }
}

