/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Build;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.doralytics.sdk.DoraSDK;
import com.calldorado.doralytics.sdk.base.DoraEventValue;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.logging.CLog;
import com.calldorado.sdk.network.CDONetworkApi;
import com.calldorado.sdk.network.CDONetworkModel;
import com.calldorado.sdk.network.CDOSearchResponseModel;
import com.calldorado.sdk.network.CDOSearchResultModel;
import com.calldorado.sdk.network.NetworkClient;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.ui.ui.ConfigController;
import com.calldorado.sdk.util.AppVersionData;
import com.calldorado.sdk.util.ConnectionSpeedData;
import com.calldorado.sdk.util.FunctionsKt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.android.ext.koin.KoinExtKt;
import org.koin.core.Koin;
import org.koin.core.KoinApplication;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.context.DefaultContextExtKt;
import org.koin.core.context.GlobalContext;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00072\u00020\u0001:\u0003\u0005\u0006\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\b"}, d2={"Lcom/calldorado/sdk/CalldoradoApplication;", "", "()V", "getKoinInstance", "Lorg/koin/core/KoinApplication;", "CDODoraConfigCallback", "CDODoraSearchCallback", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
public final class CalldoradoApplication {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static String lastCallId;
    private static boolean isCurrentCallBlocked;
    public static KoinApplication koinApplication;
    @NotNull
    private static final Lazy<PreferencesManager> mPreferencesManager$delegate;
    @NotNull
    private static final Lazy<ConfigController> configController$delegate;
    @SuppressLint(value={"StaticFieldLeak"})
    public static Context context;

    @NotNull
    public final KoinApplication getKoinInstance() {
        KoinApplication koinApplication = Companion.getKoinApplication();
        if (koinApplication == null) {
            throw new IllegalStateException("Koin has not started yet".toString());
        }
        return koinApplication;
    }

    static {
        lastCallId = "";
        KoinComponent $this$inject_u24default$iv = Companion;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        mPreferencesManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = Companion;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        configController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ConfigController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfigController invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010%\u001a\u00020\u001bJ\u001e\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0010J\u001e\u0010&\u001a\u00020*2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020*J\u001e\u0010&\u001a\u00020+2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020+J\u001e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u001bJ\u0018\u0010,\u001a\u00020-2\u0006\u0010\t\u001a\u00020\n2\b\u0010.\u001a\u0004\u0018\u00010/J\u000e\u00100\u001a\u00020-2\u0006\u0010\t\u001a\u00020\nJ \u00101\u001a\u00020-2\u0006\u00102\u001a\u00020\u001b2\b\b\u0002\u00103\u001a\u00020\u00102\u0006\u0010.\u001a\u000204J\u0006\u00105\u001a\u00020-J\u0018\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u001b2\b\b\u0002\u00108\u001a\u00020\u001bJF\u00109\u001a\u00020-2\u0006\u0010(\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001b2$\b\u0002\u0010;\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0<j\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b`=2\b\b\u0002\u0010>\u001a\u00020?J\u0016\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001bJ*\u0010C\u001a\u00020-2\"\u0010D\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0<j\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b`=J\u0010\u0010E\u001a\u00020-2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020\u00102\b\u0010H\u001a\u0004\u0018\u00010\u001bJ\u0006\u0010I\u001a\u00020-R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001b\u0010 \u001a\u00020!8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\b\u001a\u0004\b\"\u0010#\u00a8\u0006J"}, d2={"Lcom/calldorado/sdk/CalldoradoApplication$Companion;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "()V", "configController", "Lcom/calldorado/sdk/ui/ui/ConfigController;", "getConfigController", "()Lcom/calldorado/sdk/ui/ui/ConfigController;", "configController$delegate", "Lkotlin/Lazy;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "setContext", "(Landroid/content/Context;)V", "isCurrentCallBlocked", "", "()Z", "setCurrentCallBlocked", "(Z)V", "koinApplication", "Lorg/koin/core/KoinApplication;", "getKoinApplication", "()Lorg/koin/core/KoinApplication;", "setKoinApplication", "(Lorg/koin/core/KoinApplication;)V", "lastCallId", "", "getLastCallId", "()Ljava/lang/String;", "setLastCallId", "(Ljava/lang/String;)V", "mPreferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getMPreferencesManager", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "mPreferencesManager$delegate", "getDoraClientKey", "getDoraConfig", "group", "name", "defaultValue", "", "", "initializeDoralytics", "", "callback", "Lcom/calldorado/sdk/CalldoradoApplication$CDODoraConfigCallback;", "openBlockingActivity", "searchCDO", "numberToSearch", "isCallbackAsync", "Lcom/calldorado/sdk/CalldoradoApplication$CDODoraSearchCallback;", "sendFirebaseEventCdoActiveTime", "sendFirebaseStatIfPossible", "eventName", "fullText", "sendStat", "type", "extras", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "revenueInMicroUsd", "", "setDoraCustomParam", "key", "value", "setDoraCustomParams", "paramMap", "setKoinInstance", "toggleCDOBlocking", "isBlockingEnabled", "localActivityToHandleBlocking", "updateDoraConfig", "sdk_release"})
    public static final class Companion
    implements SdkCoinComponent {
        private Companion() {
        }

        @NotNull
        public final String getLastCallId() {
            return lastCallId;
        }

        public final void setLastCallId(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            lastCallId = string;
        }

        public final boolean isCurrentCallBlocked() {
            return isCurrentCallBlocked;
        }

        public final void setCurrentCallBlocked(boolean bl) {
            isCurrentCallBlocked = bl;
        }

        @NotNull
        public final KoinApplication getKoinApplication() {
            KoinApplication koinApplication = CalldoradoApplication.koinApplication;
            if (koinApplication != null) {
                return koinApplication;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"koinApplication");
            return null;
        }

        public final void setKoinApplication(@NotNull KoinApplication koinApplication) {
            Intrinsics.checkNotNullParameter((Object)koinApplication, (String)"<set-?>");
            CalldoradoApplication.koinApplication = koinApplication;
        }

        @NotNull
        public final PreferencesManager getMPreferencesManager() {
            Lazy lazy = mPreferencesManager$delegate;
            return (PreferencesManager)lazy.getValue();
        }

        private final ConfigController getConfigController() {
            Lazy lazy = configController$delegate;
            return (ConfigController)lazy.getValue();
        }

        @NotNull
        public final Context getContext() {
            Context context = CalldoradoApplication.context;
            if (context != null) {
                return context;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            return null;
        }

        public final void setContext(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
            CalldoradoApplication.context = context;
        }

        @SuppressLint(value={"StaticFieldLeak"})
        public final void setKoinInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Context context2 = context.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
            Companion.setContext(context2);
            if (GlobalContext.INSTANCE.getKoinApplicationOrNull() != null) {
                DefaultContextExtKt.stopKoin();
            }
            GlobalContext.INSTANCE.startKoin((Function1)new Function1<KoinApplication, Unit>(context){
                final /* synthetic */ Context $context;
                {
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull KoinApplication $this$startKoin) {
                    Intrinsics.checkNotNullParameter((Object)$this$startKoin, (String)"$this$startKoin");
                    CalldoradoApplication.Companion.setKoinApplication($this$startKoin);
                    KoinExtKt.androidLogger$default((KoinApplication)$this$startKoin, null, (int)1, null);
                    Context context = this.$context.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context.applicationContext");
                    KoinExtKt.androidContext((KoinApplication)$this$startKoin, (Context)context);
                }
            });
        }

        public final void initializeDoralytics(@NotNull Context context, @Nullable CDODoraConfigCallback callback) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                AppVersionData appVersionData = FunctionsKt.getAppVersionData(context);
                Ref.BooleanRef isClidSet = new Ref.BooleanRef();
                String clid = FunctionsKt.getLegacyClid(context);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bnid", (Object)"apk-7.0.12.1044"), TuplesKt.to((Object)"app_version_name", (Object)appVersionData.getAppVersion()), TuplesKt.to((Object)"app_version_code", (Object)appVersionData.getAppVersionCode())};
                HashMap doraInitParams = MapsKt.hashMapOf((Pair[])pairArray);
                if (!StringsKt.isBlank((CharSequence)clid)) {
                    ((Map)doraInitParams).put("clid", clid);
                }
                DoraSDK.init((Context)context, (String)FunctionsKt.getDoraApiToken(context), (String)FunctionsKt.getDoraAppKey(context), (HashMap)doraInitParams, () -> Companion.initializeDoralytics$lambda-0(callback, clid, context, isClidSet));
                HashMap paramMap = new HashMap();
                Map map2 = paramMap;
                String string = "package";
                String string2 = context.getPackageName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.packageName");
                String string3 = string2;
                map2.put(string, string3);
                ((Map)paramMap).put("os_version", "" + Build.VERSION.SDK_INT);
                map2 = paramMap;
                string = "manufacturer";
                String string4 = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MANUFACTURER");
                string3 = string4;
                map2.put(string, string3);
                map2 = paramMap;
                string = "model";
                String string5 = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"MODEL");
                string3 = string5;
                map2.put(string, string3);
                ((Map)paramMap).put("version", "7.0.12.1044");
                ((Map)paramMap).put("optin_version", FunctionsKt.getOptinVersion(context));
                ((Map)paramMap).put("app_version_code", appVersionData.getAppVersionCode());
                ((Map)paramMap).put("app_version", appVersionData.getAppVersion());
                ((Map)paramMap).put("country", FunctionsKt.getCountry(context));
                ((Map)paramMap).put("bnid", "apk-7.0.12.1044");
                ((Map)paramMap).put("app_version_name", appVersionData.getAppVersion());
                ((Map)paramMap).put("app_version_code", appVersionData.getAppVersionCode());
                if (!isClidSet.element) {
                    map2 = paramMap;
                    string = "clid";
                    String string6 = DoraSDK.getConfigValue((String)"cdo_custom", (String)"clid", (String)(!StringsKt.isBlank((CharSequence)clid) ? clid : "b1-" + DoraSDK.getClientKey()));
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getConfigValue(\n        \u2026                        )");
                    string3 = string6;
                    map2.put(string, string3);
                }
                DoraSDK.setCustomParams(paramMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void sendStat(@NotNull String name, @NotNull String type, @NotNull HashMap<String, String> extras, double revenueInMicroUsd) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(extras, (String)"extras");
            try {
                BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(extras, revenueInMicroUsd, name, type, null){
                    int label;
                    final /* synthetic */ HashMap<String, String> $extras;
                    final /* synthetic */ double $revenueInMicroUsd;
                    final /* synthetic */ String $name;
                    final /* synthetic */ String $type;
                    {
                        this.$extras = $extras;
                        this.$revenueInMicroUsd = $revenueInMicroUsd;
                        this.$name = $name;
                        this.$type = $type;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                try {
                                    void var3_4;
                                    Context context = CalldoradoApplication.Companion.getContext();
                                    ConnectionSpeedData connectionSpeedData = FunctionsKt.getConnectionSpeed(context);
                                    String advertisingId = CalldoradoApplication.Companion.getMPreferencesManager().getValue("advertising_id", "");
                                    ((Map)this.$extras).put("up_speed", String.valueOf(connectionSpeedData.getUpSpeed()));
                                    ((Map)this.$extras).put("down_speed", String.valueOf(var3_4.getDownSpeed()));
                                    if (!StringsKt.isBlank((CharSequence)advertisingId)) {
                                        ((Map)this.$extras).put("adid", advertisingId);
                                    }
                                    if (this.$revenueInMicroUsd > 0.0) {
                                        long revenueInMicroUsdLng = (long)(this.$revenueInMicroUsd * (double)1000000);
                                        DoraEventValue doraValueObj = new DoraEventValue(revenueInMicroUsdLng, "USD");
                                        DoraSDK.sendEvent((String)this.$name, (String)this.$type, (DoraEventValue)doraValueObj, this.$extras);
                                    } else {
                                        DoraSDK.sendEvent((String)this.$name, (String)this.$type, this.$extras);
                                    }
                                    CLog.d("Send stat", "Stat name = " + this.$name + ", type = " + this.$type + ", extras = " + this.$extras);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static /* synthetic */ void sendStat$default(Companion companion, String string, String string2, HashMap hashMap, double d, int n, Object object) {
            if ((n & 4) != 0) {
                hashMap = new HashMap<String, String>();
            }
            if ((n & 8) != 0) {
                d = 0.0;
            }
            companion.sendStat(string, string2, hashMap, d);
        }

        public final void sendFirebaseEventCdoActiveTime() {
            try {
                boolean was7DayRetentionReported = this.getMPreferencesManager().getValue("was_7_day_retention_reported", false);
                boolean was14DayRetentionReported = this.getMPreferencesManager().getValue("was_14_day_retention_reported", false);
                boolean was30DayRetentionReported = this.getMPreferencesManager().getValue("was_30_day_retention_reported", false);
                long currentMilis = System.currentTimeMillis();
                long activationMilis = this.getContext().getPackageManager().getPackageInfo((String)this.getContext().getPackageName(), (int)0).firstInstallTime;
                long timeDiffDays = (currentMilis - activationMilis) / (long)86400000;
                if (timeDiffDays >= 7L && !was7DayRetentionReported) {
                    this.sendFirebaseStatIfPossible("cdo_7days_retention", "user_active_at_least_7days");
                    this.getMPreferencesManager().saveValue("was_7_day_retention_reported", true);
                }
                if (timeDiffDays >= 14L && !was14DayRetentionReported) {
                    this.sendFirebaseStatIfPossible("cdo_14days_retention", "user_active_at_least_14days");
                    this.getMPreferencesManager().saveValue("was_14_day_retention_reported", true);
                }
                if (timeDiffDays >= 30L && !was30DayRetentionReported) {
                    this.sendFirebaseStatIfPossible("cdo_30days_retention", "user_active_at_least_30days");
                    this.getMPreferencesManager().saveValue("was_30_day_retention_reported", true);
                }
            }
            catch (Exception e) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)("Calldoradoapplication sendFirebaseEventCdoActiveTime Exception " + e.getMessage()))};
                com.calldorado.sdk.CalldoradoApplication$Companion.sendStat$default(Companion, "catched_error", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            }
        }

        public final void sendFirebaseStatIfPossible(@NotNull String eventName, @NotNull String fullText) {
            Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
            Intrinsics.checkNotNullParameter((Object)fullText, (String)"fullText");
            try {
                Intent intent = new Intent("custom_firebase_event");
                PackageManager packageManager = this.getContext().getPackageManager();
                List list = packageManager.queryBroadcastReceivers(intent, 0);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryBroadcastReceivers(intent, 0)");
                List receiverMatches = list;
                if (FunctionsKt.isFirebaseEventReceiverPresent(this.getContext())) {
                    for (ResolveInfo resolveInfo : receiverMatches) {
                        ComponentName componentName = new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name);
                        intent.putExtra("eventName", eventName);
                        intent.putExtra("fullText", fullText);
                        intent.setComponent(componentName);
                        this.getContext().sendBroadcast(intent);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static /* synthetic */ void sendFirebaseStatIfPossible$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = "";
            }
            companion.sendFirebaseStatIfPossible(string, string2);
        }

        public final void searchCDO(@NotNull String numberToSearch, boolean isCallbackAsync, @NotNull CDODoraSearchCallback callback) {
            Intrinsics.checkNotNullParameter((Object)numberToSearch, (String)"numberToSearch");
            Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
            try {
                if (!this.getConfigController().isCallerIDEnabled()) {
                    CLog.d("searchCDO", "searchCDO: caller id is disabled by the config");
                    callback.onFail("Caller ID lookup is disabled by the cdo config");
                    return;
                }
                KoinComponent $this$inject_u24default$iv = this;
                Qualifier qualifier$iv = null;
                LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
                Function0 parameters$iv = null;
                boolean $i$f$inject = false;
                Lazy networkClient$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<NetworkClient>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
                    final /* synthetic */ KoinComponent $this_inject;
                    final /* synthetic */ Qualifier $qualifier;
                    final /* synthetic */ Function0 $parameters;
                    {
                        this.$this_inject = $receiver;
                        this.$qualifier = $qualifier;
                        this.$parameters = $parameters;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final NetworkClient invoke() {
                        Object object;
                        void qualifier$iv;
                        void $this$get$iv;
                        KoinComponent koinComponent = this.$this_inject;
                        Qualifier qualifier = this.$qualifier;
                        Function0 parameters$iv = this.$parameters;
                        boolean $i$f$get = false;
                        if ($this$get$iv instanceof KoinScopeComponent) {
                            Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                            boolean $i$f$get2 = false;
                            object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(NetworkClient.class), (Qualifier)qualifier$iv, parameters$iv);
                        } else {
                            Koin this_$iv$iv = $this$get$iv.getKoin();
                            boolean $i$f$get3 = false;
                            Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                            boolean $i$f$get4 = false;
                            object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(NetworkClient.class), (Qualifier)qualifier$iv, parameters$iv);
                        }
                        return object;
                    }
                }));
                CDONetworkApi api = isCallbackAsync ? com.calldorado.sdk.CalldoradoApplication$Companion.searchCDO$lambda-1((Lazy<NetworkClient>)networkClient$delegate).getNetworkApiWithAsyncCallback() : com.calldorado.sdk.CalldoradoApplication$Companion.searchCDO$lambda-1((Lazy<NetworkClient>)networkClient$delegate).getNetworkApi();
                String clientKey = this.getDoraClientKey();
                String appKey = FunctionsKt.getDoraAppKey(this.getContext());
                String apiToken = FunctionsKt.getDoraApiToken(this.getContext());
                if (appKey == null || apiToken == null) {
                    CLog.d("searchCDO", "searchCDO: invalid appKey or apiToken, cannot search");
                    return;
                }
                CDONetworkModel cdoNetworkModel = new CDONetworkModel(clientKey, appKey, numberToSearch);
                Call<CDOSearchResponseModel> apiCall = api.searchNumber(apiToken, cdoNetworkModel);
                apiCall.enqueue((Callback)new Callback<CDOSearchResponseModel>(callback){
                    final /* synthetic */ CDODoraSearchCallback $callback;
                    {
                        this.$callback = $callback;
                    }

                    public void onResponse(@NotNull Call<CDOSearchResponseModel> call, @NotNull Response<CDOSearchResponseModel> response) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter(response, (String)"response");
                        boolean isResponseValid = false;
                        if (response.isSuccessful()) {
                            CDOSearchResponseModel searchResponseModel;
                            CDOSearchResponseModel cDOSearchResponseModel = searchResponseModel = (CDOSearchResponseModel)response.body();
                            if (cDOSearchResponseModel != null) {
                                CDOSearchResponseModel cDOSearchResponseModel2 = cDOSearchResponseModel;
                                CDODoraSearchCallback cDODoraSearchCallback = this.$callback;
                                CDOSearchResponseModel it = cDOSearchResponseModel2;
                                boolean bl = false;
                                CDOSearchResultModel searchResultModel = it.getSearchResultModel();
                                String name = searchResultModel.getName();
                                String formattedPhone = searchResultModel.getFormattedPhone();
                                boolean isSpam = searchResultModel.isSpam();
                                isResponseValid = true;
                                cDODoraSearchCallback.onResult(name, formattedPhone, isSpam);
                            }
                        } else {
                            this.$callback.onFail(response.message());
                        }
                        if (!isResponseValid) {
                            this.$callback.onFail("Server response not valid");
                        }
                    }

                    public void onFailure(@NotNull Call<CDOSearchResponseModel> call, @NotNull Throwable t) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                        this.$callback.onFail(t.getMessage());
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public static /* synthetic */ void searchCDO$default(Companion companion, String string, boolean bl, CDODoraSearchCallback cDODoraSearchCallback, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.searchCDO(string, bl, cDODoraSearchCallback);
        }

        public final void setDoraCustomParam(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            try {
                DoraSDK.setCustomParam((String)key, (String)value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void setDoraCustomParams(@NotNull HashMap<String, String> paramMap) {
            Intrinsics.checkNotNullParameter(paramMap, (String)"paramMap");
            try {
                DoraSDK.setCustomParams(paramMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @NotNull
        public final String getDoraClientKey() {
            String string;
            try {
                String string2 = DoraSDK.getClientKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                DoraSD\u2026ClientKey()\n            }");
                string = string2;
            }
            catch (Exception e) {
                e.printStackTrace();
                string = "";
            }
            return string;
        }

        public final void updateDoraConfig() {
            try {
                DoraSDK.updateConfigs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final boolean getDoraConfig(@NotNull String group, @NotNull String name, boolean defaultValue) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                bl = DoraSDK.getConfigValue((String)group, (String)name, (boolean)defaultValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getDoraConfig(@NotNull String group, @NotNull String name, @NotNull String defaultValue) {
            String string;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            try {
                String string2 = DoraSDK.getConfigValue((String)group, (String)name, (String)defaultValue);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                DoraSD\u2026faultValue)\n            }");
                string = string2;
            }
            catch (Exception e) {
                e.printStackTrace();
                string = "";
            }
            return string;
        }

        public final int getDoraConfig(@NotNull String group, @NotNull String name, int defaultValue) {
            int n;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                n = DoraSDK.getConfigValue((String)group, (String)name, (int)defaultValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                n = 0;
            }
            return n;
        }

        public final long getDoraConfig(@NotNull String group, @NotNull String name, long defaultValue) {
            long l;
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            try {
                l = DoraSDK.getConfigValue((String)group, (String)name, (long)defaultValue);
            }
            catch (Exception e) {
                e.printStackTrace();
                l = 0L;
            }
            return l;
        }

        public final void toggleCDOBlocking(boolean isBlockingEnabled, @Nullable String localActivityToHandleBlocking) {
            try {
                try {
                    this.getMPreferencesManager().saveValue("pref_blocking_state", isBlockingEnabled);
                    String string = localActivityToHandleBlocking;
                    if (string != null) {
                        String it = string;
                        boolean bl = false;
                        try {
                            Companion.getMPreferencesManager().saveValue("pref_blocking_activity_class_name", it);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public final void openBlockingActivity(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            try {
                try {
                    String blockingActivityClassName = this.getMPreferencesManager().getValue("pref_blocking_activity_class_name", "com.calldorado.blocking.activity.CDODefaultBlockingActivity");
                    Class<?> classObject = Class.forName(blockingActivityClassName);
                    Intent myIntent = new Intent(context, classObject);
                    myIntent.putExtra("fromCalldorado", true);
                    context.startActivity(myIntent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        @NotNull
        public Koin getKoin() {
            return SdkCoinComponent.DefaultImpls.getKoin(this);
        }

        private static final void initializeDoralytics$lambda-0(CDODoraConfigCallback $callback, String $clid, Context $context, Ref.BooleanRef $isClidSet) {
            Intrinsics.checkNotNullParameter((Object)$clid, (String)"$clid");
            Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
            Intrinsics.checkNotNullParameter((Object)$isClidSet, (String)"$isClidSet");
            CDODoraConfigCallback cDODoraConfigCallback = $callback;
            if (cDODoraConfigCallback != null) {
                cDODoraConfigCallback.onConfigReady();
            }
            HashMap cdoCustomParamMap = DoraSDK.getConfigGroupMap((String)"cdo_custom");
            DoraSDK.setCustomParams((HashMap)cdoCustomParamMap);
            if (!cdoCustomParamMap.containsKey("clid")) {
                Object clidParam = !StringsKt.isBlank((CharSequence)$clid) ? $clid : "b1-" + DoraSDK.getClientKey();
                DoraSDK.setCustomParam((String)"clid", (String)clidParam);
            } else if (FunctionsKt.isNewInstall($context)) {
                FunctionsKt.sendFirstHandshakeEventIfNeeded(Companion.getMPreferencesManager());
            }
            $isClidSet.element = true;
        }

        private static final NetworkClient searchCDO$lambda-1(Lazy<NetworkClient> $networkClient$delegate) {
            Lazy<NetworkClient> lazy = $networkClient$delegate;
            return (NetworkClient)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&J \u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lcom/calldorado/sdk/CalldoradoApplication$CDODoraSearchCallback;", "", "onFail", "", "errorMessage", "", "onResult", "name", "formattedNumber", "isSpam", "", "sdk_release"})
    public static interface CDODoraSearchCallback {
        public void onResult(@NotNull String var1, @NotNull String var2, boolean var3);

        public void onFail(@Nullable String var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/calldorado/sdk/CalldoradoApplication$CDODoraConfigCallback;", "", "onConfigReady", "", "sdk_release"})
    public static interface CDODoraConfigCallback {
        public void onConfigReady();
    }
}

