/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.compose.animation.ExperimentalAnimationApi;
import androidx.compose.material.ExperimentalMaterialApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.core.app.NotificationCompat;
import androidx.core.app.NotificationManagerCompat;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.R;
import com.calldorado.sdk.ui.CallerIDActivity;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ExperimentalAnimationApi
@ExperimentalComposeUiApi
@ExperimentalMaterialApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\b"}, d2={"Lcom/calldorado/sdk/NotificationsUtil;", "", "()V", "createOverlayNotificationChannel", "", "context", "Landroid/content/Context;", "sendOverlayNotification", "sdk_release"})
@StabilityInferred(parameters=0)
public final class NotificationsUtil {
    @NotNull
    public static final NotificationsUtil INSTANCE = new NotificationsUtil();
    public static final int $stable;

    private NotificationsUtil() {
    }

    @RequiresApi(value=23)
    public final void sendOverlayNotification(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            this.createOverlayNotificationChannel(context);
            String string2 = context.getString(R.string.cdo_overlay_notification_title);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026erlay_notification_title)");
            String title2 = string2;
            Intent intent = new Intent(context, CallerIDActivity.class);
            intent.putExtra("actype", "notification");
            intent.setFlags(0x14000000);
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)context, (int)0, (Intent)intent, (int)0x4000000);
            NotificationCompat.Builder builder = new NotificationCompat.Builder(context, "14423").setContentTitle((CharSequence)title2).setSmallIcon(R.drawable.cdo_ic_overlay_notification).setPriority(2).setCategory("call").setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setWhen(System.currentTimeMillis()).setFullScreenIntent(pendingIntent, true).setAutoCancel(true);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"Builder(context, \"14423\"\u2026     .setAutoCancel(true)");
            NotificationCompat.Builder builder2 = builder;
            Notification notification = builder2.build();
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"builder.build()");
            Notification notification2 = notification;
            NotificationManagerCompat notificationManagerCompat = NotificationManagerCompat.from((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)notificationManagerCompat, (String)"from(context)");
            NotificationManagerCompat notificationManager = notificationManagerCompat;
            notificationManager.notify(14423, notification2);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call_id", (Object)CalldoradoApplication.Companion.getLastCallId())};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "cdo_aftercall_notification_shown", "CDO_STAT_V7_AFTERCALL", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            CalldoradoApplication.Companion.sendFirebaseStatIfPossible("notification_clicked_firebase", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void createOverlayNotificationChannel(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CharSequence name = "Caller ID Channel";
                String description = "Get call information results in the end of every call";
                int importance = 4;
                NotificationChannel channel = new NotificationChannel("14423", name, importance);
                channel.setDescription(description);
                channel.setShowBadge(false);
                Object object = context.getSystemService(NotificationManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getSystemService\u2026ationManager::class.java)");
                NotificationManager notificationManager = (NotificationManager)object;
                notificationManager.createNotificationChannel(channel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

