/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ads;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.Lifecycle;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.ads.AdLoadingState;
import com.calldorado.sdk.ads.AftercallAdLoader;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.ui.ui.ConfigController;
import com.calldorado.sdk.ui.ui.aftercall.ExpandedAftercallCardTypes;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u000eH\u0002J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/calldorado/sdk/ads/AdController;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "()V", "aftercallAdLoaderList", "Ljava/util/ArrayList;", "Lcom/calldorado/sdk/ads/AftercallAdLoader;", "Lkotlin/collections/ArrayList;", "configController", "Lcom/calldorado/sdk/ui/ui/ConfigController;", "getConfigController", "()Lcom/calldorado/sdk/ui/ui/ConfigController;", "configController$delegate", "Lkotlin/Lazy;", "numberOfAdCards", "", "getAftercallAdLoaderStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/calldorado/sdk/ads/AdLoadingState;", "zone", "", "getNumberOfAdCards", "loadAds", "", "context", "Landroid/content/Context;", "isPostLoad", "", "canUseCache", "sendLoadEvents", "setObserverToActivityLifecycle", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "sdk_release"})
@StabilityInferred(parameters=0)
public final class AdController
implements SdkCoinComponent {
    @NotNull
    private final Lazy configController$delegate;
    private final int numberOfAdCards;
    @NotNull
    private ArrayList<AftercallAdLoader> aftercallAdLoaderList;
    public static final int $stable = 8;

    public AdController() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.configController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ConfigController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfigController invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.numberOfAdCards = this.getNumberOfAdCards();
        this.aftercallAdLoaderList = new ArrayList();
    }

    private final ConfigController getConfigController() {
        Lazy lazy = this.configController$delegate;
        return (ConfigController)lazy.getValue();
    }

    public final void loadAds(@NotNull Context context, boolean isPostLoad, boolean canUseCache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.sendLoadEvents(isPostLoad);
        ConfigController.AftercallConfigControl aftercallConfigControl = this.getConfigController().aftercallConfigControl();
        String strAftercallType = aftercallConfigControl == ConfigController.AftercallConfigControl.ONLY_EXPANDED ? "expanded_aftercall" : "light_aftercall";
        this.aftercallAdLoaderList.clear();
        int i = 1;
        int n = this.numberOfAdCards;
        if (i <= n) {
            while (true) {
                String zoneToLoad = i == 1 ? strAftercallType : strAftercallType + "_" + i;
                AftercallAdLoader aftercallAdLoader = new AftercallAdLoader(context, zoneToLoad, isPostLoad, canUseCache);
                this.aftercallAdLoaderList.add(aftercallAdLoader);
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void setObserverToActivityLifecycle(@NotNull Lifecycle lifecycle) {
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Iterable $this$forEach$iv = this.aftercallAdLoaderList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AftercallAdLoader it = (AftercallAdLoader)element$iv;
            boolean bl = false;
            it.setObserverToActivityLifecycle(lifecycle);
        }
    }

    @Nullable
    public final StateFlow<AdLoadingState> getAftercallAdLoaderStateFlow(@NotNull String zone) {
        AftercallAdLoader aftercallAdLoaderFromZone;
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
            Iterable $this$firstOrNull$iv = this.aftercallAdLoaderList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AftercallAdLoader it = (AftercallAdLoader)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getZoneToLoad(), (Object)zone)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        AftercallAdLoader aftercallAdLoader = aftercallAdLoaderFromZone = (AftercallAdLoader)v0;
        return aftercallAdLoader != null ? aftercallAdLoader.getAdLoadingState() : null;
    }

    private final int getNumberOfAdCards() {
        int n;
        ArrayList<ExpandedAftercallCardTypes> cardList = this.getConfigController().getAftercallCardsList();
        ConfigController.AftercallAdPlacement adPlacement = this.getConfigController().getAftercallAdPlacement();
        if (adPlacement == ConfigController.AftercallAdPlacement.STICKY) {
            n = 1;
        } else {
            Iterable $this$count$iv = cardList;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    ExpandedAftercallCardTypes it = (ExpandedAftercallCardTypes)((Object)element$iv);
                    boolean bl = false;
                    if (!(it == ExpandedAftercallCardTypes.AD_CARD) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        }
        return n;
    }

    private final void sendLoadEvents(boolean isPostLoad) {
        CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "ad_limit_waterfall_start", "CDO_STAT_V7_AD", null, 0.0, 12, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call_id", (Object)CalldoradoApplication.Companion.getLastCallId())};
        CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, isPostLoad ? "cdo_ad_postload_initialized" : "cdo_ad_preload_initialized", "CDO_STAT_V7_AD", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }
}

