/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.calldorado.sdk.localDB.CDODatabase;
import com.calldorado.sdk.localDB.dao.BlockingBlacklistDao;
import com.calldorado.sdk.localDB.dao.BlockingBlacklistDao_Impl;
import com.calldorado.sdk.localDB.dao.BlockingNumberStartingWithDao;
import com.calldorado.sdk.localDB.dao.BlockingNumberStartingWithDao_Impl;
import com.calldorado.sdk.localDB.dao.BlockingPrefixDao;
import com.calldorado.sdk.localDB.dao.BlockingPrefixDao_Impl;
import com.calldorado.sdk.localDB.dao.BlockingWhitelistDao;
import com.calldorado.sdk.localDB.dao.BlockingWhitelistDao_Impl;
import com.calldorado.sdk.localDB.dao.ContactDao;
import com.calldorado.sdk.localDB.dao.ContactDao_Impl;
import com.calldorado.sdk.localDB.dao.IncompleteCallHistoryDao;
import com.calldorado.sdk.localDB.dao.IncompleteCallHistoryDao_Impl;
import com.calldorado.sdk.localDB.dao.LastCallDao;
import com.calldorado.sdk.localDB.dao.LastCallDao_Impl;
import com.calldorado.sdk.localDB.dao.RemindersDao;
import com.calldorado.sdk.localDB.dao.RemindersDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CDODatabase_Impl
extends CDODatabase {
    private volatile ContactDao _contactDao;
    private volatile LastCallDao _lastCallDao;
    private volatile RemindersDao _remindersDao;
    private volatile IncompleteCallHistoryDao _incompleteCallHistoryDao;
    private volatile BlockingBlacklistDao _blockingBlacklistDao;
    private volatile BlockingWhitelistDao _blockingWhitelistDao;
    private volatile BlockingPrefixDao _blockingPrefixDao;
    private volatile BlockingNumberStartingWithDao _blockingNumberStartingWithDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(6){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `contacts` (`contactId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `name` TEXT NOT NULL, `number` TEXT NOT NULL, `formattedNumber` TEXT NOT NULL, `uri` TEXT NOT NULL, `isSpam` INTEGER NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `last_caller` (`callId` TEXT NOT NULL, `callStarted` INTEGER NOT NULL, `duration` INTEGER NOT NULL, `isIncoming` INTEGER NOT NULL, `isSearching` INTEGER NOT NULL, `isCompletedCall` INTEGER NOT NULL, `callEnded` INTEGER NOT NULL, `isRinging` INTEGER NOT NULL, `contact` TEXT NOT NULL, PRIMARY KEY(`callId`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `reminders` (`time` INTEGER NOT NULL, `text` TEXT NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `incomplete_call_history` (`number` TEXT NOT NULL, `formattedNumber` TEXT NOT NULL, `time` INTEGER NOT NULL, `numberOfCalls` INTEGER NOT NULL, `name` TEXT NOT NULL, `callType` TEXT NOT NULL, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `blocking_blacklist` (`block_prefix` TEXT, `block_phoneno` TEXT, `contact_name` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `blocking_whitelist` (`block_prefix` TEXT, `block_phoneno` TEXT, `block_profile` INTEGER, `contact_name` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `blocking_prefix` (`block_prefix` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_blocking_prefix_block_prefix` ON `blocking_prefix` (`block_prefix`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `blocking_number_starting_with` (`block_number_starting_with` TEXT, `id` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE UNIQUE INDEX IF NOT EXISTS `index_blocking_number_starting_with_block_number_starting_with` ON `blocking_number_starting_with` (`block_number_starting_with`)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'e1861a26345351cf5b7cc46075e2ee0a')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `contacts`");
                _db.execSQL("DROP TABLE IF EXISTS `last_caller`");
                _db.execSQL("DROP TABLE IF EXISTS `reminders`");
                _db.execSQL("DROP TABLE IF EXISTS `incomplete_call_history`");
                _db.execSQL("DROP TABLE IF EXISTS `blocking_blacklist`");
                _db.execSQL("DROP TABLE IF EXISTS `blocking_whitelist`");
                _db.execSQL("DROP TABLE IF EXISTS `blocking_prefix`");
                _db.execSQL("DROP TABLE IF EXISTS `blocking_number_starting_with`");
                if (CDODatabase_Impl.this.mCallbacks != null) {
                    int _size = CDODatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)CDODatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (CDODatabase_Impl.this.mCallbacks != null) {
                    int _size = CDODatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)CDODatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                CDODatabase_Impl.this.mDatabase = _db;
                CDODatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (CDODatabase_Impl.this.mCallbacks != null) {
                    int _size = CDODatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)CDODatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsContacts = new HashMap<String, TableInfo.Column>(6);
                _columnsContacts.put("contactId", new TableInfo.Column("contactId", "INTEGER", true, 1, null, 1));
                _columnsContacts.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsContacts.put("number", new TableInfo.Column("number", "TEXT", true, 0, null, 1));
                _columnsContacts.put("formattedNumber", new TableInfo.Column("formattedNumber", "TEXT", true, 0, null, 1));
                _columnsContacts.put("uri", new TableInfo.Column("uri", "TEXT", true, 0, null, 1));
                _columnsContacts.put("isSpam", new TableInfo.Column("isSpam", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysContacts = new HashSet(0);
                HashSet _indicesContacts = new HashSet(0);
                TableInfo _infoContacts = new TableInfo("contacts", _columnsContacts, _foreignKeysContacts, _indicesContacts);
                TableInfo _existingContacts = TableInfo.read((SupportSQLiteDatabase)_db, (String)"contacts");
                if (!_infoContacts.equals((Object)_existingContacts)) {
                    return new RoomOpenHelper.ValidationResult(false, "contacts(com.calldorado.sdk.localDB.model.Contact).\n Expected:\n" + _infoContacts + "\n Found:\n" + _existingContacts);
                }
                HashMap<String, TableInfo.Column> _columnsLastCaller = new HashMap<String, TableInfo.Column>(9);
                _columnsLastCaller.put("callId", new TableInfo.Column("callId", "TEXT", true, 1, null, 1));
                _columnsLastCaller.put("callStarted", new TableInfo.Column("callStarted", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("duration", new TableInfo.Column("duration", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("isIncoming", new TableInfo.Column("isIncoming", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("isSearching", new TableInfo.Column("isSearching", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("isCompletedCall", new TableInfo.Column("isCompletedCall", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("callEnded", new TableInfo.Column("callEnded", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("isRinging", new TableInfo.Column("isRinging", "INTEGER", true, 0, null, 1));
                _columnsLastCaller.put("contact", new TableInfo.Column("contact", "TEXT", true, 0, null, 1));
                HashSet _foreignKeysLastCaller = new HashSet(0);
                HashSet _indicesLastCaller = new HashSet(0);
                TableInfo _infoLastCaller = new TableInfo("last_caller", _columnsLastCaller, _foreignKeysLastCaller, _indicesLastCaller);
                TableInfo _existingLastCaller = TableInfo.read((SupportSQLiteDatabase)_db, (String)"last_caller");
                if (!_infoLastCaller.equals((Object)_existingLastCaller)) {
                    return new RoomOpenHelper.ValidationResult(false, "last_caller(com.calldorado.sdk.localDB.model.LastCallModel).\n Expected:\n" + _infoLastCaller + "\n Found:\n" + _existingLastCaller);
                }
                HashMap<String, TableInfo.Column> _columnsReminders = new HashMap<String, TableInfo.Column>(3);
                _columnsReminders.put("time", new TableInfo.Column("time", "INTEGER", true, 0, null, 1));
                _columnsReminders.put("text", new TableInfo.Column("text", "TEXT", true, 0, null, 1));
                _columnsReminders.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysReminders = new HashSet(0);
                HashSet _indicesReminders = new HashSet(0);
                TableInfo _infoReminders = new TableInfo("reminders", _columnsReminders, _foreignKeysReminders, _indicesReminders);
                TableInfo _existingReminders = TableInfo.read((SupportSQLiteDatabase)_db, (String)"reminders");
                if (!_infoReminders.equals((Object)_existingReminders)) {
                    return new RoomOpenHelper.ValidationResult(false, "reminders(com.calldorado.sdk.localDB.model.RemindersModel).\n Expected:\n" + _infoReminders + "\n Found:\n" + _existingReminders);
                }
                HashMap<String, TableInfo.Column> _columnsIncompleteCallHistory = new HashMap<String, TableInfo.Column>(7);
                _columnsIncompleteCallHistory.put("number", new TableInfo.Column("number", "TEXT", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("formattedNumber", new TableInfo.Column("formattedNumber", "TEXT", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("time", new TableInfo.Column("time", "INTEGER", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("numberOfCalls", new TableInfo.Column("numberOfCalls", "INTEGER", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("name", new TableInfo.Column("name", "TEXT", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("callType", new TableInfo.Column("callType", "TEXT", true, 0, null, 1));
                _columnsIncompleteCallHistory.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysIncompleteCallHistory = new HashSet(0);
                HashSet _indicesIncompleteCallHistory = new HashSet(0);
                TableInfo _infoIncompleteCallHistory = new TableInfo("incomplete_call_history", _columnsIncompleteCallHistory, _foreignKeysIncompleteCallHistory, _indicesIncompleteCallHistory);
                TableInfo _existingIncompleteCallHistory = TableInfo.read((SupportSQLiteDatabase)_db, (String)"incomplete_call_history");
                if (!_infoIncompleteCallHistory.equals((Object)_existingIncompleteCallHistory)) {
                    return new RoomOpenHelper.ValidationResult(false, "incomplete_call_history(com.calldorado.sdk.localDB.model.IncompleteCallHistoryModel).\n Expected:\n" + _infoIncompleteCallHistory + "\n Found:\n" + _existingIncompleteCallHistory);
                }
                HashMap<String, TableInfo.Column> _columnsBlockingBlacklist = new HashMap<String, TableInfo.Column>(4);
                _columnsBlockingBlacklist.put("block_prefix", new TableInfo.Column("block_prefix", "TEXT", false, 0, null, 1));
                _columnsBlockingBlacklist.put("block_phoneno", new TableInfo.Column("block_phoneno", "TEXT", false, 0, null, 1));
                _columnsBlockingBlacklist.put("contact_name", new TableInfo.Column("contact_name", "TEXT", false, 0, null, 1));
                _columnsBlockingBlacklist.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysBlockingBlacklist = new HashSet(0);
                HashSet _indicesBlockingBlacklist = new HashSet(0);
                TableInfo _infoBlockingBlacklist = new TableInfo("blocking_blacklist", _columnsBlockingBlacklist, _foreignKeysBlockingBlacklist, _indicesBlockingBlacklist);
                TableInfo _existingBlockingBlacklist = TableInfo.read((SupportSQLiteDatabase)_db, (String)"blocking_blacklist");
                if (!_infoBlockingBlacklist.equals((Object)_existingBlockingBlacklist)) {
                    return new RoomOpenHelper.ValidationResult(false, "blocking_blacklist(com.calldorado.sdk.localDB.model.BlockingBlacklistModel).\n Expected:\n" + _infoBlockingBlacklist + "\n Found:\n" + _existingBlockingBlacklist);
                }
                HashMap<String, TableInfo.Column> _columnsBlockingWhitelist = new HashMap<String, TableInfo.Column>(5);
                _columnsBlockingWhitelist.put("block_prefix", new TableInfo.Column("block_prefix", "TEXT", false, 0, null, 1));
                _columnsBlockingWhitelist.put("block_phoneno", new TableInfo.Column("block_phoneno", "TEXT", false, 0, null, 1));
                _columnsBlockingWhitelist.put("block_profile", new TableInfo.Column("block_profile", "INTEGER", false, 0, null, 1));
                _columnsBlockingWhitelist.put("contact_name", new TableInfo.Column("contact_name", "TEXT", false, 0, null, 1));
                _columnsBlockingWhitelist.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysBlockingWhitelist = new HashSet(0);
                HashSet _indicesBlockingWhitelist = new HashSet(0);
                TableInfo _infoBlockingWhitelist = new TableInfo("blocking_whitelist", _columnsBlockingWhitelist, _foreignKeysBlockingWhitelist, _indicesBlockingWhitelist);
                TableInfo _existingBlockingWhitelist = TableInfo.read((SupportSQLiteDatabase)_db, (String)"blocking_whitelist");
                if (!_infoBlockingWhitelist.equals((Object)_existingBlockingWhitelist)) {
                    return new RoomOpenHelper.ValidationResult(false, "blocking_whitelist(com.calldorado.sdk.localDB.model.BlockingWhitelistModel).\n Expected:\n" + _infoBlockingWhitelist + "\n Found:\n" + _existingBlockingWhitelist);
                }
                HashMap<String, TableInfo.Column> _columnsBlockingPrefix = new HashMap<String, TableInfo.Column>(2);
                _columnsBlockingPrefix.put("block_prefix", new TableInfo.Column("block_prefix", "TEXT", false, 0, null, 1));
                _columnsBlockingPrefix.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysBlockingPrefix = new HashSet(0);
                HashSet<TableInfo.Index> _indicesBlockingPrefix = new HashSet<TableInfo.Index>(1);
                _indicesBlockingPrefix.add(new TableInfo.Index("index_blocking_prefix_block_prefix", true, Arrays.asList("block_prefix"), Arrays.asList("ASC")));
                TableInfo _infoBlockingPrefix = new TableInfo("blocking_prefix", _columnsBlockingPrefix, _foreignKeysBlockingPrefix, _indicesBlockingPrefix);
                TableInfo _existingBlockingPrefix = TableInfo.read((SupportSQLiteDatabase)_db, (String)"blocking_prefix");
                if (!_infoBlockingPrefix.equals((Object)_existingBlockingPrefix)) {
                    return new RoomOpenHelper.ValidationResult(false, "blocking_prefix(com.calldorado.sdk.localDB.model.BlockingPrefixModel).\n Expected:\n" + _infoBlockingPrefix + "\n Found:\n" + _existingBlockingPrefix);
                }
                HashMap<String, TableInfo.Column> _columnsBlockingNumberStartingWith = new HashMap<String, TableInfo.Column>(2);
                _columnsBlockingNumberStartingWith.put("block_number_starting_with", new TableInfo.Column("block_number_starting_with", "TEXT", false, 0, null, 1));
                _columnsBlockingNumberStartingWith.put("id", new TableInfo.Column("id", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysBlockingNumberStartingWith = new HashSet(0);
                HashSet<TableInfo.Index> _indicesBlockingNumberStartingWith = new HashSet<TableInfo.Index>(1);
                _indicesBlockingNumberStartingWith.add(new TableInfo.Index("index_blocking_number_starting_with_block_number_starting_with", true, Arrays.asList("block_number_starting_with"), Arrays.asList("ASC")));
                TableInfo _infoBlockingNumberStartingWith = new TableInfo("blocking_number_starting_with", _columnsBlockingNumberStartingWith, _foreignKeysBlockingNumberStartingWith, _indicesBlockingNumberStartingWith);
                TableInfo _existingBlockingNumberStartingWith = TableInfo.read((SupportSQLiteDatabase)_db, (String)"blocking_number_starting_with");
                if (!_infoBlockingNumberStartingWith.equals((Object)_existingBlockingNumberStartingWith)) {
                    return new RoomOpenHelper.ValidationResult(false, "blocking_number_starting_with(com.calldorado.sdk.localDB.model.BlockingNumberStartingWithModel).\n Expected:\n" + _infoBlockingNumberStartingWith + "\n Found:\n" + _existingBlockingNumberStartingWith);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "e1861a26345351cf5b7cc46075e2ee0a", "34951435d79d7a0df1e639160e95bc3b");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"contacts", "last_caller", "reminders", "incomplete_call_history", "blocking_blacklist", "blocking_whitelist", "blocking_prefix", "blocking_number_starting_with"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `contacts`");
            _db.execSQL("DELETE FROM `last_caller`");
            _db.execSQL("DELETE FROM `reminders`");
            _db.execSQL("DELETE FROM `incomplete_call_history`");
            _db.execSQL("DELETE FROM `blocking_blacklist`");
            _db.execSQL("DELETE FROM `blocking_whitelist`");
            _db.execSQL("DELETE FROM `blocking_prefix`");
            _db.execSQL("DELETE FROM `blocking_number_starting_with`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(ContactDao.class, ContactDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(LastCallDao.class, LastCallDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(RemindersDao.class, RemindersDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(IncompleteCallHistoryDao.class, IncompleteCallHistoryDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BlockingBlacklistDao.class, BlockingBlacklistDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BlockingWhitelistDao.class, BlockingWhitelistDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BlockingPrefixDao.class, BlockingPrefixDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(BlockingNumberStartingWithDao.class, BlockingNumberStartingWithDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContactDao getContactDao() {
        if (this._contactDao != null) {
            return this._contactDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._contactDao == null) {
                this._contactDao = new ContactDao_Impl(this);
            }
            return this._contactDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LastCallDao getLastCallDao() {
        if (this._lastCallDao != null) {
            return this._lastCallDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._lastCallDao == null) {
                this._lastCallDao = new LastCallDao_Impl(this);
            }
            return this._lastCallDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemindersDao getRemindersDao() {
        if (this._remindersDao != null) {
            return this._remindersDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._remindersDao == null) {
                this._remindersDao = new RemindersDao_Impl(this);
            }
            return this._remindersDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncompleteCallHistoryDao getIncompleteCallHistoryDao() {
        if (this._incompleteCallHistoryDao != null) {
            return this._incompleteCallHistoryDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._incompleteCallHistoryDao == null) {
                this._incompleteCallHistoryDao = new IncompleteCallHistoryDao_Impl(this);
            }
            return this._incompleteCallHistoryDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingBlacklistDao getBlockingBlacklistDao() {
        if (this._blockingBlacklistDao != null) {
            return this._blockingBlacklistDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._blockingBlacklistDao == null) {
                this._blockingBlacklistDao = new BlockingBlacklistDao_Impl(this);
            }
            return this._blockingBlacklistDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingWhitelistDao getBlockingWhitelistDao() {
        if (this._blockingWhitelistDao != null) {
            return this._blockingWhitelistDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._blockingWhitelistDao == null) {
                this._blockingWhitelistDao = new BlockingWhitelistDao_Impl(this);
            }
            return this._blockingWhitelistDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingPrefixDao getBlockingPrefixDao() {
        if (this._blockingPrefixDao != null) {
            return this._blockingPrefixDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._blockingPrefixDao == null) {
                this._blockingPrefixDao = new BlockingPrefixDao_Impl(this);
            }
            return this._blockingPrefixDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingNumberStartingWithDao getBlockingNumberStartingWithDao() {
        if (this._blockingNumberStartingWithDao != null) {
            return this._blockingNumberStartingWithDao;
        }
        CDODatabase_Impl cDODatabase_Impl = this;
        synchronized (cDODatabase_Impl) {
            if (this._blockingNumberStartingWithDao == null) {
                this._blockingNumberStartingWithDao = new BlockingNumberStartingWithDao_Impl(this);
            }
            return this._blockingNumberStartingWithDao;
        }
    }
}

