/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.dao.BlockingBlacklistDao;
import com.calldorado.sdk.localDB.model.BlockingBlacklistModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BlockingBlacklistDao_Impl
implements BlockingBlacklistDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BlockingBlacklistModel> __insertionAdapterOfBlockingBlacklistModel;
    private final EntityDeletionOrUpdateAdapter<BlockingBlacklistModel> __deletionAdapterOfBlockingBlacklistModel;
    private final EntityDeletionOrUpdateAdapter<BlockingBlacklistModel> __updateAdapterOfBlockingBlacklistModel;
    private final SharedSQLiteStatement __preparedStmtOfDelete;

    public BlockingBlacklistDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBlockingBlacklistModel = new EntityInsertionAdapter<BlockingBlacklistModel>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `blocking_blacklist` (`block_prefix`,`block_phoneno`,`contact_name`,`id`) VALUES (?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingBlacklistModel value) {
                if (value.getBlockPrefix() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getBlockPrefix());
                }
                if (value.getBlockPhoneNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getBlockPhoneNumber());
                }
                if (value.getContactName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContactName());
                }
                stmt.bindLong(4, (long)value.getId());
            }
        };
        this.__deletionAdapterOfBlockingBlacklistModel = new EntityDeletionOrUpdateAdapter<BlockingBlacklistModel>(__db){

            public String createQuery() {
                return "DELETE FROM `blocking_blacklist` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingBlacklistModel value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfBlockingBlacklistModel = new EntityDeletionOrUpdateAdapter<BlockingBlacklistModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `blocking_blacklist` SET `block_prefix` = ?,`block_phoneno` = ?,`contact_name` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingBlacklistModel value) {
                if (value.getBlockPrefix() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getBlockPrefix());
                }
                if (value.getBlockPhoneNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getBlockPhoneNumber());
                }
                if (value.getContactName() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getContactName());
                }
                stmt.bindLong(4, (long)value.getId());
                stmt.bindLong(5, (long)value.getId());
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM blocking_blacklist WHERE block_prefix = ? AND block_phoneno = ?";
                return "DELETE FROM blocking_blacklist WHERE block_prefix = ? AND block_phoneno = ?";
            }
        };
    }

    @Override
    public void insert(BlockingBlacklistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBlockingBlacklistModel.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(BlockingBlacklistModel ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBlockingBlacklistModel.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(BlockingBlacklistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfBlockingBlacklistModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(BlockingBlacklistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfBlockingBlacklistModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String prefix, String number) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (prefix == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, prefix);
        }
        _argIndex = 2;
        if (number == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, number);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BlockingBlacklistModel> getAllBlackListEntries() {
        String _sql = "SELECT * FROM blocking_blacklist";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM blocking_blacklist", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfBlockPrefix = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_prefix");
            int _cursorIndexOfBlockPhoneNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_phoneno");
            int _cursorIndexOfContactName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contact_name");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            ArrayList<BlockingBlacklistModel> _result = new ArrayList<BlockingBlacklistModel>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpBlockPrefix = _cursor.isNull(_cursorIndexOfBlockPrefix) ? null : _cursor.getString(_cursorIndexOfBlockPrefix);
                String _tmpBlockPhoneNumber = _cursor.isNull(_cursorIndexOfBlockPhoneNumber) ? null : _cursor.getString(_cursorIndexOfBlockPhoneNumber);
                String _tmpContactName = _cursor.isNull(_cursorIndexOfContactName) ? null : _cursor.getString(_cursorIndexOfContactName);
                BlockingBlacklistModel _item = new BlockingBlacklistModel(_tmpBlockPrefix, _tmpBlockPhoneNumber, _tmpContactName);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _item.setId(_tmpId);
                _result.add(_item);
            }
            ArrayList<BlockingBlacklistModel> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingBlacklistModel getBlackListEntry(String prefix, String number) {
        String _sql = "SELECT * FROM blocking_blacklist WHERE block_prefix = ? AND block_phoneno = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM blocking_blacklist WHERE block_prefix = ? AND block_phoneno = ? LIMIT 1", (int)2);
        int _argIndex = 1;
        if (prefix == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, prefix);
        }
        _argIndex = 2;
        if (number == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, number);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            BlockingBlacklistModel _result;
            int _cursorIndexOfBlockPrefix = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_prefix");
            int _cursorIndexOfBlockPhoneNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_phoneno");
            int _cursorIndexOfContactName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contact_name");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            if (_cursor.moveToFirst()) {
                String _tmpBlockPrefix = _cursor.isNull(_cursorIndexOfBlockPrefix) ? null : _cursor.getString(_cursorIndexOfBlockPrefix);
                String _tmpBlockPhoneNumber = _cursor.isNull(_cursorIndexOfBlockPhoneNumber) ? null : _cursor.getString(_cursorIndexOfBlockPhoneNumber);
                String _tmpContactName = _cursor.isNull(_cursorIndexOfContactName) ? null : _cursor.getString(_cursorIndexOfContactName);
                _result = new BlockingBlacklistModel(_tmpBlockPrefix, _tmpBlockPhoneNumber, _tmpContactName);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            BlockingBlacklistModel blockingBlacklistModel = _result;
            return blockingBlacklistModel;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

