/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.dao.BlockingWhitelistDao;
import com.calldorado.sdk.localDB.model.BlockingWhitelistModel;
import java.util.Collections;
import java.util.List;

public final class BlockingWhitelistDao_Impl
implements BlockingWhitelistDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<BlockingWhitelistModel> __insertionAdapterOfBlockingWhitelistModel;
    private final EntityDeletionOrUpdateAdapter<BlockingWhitelistModel> __deletionAdapterOfBlockingWhitelistModel;
    private final EntityDeletionOrUpdateAdapter<BlockingWhitelistModel> __updateAdapterOfBlockingWhitelistModel;
    private final SharedSQLiteStatement __preparedStmtOfDelete;
    private final SharedSQLiteStatement __preparedStmtOfDeleteProfile;

    public BlockingWhitelistDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfBlockingWhitelistModel = new EntityInsertionAdapter<BlockingWhitelistModel>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `blocking_whitelist` (`block_prefix`,`block_phoneno`,`block_profile`,`contact_name`,`id`) VALUES (?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingWhitelistModel value) {
                if (value.getBlockPrefix() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getBlockPrefix());
                }
                if (value.getBlockPhoneNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getBlockPhoneNumber());
                }
                if (value.getBlockProfile() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getBlockProfile().intValue());
                }
                if (value.getContactName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getContactName());
                }
                stmt.bindLong(5, (long)value.getId());
            }
        };
        this.__deletionAdapterOfBlockingWhitelistModel = new EntityDeletionOrUpdateAdapter<BlockingWhitelistModel>(__db){

            public String createQuery() {
                return "DELETE FROM `blocking_whitelist` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingWhitelistModel value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfBlockingWhitelistModel = new EntityDeletionOrUpdateAdapter<BlockingWhitelistModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `blocking_whitelist` SET `block_prefix` = ?,`block_phoneno` = ?,`block_profile` = ?,`contact_name` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, BlockingWhitelistModel value) {
                if (value.getBlockPrefix() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getBlockPrefix());
                }
                if (value.getBlockPhoneNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getBlockPhoneNumber());
                }
                if (value.getBlockProfile() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)value.getBlockProfile().intValue());
                }
                if (value.getContactName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getContactName());
                }
                stmt.bindLong(5, (long)value.getId());
                stmt.bindLong(6, (long)value.getId());
            }
        };
        this.__preparedStmtOfDelete = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM blocking_whitelist WHERE block_prefix = ? AND block_phoneno = ? AND block_profile = ?";
                return "DELETE FROM blocking_whitelist WHERE block_prefix = ? AND block_phoneno = ? AND block_profile = ?";
            }
        };
        this.__preparedStmtOfDeleteProfile = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM blocking_whitelist WHERE block_profile = ?";
                return "DELETE FROM blocking_whitelist WHERE block_profile = ?";
            }
        };
    }

    @Override
    public void insert(BlockingWhitelistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBlockingWhitelistModel.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(BlockingWhitelistModel ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfBlockingWhitelistModel.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(BlockingWhitelistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfBlockingWhitelistModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(BlockingWhitelistModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfBlockingWhitelistModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String prefix, String number, Integer blockProfile) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDelete.acquire();
        int _argIndex = 1;
        if (prefix == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, prefix);
        }
        _argIndex = 2;
        if (number == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, number);
        }
        _argIndex = 3;
        if (blockProfile == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)blockProfile.intValue());
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDelete.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProfile(int profile) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteProfile.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, (long)profile);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteProfile.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BlockingWhitelistModel getWhiteListEntry(String prefix, String number, Integer blockProfile) {
        String _sql = "SELECT * FROM blocking_whitelist WHERE block_prefix = ? AND block_phoneno = ? AND block_profile = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM blocking_whitelist WHERE block_prefix = ? AND block_phoneno = ? AND block_profile = ? LIMIT 1", (int)3);
        int _argIndex = 1;
        if (prefix == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, prefix);
        }
        _argIndex = 2;
        if (number == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, number);
        }
        _argIndex = 3;
        if (blockProfile == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)blockProfile.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            BlockingWhitelistModel _result;
            int _cursorIndexOfBlockPrefix = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_prefix");
            int _cursorIndexOfBlockPhoneNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_phoneno");
            int _cursorIndexOfBlockProfile = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"block_profile");
            int _cursorIndexOfContactName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contact_name");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            if (_cursor.moveToFirst()) {
                String _tmpBlockPrefix = _cursor.isNull(_cursorIndexOfBlockPrefix) ? null : _cursor.getString(_cursorIndexOfBlockPrefix);
                String _tmpBlockPhoneNumber = _cursor.isNull(_cursorIndexOfBlockPhoneNumber) ? null : _cursor.getString(_cursorIndexOfBlockPhoneNumber);
                Integer _tmpBlockProfile = _cursor.isNull(_cursorIndexOfBlockProfile) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfBlockProfile));
                String _tmpContactName = _cursor.isNull(_cursorIndexOfContactName) ? null : _cursor.getString(_cursorIndexOfContactName);
                _result = new BlockingWhitelistModel(_tmpBlockPrefix, _tmpBlockPhoneNumber, _tmpBlockProfile, _tmpContactName);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            BlockingWhitelistModel blockingWhitelistModel = _result;
            return blockingWhitelistModel;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

