/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.dao.ContactDao;
import com.calldorado.sdk.localDB.model.Contact;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ContactDao_Impl
implements ContactDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<Contact> __insertionAdapterOfContact;
    private final EntityDeletionOrUpdateAdapter<Contact> __deletionAdapterOfContact;
    private final EntityDeletionOrUpdateAdapter<Contact> __updateAdapterOfContact;

    public ContactDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfContact = new EntityInsertionAdapter<Contact>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `contacts` (`contactId`,`name`,`number`,`formattedNumber`,`uri`,`isSpam`) VALUES (nullif(?, 0),?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Contact value) {
                stmt.bindLong(1, (long)value.getContactId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getNumber() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getNumber());
                }
                if (value.getFormattedNumber() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFormattedNumber());
                }
                if (value.getUri() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUri());
                }
                int _tmp = value.isSpam() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
            }
        };
        this.__deletionAdapterOfContact = new EntityDeletionOrUpdateAdapter<Contact>(__db){

            public String createQuery() {
                return "DELETE FROM `contacts` WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Contact value) {
                stmt.bindLong(1, (long)value.getContactId());
            }
        };
        this.__updateAdapterOfContact = new EntityDeletionOrUpdateAdapter<Contact>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `contacts` SET `contactId` = ?,`name` = ?,`number` = ?,`formattedNumber` = ?,`uri` = ?,`isSpam` = ? WHERE `contactId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Contact value) {
                stmt.bindLong(1, (long)value.getContactId());
                if (value.getName() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getName());
                }
                if (value.getNumber() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getNumber());
                }
                if (value.getFormattedNumber() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getFormattedNumber());
                }
                if (value.getUri() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getUri());
                }
                int _tmp = value.isSpam() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp);
                stmt.bindLong(7, (long)value.getContactId());
            }
        };
    }

    @Override
    public void insert(Contact obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContact.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(Contact ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfContact.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(Contact obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfContact.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(Contact obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfContact.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Contact> getAllContacts() {
        String _sql = "SELECT * FROM contacts";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM contacts", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
            int _cursorIndexOfUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uri");
            int _cursorIndexOfIsSpam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSpam");
            ArrayList<Contact> _result = new ArrayList<Contact>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                int _tmpContactId = _cursor.getInt(_cursorIndexOfContactId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                String _tmpUri = _cursor.isNull(_cursorIndexOfUri) ? null : _cursor.getString(_cursorIndexOfUri);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSpam);
                boolean _tmpIsSpam = _tmp != 0;
                Contact _item = new Contact(_tmpContactId, _tmpName, _tmpNumber, _tmpFormattedNumber, _tmpUri, _tmpIsSpam);
                _result.add(_item);
            }
            ArrayList<Contact> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact getContactByNumber(String number) {
        String _sql = "SELECT * FROM contacts WHERE number = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM contacts WHERE number = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (number == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, number);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Contact _result;
            int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
            int _cursorIndexOfUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uri");
            int _cursorIndexOfIsSpam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSpam");
            if (_cursor.moveToFirst()) {
                int _tmpContactId = _cursor.getInt(_cursorIndexOfContactId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                String _tmpUri = _cursor.isNull(_cursorIndexOfUri) ? null : _cursor.getString(_cursorIndexOfUri);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSpam);
                boolean _tmpIsSpam = _tmp != 0;
                _result = new Contact(_tmpContactId, _tmpName, _tmpNumber, _tmpFormattedNumber, _tmpUri, _tmpIsSpam);
            } else {
                _result = null;
            }
            Contact contact = _result;
            return contact;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Contact getContactById(int contactId) {
        String _sql = "SELECT * FROM contacts WHERE contactId = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM contacts WHERE contactId = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)contactId);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            Contact _result;
            int _cursorIndexOfContactId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contactId");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
            int _cursorIndexOfUri = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uri");
            int _cursorIndexOfIsSpam = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSpam");
            if (_cursor.moveToFirst()) {
                int _tmpContactId = _cursor.getInt(_cursorIndexOfContactId);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                String _tmpUri = _cursor.isNull(_cursorIndexOfUri) ? null : _cursor.getString(_cursorIndexOfUri);
                int _tmp = _cursor.getInt(_cursorIndexOfIsSpam);
                boolean _tmpIsSpam = _tmp != 0;
                _result = new Contact(_tmpContactId, _tmpName, _tmpNumber, _tmpFormattedNumber, _tmpUri, _tmpIsSpam);
            } else {
                _result = null;
            }
            Contact contact = _result;
            return contact;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

