/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.dao.IncompleteCallHistoryDao;
import com.calldorado.sdk.localDB.model.IncompleteCallHistoryModel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class IncompleteCallHistoryDao_Impl
implements IncompleteCallHistoryDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<IncompleteCallHistoryModel> __insertionAdapterOfIncompleteCallHistoryModel;
    private final EntityDeletionOrUpdateAdapter<IncompleteCallHistoryModel> __deletionAdapterOfIncompleteCallHistoryModel;
    private final EntityDeletionOrUpdateAdapter<IncompleteCallHistoryModel> __updateAdapterOfIncompleteCallHistoryModel;
    private final SharedSQLiteStatement __preparedStmtOfDeleteExpiredEntries;

    public IncompleteCallHistoryDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfIncompleteCallHistoryModel = new EntityInsertionAdapter<IncompleteCallHistoryModel>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `incomplete_call_history` (`number`,`formattedNumber`,`time`,`numberOfCalls`,`name`,`callType`,`id`) VALUES (?,?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, IncompleteCallHistoryModel value) {
                if (value.getNumber() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getNumber());
                }
                if (value.getFormattedNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFormattedNumber());
                }
                stmt.bindLong(3, value.getTime());
                stmt.bindLong(4, (long)value.getNumberOfCalls());
                if (value.getName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getName());
                }
                if (value.getCallType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCallType());
                }
                stmt.bindLong(7, (long)value.getId());
            }
        };
        this.__deletionAdapterOfIncompleteCallHistoryModel = new EntityDeletionOrUpdateAdapter<IncompleteCallHistoryModel>(__db){

            public String createQuery() {
                return "DELETE FROM `incomplete_call_history` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, IncompleteCallHistoryModel value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfIncompleteCallHistoryModel = new EntityDeletionOrUpdateAdapter<IncompleteCallHistoryModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `incomplete_call_history` SET `number` = ?,`formattedNumber` = ?,`time` = ?,`numberOfCalls` = ?,`name` = ?,`callType` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, IncompleteCallHistoryModel value) {
                if (value.getNumber() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getNumber());
                }
                if (value.getFormattedNumber() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getFormattedNumber());
                }
                stmt.bindLong(3, value.getTime());
                stmt.bindLong(4, (long)value.getNumberOfCalls());
                if (value.getName() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getName());
                }
                if (value.getCallType() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getCallType());
                }
                stmt.bindLong(7, (long)value.getId());
                stmt.bindLong(8, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteExpiredEntries = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM incomplete_call_history WHERE time + 86400000 < ?";
                return "DELETE FROM incomplete_call_history WHERE time + 86400000 < ?";
            }
        };
    }

    @Override
    public void insert(IncompleteCallHistoryModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfIncompleteCallHistoryModel.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(IncompleteCallHistoryModel ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfIncompleteCallHistoryModel.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(IncompleteCallHistoryModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfIncompleteCallHistoryModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(IncompleteCallHistoryModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfIncompleteCallHistoryModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteExpiredEntries(long currentTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteExpiredEntries.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, currentTime);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteExpiredEntries.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IncompleteCallHistoryModel getEntry(String number) {
        String _sql = "SELECT * FROM incomplete_call_history WHERE number = ? LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM incomplete_call_history WHERE number = ? LIMIT 1", (int)1);
        int _argIndex = 1;
        if (number == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, number);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            IncompleteCallHistoryModel _result;
            int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
            int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
            int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
            int _cursorIndexOfNumberOfCalls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"numberOfCalls");
            int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
            int _cursorIndexOfCallType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callType");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            if (_cursor.moveToFirst()) {
                String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                int _tmpNumberOfCalls = _cursor.getInt(_cursorIndexOfNumberOfCalls);
                String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                String _tmpCallType = _cursor.isNull(_cursorIndexOfCallType) ? null : _cursor.getString(_cursorIndexOfCallType);
                _result = new IncompleteCallHistoryModel(_tmpNumber, _tmpFormattedNumber, _tmpTime, _tmpNumberOfCalls, _tmpName, _tmpCallType);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            IncompleteCallHistoryModel incompleteCallHistoryModel = _result;
            return incompleteCallHistoryModel;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<IncompleteCallHistoryModel> getMostRelevantNoAnswerEntry() {
        String _sql = "SELECT * FROM incomplete_call_history WHERE callType = 'no_answer' ORDER BY numberOfCalls DESC, time DESC LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM incomplete_call_history WHERE callType = 'no_answer' ORDER BY numberOfCalls DESC, time DESC LIMIT 1", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"incomplete_call_history"}, false, (Callable)new Callable<IncompleteCallHistoryModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncompleteCallHistoryModel call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)IncompleteCallHistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    IncompleteCallHistoryModel _result;
                    int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
                    int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
                    int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
                    int _cursorIndexOfNumberOfCalls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"numberOfCalls");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfCallType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callType");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                        String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                        long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                        int _tmpNumberOfCalls = _cursor.getInt(_cursorIndexOfNumberOfCalls);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpCallType = _cursor.isNull(_cursorIndexOfCallType) ? null : _cursor.getString(_cursorIndexOfCallType);
                        _result = new IncompleteCallHistoryModel(_tmpNumber, _tmpFormattedNumber, _tmpTime, _tmpNumberOfCalls, _tmpName, _tmpCallType);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _result.setId(_tmpId);
                    } else {
                        _result = null;
                    }
                    IncompleteCallHistoryModel incompleteCallHistoryModel = _result;
                    return incompleteCallHistoryModel;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<IncompleteCallHistoryModel> getMostRelevantMissedCallEntry() {
        String _sql = "SELECT * FROM incomplete_call_history WHERE callType = 'missed_call' ORDER BY numberOfCalls DESC, time DESC LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM incomplete_call_history WHERE callType = 'missed_call' ORDER BY numberOfCalls DESC, time DESC LIMIT 1", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"incomplete_call_history"}, false, (Callable)new Callable<IncompleteCallHistoryModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IncompleteCallHistoryModel call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)IncompleteCallHistoryDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    IncompleteCallHistoryModel _result;
                    int _cursorIndexOfNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"number");
                    int _cursorIndexOfFormattedNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"formattedNumber");
                    int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
                    int _cursorIndexOfNumberOfCalls = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"numberOfCalls");
                    int _cursorIndexOfName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"name");
                    int _cursorIndexOfCallType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callType");
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    if (_cursor.moveToFirst()) {
                        String _tmpNumber = _cursor.isNull(_cursorIndexOfNumber) ? null : _cursor.getString(_cursorIndexOfNumber);
                        String _tmpFormattedNumber = _cursor.isNull(_cursorIndexOfFormattedNumber) ? null : _cursor.getString(_cursorIndexOfFormattedNumber);
                        long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                        int _tmpNumberOfCalls = _cursor.getInt(_cursorIndexOfNumberOfCalls);
                        String _tmpName = _cursor.isNull(_cursorIndexOfName) ? null : _cursor.getString(_cursorIndexOfName);
                        String _tmpCallType = _cursor.isNull(_cursorIndexOfCallType) ? null : _cursor.getString(_cursorIndexOfCallType);
                        _result = new IncompleteCallHistoryModel(_tmpNumber, _tmpFormattedNumber, _tmpTime, _tmpNumberOfCalls, _tmpName, _tmpCallType);
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        _result.setId(_tmpId);
                    } else {
                        _result = null;
                    }
                    IncompleteCallHistoryModel incompleteCallHistoryModel = _result;
                    return incompleteCallHistoryModel;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

