/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.RoomTypeConverters;
import com.calldorado.sdk.localDB.dao.LastCallDao;
import com.calldorado.sdk.localDB.model.Contact;
import com.calldorado.sdk.localDB.model.LastCallModel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class LastCallDao_Impl
implements LastCallDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LastCallModel> __insertionAdapterOfLastCallModel;
    private final RoomTypeConverters __roomTypeConverters = new RoomTypeConverters();
    private final EntityDeletionOrUpdateAdapter<LastCallModel> __deletionAdapterOfLastCallModel;
    private final EntityDeletionOrUpdateAdapter<LastCallModel> __updateAdapterOfLastCallModel;
    private final SharedSQLiteStatement __preparedStmtOfRemoveAll;

    public LastCallDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLastCallModel = new EntityInsertionAdapter<LastCallModel>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `last_caller` (`callId`,`callStarted`,`duration`,`isIncoming`,`isSearching`,`isCompletedCall`,`callEnded`,`isRinging`,`contact`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, LastCallModel value) {
                if (value.getCallId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCallId());
                }
                stmt.bindLong(2, value.getCallStarted());
                stmt.bindLong(3, value.getDuration());
                int _tmp = value.isIncoming() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                int _tmp_1 = value.isSearching() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isCompletedCall() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                stmt.bindLong(7, value.getCallEnded());
                int _tmp_3 = value.isRinging() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                String _tmp_4 = LastCallDao_Impl.this.__roomTypeConverters.convertContactToString(value.getContact());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
            }
        };
        this.__deletionAdapterOfLastCallModel = new EntityDeletionOrUpdateAdapter<LastCallModel>(__db){

            public String createQuery() {
                return "DELETE FROM `last_caller` WHERE `callId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LastCallModel value) {
                if (value.getCallId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCallId());
                }
            }
        };
        this.__updateAdapterOfLastCallModel = new EntityDeletionOrUpdateAdapter<LastCallModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `last_caller` SET `callId` = ?,`callStarted` = ?,`duration` = ?,`isIncoming` = ?,`isSearching` = ?,`isCompletedCall` = ?,`callEnded` = ?,`isRinging` = ?,`contact` = ? WHERE `callId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, LastCallModel value) {
                if (value.getCallId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getCallId());
                }
                stmt.bindLong(2, value.getCallStarted());
                stmt.bindLong(3, value.getDuration());
                int _tmp = value.isIncoming() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp);
                int _tmp_1 = value.isSearching() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_1);
                int _tmp_2 = value.isCompletedCall() ? 1 : 0;
                stmt.bindLong(6, (long)_tmp_2);
                stmt.bindLong(7, value.getCallEnded());
                int _tmp_3 = value.isRinging() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_3);
                String _tmp_4 = LastCallDao_Impl.this.__roomTypeConverters.convertContactToString(value.getContact());
                if (_tmp_4 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_4);
                }
                if (value.getCallId() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getCallId());
                }
            }
        };
        this.__preparedStmtOfRemoveAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM last_caller";
                return "DELETE FROM last_caller";
            }
        };
    }

    @Override
    public void insert(LastCallModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLastCallModel.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(LastCallModel ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLastCallModel.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(LastCallModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfLastCallModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(LastCallModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfLastCallModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfRemoveAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfRemoveAll.release(_stmt);
        }
    }

    @Override
    public LiveData<LastCallModel> getLastCall() {
        String _sql = "SELECT * FROM last_caller ORDER BY callStarted LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM last_caller ORDER BY callStarted LIMIT 1", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"last_caller"}, false, (Callable)new Callable<LastCallModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public LastCallModel call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)LastCallDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    LastCallModel _result;
                    int _cursorIndexOfCallId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callId");
                    int _cursorIndexOfCallStarted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callStarted");
                    int _cursorIndexOfDuration = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duration");
                    int _cursorIndexOfIsIncoming = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isIncoming");
                    int _cursorIndexOfIsSearching = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isSearching");
                    int _cursorIndexOfIsCompletedCall = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isCompletedCall");
                    int _cursorIndexOfCallEnded = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"callEnded");
                    int _cursorIndexOfIsRinging = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRinging");
                    int _cursorIndexOfContact = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"contact");
                    if (_cursor.moveToFirst()) {
                        String _tmpCallId = _cursor.isNull(_cursorIndexOfCallId) ? null : _cursor.getString(_cursorIndexOfCallId);
                        long _tmpCallStarted = _cursor.getLong(_cursorIndexOfCallStarted);
                        long _tmpDuration = _cursor.getLong(_cursorIndexOfDuration);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsIncoming);
                        boolean _tmpIsIncoming = _tmp != 0;
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsSearching);
                        boolean _tmpIsSearching = _tmp_1 != 0;
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsCompletedCall);
                        boolean _tmpIsCompletedCall = _tmp_2 != 0;
                        long _tmpCallEnded = _cursor.getLong(_cursorIndexOfCallEnded);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsRinging);
                        boolean _tmpIsRinging = _tmp_3 != 0;
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfContact) ? null : _cursor.getString(_cursorIndexOfContact);
                        Contact _tmpContact = LastCallDao_Impl.this.__roomTypeConverters.convertStringToContact(_tmp_4);
                        _result = new LastCallModel(_tmpCallId, _tmpCallStarted, _tmpDuration, _tmpIsIncoming, _tmpIsSearching, _tmpIsCompletedCall, _tmpCallEnded, _tmpIsRinging, _tmpContact);
                    } else {
                        _result = null;
                    }
                    LastCallModel lastCallModel = _result;
                    return lastCallModel;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

