/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.localDB.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.calldorado.sdk.localDB.dao.RemindersDao;
import com.calldorado.sdk.localDB.model.RemindersModel;
import java.util.Collections;
import java.util.List;

public final class RemindersDao_Impl
implements RemindersDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<RemindersModel> __insertionAdapterOfRemindersModel;
    private final EntityDeletionOrUpdateAdapter<RemindersModel> __deletionAdapterOfRemindersModel;
    private final EntityDeletionOrUpdateAdapter<RemindersModel> __updateAdapterOfRemindersModel;
    private final SharedSQLiteStatement __preparedStmtOfDeleteExpiredReminders;
    private final SharedSQLiteStatement __preparedStmtOfDeleteReminders;

    public RemindersDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfRemindersModel = new EntityInsertionAdapter<RemindersModel>(__db){

            public String createQuery() {
                return "INSERT OR IGNORE INTO `reminders` (`time`,`text`,`id`) VALUES (?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, RemindersModel value) {
                stmt.bindLong(1, value.getTime());
                if (value.getText() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getText());
                }
                stmt.bindLong(3, (long)value.getId());
            }
        };
        this.__deletionAdapterOfRemindersModel = new EntityDeletionOrUpdateAdapter<RemindersModel>(__db){

            public String createQuery() {
                return "DELETE FROM `reminders` WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RemindersModel value) {
                stmt.bindLong(1, (long)value.getId());
            }
        };
        this.__updateAdapterOfRemindersModel = new EntityDeletionOrUpdateAdapter<RemindersModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `reminders` SET `time` = ?,`text` = ?,`id` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, RemindersModel value) {
                stmt.bindLong(1, value.getTime());
                if (value.getText() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getText());
                }
                stmt.bindLong(3, (long)value.getId());
                stmt.bindLong(4, (long)value.getId());
            }
        };
        this.__preparedStmtOfDeleteExpiredReminders = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM reminders WHERE time < ?";
                return "DELETE FROM reminders WHERE time < ?";
            }
        };
        this.__preparedStmtOfDeleteReminders = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM reminders";
                return "DELETE FROM reminders";
            }
        };
    }

    @Override
    public void insert(RemindersModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRemindersModel.insert((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(RemindersModel ... obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfRemindersModel.insert((Object[])obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(RemindersModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfRemindersModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(RemindersModel obj) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfRemindersModel.handle((Object)obj);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteExpiredReminders(long currentTime) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteExpiredReminders.acquire();
        int _argIndex = 1;
        _stmt.bindLong(_argIndex, currentTime);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteExpiredReminders.release(_stmt);
        }
    }

    @Override
    public void deleteReminders() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteReminders.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteReminders.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemindersModel getReminder() {
        String _sql = "SELECT * FROM reminders ORDER BY time DESC LIMIT 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM reminders ORDER BY time DESC LIMIT 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            RemindersModel _result;
            int _cursorIndexOfTime = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"time");
            int _cursorIndexOfText = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"text");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            if (_cursor.moveToFirst()) {
                long _tmpTime = _cursor.getLong(_cursorIndexOfTime);
                String _tmpText = _cursor.isNull(_cursorIndexOfText) ? null : _cursor.getString(_cursorIndexOfText);
                _result = new RemindersModel(_tmpTime, _tmpText);
                int _tmpId = _cursor.getInt(_cursorIndexOfId);
                _result.setId(_tmpId);
            } else {
                _result = null;
            }
            RemindersModel remindersModel = _result;
            return remindersModel;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

