/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.receivers;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import androidx.annotation.RequiresApi;
import androidx.compose.animation.ExperimentalAnimationApi;
import androidx.compose.material.ExperimentalMaterialApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.DeveloperFeatureHandler;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.services.CalldoradoForegroundService;
import com.calldorado.sdk.services.CalldoradoForegroundServiceBinder;
import com.calldorado.sdk.ui.repository.RepositoryImpl;
import com.calldorado.sdk.util.FunctionsKt;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@ExperimentalMaterialApi
@ExperimentalAnimationApi
@ExperimentalComposeUiApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0015H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u000b\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/calldorado/sdk/receivers/PhoneStateReceiver;", "Landroid/content/BroadcastReceiver;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "()V", "mContext", "Landroid/content/Context;", "mPreferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getMPreferencesManager", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "mPreferencesManager$delegate", "Lkotlin/Lazy;", "mRepositoryImpl", "Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "getMRepositoryImpl", "()Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "mRepositoryImpl$delegate", "onReceive", "", "context", "intent", "Landroid/content/Intent;", "reOptinUsersIfNeeded", "startServiceWithBinding", "updateRepository", "updateService", "intentExtra", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
public final class PhoneStateReceiver
extends BroadcastReceiver
implements SdkCoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Context mContext;
    @NotNull
    private final Lazy mPreferencesManager$delegate;
    @NotNull
    private final Lazy mRepositoryImpl$delegate;
    public static final int $stable = 8;
    @NotNull
    private static String prevCallState;

    public PhoneStateReceiver() {
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.mPreferencesManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.mRepositoryImpl$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<RepositoryImpl>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RepositoryImpl invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RepositoryImpl.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RepositoryImpl.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    @NotNull
    public final PreferencesManager getMPreferencesManager() {
        Lazy lazy = this.mPreferencesManager$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    private final RepositoryImpl getMRepositoryImpl() {
        Lazy lazy = this.mRepositoryImpl$delegate;
        return (RepositoryImpl)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public void onReceive(@Nullable Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            boolean bl;
            String callState;
            boolean optinAcceptance;
            block11: {
                void $this$all$iv;
                this.mContext = context;
                Context context2 = context;
                if (context2 != null) {
                    Context it = context2;
                    boolean bl2 = false;
                    DeveloperFeatureHandler.INSTANCE.startCalldorado(context);
                }
                this.reOptinUsersIfNeeded();
                optinAcceptance = this.getMPreferencesManager().getValue("pref_optin_acceptance", false);
                String string2 = intent.getStringExtra("state");
                if (string2 == null) {
                    string2 = TelephonyManager.EXTRA_STATE_IDLE;
                }
                callState = string2;
                Object bl2 = new Boolean[]{Intrinsics.areEqual((Object)callState, (Object)prevCallState), Intrinsics.areEqual((Object)callState, (Object)TelephonyManager.EXTRA_STATE_IDLE)};
                bl2 = CollectionsKt.listOf((Object[])bl2);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        boolean it = (Boolean)element$iv;
                        boolean bl3 = false;
                        if (it) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (!bl) {
                boolean canServiceStart = FunctionsKt.canForegroundServiceStart(context);
                Intrinsics.checkNotNullExpressionValue((Object)callState, (String)"callState");
                prevCallState = callState;
                if (optinAcceptance) {
                    if (canServiceStart) {
                        this.updateService(intent);
                    } else {
                        this.updateRepository(intent);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void updateService(Intent intentExtra) {
        try {
            Context context = this.mContext;
            if (context == null) {
                return;
            }
            Context context2 = context;
            Intent intent = new Intent(context2, CalldoradoForegroundService.class);
            intent.putExtra("android.intent.extra.INTENT", (Parcelable)intentExtra);
            if (Build.VERSION.SDK_INT < 26) {
                context2.startService(intent);
            } else if (Build.VERSION.SDK_INT < 31 || FunctionsKt.hasOverlayPermission(context2)) {
                this.startServiceWithBinding(context2, intent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void updateRepository(Intent intent) {
        this.getMRepositoryImpl().resolvePhoneState(intent, false);
    }

    @RequiresApi(value=26)
    public final void startServiceWithBinding(@NotNull Context context, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            Context applicationContext = context.getApplicationContext();
            applicationContext.bindService(intent, new ServiceConnection(applicationContext, intent){
                final /* synthetic */ Context $applicationContext;
                final /* synthetic */ Intent $intent;
                {
                    this.$applicationContext = $applicationContext;
                    this.$intent = $intent;
                }

                public void onServiceConnected(@Nullable ComponentName name, @Nullable IBinder binder) {
                    try {
                        if (binder instanceof CalldoradoForegroundServiceBinder) {
                            CalldoradoForegroundService service;
                            CalldoradoForegroundService calldoradoForegroundService = service = ((CalldoradoForegroundServiceBinder)binder).getService();
                            if (calldoradoForegroundService != null) {
                                CalldoradoForegroundService calldoradoForegroundService2 = calldoradoForegroundService;
                                Intent intent = this.$intent;
                                CalldoradoForegroundService it = calldoradoForegroundService2;
                                boolean bl = false;
                                service.forceForeground(intent);
                            }
                        }
                        this.$applicationContext.unbindService((ServiceConnection)this);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }

                public void onServiceDisconnected(@Nullable ComponentName name) {
                }
            }, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private final void reOptinUsersIfNeeded() {
        block1: {
            Context context = this.mContext;
            if (context == null) break block1;
            Context it = context;
            boolean bl = false;
            boolean isOptinAccepted = this.getMPreferencesManager().getValue("pref_optin_acceptance", false);
            if (!isOptinAccepted && FunctionsKt.hasPermission(it, "android.permission.READ_PHONE_STATE")) {
                DeveloperFeatureHandler.INSTANCE.acceptConditions(CalldoradoApplication.Companion.getContext(), true);
            }
        }
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    static {
        String string2 = TelephonyManager.EXTRA_STATE_IDLE;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"EXTRA_STATE_IDLE");
        prevCallState = string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/calldorado/sdk/receivers/PhoneStateReceiver$Companion;", "", "()V", "prevCallState", "", "getPrevCallState", "()Ljava/lang/String;", "setPrevCallState", "(Ljava/lang/String;)V", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPrevCallState() {
            return prevCallState;
        }

        public final void setPrevCallState(@NotNull String string2) {
            Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
            prevCallState = string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

