/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.services;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import androidx.compose.animation.ExperimentalAnimationApi;
import androidx.compose.material.ExperimentalMaterialApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.LifecycleService;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import com.calldorado.ads.adsapi.AdsAPI;
import com.calldorado.ads.adsapi.models.AdRequest;
import com.calldorado.sdk.Calldorado;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.DeveloperFeatureHandler;
import com.calldorado.sdk.NotificationsUtil;
import com.calldorado.sdk.ads.AdController;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.localDB.model.Contact;
import com.calldorado.sdk.logging.CLog;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.services.CalldoradoForegroundServiceBinder;
import com.calldorado.sdk.ui.repository.CallState;
import com.calldorado.sdk.ui.repository.RepositoryImpl;
import com.calldorado.sdk.ui.ui.ConfigController;
import com.calldorado.sdk.ui.ui.wic.WicController;
import com.calldorado.sdk.util.EmergencyNumbers;
import com.calldorado.sdk.util.FunctionsKt;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.android.ext.android.ComponentCallbackExtKt;
import org.koin.core.Koin;
import org.koin.core.parameter.ParametersHolder;
import org.koin.core.parameter.ParametersHolderKt;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ExperimentalMaterialApi
@ExperimentalAnimationApi
@ExperimentalComposeUiApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 P2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001PB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u00100\u001a\u00020.H\u0007J\b\u00101\u001a\u00020,H\u0002J\b\u00102\u001a\u00020,H\u0003J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0007J\b\u00106\u001a\u000207H\u0002J$\u00108\u001a\u001e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:09j\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020:`;H\u0002J\b\u0010<\u001a\u00020,H\u0002J\u000e\u0010=\u001a\u00020.2\u0006\u0010>\u001a\u00020?J\u0006\u0010@\u001a\u00020,J\u0012\u0010A\u001a\u0004\u0018\u00010B2\u0006\u00104\u001a\u000205H\u0016J\b\u0010C\u001a\u00020,H\u0016J\b\u0010D\u001a\u00020,H\u0016J\"\u0010E\u001a\u00020F2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020FH\u0016J\u0012\u0010I\u001a\u00020.2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\b\u0010L\u001a\u00020,H\u0002J\b\u0010M\u001a\u00020,H\u0002J\b\u0010N\u001a\u00020,H\u0002J\b\u0010O\u001a\u00020,H\u0003R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\n\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\n\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001b\u0010&\u001a\u00020'8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010\n\u001a\u0004\b(\u0010)\u00a8\u0006Q"}, d2={"Lcom/calldorado/sdk/services/CalldoradoForegroundService;", "Landroidx/lifecycle/LifecycleService;", "Landroidx/savedstate/SavedStateRegistryOwner;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "()V", "adController", "Lcom/calldorado/sdk/ads/AdController;", "getAdController", "()Lcom/calldorado/sdk/ads/AdController;", "adController$delegate", "Lkotlin/Lazy;", "configController", "Lcom/calldorado/sdk/ui/ui/ConfigController;", "getConfigController", "()Lcom/calldorado/sdk/ui/ui/ConfigController;", "configController$delegate", "foregroundBind", "Lcom/calldorado/sdk/services/CalldoradoForegroundServiceBinder;", "mAdRequest", "Lcom/calldorado/ads/adsapi/models/AdRequest;", "mLifecycleRegistry", "Landroidx/lifecycle/LifecycleRegistry;", "mPreferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getMPreferencesManager", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "mPreferencesManager$delegate", "mSavedStateRegistryController", "Landroidx/savedstate/SavedStateRegistryController;", "repositoryImpl", "Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "getRepositoryImpl", "()Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "repositoryImpl$delegate", "savedStateRegistry", "Landroidx/savedstate/SavedStateRegistry;", "getSavedStateRegistry", "()Landroidx/savedstate/SavedStateRegistry;", "wicController", "Lcom/calldorado/sdk/ui/ui/wic/WicController;", "getWicController", "()Lcom/calldorado/sdk/ui/ui/wic/WicController;", "wicController$delegate", "callEnded", "", "completed", "", "callStarted", "incoming", "createNotificationChannel", "finishService", "forceForeground", "intent", "Landroid/content/Intent;", "getNotification", "Landroid/app/Notification;", "getParamMapForShowWic", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "handleEmergencyCallState", "handleLifecycleEvent", "event", "Landroidx/lifecycle/Lifecycle$Event;", "listenToUpdates", "onBind", "Landroid/os/IBinder;", "onCreate", "onDestroy", "onStartCommand", "", "flags", "startId", "performRestore", "savedState", "Landroid/os/Bundle;", "preloadAd", "removeNotification", "resetMaxAdClickPerDatValuesIfNeeded", "updateNotification", "Companion", "sdk_release"})
@StabilityInferred(parameters=0)
public final class CalldoradoForegroundService
extends LifecycleService
implements SavedStateRegistryOwner,
SdkCoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CalldoradoForegroundServiceBinder foregroundBind = new CalldoradoForegroundServiceBinder();
    @NotNull
    private LifecycleRegistry mLifecycleRegistry = new LifecycleRegistry((LifecycleOwner)this);
    @NotNull
    private SavedStateRegistryController mSavedStateRegistryController = SavedStateRegistryController.Companion.create((SavedStateRegistryOwner)this);
    @NotNull
    private final Lazy wicController$delegate;
    @NotNull
    private final Lazy repositoryImpl$delegate;
    @NotNull
    private final Lazy configController$delegate;
    @NotNull
    private final Lazy mPreferencesManager$delegate;
    @NotNull
    private final Lazy adController$delegate;
    @Nullable
    private AdRequest mAdRequest;
    public static final int $stable = 8;
    @NotNull
    private static final String TAG = "CalldoradoService";
    private static final int NOTIFICATION_ID = 56213;
    @NotNull
    private static final String CHANNEL_ID = "19213";

    public CalldoradoForegroundService() {
        ComponentCallbacks $this$inject_u24default$iv;
        ComponentCallbacks componentCallbacks = (ComponentCallbacks)this;
        Function0 parameters$iv = (Function0)new Function0<ParametersHolder>(this){
            final /* synthetic */ CalldoradoForegroundService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ParametersHolder invoke() {
                Object[] objectArray = new Object[]{this.this$0};
                return ParametersHolderKt.parametersOf((Object[])objectArray);
            }
        };
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        boolean $i$f$inject = false;
        this.wicController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<WicController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final WicController invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = ComponentCallbackExtKt.getDefaultScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(WicController.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.repositoryImpl$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<RepositoryImpl>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RepositoryImpl invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = ComponentCallbackExtKt.getDefaultScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RepositoryImpl.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.configController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ConfigController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfigController invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = ComponentCallbackExtKt.getDefaultScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.mPreferencesManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = ComponentCallbackExtKt.getDefaultScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
        $this$inject_u24default$iv = (ComponentCallbacks)this;
        qualifier$iv = null;
        mode$iv = LazyThreadSafetyMode.SYNCHRONIZED;
        parameters$iv = null;
        $i$f$inject = false;
        this.adController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AdController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ ComponentCallbacks $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AdController invoke() {
                void qualifier$iv;
                void $this$get$iv;
                ComponentCallbacks componentCallbacks = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                Scope this_$iv$iv = ComponentCallbackExtKt.getDefaultScope((ComponentCallbacks)$this$get$iv);
                boolean $i$f$get2 = false;
                return this_$iv$iv.get(Reflection.getOrCreateKotlinClass(AdController.class), (Qualifier)qualifier$iv, parameters$iv);
            }
        }));
    }

    private final WicController getWicController() {
        Lazy lazy = this.wicController$delegate;
        return (WicController)lazy.getValue();
    }

    private final RepositoryImpl getRepositoryImpl() {
        Lazy lazy = this.repositoryImpl$delegate;
        return (RepositoryImpl)lazy.getValue();
    }

    private final ConfigController getConfigController() {
        Lazy lazy = this.configController$delegate;
        return (ConfigController)lazy.getValue();
    }

    private final PreferencesManager getMPreferencesManager() {
        Lazy lazy = this.mPreferencesManager$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    private final AdController getAdController() {
        Lazy lazy = this.adController$delegate;
        return (AdController)lazy.getValue();
    }

    public void onCreate() {
        try {
            super.onCreate();
            CalldoradoApplication.Companion.updateDoraConfig();
            this.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
            if (!this.performRestore(null)) {
                CLog.d(TAG, "performRestore returned false");
            }
            this.listenToUpdates();
        }
        catch (Exception e) {
            CLog.d(TAG, "onCreate Exception " + e.getMessage());
        }
    }

    @RequiresApi(api=26)
    public final void forceForeground(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            ContextCompat.startForegroundService((Context)((Context)this), (Intent)intent);
            this.startForeground(56213, this.getNotification());
        }
        catch (Exception e) {
            CLog.d(TAG, "forceForeground Exception " + e.getMessage());
        }
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        try {
            super.onStartCommand(intent, flags, startId);
            String number = EmergencyNumbers.INSTANCE.getNumberFromIntent(intent);
            Intent intent2 = intent;
            Intent extra = (Intent)(intent2 != null && (intent2 = intent2.getExtras()) != null ? intent2.get("android.intent.extra.INTENT") : null);
            this.getRepositoryImpl().resolvePhoneState(extra, true);
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            if (EmergencyNumbers.INSTANCE.isEmergencyNumber(context, number)) {
                this.handleEmergencyCallState();
            }
            return super.onStartCommand(intent, flags, startId);
        }
        catch (Exception e) {
            CLog.d(TAG, "onStartCommand Exception " + e.getMessage());
            return 2;
        }
    }

    public final void listenToUpdates() {
        try {
            this.getRepositoryImpl().getCallState().observe((LifecycleOwner)this, arg_0 -> CalldoradoForegroundService.listenToUpdates$lambda-0(this, arg_0));
            if (Build.VERSION.SDK_INT >= 23) {
                this.getRepositoryImpl().getLastcallerD().observe((LifecycleOwner)this, arg_0 -> CalldoradoForegroundService.listenToUpdates$lambda-1(this, arg_0));
            }
        }
        catch (Exception e) {
            CLog.d(TAG, "listenToUpdates Exception " + e.getMessage());
        }
    }

    @ExperimentalComposeUiApi
    public final void callStarted(boolean incoming) {
        try {
            try {
                this.resetMaxAdClickPerDatValuesIfNeeded();
                String showWicRestrictionStr = this.getConfigController().getShowWicRestrictionsStr();
                boolean shouldPreloadAd = this.getConfigController().shouldPreLoadAd();
                if (((CharSequence)showWicRestrictionStr).length() == 0) {
                    this.getWicController().show();
                    HashMap<String, String> mapShowWic = this.getParamMapForShowWic();
                    ((Map)mapShowWic).put("should_preload_ad", String.valueOf(shouldPreloadAd));
                    ((Map)mapShowWic).put("should_preload_ad_reason", this.getConfigController().shouldPreLoadAdString());
                    CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "cdo_wic_shown", "CDO_STAT_V7_CALL", mapShowWic, 0.0, 8, null);
                } else {
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call_id", (Object)CalldoradoApplication.Companion.getLastCallId()), TuplesKt.to((Object)"wic_not_shown_reason", (Object)showWicRestrictionStr)};
                    CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "cdo_wic_not_shown", "CDO_STAT_V7_CALL", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
                }
                if (shouldPreloadAd) {
                    this.preloadAd();
                }
                if (this.getRepositoryImpl().isFirstTimeCall()) {
                    CalldoradoApplication.Companion.sendFirebaseStatIfPossible("first_time_phone_call", "");
                    Calldorado.sendStat("first_time_phone_call", "OPTIN");
                    this.getRepositoryImpl().setIsFirstTimeCallDone();
                }
            }
            catch (Exception e) {
                CLog.d(TAG, "callStarted.CoroutineScope.launch Exception " + e.getMessage());
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)String.valueOf(e.getMessage()))};
                CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "callStarted Exception", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            }
        }
        catch (Exception e) {
            CLog.d(TAG, "callStarted Exception " + e.getMessage());
        }
    }

    private final void callEnded(boolean completed) {
        block7: {
            try {
                this.getWicController().hide();
                this.finishService();
                CalldoradoApplication.Companion.sendFirebaseStatIfPossible("phone_calls", "");
                if (Build.VERSION.SDK_INT >= 29) {
                    Context context = this.getApplicationContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                    if (!FunctionsKt.hasOverlayPermission(context)) {
                        NotificationsUtil.INSTANCE.sendOverlayNotification(CalldoradoApplication.Companion.getContext());
                    }
                }
                Contact contact = (Contact)this.getRepositoryImpl().getLastcallerD().getValue();
                String calledNumber = contact != null ? contact.getNumber() : null;
                Object object = (Contact)this.getRepositoryImpl().getLastcallerD().getValue();
                Boolean isContact = object != null && (object = ((Contact)object).getUri()) != null ? Boolean.valueOf(!StringsKt.isBlank((CharSequence)((CharSequence)object))) : null;
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                boolean isEmergencyCall = EmergencyNumbers.INSTANCE.isEmergencyNumber(context, calledNumber);
                ConfigController.AftercallConfigControl aftercallConfigControl = this.getConfigController().aftercallConfigControl();
                boolean isShowCallInfoForContactsEnabled = this.getConfigController().isShowInPhoneBookSettingsOn();
                boolean isCurrentCallBlocked = CalldoradoApplication.Companion.isCurrentCallBlocked();
                boolean shouldShowACForContact = !Intrinsics.areEqual((Object)isContact, (Object)true) || isShowCallInfoForContactsEnabled;
                try {
                    if (this.getConfigController().shouldShowAc() && !isEmergencyCall && aftercallConfigControl != ConfigController.AftercallConfigControl.DISABLED && !isCurrentCallBlocked && shouldShowACForContact) {
                        DeveloperFeatureHandler.INSTANCE.showAftercall((Context)this, aftercallConfigControl == ConfigController.AftercallConfigControl.ONLY_EXPANDED ? "expanded_aftercall" : "light_aftercall");
                        break block7;
                    }
                    Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call_id", (Object)CalldoradoApplication.Companion.getLastCallId()), TuplesKt.to((Object)"reason", (Object)(this.getConfigController().shouldShowAcString() + "emergency call = " + isEmergencyCall + "; aftercall config should show = " + (aftercallConfigControl != ConfigController.AftercallConfigControl.DISABLED) + "; is call blocked = " + isCurrentCallBlocked + "; is contact and showContact is disabled = " + !shouldShowACForContact))};
                    CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "cdo_aftercall_not_shown", "CDO_STAT_V7_CALL", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
                }
                catch (Exception e) {
                    CLog.d(TAG, "callEnded.CoroutineScope.launch Exception " + e.getMessage());
                }
            }
            catch (Exception e) {
                CLog.d(TAG, "callEnded Exception " + e.getMessage());
            }
        }
    }

    private final void preloadAd() {
        try {
            AdController adController = this.getAdController();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            adController.loadAds(context, false, false);
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)String.valueOf(e.getMessage()))};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "error_caught", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
        }
    }

    public void onDestroy() {
        try {
            super.onDestroy();
            this.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
            this.finishService();
        }
        catch (Exception e) {
            CLog.d(TAG, "onDestroy Exception " + e.getMessage());
        }
    }

    @SuppressLint(value={"NewApi"})
    private final void finishService() {
        try {
            if (Build.VERSION.SDK_INT >= 24) {
                this.stopForeground(2);
            } else {
                this.stopForeground(true);
            }
            this.stopSelf();
            this.removeNotification();
        }
        catch (Exception e) {
            CLog.d(TAG, "finishService Exception " + e.getMessage());
        }
    }

    private final void handleEmergencyCallState() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CalldoradoForegroundService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay((long)1000L, (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        CalldoradoForegroundService.access$getWicController(this.this$0).hide();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.removeNotification();
        AdsAPI.INSTANCE.cancelWaterfalls();
    }

    private final void removeNotification() {
        try {
            Object object = this.getSystemService("notification");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.NotificationManager");
            NotificationManager nMgr = (NotificationManager)object;
            nMgr.cancel(56213);
        }
        catch (Exception e) {
            CLog.d(TAG, "removeNotification Exception " + e.getMessage());
        }
    }

    @RequiresApi(value=23)
    private final void updateNotification() {
        try {
            NotificationManager notificationManager = (NotificationManager)this.getApplicationContext().getSystemService(NotificationManager.class);
            if (notificationManager != null) {
                notificationManager.notify(56213, this.getNotification());
            }
        }
        catch (Exception e) {
            CLog.d(TAG, "updateNotification Exception " + e.getMessage());
        }
    }

    private final void resetMaxAdClickPerDatValuesIfNeeded() {
        Date time = new Date(System.currentTimeMillis());
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int todayDayNumber = cal.get(6);
        int savedLastCallDay = this.getMPreferencesManager().getValue("last_call_day_number", 0);
        if (todayDayNumber != savedLastCallDay) {
            this.getMPreferencesManager().saveValue("is_ad_click_limit_reached", false);
            this.getMPreferencesManager().saveValue("ad_clicks_made_today", 0);
            this.getMPreferencesManager().saveValue("last_call_day_number", todayDayNumber);
        }
    }

    private final Notification getNotification() {
        try {
            String string2;
            this.createNotificationChannel();
            NotificationCompat.Builder builder = new NotificationCompat.Builder((Context)this, CHANNEL_ID).setSmallIcon(17301599).setContentTitle((CharSequence)"Call started");
            Contact contact = (Contact)this.getRepositoryImpl().getLastcallerD().getValue();
            CharSequence charSequence = contact != null ? contact.getNumber() : null;
            if (charSequence == null || charSequence.length() == 0) {
                string2 = "ongoing";
            } else {
                Contact contact2 = (Contact)this.getRepositoryImpl().getLastcallerD().getValue();
                string2 = contact2 != null ? contact2.getNumber() : null;
            }
            Notification notification = builder.setContentText((CharSequence)string2).setUsesChronometer(true).setOnlyAlertOnce(true).setPriority(0).setVibrate(null).build();
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(this, CHANNEL_ID\u2026\n                .build()");
            return notification;
        }
        catch (Exception e) {
            CLog.d(TAG, "getNotification Exception " + e.getMessage());
            Notification notification = new NotificationCompat.Builder((Context)this, CHANNEL_ID).build();
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(this, CHANNEL_ID).build()");
            return notification;
        }
    }

    private final void createNotificationChannel() {
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                CharSequence name = "To get call information";
                String description = "Helps you control the functionality";
                int importance = 3;
                NotificationChannel channel = new NotificationChannel(CHANNEL_ID, name, importance);
                channel.setShowBadge(false);
                long[] lArray = new long[]{0L};
                channel.setVibrationPattern(lArray);
                channel.enableVibration(true);
                NotificationManager notificationManager = (NotificationManager)this.getSystemService(NotificationManager.class);
                notificationManager.createNotificationChannel(channel);
            }
        }
        catch (Exception e) {
            CLog.d(TAG, "createNotificationChannel Exception " + e.getMessage());
        }
    }

    private final HashMap<String, String> getParamMapForShowWic() {
        HashMap paramMap = new HashMap();
        try {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"call_id", (Object)CalldoradoApplication.Companion.getLastCallId())};
            paramMap = MapsKt.hashMapOf((Pair[])pairArray);
            boolean shouldShowWicContent = this.getConfigController().shouldShowWicContent();
            boolean shouldShowNativeField = this.getConfigController().shouldShowWicNativeField();
            if (shouldShowWicContent && shouldShowNativeField) {
                ((Map)paramMap).put("wic_shown_type", "all");
            } else if (!shouldShowWicContent && !shouldShowNativeField) {
                ((Map)paramMap).put("wic_shown_type", "pixel");
            } else if (shouldShowWicContent) {
                ((Map)paramMap).put("wic_shown_type", "content_only");
            } else if (shouldShowNativeField) {
                ((Map)paramMap).put("wic_shown_type", "native_field_only");
            }
        }
        catch (Exception e) {
            CLog.d(TAG, "getParamMapForShowWic Exception " + e.getMessage());
        }
        return paramMap;
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        try {
            super.onBind(intent);
            this.foregroundBind.onBind(this);
        }
        catch (Exception e) {
            CLog.d(TAG, "onBind Exception " + e.getMessage());
        }
        return (IBinder)this.foregroundBind;
    }

    public final boolean handleLifecycleEvent(@NotNull Lifecycle.Event event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        try {
            this.mLifecycleRegistry.handleLifecycleEvent(event);
            bl = true;
        }
        catch (Exception e) {
            CLog.d(TAG, "handleLifecycleEvent Exception " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    private final boolean performRestore(Bundle savedState) {
        boolean bl;
        try {
            this.mSavedStateRegistryController.performRestore(savedState);
            bl = true;
        }
        catch (Exception e) {
            CLog.d(TAG, "performRestore Exception " + e.getMessage());
            bl = false;
        }
        return bl;
    }

    @NotNull
    public SavedStateRegistry getSavedStateRegistry() {
        return this.mSavedStateRegistryController.getSavedStateRegistry();
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    private static final void listenToUpdates$lambda-0(CalldoradoForegroundService this$0, CallState it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        CallState callState = it;
        if (callState instanceof CallState.CallStarted) {
            this$0.callStarted(((CallState.CallStarted)it).getIncoming());
        } else if (callState instanceof CallState.CallEnded) {
            this$0.callEnded(((CallState.CallEnded)it).getCompleted());
        }
    }

    private static final void listenToUpdates$lambda-1(CalldoradoForegroundService this$0, Contact it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateNotification();
    }

    public static final /* synthetic */ WicController access$getWicController(CalldoradoForegroundService $this) {
        return $this.getWicController();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/calldorado/sdk/services/CalldoradoForegroundService$Companion;", "", "()V", "CHANNEL_ID", "", "NOTIFICATION_ID", "", "TAG", "sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

