/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.thirdparties;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.ActivityCompat;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.logging.CLog;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.thirdparties.ThirdParties;
import com.calldorado.sdk.thirdparties.Tutela;
import com.calldorado.sdk.thirdparties.Umlaut;
import com.calldorado.sdk.ui.ui.ConfigController;
import com.calldorado.sdk.util.FunctionsKt;
import com.qualityinfo.InsightCore;
import java.util.HashMap;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017`\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J$\u0010\u001b\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017`\u0018H\u0002J$\u0010\u001c\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017`\u0018H\u0002J$\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016j\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0017`\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\f\u0010!\u001a\u00020\u0017*\u00020\u001aH\u0002R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/calldorado/sdk/thirdparties/DAUReportWorker;", "Landroidx/work/Worker;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "appContext", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "configController", "Lcom/calldorado/sdk/ui/ui/ConfigController;", "getConfigController", "()Lcom/calldorado/sdk/ui/ui/ConfigController;", "configController$delegate", "Lkotlin/Lazy;", "preferences", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getPreferences", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "preferences$delegate", "doWork", "Landroidx/work/ListenableWorker$Result;", "getDauMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getIsACShownToday", "", "getPermissionParameters", "getSettingsParameters", "getVersionParameters", "resetIsAcShownToday", "", "restartUmlautIfNeeded", "getStringValue", "sdk_release"})
@StabilityInferred(parameters=0)
public final class DAUReportWorker
extends Worker
implements SdkCoinComponent {
    @NotNull
    private final Lazy preferences$delegate;
    @NotNull
    private final Lazy configController$delegate;
    public static final int $stable = 8;

    public DAUReportWorker(@NotNull Context appContext, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(appContext, workerParams);
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.preferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.configController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ConfigController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfigController invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    private final PreferencesManager getPreferences() {
        Lazy lazy = this.preferences$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    private final ConfigController getConfigController() {
        Lazy lazy = this.configController$delegate;
        return (ConfigController)lazy.getValue();
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        try {
            HashMap paramMap = new HashMap();
            HashMap<String, String> dauMap = this.getDauMap();
            HashMap<String, String> versionMap = this.getVersionParameters();
            HashMap<String, String> settingsMap = this.getSettingsParameters();
            HashMap<String, String> permissionMap = this.getPermissionParameters();
            boolean countAsActiveUser = this.getIsACShownToday();
            paramMap.putAll(dauMap);
            paramMap.putAll(versionMap);
            paramMap.putAll(settingsMap);
            paramMap.putAll(permissionMap);
            ((Map)paramMap).put("count_as_active_user", String.valueOf(countAsActiveUser));
            CLog.d("DAUReportWorker", "sendDAUEvents " + paramMap);
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "cdo_client_info", "CDO_STAT_V7_DATA", paramMap, 0.0, 8, null);
            CalldoradoApplication.Companion.sendFirebaseStatIfPossible("active_users_cdo", "active_users_reported_once_a_day");
            this.resetIsAcShownToday();
            this.restartUmlautIfNeeded();
            CalldoradoApplication.Companion.sendFirebaseEventCdoActiveTime();
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)("doWork.CoroutineScope.launch Exception " + e.getMessage()))};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "catched_error", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    private final void restartUmlautIfNeeded() {
        ThirdParties thirdParties;
        if (!InsightCore.isInitialized() && (thirdParties = new ThirdParties()).shouldRunThirdParty(ThirdParties.ThirdPartyType.UMLAUT)) {
            thirdParties.startUmlaut(CalldoradoApplication.Companion.getContext());
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "daily_init_data_partner_p3_failed", "CDO_STAT_V7_DATA", null, 0.0, 12, null);
        }
    }

    private final HashMap<String, String> getDauMap() {
        try {
            boolean dailyInitDataPartnerTu = false;
            boolean dauTuLocation = false;
            boolean dauTuConsent = false;
            boolean dailyInitDataPartnerP3 = false;
            boolean dauP3Location = false;
            boolean dauP3Consent = false;
            Tutela tutela = new Tutela();
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            if (tutela.isInitialized(context).booleanValue()) {
                dailyInitDataPartnerTu = true;
                dauTuConsent = true;
                Context context2 = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"applicationContext");
                dauTuLocation = FunctionsKt.hasPermission(context2, "android.permission.ACCESS_COARSE_LOCATION");
            }
            Umlaut umlaut = new Umlaut();
            Context context3 = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"applicationContext");
            if (umlaut.isInitialized(context3).booleanValue()) {
                dailyInitDataPartnerP3 = true;
                dauP3Consent = true;
                Context context4 = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context4, (String)"applicationContext");
                dauP3Location = FunctionsKt.hasPermission(context4, "android.permission.ACCESS_COARSE_LOCATION");
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"daily_init_data_partner_tu", (Object)String.valueOf(dailyInitDataPartnerTu)), TuplesKt.to((Object)"dau_tu_location", (Object)String.valueOf(dauTuLocation)), TuplesKt.to((Object)"dau_tu_consent", (Object)String.valueOf(dauTuConsent)), TuplesKt.to((Object)"tu_version", (Object)"11.1.21"), TuplesKt.to((Object)"daily_init_data_partner_p3", (Object)String.valueOf(dailyInitDataPartnerP3)), TuplesKt.to((Object)"dau_p3_location", (Object)String.valueOf(dauP3Location)), TuplesKt.to((Object)"dau_p3_consent", (Object)String.valueOf(dauP3Consent)), TuplesKt.to((Object)"p3_version", (Object)"20221115120445")};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        catch (Exception exception) {
            CLog.d(Tutela.Companion.getTAG(), "getDauMap Exception " + exception.getMessage());
            return new HashMap<String, String>();
        }
    }

    private final HashMap<String, String> getVersionParameters() {
        Object object;
        try {
            object = new Pair[]{TuplesKt.to((Object)"lib_versions", (Object)"dfp_version:21.3.0; fan_version:6.12.0; mopub_version:n/a; applovin_version:11.5.5; applovin_facebook_adapter_version:6.12.0.0; applovin_google_ad_manager_adapter_version:21.3.0.2; applovin_admob_adapter_version:21.3.0.2")};
            object = MapsKt.hashMapOf((Pair[])object);
        }
        catch (Exception e) {
            object = new HashMap();
        }
        return object;
    }

    private final HashMap<String, String> getSettingsParameters() {
        try {
            boolean isSettingsMissedCall = this.getConfigController().isMissedCallSettingsOn();
            boolean isSettingsCompleteCall = this.getConfigController().isCompletedCallSettingsOn();
            boolean isSettingsNoAnswerCall = this.getConfigController().isNoAnswerCallSettingsOn();
            boolean isSettingsUnknownCall = this.getConfigController().isUnknownCallerSettingsOn();
            String settingsStatusString = this.getStringValue(isSettingsMissedCall) + this.getStringValue(isSettingsCompleteCall) + this.getStringValue(isSettingsNoAnswerCall) + this.getStringValue(isSettingsUnknownCall);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"settings_status", (Object)settingsStatusString)};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)("getSettingsParameters Exception " + e.getMessage()))};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "catched_error", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            pairArray = new Pair[]{TuplesKt.to((Object)"settings_status", (Object)"")};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
    }

    private final HashMap<String, String> getPermissionParameters() {
        try {
            boolean isCallLogGranted = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.READ_CALL_LOG") == 0;
            boolean isReadPhoneStateGranted = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.READ_PHONE_STATE") == 0;
            boolean isFineLocationGranted = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
            boolean isCoarseLocationGranted = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") == 0;
            boolean isReadContactsGranted = ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.READ_CONTACTS") == 0;
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            boolean canDrawOverlay = FunctionsKt.hasOverlayPermission(context);
            String permissionsStatusString = this.getStringValue(isCallLogGranted) + this.getStringValue(isReadPhoneStateGranted) + this.getStringValue(isFineLocationGranted) + this.getStringValue(isCoarseLocationGranted) + this.getStringValue(isReadContactsGranted) + this.getStringValue(canDrawOverlay);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"permissions_status", (Object)permissionsStatusString)};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
        catch (Exception e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"message", (Object)("getPermissionParameters Exception " + e.getMessage()))};
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "catched_error", "CDO_STAT_V7_ERROR", MapsKt.hashMapOf((Pair[])pairArray), 0.0, 8, null);
            pairArray = new Pair[]{TuplesKt.to((Object)"permissions_status", (Object)"")};
            return MapsKt.hashMapOf((Pair[])pairArray);
        }
    }

    private final boolean getIsACShownToday() {
        return this.getPreferences().getValue("isACShownToday", false);
    }

    private final void resetIsAcShownToday() {
        this.getPreferences().saveValue("isACShownToday", false);
    }

    private final String getStringValue(boolean $this$getStringValue) {
        String string2;
        try {
            string2 = $this$getStringValue ? "1" : "0";
        }
        catch (Exception e) {
            string2 = "0";
        }
        return string2;
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }
}

