/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ui.ui;

import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.ui.repository.RepositoryImpl;
import com.calldorado.sdk.ui.ui.aftercall.ExpandedAftercallCardTypes;
import com.calldorado.sdk.util.FunctionsKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001:\u0003234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u001c0\u001bj\b\u0012\u0004\u0012\u00020\u001c`\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u0013J\b\u0010$\u001a\u00020\u0013H\u0002J\u0006\u0010%\u001a\u00020\u0013J\u0006\u0010&\u001a\u00020\u0013J\u0006\u0010'\u001a\u00020\u0013J\u0006\u0010(\u001a\u00020\u0013J\u0006\u0010)\u001a\u00020\u0013J\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020\u0013J\u0006\u0010,\u001a\u00020\u0013J\u0006\u0010-\u001a\u00020\"J\u0006\u0010.\u001a\u00020\u0013J\u0006\u0010/\u001a\u00020\"J\u0006\u00100\u001a\u00020\u0013J\u0006\u00101\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Lcom/calldorado/sdk/ui/ui/ConfigController;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "preferences", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getPreferences", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "preferences$delegate", "Lkotlin/Lazy;", "repositoryImpl", "Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "getRepositoryImpl", "()Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "repositoryImpl$delegate", "adProviderWaitForInit", "", "aftercallConfigControl", "Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallConfigControl;", "getAdClickBehaviour", "Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallAdClickBehaviour;", "getAftercallAdPlacement", "Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallAdPlacement;", "getAftercallCardsList", "Ljava/util/ArrayList;", "Lcom/calldorado/sdk/ui/ui/aftercall/ExpandedAftercallCardTypes;", "Lkotlin/collections/ArrayList;", "getIsUserPremium", "getMaxClickPerDay", "", "getShowWicRestrictionsStr", "", "isAdCacheAllowedFromDora", "isAllSettingsDisabled", "isCallerIDEnabled", "isCompletedCallSettingsOn", "isLocationSettingsOn", "isMissedCallSettingsOn", "isNoAnswerCallSettingsOn", "isShowInPhoneBookSettingsOn", "isUnknownCallerSettingsOn", "shouldPreLoadAd", "shouldPreLoadAdString", "shouldShowAc", "shouldShowAcString", "shouldShowWicContent", "shouldShowWicNativeField", "AftercallAdClickBehaviour", "AftercallAdPlacement", "AftercallConfigControl", "sdk_release"})
@StabilityInferred(parameters=0)
public final class ConfigController
implements SdkCoinComponent {
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy preferences$delegate;
    @NotNull
    private final Lazy repositoryImpl$delegate;
    public static final int $stable = 8;

    public ConfigController(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.preferences$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.repositoryImpl$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<RepositoryImpl>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RepositoryImpl invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RepositoryImpl.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RepositoryImpl.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final PreferencesManager getPreferences() {
        Lazy lazy = this.preferences$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    private final RepositoryImpl getRepositoryImpl() {
        Lazy lazy = this.repositoryImpl$delegate;
        return (RepositoryImpl)lazy.getValue();
    }

    @NotNull
    public final String getShowWicRestrictionsStr() {
        Object restrictions = "";
        boolean isShowWicEnabledFromConfigs = CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "show_wic", true);
        boolean isSettingsShowWic = this.getPreferences().getValue("pref_switch_real_time_call_info", true);
        if (Build.VERSION.SDK_INT >= 29 && !Settings.canDrawOverlays((Context)this.context)) {
            restrictions = (String)restrictions + "no_overlay,";
        }
        if (!isShowWicEnabledFromConfigs) {
            restrictions = (String)restrictions + "config_show_wic_disabled,";
        }
        if (!isSettingsShowWic) {
            restrictions = (String)restrictions + "settings_show_wic_disabled,";
        }
        if (!(this.isCompletedCallSettingsOn() || this.isMissedCallSettingsOn() || this.isUnknownCallerSettingsOn() || this.isNoAnswerCallSettingsOn())) {
            restrictions = (String)restrictions + "settings_all_disabled";
        }
        if (((CharSequence)restrictions).length() > 0 && Intrinsics.areEqual((Object)String.valueOf(StringsKt.last((CharSequence)((CharSequence)restrictions))), (Object)",")) {
            restrictions = StringsKt.dropLast((String)restrictions, (int)1);
        }
        return restrictions;
    }

    @NotNull
    public final AftercallConfigControl aftercallConfigControl() {
        switch (CalldoradoApplication.Companion.getDoraConfig("cdo_aftercall", "aftercall_control_value", 1)) {
            case 0: {
                return AftercallConfigControl.NORMAL;
            }
            case 1: {
                return AftercallConfigControl.ONLY_EXPANDED;
            }
            case 2: {
                return AftercallConfigControl.DISABLED;
            }
        }
        return AftercallConfigControl.ONLY_EXPANDED;
    }

    public final boolean adProviderWaitForInit() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "ad_provider_wait_for_init", false);
    }

    public final boolean shouldShowAc() {
        try {
            return ((CharSequence)RepositoryImpl.Companion.getLastCallDetails().getContact().getNumber()).length() == 0 && FunctionsKt.hasCallLog(this.context) ? this.isUnknownCallerSettingsOn() : (!FunctionsKt.hasCallLog(this.context) && !this.isUnknownCallerSettingsOn() ? false : (this.getRepositoryImpl().isCompletedCall() ? this.isCompletedCallSettingsOn() : (this.getRepositoryImpl().isIncoming() ? this.isMissedCallSettingsOn() : this.isNoAnswerCallSettingsOn())));
        }
        catch (Exception e) {
            return true;
        }
    }

    @NotNull
    public final String shouldShowAcString() {
        try {
            return ((CharSequence)RepositoryImpl.Companion.getLastCallDetails().getContact().getNumber()).length() == 0 && FunctionsKt.hasCallLog(this.context) ? (this.isCompletedCallSettingsOn() ? "settings_unknown_caller" : "") : (!FunctionsKt.hasCallLog(this.context) && !this.isUnknownCallerSettingsOn() ? "settings_unknown_caller_no_call_log" : (this.getRepositoryImpl().isCompletedCall() ? (this.isCompletedCallSettingsOn() ? "settings_completed_call" : "") : (this.getRepositoryImpl().isIncoming() ? (this.isMissedCallSettingsOn() ? "settings_incoming" : "") : (this.isNoAnswerCallSettingsOn() ? "settings_no_answer" : ""))));
        }
        catch (Exception e) {
            return "";
        }
    }

    public final boolean shouldPreLoadAd() {
        return !CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "noads", false) && CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "show_wic", true) && !this.getPreferences().getValue("is_ad_click_limit_reached", false) && !this.getIsUserPremium() && !this.isAllSettingsDisabled() && (FunctionsKt.hasOverlayPermission(this.context) || !FunctionsKt.needOverlay());
    }

    @NotNull
    public final String shouldPreLoadAdString() {
        if (CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "noads", false)) {
            return "noads_false in_config";
        }
        if (!CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "show_wic", true)) {
            return "show_wic_true_in_config";
        }
        if (this.getIsUserPremium()) {
            return "user_is_premium";
        }
        if (this.isAllSettingsDisabled()) {
            return "all_settings_disabled";
        }
        if (!FunctionsKt.hasOverlayPermission(this.context) && FunctionsKt.needOverlay()) {
            return "no_overlay";
        }
        return "";
    }

    public final boolean isUnknownCallerSettingsOn() {
        return this.getPreferences().getValue("pref_switch_unknown_caller", true);
    }

    public final boolean isCompletedCallSettingsOn() {
        return this.getPreferences().getValue("pref_switch_completed_call", true);
    }

    public final boolean isMissedCallSettingsOn() {
        return this.getPreferences().getValue("pref_switch_missed_call", true);
    }

    public final boolean isNoAnswerCallSettingsOn() {
        return this.getPreferences().getValue("pref_switch_no_answer", true);
    }

    public final boolean isShowInPhoneBookSettingsOn() {
        return this.getPreferences().getValue("pref_switch_show_in_phonebook", true);
    }

    public final boolean isLocationSettingsOn() {
        return this.getPreferences().getValue("pref_switch_location", true);
    }

    private final boolean isAllSettingsDisabled() {
        return !this.isUnknownCallerSettingsOn() && !this.isCompletedCallSettingsOn() && !this.isMissedCallSettingsOn() && !this.isNoAnswerCallSettingsOn();
    }

    public final boolean getIsUserPremium() {
        return this.getPreferences().getValue("isCdoUserPremium", false);
    }

    public final boolean shouldShowWicContent() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "show_content", true);
    }

    public final boolean shouldShowWicNativeField() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "show_native_field", true);
    }

    @NotNull
    public final ArrayList<ExpandedAftercallCardTypes> getAftercallCardsList() {
        ArrayList<ExpandedAftercallCardTypes> cardTypeList = new ArrayList<ExpandedAftercallCardTypes>();
        String[] stringArray = new String[]{","};
        List remoteCardList = StringsKt.split$default((CharSequence)CalldoradoApplication.Companion.getDoraConfig("cdo_aftercall", "card_list", "native_field,ad,quick_reply,weather_hourlyforecast,greetings,weather_current,reminder,summary,call_card,settings"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String cardString : remoteCardList) {
            ExpandedAftercallCardTypes type;
            block2: {
                ExpandedAftercallCardTypes expandedAftercallCardTypes;
                ExpandedAftercallCardTypes[] $this$firstOrNull$iv = ExpandedAftercallCardTypes.values();
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    ExpandedAftercallCardTypes element$iv;
                    ExpandedAftercallCardTypes it = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)cardString)) continue;
                    expandedAftercallCardTypes = element$iv;
                    break block2;
                }
                expandedAftercallCardTypes = type = null;
            }
            if (type == null) continue;
            boolean bl = false;
            cardTypeList.add(type);
        }
        return cardTypeList;
    }

    public final boolean isCallerIDEnabled() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_wic", "enable_callerid", false);
    }

    public final boolean isAdCacheAllowedFromDora() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "cache", true);
    }

    @NotNull
    public final AftercallAdPlacement getAftercallAdPlacement() {
        String string2 = CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "aftercall_ad_placement", "sticky");
        return Intrinsics.areEqual((Object)string2, (Object)"sticky") ? AftercallAdPlacement.STICKY : (Intrinsics.areEqual((Object)string2, (Object)"card") ? AftercallAdPlacement.IN_CARD : AftercallAdPlacement.STICKY);
    }

    @NotNull
    public final AftercallAdClickBehaviour getAdClickBehaviour() {
        AftercallAdClickBehaviour aftercallAdClickBehaviour;
        switch (CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "ad_click_behaviour", 0)) {
            case 0: {
                aftercallAdClickBehaviour = AftercallAdClickBehaviour.DEFAULT;
                break;
            }
            case 1: {
                aftercallAdClickBehaviour = AftercallAdClickBehaviour.PERMANENT_OVERLAY;
                break;
            }
            case 2: {
                aftercallAdClickBehaviour = AftercallAdClickBehaviour.PERMANENT_SPINNER;
                break;
            }
            case 3: {
                aftercallAdClickBehaviour = AftercallAdClickBehaviour.LOAD_NEW;
                break;
            }
            default: {
                aftercallAdClickBehaviour = AftercallAdClickBehaviour.DEFAULT;
            }
        }
        return aftercallAdClickBehaviour;
    }

    public final int getMaxClickPerDay() {
        return CalldoradoApplication.Companion.getDoraConfig("cdo_ads", "max_clicks_per_24h", 0);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallConfigControl;", "", "(Ljava/lang/String;I)V", "NORMAL", "DISABLED", "ONLY_EXPANDED", "sdk_release"})
    public static final class AftercallConfigControl
    extends Enum<AftercallConfigControl> {
        public static final /* enum */ AftercallConfigControl NORMAL = new AftercallConfigControl();
        public static final /* enum */ AftercallConfigControl DISABLED = new AftercallConfigControl();
        public static final /* enum */ AftercallConfigControl ONLY_EXPANDED = new AftercallConfigControl();
        private static final /* synthetic */ AftercallConfigControl[] $VALUES;

        public static AftercallConfigControl[] values() {
            return (AftercallConfigControl[])$VALUES.clone();
        }

        public static AftercallConfigControl valueOf(String value) {
            return Enum.valueOf(AftercallConfigControl.class, value);
        }

        static {
            $VALUES = aftercallConfigControlArray = new AftercallConfigControl[]{AftercallConfigControl.NORMAL, AftercallConfigControl.DISABLED, AftercallConfigControl.ONLY_EXPANDED};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallAdPlacement;", "", "(Ljava/lang/String;I)V", "STICKY", "IN_CARD", "sdk_release"})
    public static final class AftercallAdPlacement
    extends Enum<AftercallAdPlacement> {
        public static final /* enum */ AftercallAdPlacement STICKY = new AftercallAdPlacement();
        public static final /* enum */ AftercallAdPlacement IN_CARD = new AftercallAdPlacement();
        private static final /* synthetic */ AftercallAdPlacement[] $VALUES;

        public static AftercallAdPlacement[] values() {
            return (AftercallAdPlacement[])$VALUES.clone();
        }

        public static AftercallAdPlacement valueOf(String value) {
            return Enum.valueOf(AftercallAdPlacement.class, value);
        }

        static {
            $VALUES = aftercallAdPlacementArray = new AftercallAdPlacement[]{AftercallAdPlacement.STICKY, AftercallAdPlacement.IN_CARD};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/calldorado/sdk/ui/ui/ConfigController$AftercallAdClickBehaviour;", "", "(Ljava/lang/String;I)V", "DEFAULT", "PERMANENT_OVERLAY", "PERMANENT_SPINNER", "LOAD_NEW", "sdk_release"})
    public static final class AftercallAdClickBehaviour
    extends Enum<AftercallAdClickBehaviour> {
        public static final /* enum */ AftercallAdClickBehaviour DEFAULT = new AftercallAdClickBehaviour();
        public static final /* enum */ AftercallAdClickBehaviour PERMANENT_OVERLAY = new AftercallAdClickBehaviour();
        public static final /* enum */ AftercallAdClickBehaviour PERMANENT_SPINNER = new AftercallAdClickBehaviour();
        public static final /* enum */ AftercallAdClickBehaviour LOAD_NEW = new AftercallAdClickBehaviour();
        private static final /* synthetic */ AftercallAdClickBehaviour[] $VALUES;

        public static AftercallAdClickBehaviour[] values() {
            return (AftercallAdClickBehaviour[])$VALUES.clone();
        }

        public static AftercallAdClickBehaviour valueOf(String value) {
            return Enum.valueOf(AftercallAdClickBehaviour.class, value);
        }

        static {
            $VALUES = aftercallAdClickBehaviourArray = new AftercallAdClickBehaviour[]{AftercallAdClickBehaviour.DEFAULT, AftercallAdClickBehaviour.PERMANENT_OVERLAY, AftercallAdClickBehaviour.PERMANENT_SPINNER, AftercallAdClickBehaviour.LOAD_NEW};
        }
    }
}

