/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ui.ui.aftercall;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.ContactsContract;
import android.util.Log;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.CoroutineLiveDataKt;
import androidx.lifecycle.FlowLiveDataConversions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.LiveDataScope;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.calldorado.base.logging.CLog;
import com.calldorado.sdk.CalldoradoApplication;
import com.calldorado.sdk.R;
import com.calldorado.sdk.adevents.AdEvents;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.localDB.model.Contact;
import com.calldorado.sdk.localDB.model.IncompleteCallHistoryModel;
import com.calldorado.sdk.localDB.model.LastCallModel;
import com.calldorado.sdk.preferences.PreferencesManager;
import com.calldorado.sdk.ui.repository.CallState;
import com.calldorado.sdk.ui.repository.RepositoryImpl;
import com.calldorado.sdk.ui.ui.ConfigController;
import com.calldorado.sdk.ui.ui.aftercall.ActivityState;
import com.calldorado.sdk.ui.ui.aftercall.AftercallActionButtonType;
import com.calldorado.sdk.ui.ui.aftercall.cards.native_field.NativeViewType;
import com.calldorado.sdk.ui.ui.wic.WicCardConstants;
import com.calldorado.sdk.util.FunctionsKt;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u00072\u0006\u0010A\u001a\u00020\u0007J\u0006\u0010B\u001a\u00020\u0007J\u0006\u0010C\u001a\u00020\u0013J\u0006\u0010D\u001a\u00020\u0013J\u0016\u0010E\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?2\u0006\u0010F\u001a\u00020\u0007J\u000e\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020)J\u0016\u0010I\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u0010H\u001a\u00020)J\u001e\u0010J\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020-J\u0016\u0010M\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u0010H\u001a\u00020)J\u0016\u0010N\u001a\u00020O2\u0006\u0010>\u001a\u00020?2\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u00020S2\u0006\u0010P\u001a\u00020QJ\u0012\u0010T\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0U0(J\u001e\u0010V\u001a\u00020O2\u0006\u0010W\u001a\u00020-2\u0006\u0010K\u001a\u00020-2\u0006\u0010L\u001a\u00020-J\u000e\u0010X\u001a\u00020\u00072\u0006\u0010Y\u001a\u00020\u001dJ\u0014\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u000e0(2\u0006\u0010[\u001a\u00020\\J\u001e\u0010]\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u0010H\u001a\u00020)2\u0006\u0010^\u001a\u00020-J\u0006\u0010_\u001a\u00020OJ\u0016\u0010`\u001a\u00020\u00072\u0006\u0010>\u001a\u00020?2\u0006\u0010H\u001a\u00020)J\u0006\u0010a\u001a\u00020\u0013J\u0006\u0010b\u001a\u00020-J\u0006\u0010K\u001a\u00020-J\u0006\u0010c\u001a\u00020-J\b\u0010d\u001a\u00020\u0013H\u0014J\u000e\u0010e\u001a\u00020\u00132\u0006\u0010>\u001a\u00020?J\u0006\u0010f\u001a\u00020\u0013J\u0006\u0010g\u001a\u00020\u0013J\u000e\u0010h\u001a\u00020\u00132\u0006\u0010i\u001a\u00020-J\u0006\u0010j\u001a\u00020\u0013J\u0006\u0010k\u001a\u00020\u0013R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001b\u0010\"\u001a\u00020#8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u001b\u001a\u0004\b$\u0010%R\u0019\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010.\"\u0004\b2\u00100R\u001b\u00103\u001a\u0002048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b7\u0010\u001b\u001a\u0004\b5\u00106R\u0019\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090(\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010+R\u0019\u0010;\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001090(\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010+R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006l"}, d2={"Lcom/calldorado/sdk/ui/ui/aftercall/CDOViewModel;", "Landroidx/lifecycle/ViewModel;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "repositoryImpl", "Lcom/calldorado/sdk/ui/repository/RepositoryImpl;", "(Lcom/calldorado/sdk/ui/repository/RepositoryImpl;)V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "activityState", "Landroidx/lifecycle/MutableLiveData;", "Lcom/calldorado/sdk/ui/ui/aftercall/ActivityState;", "", "getActivityState", "()Landroidx/lifecycle/MutableLiveData;", "adDisplayListener", "Lkotlin/Function0;", "", "getAdDisplayListener", "()Lkotlin/jvm/functions/Function0;", "adEventsHandler", "Lcom/calldorado/sdk/adevents/AdEvents;", "getAdEventsHandler", "()Lcom/calldorado/sdk/adevents/AdEvents;", "adEventsHandler$delegate", "Lkotlin/Lazy;", "aftercallAdClickTimeStamp", "", "getAftercallAdClickTimeStamp", "()J", "setAftercallAdClickTimeStamp", "(J)V", "configController", "Lcom/calldorado/sdk/ui/ui/ConfigController;", "getConfigController", "()Lcom/calldorado/sdk/ui/ui/ConfigController;", "configController$delegate", "currentCallDetails", "Landroidx/lifecycle/LiveData;", "Lcom/calldorado/sdk/localDB/model/LastCallModel;", "getCurrentCallDetails", "()Landroidx/lifecycle/LiveData;", "isACAdClicked", "", "()Z", "setACAdClicked", "(Z)V", "isAdViewed", "setAdViewed", "mPreferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getMPreferencesManager", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "mPreferencesManager$delegate", "missedCallData", "Lcom/calldorado/sdk/localDB/model/IncompleteCallHistoryModel;", "getMissedCallData", "noAnswerData", "getNoAnswerData", "addContact", "context", "Landroid/content/Context;", "number", "name", "callNumber", "checkAndReportAccidentalClicks", "doSearchOnLastCalledNumber", "editContact", "uri", "getACBottomLeftText", "call", "getACBottomRightText", "getACCallStatusText", "isIncoming", "isCompletedCall", "getACMainText", "getActionIcon", "", "contact", "Lcom/calldorado/sdk/localDB/model/Contact;", "getAftercallActionButtonType", "Lcom/calldorado/sdk/ui/ui/aftercall/AftercallActionButtonType;", "getCallStateLiveData", "Lcom/calldorado/sdk/ui/repository/CallState;", "getCallTypeIcon", "isSpam", "getFormattedTime", "time", "getNativeCardLiveData", "type", "Lcom/calldorado/sdk/ui/ui/aftercall/cards/native_field/NativeViewType;", "getWicMainText", "isExpandedWic", "getWicSize", "getWicSubText", "increaseShowCounter", "isFirstFirebaseAftercallStatSent", "isResumeFromAdClicked", "onCleared", "openPhoneBook", "saveAdClick", "sendFirebaseEventCdoActiveTime", "setACShownToday", "isACShownToday", "setFirstFirebaseAftercallStatSent", "unregisterCallLogListener", "sdk_release"})
@StabilityInferred(parameters=0)
public final class CDOViewModel
extends ViewModel
implements SdkCoinComponent {
    @NotNull
    private final RepositoryImpl repositoryImpl;
    private final String TAG;
    @NotNull
    private final Lazy configController$delegate;
    @NotNull
    private final Lazy adEventsHandler$delegate;
    private boolean isACAdClicked;
    private boolean isAdViewed;
    private long aftercallAdClickTimeStamp;
    @NotNull
    private final Lazy mPreferencesManager$delegate;
    @NotNull
    private final MutableLiveData<ActivityState<Object>> activityState;
    @NotNull
    private final LiveData<LastCallModel> currentCallDetails;
    @NotNull
    private final LiveData<IncompleteCallHistoryModel> noAnswerData;
    @NotNull
    private final LiveData<IncompleteCallHistoryModel> missedCallData;
    @NotNull
    private final Function0<Unit> adDisplayListener;
    public static final int $stable = 8;

    public CDOViewModel(@NotNull RepositoryImpl repositoryImpl) {
        Intrinsics.checkNotNullParameter((Object)repositoryImpl, (String)"repositoryImpl");
        this.repositoryImpl = repositoryImpl;
        this.TAG = CDOViewModel.class.getSimpleName();
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.configController$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ConfigController>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfigController invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ConfigController.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.adEventsHandler$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<AdEvents>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AdEvents invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(AdEvents.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(AdEvents.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.mPreferencesManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.activityState = new MutableLiveData();
        this.currentCallDetails = this.repositoryImpl.getLastCall();
        this.noAnswerData = this.repositoryImpl.getNoAnswerData();
        this.missedCallData = this.repositoryImpl.getMissedCallData();
        this.adDisplayListener = (Function0)new Function0<Unit>(this){
            final /* synthetic */ CDOViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                CDOViewModel.access$getAdEventsHandler(this.this$0).increaseShowCounter();
            }
        };
    }

    public final String getTAG() {
        return this.TAG;
    }

    private final ConfigController getConfigController() {
        Lazy lazy = this.configController$delegate;
        return (ConfigController)lazy.getValue();
    }

    private final AdEvents getAdEventsHandler() {
        Lazy lazy = this.adEventsHandler$delegate;
        return (AdEvents)lazy.getValue();
    }

    public final boolean isACAdClicked() {
        return this.isACAdClicked;
    }

    public final void setACAdClicked(boolean bl) {
        this.isACAdClicked = bl;
    }

    public final boolean isAdViewed() {
        return this.isAdViewed;
    }

    public final void setAdViewed(boolean bl) {
        this.isAdViewed = bl;
    }

    public final long getAftercallAdClickTimeStamp() {
        return this.aftercallAdClickTimeStamp;
    }

    public final void setAftercallAdClickTimeStamp(long l) {
        this.aftercallAdClickTimeStamp = l;
    }

    private final PreferencesManager getMPreferencesManager() {
        Lazy lazy = this.mPreferencesManager$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    @NotNull
    public final MutableLiveData<ActivityState<Object>> getActivityState() {
        return this.activityState;
    }

    @NotNull
    public final LiveData<LastCallModel> getCurrentCallDetails() {
        return this.currentCallDetails;
    }

    @NotNull
    public final LiveData<IncompleteCallHistoryModel> getNoAnswerData() {
        return this.noAnswerData;
    }

    @NotNull
    public final LiveData<IncompleteCallHistoryModel> getMissedCallData() {
        return this.missedCallData;
    }

    @NotNull
    public final Function0<Unit> getAdDisplayListener() {
        return this.adDisplayListener;
    }

    @NotNull
    public final LiveData<CallState<Object>> getCallStateLiveData() {
        return this.repositoryImpl.getCallState();
    }

    public final void increaseShowCounter() {
        try {
            try {
                int adShownCount = this.getMPreferencesManager().getValue("ad_shown_counter", 0);
                switch (++adShownCount) {
                    case 50: {
                        CalldoradoApplication.Companion.sendFirebaseStatIfPossible("aftercall_ad_shown_50th", "ad shown # times for user");
                        break;
                    }
                    case 100: {
                        CalldoradoApplication.Companion.sendFirebaseStatIfPossible("aftercall_ad_shown_100th", "ad shown # times for user");
                    }
                }
                this.getMPreferencesManager().saveValue("ad_shown_counter", adShownCount);
            }
            catch (Exception e) {
                CLog.d((String)"AdProfilesRepository", (String)("increaseShowCounter.CoroutineScope.launch Exception " + e.getMessage()));
            }
        }
        catch (Exception e) {
            CLog.d((String)"AdProfilesRepository", (String)("increaseShowCounter Exception " + e.getMessage()));
        }
    }

    @NotNull
    public final LiveData<Object> getNativeCardLiveData(@NotNull NativeViewType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return CoroutineLiveDataKt.liveData$default((CoroutineContext)ViewModelKt.getViewModelScope((ViewModel)this).getCoroutineContext().plus((CoroutineContext)Dispatchers.getIO()), (long)0L, (Function2)((Function2)new Function2<LiveDataScope<Object>, Continuation<? super Unit>, Object>(this, type, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ CDOViewModel this$0;
            final /* synthetic */ NativeViewType $type;
            {
                this.this$0 = $receiver;
                this.$type = $type;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LiveDataScope $this$liveData = (LiveDataScope)this.L$0;
                        this.label = 1;
                        Object object3 = $this$liveData.emitSource(FlowLiveDataConversions.asLiveData$default(CDOViewModel.access$getRepositoryImpl$p(this.this$0).getNativeView(this.$type), null, (long)0L, (int)3, null), (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull LiveDataScope<Object> p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final String callNumber() {
        return RepositoryImpl.Companion.getLastCallDetails().getContact().getNumber();
    }

    public final boolean isIncoming() {
        return this.repositoryImpl.isIncoming();
    }

    public final void unregisterCallLogListener() {
        this.repositoryImpl.unregisterCallLogListener();
    }

    public final void doSearchOnLastCalledNumber() {
        this.repositoryImpl.doSearchOnLastCalledNumber();
    }

    protected void onCleared() {
        super.onCleared();
        this.repositoryImpl.reset();
        this.repositoryImpl.onCleared();
    }

    public final int getWicSize() {
        int size = 0;
        if (this.getConfigController().shouldShowWicContent()) {
            size += (int)WicCardConstants.INSTANCE.getSIZE_OF_CONTENT_FIELD-D9Ej5fM();
        }
        if (this.getConfigController().shouldShowWicNativeField()) {
            size += (int)WicCardConstants.INSTANCE.getSIZE_OF_CONTENT_FIELD-D9Ej5fM();
        }
        return size;
    }

    @NotNull
    public final String getWicMainText(@NotNull Context context, @NotNull LastCallModel call, boolean isExpandedWic) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (call.isSearching()) {
            String string2;
            if (((CharSequence)call.getContact().getNumber()).length() > 0) {
                string2 = call.getContact().getNumber();
            } else {
                String string3 = context.getString(R.string.searching);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(\n     \u2026arching\n                )");
            }
            return string2;
        }
        if (call.getContact().isSpam()) {
            String string4 = context.getString(R.string.spam_call_detected);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"context.getString(R.string.spam_call_detected)");
            return string4;
        }
        if (((CharSequence)call.getContact().getNumber()).length() == 0 && ((CharSequence)call.getContact().getName()).length() == 0) {
            String string5;
            if (isExpandedWic) {
                string5 = "";
            } else if (call.isIncoming()) {
                String string6 = context.getString(R.string.incoming);
                string5 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"{\n                      \u2026ng)\n                    }");
            } else {
                String string7 = context.getString(R.string.outgoing);
                string5 = string7;
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"{\n                      \u2026ng)\n                    }");
            }
            return string5;
        }
        if (((CharSequence)call.getContact().getName()).length() == 0) {
            CharSequence charSequence;
            CharSequence charSequence2 = call.getContact().getFormattedNumber();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = call.getContact().getNumber();
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }
        return call.getContact().getName();
    }

    @NotNull
    public final String getWicSubText(@NotNull Context context, @NotNull LastCallModel call) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (((CharSequence)call.getContact().getNumber()).length() == 0) {
            return context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
        }
        if (((CharSequence)call.getContact().getName()).length() > 0 || call.getContact().isSpam()) {
            return call.isRinging() ? call.getContact().getNumber() : context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
        }
        if (call.isSearching() || ((CharSequence)call.getContact().getName()).length() == 0) {
            Object object;
            if (call.isRinging()) {
                String string2 = call.isIncoming() ? context.getString(R.string.incoming) : context.getString(R.string.outgoing);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                    if\u2026      )\n                }");
            } else {
                object = context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
            }
            return object;
        }
        return context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
    }

    @NotNull
    public final String getACMainText(@NotNull Context context, @NotNull LastCallModel call) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (StringsKt.isBlank((CharSequence)call.getContact().getNumber())) {
            String string2;
            if (call.isCompletedCall()) {
                String string3 = call.isIncoming() ? context.getString(R.string.incoming) : context.getString(R.string.outgoing);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                    if\u2026      )\n                }");
            } else {
                String string4 = call.isIncoming() ? context.getString(R.string.missed) : context.getString(R.string.no_answer);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n                    if\u2026answer)\n                }");
            }
            return string2;
        }
        if (call.isSearching()) {
            CharSequence charSequence;
            CharSequence charSequence2 = call.getContact().getNumber();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                String string5 = context.getString(R.string.searching);
                charSequence = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"context.getString(\n     \u2026ing\n                    )");
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }
        if (call.getContact().isSpam()) {
            String string6 = context.getString(R.string.spam_call_detected);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"context.getString(R.string.spam_call_detected)");
            return string6;
        }
        if (((CharSequence)call.getContact().getName()).length() > 0) {
            return call.getContact().getName();
        }
        if (StringsKt.isBlank((CharSequence)call.getContact().getName())) {
            String string7;
            if (call.isCompletedCall()) {
                CharSequence charSequence;
                CharSequence charSequence3 = call.getContact().getFormattedNumber();
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    boolean bl = false;
                    charSequence = call.getContact().getNumber();
                } else {
                    charSequence = charSequence3;
                }
                string7 = (String)charSequence;
            } else {
                String string8 = call.isIncoming() ? context.getString(R.string.missed) : context.getString(R.string.no_answer);
                string7 = string8;
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"{\n                    if\u2026answer)\n                }");
            }
            return string7;
        }
        return "Private number";
    }

    @NotNull
    public final String getACBottomLeftText(@NotNull LastCallModel call) {
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        return call.getContact().isSpam() ? call.getContact().getNumber() : this.getFormattedTime(call.getCallStarted());
    }

    @NotNull
    public final String getACBottomRightText(@NotNull Context context, @NotNull LastCallModel call) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        if (StringsKt.isBlank((CharSequence)call.getContact().getNumber())) {
            object = context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
        } else if (call.getContact().isSpam()) {
            if (call.isCompletedCall()) {
                object = context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
            } else {
                String string2 = call.isIncoming() ? context.getString(R.string.missed) : context.getString(R.string.no_answer);
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                    if\u2026answer)\n                }");
            }
        } else if (call.isCompletedCall()) {
            object = context.getString(R.string.duration) + ": " + FunctionsKt.formatSeconds(call.getDuration());
        } else if (!call.isCompletedCall()) {
            String string3;
            if (!StringsKt.isBlank((CharSequence)call.getContact().getUri())) {
                string3 = call.isIncoming() ? context.getString(R.string.missed) : context.getString(R.string.no_answer);
            } else {
                CharSequence charSequence;
                CharSequence charSequence2 = call.getContact().getFormattedNumber();
                if (StringsKt.isBlank((CharSequence)charSequence2)) {
                    boolean bl = false;
                    charSequence = call.getContact().getNumber();
                } else {
                    charSequence = charSequence2;
                }
                string3 = (String)charSequence;
            }
            object = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n                if (ca\u2026          }\n            }");
        } else {
            object = "Private number";
        }
        return object;
    }

    @NotNull
    public final String getACCallStatusText(@NotNull Context context, boolean isIncoming, boolean isCompletedCall) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (isCompletedCall) {
            String string3 = isIncoming ? context.getString(R.string.incoming) : context.getString(R.string.outgoing);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"{\n            if (isInco\u2026tring.outgoing)\n        }");
        } else {
            String string4 = isIncoming ? context.getString(R.string.missed) : context.getString(R.string.no_answer);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"{\n            if (isInco\u2026ring.no_answer)\n        }");
        }
        return string2;
    }

    public final int getCallTypeIcon(boolean isSpam, boolean isIncoming, boolean isCompletedCall) {
        return isSpam ? R.drawable.cdo_ic_call_spam_detected : (isCompletedCall ? (isIncoming ? R.drawable.cdo_ic_call_incoming_completed : R.drawable.cdo_ic_call_outgoing_completed) : (isIncoming ? R.drawable.cdo_ic_call_incoming_missed : R.drawable.cdo_ic_call_outgoing_unanswered));
    }

    public final int getActionIcon(@NotNull Context context, @NotNull Contact contact) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
        return !StringsKt.isBlank((CharSequence)contact.getUri()) ? R.drawable.cdo_ic_btn_contact_edit : (!StringsKt.isBlank((CharSequence)contact.getNumber()) ? R.drawable.cdo_ic_btn_contact_add : (FunctionsKt.hasCallLog(context) ? 0 : R.drawable.cdo_ic_btn_contact_address_book));
    }

    @NotNull
    public final AftercallActionButtonType getAftercallActionButtonType(@NotNull Contact contact) {
        Intrinsics.checkNotNullParameter((Object)contact, (String)"contact");
        return !StringsKt.isBlank((CharSequence)contact.getUri()) ? AftercallActionButtonType.EDIT_CONTACT : (!StringsKt.isBlank((CharSequence)contact.getNumber()) ? AftercallActionButtonType.ADD_CONTACT : AftercallActionButtonType.OPEN_PHONEBOOK);
    }

    public final void addContact(@NotNull Context context, @NotNull String number, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(number, name, context, null){
            int label;
            final /* synthetic */ String $number;
            final /* synthetic */ String $name;
            final /* synthetic */ Context $context;
            {
                this.$number = $number;
                this.$name = $name;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Intent intent = new Intent("android.intent.action.INSERT");
                        String string2 = this.$number;
                        String string3 = this.$name;
                        Intent $this$invokeSuspend_u24lambda_u2d0 = intent;
                        boolean bl = false;
                        $this$invokeSuspend_u24lambda_u2d0.setType("vnd.android.cursor.dir/raw_contact");
                        $this$invokeSuspend_u24lambda_u2d0.putExtra("phone", string2);
                        $this$invokeSuspend_u24lambda_u2d0.putExtra("name", string3);
                        Intent intent2 = intent;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$context, intent2, null){
                            int label;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ Intent $intent;
                            {
                                this.$context = $context;
                                this.$intent = $intent;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$context.startActivity(this.$intent);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void openPhoneBook(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(context, null){
            int label;
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Intent intent = new Intent("android.intent.action.VIEW", ContactsContract.Contacts.CONTENT_URI);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$context, intent, null){
                            int label;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ Intent $intent;
                            {
                                this.$context = $context;
                                this.$intent = $intent;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$context.startActivity(this.$intent);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void editContact(@NotNull Context context, @NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(uri, context, null){
            int label;
            final /* synthetic */ String $uri;
            final /* synthetic */ Context $context;
            {
                this.$uri = $uri;
                this.$context = $context;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Intent intent = new Intent("android.intent.action.EDIT");
                        String string2 = this.$uri;
                        Intent $this$invokeSuspend_u24lambda_u2d0 = intent;
                        boolean bl = false;
                        $this$invokeSuspend_u24lambda_u2d0.setType("vnd.android.cursor.item/contact");
                        $this$invokeSuspend_u24lambda_u2d0.setData(Uri.parse((String)string2));
                        Intent intent2 = intent;
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$context, intent2, null){
                            int label;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ Intent $intent;
                            {
                                this.$context = $context;
                                this.$intent = $intent;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$context.startActivity(this.$intent);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final String getFormattedTime(long time) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(time);
        SimpleDateFormat format = new SimpleDateFormat("HH:mm", Locale.getDefault());
        String string2 = format.format(date.getTime());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format.format(date.time)");
        return string2;
    }

    public final void sendFirebaseEventCdoActiveTime() {
        this.repositoryImpl.sendFirebaseEventCdoActiveTime();
    }

    public final boolean isFirstFirebaseAftercallStatSent() {
        return this.repositoryImpl.isFirstFirebaseAftercallStatSent();
    }

    public final void setFirstFirebaseAftercallStatSent() {
        this.repositoryImpl.setFirstFirebaseAftercallStatSent();
    }

    public final void setACShownToday(boolean isACShownToday) {
        this.repositoryImpl.setACShownToday(isACShownToday);
    }

    public final boolean isResumeFromAdClicked() {
        boolean bl;
        if (this.isACAdClicked) {
            this.isACAdClicked = false;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void checkAndReportAccidentalClicks() {
        long timeElapsed = System.currentTimeMillis() - this.aftercallAdClickTimeStamp;
        if (timeElapsed < 1000L) {
            Log.d((String)this.TAG, (String)"accidental click bellow 1000ms");
            CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "aftercall_click_ad_accidental_1000", "CDO_STAT_V7_AD", null, 0.0, 12, null);
        } else {
            boolean bl = 1001L <= timeElapsed ? timeElapsed < 2000L : false;
            if (bl) {
                Log.d((String)this.TAG, (String)"accidental click above 1000ms and bellow 2000ms");
                CalldoradoApplication.Companion.sendStat$default(CalldoradoApplication.Companion, "aftercall_click_ad_accidental_2000", "CDO_STAT_V7_AD", null, 0.0, 12, null);
            } else {
                Log.d((String)this.TAG, (String)"non accidental click");
            }
        }
    }

    public final void saveAdClick() {
        int maxAdClicksPerDay = this.getConfigController().getMaxClickPerDay();
        if (maxAdClicksPerDay > 0) {
            int adClicksMadeToday = this.getMPreferencesManager().getValue("ad_clicks_made_today", 0);
            this.getMPreferencesManager().saveValue("ad_clicks_made_today", ++adClicksMadeToday);
            if (adClicksMadeToday >= maxAdClicksPerDay) {
                this.getMPreferencesManager().saveValue("is_ad_click_limit_reached", true);
            }
        }
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    public static final /* synthetic */ RepositoryImpl access$getRepositoryImpl$p(CDOViewModel $this) {
        return $this.repositoryImpl;
    }

    public static final /* synthetic */ AdEvents access$getAdEventsHandler(CDOViewModel $this) {
        return $this.getAdEventsHandler();
    }
}

