/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ui.ui.aftercall.cards.reminder;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.localDB.dao.RemindersDao;
import com.calldorado.sdk.localDB.model.RemindersModel;
import com.calldorado.sdk.ui.ui.aftercall.cards.reminder.ReminderBroadcastReceiver;
import com.calldorado.sdk.ui.util.Resource;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0016\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0014J\u0006\u0010\u001c\u001a\u00020\u0014J\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/calldorado/sdk/ui/ui/aftercall/cards/reminder/ReminderRepository;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "reminderDao", "Lcom/calldorado/sdk/localDB/dao/RemindersDao;", "getReminderDao", "()Lcom/calldorado/sdk/localDB/dao/RemindersDao;", "reminderDao$delegate", "Lkotlin/Lazy;", "reminderData", "Landroidx/compose/runtime/MutableState;", "Lcom/calldorado/sdk/ui/util/Resource;", "Lcom/calldorado/sdk/localDB/model/RemindersModel;", "getReminderData", "()Landroidx/compose/runtime/MutableState;", "cancelReminder", "", "reminder", "insertReminder", "time", "", "text", "", "loadReminder", "removeReminder", "scheduleReminder", "sdk_release"})
@StabilityInferred(parameters=0)
public final class ReminderRepository
implements SdkCoinComponent {
    @NotNull
    private final Context context;
    @NotNull
    private final Lazy reminderDao$delegate;
    @NotNull
    private final MutableState<Resource<RemindersModel>> reminderData;
    public static final int $stable = 8;

    public ReminderRepository(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.reminderDao$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<RemindersDao>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final RemindersDao invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(RemindersDao.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(RemindersDao.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.reminderData = SnapshotStateKt.mutableStateOf$default(new Resource.Loading(null, 1, null), null, (int)2, null);
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    private final RemindersDao getReminderDao() {
        Lazy lazy = this.reminderDao$delegate;
        return (RemindersDao)lazy.getValue();
    }

    @NotNull
    public final MutableState<Resource<RemindersModel>> getReminderData() {
        return this.reminderData;
    }

    public final void loadReminder() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ReminderRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ReminderRepository.access$getReminderDao(this.this$0).deleteExpiredReminders(System.currentTimeMillis());
                        RemindersModel reminder = ReminderRepository.access$getReminderDao(this.this$0).getReminder();
                        this.this$0.getReminderData().setValue((Object)(reminder != null ? (Resource)new Resource.Success<RemindersModel>(reminder) : (Resource)Resource.NoValue.INSTANCE));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void removeReminder() {
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ReminderRepository this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        RemindersModel reminder = ReminderRepository.access$getReminderDao(this.this$0).getReminder();
                        ReminderRepository.access$cancelReminder(this.this$0, reminder);
                        ReminderRepository.access$getReminderDao(this.this$0).deleteReminders();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void insertReminder(long time, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, time, text, null){
            int label;
            final /* synthetic */ ReminderRepository this$0;
            final /* synthetic */ long $time;
            final /* synthetic */ String $text;
            {
                this.this$0 = $receiver;
                this.$time = $time;
                this.$text = $text;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ReminderRepository.access$getReminderDao(this.this$0).deleteReminders();
                        RemindersModel reminder = new RemindersModel(this.$time, this.$text);
                        ReminderRepository.access$getReminderDao(this.this$0).insert(reminder);
                        ReminderRepository.access$scheduleReminder(this.this$0, ReminderRepository.access$getReminderDao(this.this$0).getReminder());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleReminder(RemindersModel reminder) {
        AlarmManager alarmManager;
        Object object = this.context.getSystemService("alarm");
        AlarmManager alarmManager2 = alarmManager = object instanceof AlarmManager ? (AlarmManager)object : null;
        if (alarmManager == null || reminder == null) {
            return;
        }
        Intent alertIntent = new Intent(this.context, ReminderBroadcastReceiver.class);
        alertIntent.putExtra("reminder_content", reminder.getText());
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)reminder.getId(), (Intent)alertIntent, (int)0xC000000);
        if (Build.VERSION.SDK_INT >= 23) {
            alarmManager.setAndAllowWhileIdle(0, reminder.getTime(), pendingIntent);
        } else {
            alarmManager.set(0, reminder.getTime(), pendingIntent);
        }
    }

    private final void cancelReminder(RemindersModel reminder) {
        AlarmManager alarmManager;
        Object object = this.context.getSystemService("alarm");
        AlarmManager alarmManager2 = alarmManager = object instanceof AlarmManager ? (AlarmManager)object : null;
        if (alarmManager == null || reminder == null) {
            return;
        }
        Intent alertIntent = new Intent(this.context, ReminderBroadcastReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)reminder.getId(), (Intent)alertIntent, (int)0xC000000);
        alarmManager.cancel(pendingIntent);
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    public static final /* synthetic */ RemindersDao access$getReminderDao(ReminderRepository $this) {
        return $this.getReminderDao();
    }

    public static final /* synthetic */ void access$cancelReminder(ReminderRepository $this, RemindersModel reminder) {
        $this.cancelReminder(reminder);
    }

    public static final /* synthetic */ void access$scheduleReminder(ReminderRepository $this, RemindersModel reminder) {
        $this.scheduleReminder(reminder);
    }
}

