/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ui.ui.settings;

import android.content.Context;
import android.content.Intent;
import androidx.compose.material.ExperimentalMaterialApi;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.ExperimentalComposeUiApi;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavHostController;
import androidx.navigation.NavOptionsBuilder;
import com.calldorado.sdk.thirdparties.ThirdParties;
import com.calldorado.sdk.ui.ui.aftercall.composables.SettingsNavigationScreens;
import com.calldorado.sdk.ui.ui.settings.SettingsActivity;
import com.calldorado.sdk.ui.ui.settings.SettingsEventHandlerImpl;
import com.calldorado.sdk.ui.util.SettingsEventHandler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@ExperimentalComposeUiApi
@ExperimentalMaterialApi
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0005H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/calldorado/sdk/ui/ui/settings/SettingsEventHandlerImpl;", "Lcom/calldorado/sdk/ui/util/SettingsEventHandler;", "activity", "Lcom/calldorado/sdk/ui/ui/settings/SettingsActivity;", "navController", "Landroidx/navigation/NavHostController;", "(Lcom/calldorado/sdk/ui/ui/settings/SettingsActivity;Landroidx/navigation/NavHostController;)V", "getActivity", "()Lcom/calldorado/sdk/ui/ui/settings/SettingsActivity;", "getNavController", "onAdsPersonalizationPressed", "", "onBackButtonPressed", "onCDOEulaButtonPressed", "onDeleteMyDataPressed", "context", "Landroid/content/Context;", "onLicenseButtonPressed", "sdk_release"})
@StabilityInferred(parameters=0)
public final class SettingsEventHandlerImpl
implements SettingsEventHandler {
    @NotNull
    private final SettingsActivity activity;
    @NotNull
    private final NavHostController navController;
    public static final int $stable = 8;

    public SettingsEventHandlerImpl(@NotNull SettingsActivity activity, @NotNull NavHostController navController) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)navController, (String)"navController");
        this.activity = activity;
        this.navController = navController;
    }

    @NotNull
    public final SettingsActivity getActivity() {
        return this.activity;
    }

    @Override
    public void onAdsPersonalizationPressed() {
        String action = "com.google.android.gms.settings.ADS_PRIVACY";
        Intent settings = new Intent(action);
        this.activity.startActivity(settings);
    }

    @Override
    public void onDeleteMyDataPressed(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ThirdParties.Companion.clearData(context, (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(1);
            }

            public final void invoke(boolean it) {
                ThirdParties.Companion.deleteMyDataInApp(this.$context);
            }
        }));
    }

    @Override
    public void onCDOEulaButtonPressed() {
        NavController.navigate$default((NavController)((NavController)this.navController), (String)SettingsNavigationScreens.CDOEulaScreen.INSTANCE.getRoute(), null, null, (int)6, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onBackButtonPressed() {
        String licenseScreenRoute = SettingsNavigationScreens.LicenseScreen.INSTANCE.getRoute();
        String cdoEulaScreenRoute = SettingsNavigationScreens.CDOEulaScreen.INSTANCE.getRoute();
        String settingsScreenRoute = SettingsNavigationScreens.SettingsScreen.INSTANCE.getRoute();
        NavGraph $this$get$iv = this.navController.getGraph();
        boolean $i$f$get = false;
        NavDestination navDestination = $this$get$iv.findNode(licenseScreenRoute);
        if (navDestination == null) {
            throw new IllegalArgumentException("No destination for " + licenseScreenRoute + " was found in " + $this$get$iv);
        }
        if (!Intrinsics.areEqual((Object)this.navController.getCurrentDestination(), (Object)navDestination)) {
            $this$get$iv = this.navController.getGraph();
            $i$f$get = false;
            navDestination = $this$get$iv.findNode(cdoEulaScreenRoute);
            if (navDestination == null) {
                throw new IllegalArgumentException("No destination for " + cdoEulaScreenRoute + " was found in " + $this$get$iv);
            }
            if (!Intrinsics.areEqual((Object)this.navController.getCurrentDestination(), (Object)navDestination)) {
                this.activity.finish();
                return;
            }
        }
        this.navController.navigate(settingsScreenRoute, (Function1)new Function1<NavOptionsBuilder, Unit>(settingsScreenRoute){
            final /* synthetic */ String $settingsScreenRoute;
            {
                this.$settingsScreenRoute = $settingsScreenRoute;
                super(1);
            }

            public final void invoke(@NotNull NavOptionsBuilder $this$navigate) {
                Intrinsics.checkNotNullParameter((Object)$this$navigate, (String)"$this$navigate");
                $this$navigate.popUpTo(this.$settingsScreenRoute, (Function1)onBackButtonPressed.1.INSTANCE);
            }
        });
    }

    @Override
    public void onLicenseButtonPressed() {
        NavController.navigate$default((NavController)((NavController)this.navController), (String)SettingsNavigationScreens.LicenseScreen.INSTANCE.getRoute(), null, null, (int)6, null);
    }

    @Override
    @NotNull
    public NavHostController getNavController() {
        return this.navController;
    }
}

