/*
 * Decompiled with CFR 0.152.
 */
package com.calldorado.sdk.ui.util;

import android.app.role.RoleManager;
import android.content.Context;
import android.content.res.Resources;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.compose.runtime.internal.StabilityInferred;
import com.calldorado.sdk.di.SdkCoinComponent;
import com.calldorado.sdk.logging.CLog;
import com.calldorado.sdk.preferences.PreferencesManager;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0011J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/calldorado/sdk/ui/util/Utils;", "Lcom/calldorado/sdk/di/SdkCoinComponent;", "()V", "mSharedPreferencesManager", "Lcom/calldorado/sdk/preferences/PreferencesManager;", "getMSharedPreferencesManager", "()Lcom/calldorado/sdk/preferences/PreferencesManager;", "mSharedPreferencesManager$delegate", "Lkotlin/Lazy;", "convertDpToPixel", "", "dp", "context", "Landroid/content/Context;", "convertPixelsToDp", "px", "getApplicationName", "", "isBlockingEnabled", "", "printInitials", "name", "stripSpaces", "s", "sdk_release"})
@StabilityInferred(parameters=0)
public final class Utils
implements SdkCoinComponent {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    private static final Lazy mSharedPreferencesManager$delegate;
    public static final int $stable;

    private Utils() {
    }

    @NotNull
    public final PreferencesManager getMSharedPreferencesManager() {
        Lazy lazy = mSharedPreferencesManager$delegate;
        return (PreferencesManager)lazy.getValue();
    }

    @NotNull
    public final String printInitials(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            Object object;
            if (((CharSequence)name).length() == 0) {
                return "";
            }
            CLog.d("TAG", "printInitials: " + name);
            CharSequence charSequence = this.stripSpaces(name);
            Regex regex = new Regex(" ");
            int n = 0;
            Collection $this$toTypedArray$iv = regex.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] nameParts = stringArray;
            CLog.d("TAG", "printInitials: " + nameParts);
            String firstName = nameParts[0];
            char firstNameChar = firstName.charAt(0);
            if (nameParts.length > 1) {
                String lastName = nameParts[nameParts.length - 1];
                char lastNameChar = lastName.charAt(0);
                object = firstNameChar + "." + lastNameChar;
            } else {
                object = String.valueOf(firstNameChar);
            }
            return object;
        }
        catch (Exception e) {
            CLog.d("TAG", "printInitials: " + name);
            return "";
        }
    }

    private final String stripSpaces(String s) {
        CharSequence charSequence;
        try {
            charSequence = s;
            Regex regex = new Regex("\\s+");
            String string2 = " ";
            charSequence = ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string2))).toString();
        }
        catch (Exception e) {
            charSequence = "";
        }
        return charSequence;
    }

    public final float convertPixelsToDp(float px, @Nullable Context context) {
        float f;
        if (context != null) {
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            f = px / ((float)metrics.densityDpi / (float)160);
        } else {
            DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
            f = px / ((float)metrics.densityDpi / (float)160);
        }
        return f;
    }

    public final float convertDpToPixel(float dp, @Nullable Context context) {
        float f;
        if (context != null) {
            Resources resources = context.getResources();
            DisplayMetrics metrics = resources.getDisplayMetrics();
            f = dp * ((float)metrics.densityDpi / (float)160);
        } else {
            DisplayMetrics metrics = Resources.getSystem().getDisplayMetrics();
            f = dp * ((float)metrics.densityDpi / (float)160);
        }
        return f;
    }

    @NotNull
    public final String getApplicationName(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return StringsKt.replace$default((String)((Object)context.getApplicationInfo().loadLabel(context.getPackageManager())).toString(), (String)"#", (String)"", (boolean)false, (int)4, null);
    }

    public final boolean isBlockingEnabled(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        boolean isBlockingEnabled = this.getMSharedPreferencesManager().getValue("pref_blocking_state", false);
        if (Build.VERSION.SDK_INT >= 29) {
            boolean isRoleHeld;
            RoleManager roleManager = (RoleManager)context.getSystemService(RoleManager.class);
            boolean isRoleAvailable = roleManager.isRoleAvailable("android.app.role.CALL_SCREENING");
            return isRoleAvailable && (isRoleHeld = roleManager.isRoleHeld("android.app.role.CALL_SCREENING")) && isBlockingEnabled;
        }
        return isBlockingEnabled;
    }

    @Override
    @NotNull
    public Koin getKoin() {
        return SdkCoinComponent.DefaultImpls.getKoin(this);
    }

    static {
        KoinComponent $this$inject_u24default$iv = INSTANCE;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        mSharedPreferencesManager$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<PreferencesManager>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final PreferencesManager invoke() {
                Object object;
                void qualifier$iv;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(PreferencesManager.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $stable = 8;
    }
}

